// qtwebengine/userscript/userscript.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "qtwebengine/userscript/userscript.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "qtwebengine/userscript/userscript.mojom-params-data.h"
namespace qtwebengine {
namespace mojom {

NOINLINE static const char* InjectionPointToStringHelper(InjectionPoint value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InjectionPoint::AfterLoad:
      return "AfterLoad";
    case InjectionPoint::DocumentLoadFinished:
      return "DocumentLoadFinished";
    case InjectionPoint::DocumentElementCreation:
      return "DocumentElementCreation";
    default:
      return nullptr;
  }
}

std::string InjectionPointToString(InjectionPoint value) {
  const char *str = InjectionPointToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InjectionPoint value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InjectionPoint value) {
  return os << InjectionPointToString(value);
}

namespace internal {


// static
bool UserScriptData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UserScriptData_Data* object =
      static_cast<const UserScriptData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source, validation_context,
                                         &source_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->globs, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& globs_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->globs, validation_context,
                                         &globs_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->excludeGlobs, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& excludeGlobs_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->excludeGlobs, validation_context,
                                         &excludeGlobs_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urlPatterns, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urlPatterns_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->urlPatterns, validation_context,
                                         &urlPatterns_validate_params)) {
    return false;
  }

  return true;
}

UserScriptData_Data::UserScriptData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UserResourceControllerRenderFrame_AddScript_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UserResourceControllerRenderFrame_AddScript_Params_Data* object =
      static_cast<const UserResourceControllerRenderFrame_AddScript_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

UserResourceControllerRenderFrame_AddScript_Params_Data::UserResourceControllerRenderFrame_AddScript_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UserResourceControllerRenderFrame_RemoveScript_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UserResourceControllerRenderFrame_RemoveScript_Params_Data* object =
      static_cast<const UserResourceControllerRenderFrame_RemoveScript_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

UserResourceControllerRenderFrame_RemoveScript_Params_Data::UserResourceControllerRenderFrame_RemoveScript_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UserResourceControllerRenderFrame_ClearScripts_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UserResourceControllerRenderFrame_ClearScripts_Params_Data* object =
      static_cast<const UserResourceControllerRenderFrame_ClearScripts_Params_Data*>(data);

  return true;
}

UserResourceControllerRenderFrame_ClearScripts_Params_Data::UserResourceControllerRenderFrame_ClearScripts_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UserResourceController_AddScript_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UserResourceController_AddScript_Params_Data* object =
      static_cast<const UserResourceController_AddScript_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

UserResourceController_AddScript_Params_Data::UserResourceController_AddScript_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UserResourceController_RemoveScript_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UserResourceController_RemoveScript_Params_Data* object =
      static_cast<const UserResourceController_RemoveScript_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

UserResourceController_RemoveScript_Params_Data::UserResourceController_RemoveScript_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UserResourceController_ClearScripts_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UserResourceController_ClearScripts_Params_Data* object =
      static_cast<const UserResourceController_ClearScripts_Params_Data*>(data);

  return true;
}

UserResourceController_ClearScripts_Params_Data::UserResourceController_ClearScripts_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace qtwebengine

namespace perfetto {

// static
void TraceFormatTraits<::qtwebengine::mojom::InjectionPoint>::WriteIntoTrace(
   perfetto::TracedValue context, ::qtwebengine::mojom::InjectionPoint value) {
  return std::move(context).WriteString(::qtwebengine::mojom::InjectionPointToString(value));
}

} // namespace perfetto