// qtwebengine/userscript/userscript.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_SHARED_H_
#define QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "qtwebengine/userscript/userscript.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace qtwebengine::mojom {
class UserScriptDataDataView;



}  // qtwebengine::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::qtwebengine::mojom::UserScriptDataDataView> {
  using Data = ::qtwebengine::mojom::internal::UserScriptData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace qtwebengine::mojom {


enum class InjectionPoint : int32_t {
  
  AfterLoad = 0,
  
  DocumentLoadFinished = 1,
  
  DocumentElementCreation = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, InjectionPoint value);
inline bool IsKnownEnumValue(InjectionPoint value) {
  return internal::InjectionPoint_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class UserResourceControllerRenderFrameInterfaceBase {};

using UserResourceControllerRenderFramePtrDataView =
    mojo::InterfacePtrDataView<UserResourceControllerRenderFrameInterfaceBase>;
using UserResourceControllerRenderFrameRequestDataView =
    mojo::InterfaceRequestDataView<UserResourceControllerRenderFrameInterfaceBase>;
using UserResourceControllerRenderFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UserResourceControllerRenderFrameInterfaceBase>;
using UserResourceControllerRenderFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UserResourceControllerRenderFrameInterfaceBase>;
class UserResourceControllerInterfaceBase {};

using UserResourceControllerPtrDataView =
    mojo::InterfacePtrDataView<UserResourceControllerInterfaceBase>;
using UserResourceControllerRequestDataView =
    mojo::InterfaceRequestDataView<UserResourceControllerInterfaceBase>;
using UserResourceControllerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UserResourceControllerInterfaceBase>;
using UserResourceControllerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UserResourceControllerInterfaceBase>;


class UserScriptDataDataView {
 public:
  UserScriptDataDataView() = default;

  UserScriptDataDataView(
      internal::UserScriptData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) {
    
    auto* pointer = data_->source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  uint8_t injectionPoint() const {
    return data_->injectionPoint;
  }
  bool injectForSubframes() const {
    return data_->injectForSubframes;
  }
  uint8_t worldId() const {
    return data_->worldId;
  }
  uint64_t scriptId() const {
    return data_->scriptId;
  }
  inline void GetGlobsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGlobs(UserType* output) {
    
    auto* pointer = data_->globs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetExcludeGlobsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExcludeGlobs(UserType* output) {
    
    auto* pointer = data_->excludeGlobs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetUrlPatternsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlPatterns(UserType* output) {
    
    auto* pointer = data_->urlPatterns.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::UserScriptData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // qtwebengine::mojom

namespace std {

template <>
struct hash<::qtwebengine::mojom::InjectionPoint>
    : public mojo::internal::EnumHashImpl<::qtwebengine::mojom::InjectionPoint> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::qtwebengine::mojom::InjectionPoint, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::qtwebengine::mojom::InjectionPoint, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::qtwebengine::mojom::InjectionPoint>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::qtwebengine::mojom::UserScriptDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::qtwebengine::mojom::UserScriptDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::qtwebengine::mojom::internal::UserScriptData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::source(input)) in_source = Traits::source(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source)::BaseType> source_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_source, source_fragment);
    fragment->source.Set(
        source_fragment.is_null() ? nullptr : source_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->source.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source in UserScriptData struct");
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in UserScriptData struct");
    fragment->injectionPoint = Traits::injectionPoint(input);
    fragment->injectForSubframes = Traits::injectForSubframes(input);
    fragment->worldId = Traits::worldId(input);
    fragment->scriptId = Traits::scriptId(input);
    decltype(Traits::globs(input)) in_globs = Traits::globs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->globs)::BaseType>
        globs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& globs_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_globs, globs_fragment, &globs_validate_params);
    fragment->globs.Set(
        globs_fragment.is_null() ? nullptr : globs_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->globs.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null globs in UserScriptData struct");
    decltype(Traits::excludeGlobs(input)) in_excludeGlobs = Traits::excludeGlobs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->excludeGlobs)::BaseType>
        excludeGlobs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& excludeGlobs_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_excludeGlobs, excludeGlobs_fragment, &excludeGlobs_validate_params);
    fragment->excludeGlobs.Set(
        excludeGlobs_fragment.is_null() ? nullptr : excludeGlobs_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->excludeGlobs.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null excludeGlobs in UserScriptData struct");
    decltype(Traits::urlPatterns(input)) in_urlPatterns = Traits::urlPatterns(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->urlPatterns)::BaseType>
        urlPatterns_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& urlPatterns_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_urlPatterns, urlPatterns_fragment, &urlPatterns_validate_params);
    fragment->urlPatterns.Set(
        urlPatterns_fragment.is_null() ? nullptr : urlPatterns_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->urlPatterns.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null urlPatterns in UserScriptData struct");
  }

  static bool Deserialize(::qtwebengine::mojom::internal::UserScriptData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::qtwebengine::mojom::UserScriptDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace qtwebengine::mojom {

inline void UserScriptDataDataView::GetSourceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->source.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserScriptDataDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void UserScriptDataDataView::GetGlobsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->globs.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void UserScriptDataDataView::GetExcludeGlobsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->excludeGlobs.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void UserScriptDataDataView::GetUrlPatternsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->urlPatterns.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // qtwebengine::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::qtwebengine::mojom::InjectionPoint> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::qtwebengine::mojom::InjectionPoint value);
};

} // namespace perfetto

#endif  // QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_SHARED_H_