// services/network/public/mojom/restricted_udp_socket.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_UDP_SOCKET_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_UDP_SOCKET_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/restricted_udp_socket.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "services/network/public/mojom/host_resolver.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/udp_socket.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class RestrictedUDPSocketParamsDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::RestrictedUDPSocketParamsDataView> {
  using Data = ::network::mojom::internal::RestrictedUDPSocketParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class RestrictedUDPSocketMode : int32_t {
  
  CONNECTED = 0,
  
  BOUND = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, RestrictedUDPSocketMode value);
inline bool IsKnownEnumValue(RestrictedUDPSocketMode value) {
  return internal::RestrictedUDPSocketMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class RestrictedUDPSocketInterfaceBase {};

using RestrictedUDPSocketPtrDataView =
    mojo::InterfacePtrDataView<RestrictedUDPSocketInterfaceBase>;
using RestrictedUDPSocketRequestDataView =
    mojo::InterfaceRequestDataView<RestrictedUDPSocketInterfaceBase>;
using RestrictedUDPSocketAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RestrictedUDPSocketInterfaceBase>;
using RestrictedUDPSocketAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RestrictedUDPSocketInterfaceBase>;


class RestrictedUDPSocketParamsDataView {
 public:
  RestrictedUDPSocketParamsDataView() = default;

  RestrictedUDPSocketParamsDataView(
      internal::RestrictedUDPSocketParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSocketOptionsDataView(
      ::network::mojom::UDPSocketOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSocketOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::UDPSocketOptionsDataView, UserType>(),
    "Attempting to read the optional `socket_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSocketOptions` instead "
    "of `ReadSocketOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->socket_options.Get();
    return mojo::internal::Deserialize<::network::mojom::UDPSocketOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::RestrictedUDPSocketParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

template <>
struct hash<::network::mojom::RestrictedUDPSocketMode>
    : public mojo::internal::EnumHashImpl<::network::mojom::RestrictedUDPSocketMode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::RestrictedUDPSocketMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::RestrictedUDPSocketMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::RestrictedUDPSocketMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::RestrictedUDPSocketParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::RestrictedUDPSocketParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::RestrictedUDPSocketParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::socket_options(input)) in_socket_options = Traits::socket_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->socket_options)::BaseType> socket_options_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::UDPSocketOptionsDataView>(
        in_socket_options, socket_options_fragment);
    fragment->socket_options.Set(
        socket_options_fragment.is_null() ? nullptr : socket_options_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::RestrictedUDPSocketParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::RestrictedUDPSocketParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void RestrictedUDPSocketParamsDataView::GetSocketOptionsDataView(
    ::network::mojom::UDPSocketOptionsDataView* output) {
  auto pointer = data_->socket_options.Get();
  *output = ::network::mojom::UDPSocketOptionsDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::RestrictedUDPSocketMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::RestrictedUDPSocketMode value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_UDP_SOCKET_MOJOM_SHARED_H_