// services/tracing/public/mojom/background_tracing_agent.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/tracing/public/mojom/background_tracing_agent.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/tracing/public/mojom/background_tracing_agent.mojom-params-data.h"
namespace tracing {
namespace mojom {

namespace internal {


// static
bool BackgroundTracingRule_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundTracingRule_Data* object =
      static_cast<const BackgroundTracingRule_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rule_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& rule_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->rule_id, validation_context,
                                         &rule_id_validate_params)) {
    return false;
  }

  return true;
}

BackgroundTracingRule_Data::BackgroundTracingRule_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundTracingAgentClient_OnInitialized_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundTracingAgentClient_OnInitialized_Params_Data* object =
      static_cast<const BackgroundTracingAgentClient_OnInitialized_Params_Data*>(data);

  return true;
}

BackgroundTracingAgentClient_OnInitialized_Params_Data::BackgroundTracingAgentClient_OnInitialized_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data* object =
      static_cast<const BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rule, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rule, validation_context))
    return false;

  return true;
}

BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data::BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundTracingAgent_SetUMACallback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundTracingAgent_SetUMACallback_Params_Data* object =
      static_cast<const BackgroundTracingAgent_SetUMACallback_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rule, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rule, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->histogram_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& histogram_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->histogram_name, validation_context,
                                         &histogram_name_validate_params)) {
    return false;
  }

  return true;
}

BackgroundTracingAgent_SetUMACallback_Params_Data::BackgroundTracingAgent_SetUMACallback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundTracingAgent_ClearUMACallback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundTracingAgent_ClearUMACallback_Params_Data* object =
      static_cast<const BackgroundTracingAgent_ClearUMACallback_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rule, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rule, validation_context))
    return false;

  return true;
}

BackgroundTracingAgent_ClearUMACallback_Params_Data::BackgroundTracingAgent_ClearUMACallback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundTracingAgentProvider_Create_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundTracingAgentProvider_Create_Params_Data* object =
      static_cast<const BackgroundTracingAgentProvider_Create_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->agent, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->agent,
                                                 validation_context)) {
    return false;
  }

  return true;
}

BackgroundTracingAgentProvider_Create_Params_Data::BackgroundTracingAgentProvider_Create_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace tracing