// services/tracing/public/mojom/perfetto_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_SHARED_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/tracing/public/mojom/perfetto_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace tracing::mojom {
class ChunksToMoveDataView;

class ChunkPatchDataView;

class ChunksToPatchDataView;

class CommitDataRequestDataView;

class ChromeConfigDataView;

class ConsoleConfigDataView;

class InterceptorConfigDataView;

class DataSourceConfigDataView;

class DataSourceRegistrationDataView;

class BufferConfigDataView;

class DataSourceDataView;

class PerfettoBuiltinDataSourceDataView;

class IncrementalStateConfigDataView;

class TraceConfigDataView;



}  // tracing::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::tracing::mojom::ChunksToMoveDataView> {
  using Data = ::tracing::mojom::internal::ChunksToMove_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::ChunkPatchDataView> {
  using Data = ::tracing::mojom::internal::ChunkPatch_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::ChunksToPatchDataView> {
  using Data = ::tracing::mojom::internal::ChunksToPatch_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::CommitDataRequestDataView> {
  using Data = ::tracing::mojom::internal::CommitDataRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::ChromeConfigDataView> {
  using Data = ::tracing::mojom::internal::ChromeConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::ConsoleConfigDataView> {
  using Data = ::tracing::mojom::internal::ConsoleConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::InterceptorConfigDataView> {
  using Data = ::tracing::mojom::internal::InterceptorConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::DataSourceConfigDataView> {
  using Data = ::tracing::mojom::internal::DataSourceConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::DataSourceRegistrationDataView> {
  using Data = ::tracing::mojom::internal::DataSourceRegistration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::BufferConfigDataView> {
  using Data = ::tracing::mojom::internal::BufferConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::DataSourceDataView> {
  using Data = ::tracing::mojom::internal::DataSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::PerfettoBuiltinDataSourceDataView> {
  using Data = ::tracing::mojom::internal::PerfettoBuiltinDataSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::IncrementalStateConfigDataView> {
  using Data = ::tracing::mojom::internal::IncrementalStateConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tracing::mojom::TraceConfigDataView> {
  using Data = ::tracing::mojom::internal::TraceConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace tracing::mojom {


enum class ConsoleOutput : int32_t {
  
  kOutputUnspecified = 0,
  
  kOutputStdOut = 1,
  
  kOutputStdErr = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(TRACING_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ConsoleOutput value);
inline bool IsKnownEnumValue(ConsoleOutput value) {
  return internal::ConsoleOutput_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BufferFillPolicy : int32_t {
  
  kUnspecified = 0,
  
  kRingBuffer = 1,
  
  kDiscard = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(TRACING_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, BufferFillPolicy value);
inline bool IsKnownEnumValue(BufferFillPolicy value) {
  return internal::BufferFillPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TracingClientPriority : int32_t {
  
  kUnknown = 0,
  
  kBackground = 1,
  
  kUserInitiated = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(TRACING_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TracingClientPriority value);
inline bool IsKnownEnumValue(TracingClientPriority value) {
  return internal::TracingClientPriority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ProducerHostInterfaceBase {};

using ProducerHostPtrDataView =
    mojo::InterfacePtrDataView<ProducerHostInterfaceBase>;
using ProducerHostRequestDataView =
    mojo::InterfaceRequestDataView<ProducerHostInterfaceBase>;
using ProducerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProducerHostInterfaceBase>;
using ProducerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProducerHostInterfaceBase>;
class ProducerClientInterfaceBase {};

using ProducerClientPtrDataView =
    mojo::InterfacePtrDataView<ProducerClientInterfaceBase>;
using ProducerClientRequestDataView =
    mojo::InterfaceRequestDataView<ProducerClientInterfaceBase>;
using ProducerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProducerClientInterfaceBase>;
using ProducerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProducerClientInterfaceBase>;
class PerfettoServiceInterfaceBase {};

using PerfettoServicePtrDataView =
    mojo::InterfacePtrDataView<PerfettoServiceInterfaceBase>;
using PerfettoServiceRequestDataView =
    mojo::InterfaceRequestDataView<PerfettoServiceInterfaceBase>;
using PerfettoServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PerfettoServiceInterfaceBase>;
using PerfettoServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PerfettoServiceInterfaceBase>;
class ConsumerHostInterfaceBase {};

using ConsumerHostPtrDataView =
    mojo::InterfacePtrDataView<ConsumerHostInterfaceBase>;
using ConsumerHostRequestDataView =
    mojo::InterfaceRequestDataView<ConsumerHostInterfaceBase>;
using ConsumerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ConsumerHostInterfaceBase>;
using ConsumerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ConsumerHostInterfaceBase>;
class TracingSessionHostInterfaceBase {};

using TracingSessionHostPtrDataView =
    mojo::InterfacePtrDataView<TracingSessionHostInterfaceBase>;
using TracingSessionHostRequestDataView =
    mojo::InterfaceRequestDataView<TracingSessionHostInterfaceBase>;
using TracingSessionHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TracingSessionHostInterfaceBase>;
using TracingSessionHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TracingSessionHostInterfaceBase>;
class TracingSessionClientInterfaceBase {};

using TracingSessionClientPtrDataView =
    mojo::InterfacePtrDataView<TracingSessionClientInterfaceBase>;
using TracingSessionClientRequestDataView =
    mojo::InterfaceRequestDataView<TracingSessionClientInterfaceBase>;
using TracingSessionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TracingSessionClientInterfaceBase>;
using TracingSessionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TracingSessionClientInterfaceBase>;


class ChunksToMoveDataView {
 public:
  ChunksToMoveDataView() = default;

  ChunksToMoveDataView(
      internal::ChunksToMove_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t page() const {
    return data_->page;
  }
  uint32_t chunk() const {
    return data_->chunk;
  }
  uint32_t target_buffer() const {
    return data_->target_buffer;
  }
 private:
  internal::ChunksToMove_Data* data_ = nullptr;
};


class ChunkPatchDataView {
 public:
  ChunkPatchDataView() = default;

  ChunkPatchDataView(
      internal::ChunkPatch_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t offset() const {
    return data_->offset;
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ChunkPatch_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ChunksToPatchDataView {
 public:
  ChunksToPatchDataView() = default;

  ChunksToPatchDataView(
      internal::ChunksToPatch_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t target_buffer() const {
    return data_->target_buffer;
  }
  uint32_t writer_id() const {
    return data_->writer_id;
  }
  uint32_t chunk_id() const {
    return data_->chunk_id;
  }
  inline void GetPatchesDataView(
      mojo::ArrayDataView<ChunkPatchDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPatches(UserType* output) {
    
    auto* pointer = data_->patches.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tracing::mojom::ChunkPatchDataView>>(
        pointer, output, message_);
  }
  bool has_more_patches() const {
    return data_->has_more_patches;
  }
 private:
  internal::ChunksToPatch_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommitDataRequestDataView {
 public:
  CommitDataRequestDataView() = default;

  CommitDataRequestDataView(
      internal::CommitDataRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetChunksToMoveDataView(
      mojo::ArrayDataView<ChunksToMoveDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChunksToMove(UserType* output) {
    
    auto* pointer = data_->chunks_to_move.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tracing::mojom::ChunksToMoveDataView>>(
        pointer, output, message_);
  }
  inline void GetChunksToPatchDataView(
      mojo::ArrayDataView<ChunksToPatchDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChunksToPatch(UserType* output) {
    
    auto* pointer = data_->chunks_to_patch.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tracing::mojom::ChunksToPatchDataView>>(
        pointer, output, message_);
  }
  uint64_t flush_request_id() const {
    return data_->flush_request_id;
  }
 private:
  internal::CommitDataRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ChromeConfigDataView {
 public:
  ChromeConfigDataView() = default;

  ChromeConfigDataView(
      internal::ChromeConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTraceConfigDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTraceConfig(UserType* output) {
    
    auto* pointer = data_->trace_config.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool privacy_filtering_enabled() const {
    return data_->privacy_filtering_enabled;
  }
  bool convert_to_legacy_json() const {
    return data_->convert_to_legacy_json;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadClientPriority(UserType* output) const {
    auto data_value = data_->client_priority;
    return mojo::internal::Deserialize<::tracing::mojom::TracingClientPriority>(
        data_value, output);
  }
  TracingClientPriority client_priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tracing::mojom::TracingClientPriority>(data_->client_priority));
  }
 private:
  internal::ChromeConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ConsoleConfigDataView {
 public:
  ConsoleConfigDataView() = default;

  ConsoleConfigDataView(
      internal::ConsoleConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadOutput(UserType* output) const {
    auto data_value = data_->output;
    return mojo::internal::Deserialize<::tracing::mojom::ConsoleOutput>(
        data_value, output);
  }
  ConsoleOutput output() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tracing::mojom::ConsoleOutput>(data_->output));
  }
  bool enable_colors() const {
    return data_->enable_colors;
  }
 private:
  internal::ConsoleConfig_Data* data_ = nullptr;
};


class InterceptorConfigDataView {
 public:
  InterceptorConfigDataView() = default;

  InterceptorConfigDataView(
      internal::InterceptorConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetConsoleConfigDataView(
      ConsoleConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConsoleConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::tracing::mojom::ConsoleConfigDataView, UserType>(),
    "Attempting to read the optional `console_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadConsoleConfig` instead "
    "of `ReadConsoleConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->console_config.Get();
    return mojo::internal::Deserialize<::tracing::mojom::ConsoleConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::InterceptorConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataSourceConfigDataView {
 public:
  DataSourceConfigDataView() = default;

  DataSourceConfigDataView(
      internal::DataSourceConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t target_buffer() const {
    return data_->target_buffer;
  }
  uint32_t trace_duration_ms() const {
    return data_->trace_duration_ms;
  }
  uint64_t tracing_session_id() const {
    return data_->tracing_session_id;
  }
  inline void GetChromeConfigDataView(
      ChromeConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChromeConfig(UserType* output) {
    
    auto* pointer = data_->chrome_config.Get();
    return mojo::internal::Deserialize<::tracing::mojom::ChromeConfigDataView>(
        pointer, output, message_);
  }
  inline void GetInterceptorConfigDataView(
      InterceptorConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterceptorConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::tracing::mojom::InterceptorConfigDataView, UserType>(),
    "Attempting to read the optional `interceptor_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInterceptorConfig` instead "
    "of `ReadInterceptorConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->interceptor_config.Get();
    return mojo::internal::Deserialize<::tracing::mojom::InterceptorConfigDataView>(
        pointer, output, message_);
  }
  inline void GetLegacyConfigDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLegacyConfig(UserType* output) {
    
    auto* pointer = data_->legacy_config.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTrackEventConfigRawDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackEventConfigRaw(UserType* output) {
    
    auto* pointer = data_->track_event_config_raw.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetEtwConfigRawDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEtwConfigRaw(UserType* output) {
    
    auto* pointer = data_->etw_config_raw.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetSystemMetricsConfigRawDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSystemMetricsConfigRaw(UserType* output) {
    
    auto* pointer = data_->system_metrics_config_raw.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DataSourceConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataSourceRegistrationDataView {
 public:
  DataSourceRegistrationDataView() = default;

  DataSourceRegistrationDataView(
      internal::DataSourceRegistration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool will_notify_on_start() const {
    return data_->will_notify_on_start;
  }
  bool will_notify_on_stop() const {
    return data_->will_notify_on_stop;
  }
  bool handles_incremental_state_clear() const {
    return data_->handles_incremental_state_clear;
  }
 private:
  internal::DataSourceRegistration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BufferConfigDataView {
 public:
  BufferConfigDataView() = default;

  BufferConfigDataView(
      internal::BufferConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t size_kb() const {
    return data_->size_kb;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFillPolicy(UserType* output) const {
    auto data_value = data_->fill_policy;
    return mojo::internal::Deserialize<::tracing::mojom::BufferFillPolicy>(
        data_value, output);
  }
  BufferFillPolicy fill_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tracing::mojom::BufferFillPolicy>(data_->fill_policy));
  }
 private:
  internal::BufferConfig_Data* data_ = nullptr;
};


class DataSourceDataView {
 public:
  DataSourceDataView() = default;

  DataSourceDataView(
      internal::DataSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      DataSourceConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::tracing::mojom::DataSourceConfigDataView>(
        pointer, output, message_);
  }
  inline void GetProducerNameFilterDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProducerNameFilter(UserType* output) {
    
    auto* pointer = data_->producer_name_filter.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DataSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PerfettoBuiltinDataSourceDataView {
 public:
  PerfettoBuiltinDataSourceDataView() = default;

  PerfettoBuiltinDataSourceDataView(
      internal::PerfettoBuiltinDataSource_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool disable_clock_snapshotting() const {
    return data_->disable_clock_snapshotting;
  }
  bool disable_trace_config() const {
    return data_->disable_trace_config;
  }
  bool disable_system_info() const {
    return data_->disable_system_info;
  }
  bool disable_service_events() const {
    return data_->disable_service_events;
  }
  int32_t primary_trace_clock_id() const {
    return data_->primary_trace_clock_id;
  }
 private:
  internal::PerfettoBuiltinDataSource_Data* data_ = nullptr;
};


class IncrementalStateConfigDataView {
 public:
  IncrementalStateConfigDataView() = default;

  IncrementalStateConfigDataView(
      internal::IncrementalStateConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t clear_period_ms() const {
    return data_->clear_period_ms;
  }
 private:
  internal::IncrementalStateConfig_Data* data_ = nullptr;
};


class TraceConfigDataView {
 public:
  TraceConfigDataView() = default;

  TraceConfigDataView(
      internal::TraceConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataSourcesDataView(
      mojo::ArrayDataView<DataSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataSources(UserType* output) {
    
    auto* pointer = data_->data_sources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tracing::mojom::DataSourceDataView>>(
        pointer, output, message_);
  }
  inline void GetPerfettoBuiltinDataSourceDataView(
      PerfettoBuiltinDataSourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerfettoBuiltinDataSource(UserType* output) {
    
    auto* pointer = data_->perfetto_builtin_data_source.Get();
    return mojo::internal::Deserialize<::tracing::mojom::PerfettoBuiltinDataSourceDataView>(
        pointer, output, message_);
  }
  inline void GetBuffersDataView(
      mojo::ArrayDataView<BufferConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuffers(UserType* output) {
    
    auto* pointer = data_->buffers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tracing::mojom::BufferConfigDataView>>(
        pointer, output, message_);
  }
  inline void GetIncrementalStateConfigDataView(
      IncrementalStateConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIncrementalStateConfig(UserType* output) {
    
    auto* pointer = data_->incremental_state_config.Get();
    return mojo::internal::Deserialize<::tracing::mojom::IncrementalStateConfigDataView>(
        pointer, output, message_);
  }
  uint32_t duration_ms() const {
    return data_->duration_ms;
  }
  bool write_into_file() const {
    return data_->write_into_file;
  }
  inline void GetTraceUuidDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTraceUuid(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TokenDataView, UserType>(),
    "Attempting to read the optional `trace_uuid` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTraceUuid` instead "
    "of `ReadTraceUuid if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trace_uuid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetUniqueSessionNameDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUniqueSessionName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `unique_session_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUniqueSessionName` instead "
    "of `ReadUniqueSessionName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->unique_session_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::TraceConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // tracing::mojom

namespace std {

template <>
struct hash<::tracing::mojom::ConsoleOutput>
    : public mojo::internal::EnumHashImpl<::tracing::mojom::ConsoleOutput> {};

template <>
struct hash<::tracing::mojom::BufferFillPolicy>
    : public mojo::internal::EnumHashImpl<::tracing::mojom::BufferFillPolicy> {};

template <>
struct hash<::tracing::mojom::TracingClientPriority>
    : public mojo::internal::EnumHashImpl<::tracing::mojom::TracingClientPriority> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::ConsoleOutput, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tracing::mojom::ConsoleOutput, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tracing::mojom::ConsoleOutput>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::BufferFillPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tracing::mojom::BufferFillPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tracing::mojom::BufferFillPolicy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::TracingClientPriority, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tracing::mojom::TracingClientPriority, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tracing::mojom::TracingClientPriority>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::ChunksToMoveDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::ChunksToMoveDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::ChunksToMove_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->page = Traits::page(input);
    fragment->chunk = Traits::chunk(input);
    fragment->target_buffer = Traits::target_buffer(input);
  }

  static bool Deserialize(::tracing::mojom::internal::ChunksToMove_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::ChunksToMoveDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::ChunkPatchDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::ChunkPatchDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::ChunkPatch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->offset = Traits::offset(input);
    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType> data_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
        in_data, data_fragment);
    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in ChunkPatch struct");
  }

  static bool Deserialize(::tracing::mojom::internal::ChunkPatch_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::ChunkPatchDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::ChunksToPatchDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::ChunksToPatchDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::ChunksToPatch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->target_buffer = Traits::target_buffer(input);
    fragment->writer_id = Traits::writer_id(input);
    fragment->chunk_id = Traits::chunk_id(input);
    decltype(Traits::patches(input)) in_patches = Traits::patches(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->patches)::BaseType>
        patches_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& patches_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::tracing::mojom::ChunkPatchDataView>>(
        in_patches, patches_fragment, &patches_validate_params);
    fragment->patches.Set(
        patches_fragment.is_null() ? nullptr : patches_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->patches.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null patches in ChunksToPatch struct");
    fragment->has_more_patches = Traits::has_more_patches(input);
  }

  static bool Deserialize(::tracing::mojom::internal::ChunksToPatch_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::ChunksToPatchDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::CommitDataRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::CommitDataRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::CommitDataRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::chunks_to_move(input)) in_chunks_to_move = Traits::chunks_to_move(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->chunks_to_move)::BaseType>
        chunks_to_move_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& chunks_to_move_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::tracing::mojom::ChunksToMoveDataView>>(
        in_chunks_to_move, chunks_to_move_fragment, &chunks_to_move_validate_params);
    fragment->chunks_to_move.Set(
        chunks_to_move_fragment.is_null() ? nullptr : chunks_to_move_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->chunks_to_move.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null chunks_to_move in CommitDataRequest struct");
    decltype(Traits::chunks_to_patch(input)) in_chunks_to_patch = Traits::chunks_to_patch(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->chunks_to_patch)::BaseType>
        chunks_to_patch_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& chunks_to_patch_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::tracing::mojom::ChunksToPatchDataView>>(
        in_chunks_to_patch, chunks_to_patch_fragment, &chunks_to_patch_validate_params);
    fragment->chunks_to_patch.Set(
        chunks_to_patch_fragment.is_null() ? nullptr : chunks_to_patch_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->chunks_to_patch.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null chunks_to_patch in CommitDataRequest struct");
    fragment->flush_request_id = Traits::flush_request_id(input);
  }

  static bool Deserialize(::tracing::mojom::internal::CommitDataRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::CommitDataRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::ChromeConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::ChromeConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::ChromeConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::trace_config(input)) in_trace_config = Traits::trace_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trace_config)::BaseType> trace_config_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_trace_config, trace_config_fragment);
    fragment->trace_config.Set(
        trace_config_fragment.is_null() ? nullptr : trace_config_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->trace_config.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null trace_config in ChromeConfig struct");
    fragment->privacy_filtering_enabled = Traits::privacy_filtering_enabled(input);
    fragment->convert_to_legacy_json = Traits::convert_to_legacy_json(input);
    mojo::internal::Serialize<::tracing::mojom::TracingClientPriority>(
        Traits::client_priority(input), &fragment->client_priority);
  }

  static bool Deserialize(::tracing::mojom::internal::ChromeConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::ChromeConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::ConsoleConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::ConsoleConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::ConsoleConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::tracing::mojom::ConsoleOutput>(
        Traits::output(input), &fragment->output);
    fragment->enable_colors = Traits::enable_colors(input);
  }

  static bool Deserialize(::tracing::mojom::internal::ConsoleConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::ConsoleConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::InterceptorConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::InterceptorConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::InterceptorConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in InterceptorConfig struct");
    decltype(Traits::console_config(input)) in_console_config = Traits::console_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->console_config)::BaseType> console_config_fragment(
            fragment.message());
    mojo::internal::Serialize<::tracing::mojom::ConsoleConfigDataView>(
        in_console_config, console_config_fragment);
    fragment->console_config.Set(
        console_config_fragment.is_null() ? nullptr : console_config_fragment.data());
  }

  static bool Deserialize(::tracing::mojom::internal::InterceptorConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::InterceptorConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::DataSourceConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::DataSourceConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::DataSourceConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in DataSourceConfig struct");
    fragment->target_buffer = Traits::target_buffer(input);
    fragment->trace_duration_ms = Traits::trace_duration_ms(input);
    fragment->tracing_session_id = Traits::tracing_session_id(input);
    decltype(Traits::chrome_config(input)) in_chrome_config = Traits::chrome_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->chrome_config)::BaseType> chrome_config_fragment(
            fragment.message());
    mojo::internal::Serialize<::tracing::mojom::ChromeConfigDataView>(
        in_chrome_config, chrome_config_fragment);
    fragment->chrome_config.Set(
        chrome_config_fragment.is_null() ? nullptr : chrome_config_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->chrome_config.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null chrome_config in DataSourceConfig struct");
    decltype(Traits::interceptor_config(input)) in_interceptor_config = Traits::interceptor_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interceptor_config)::BaseType> interceptor_config_fragment(
            fragment.message());
    mojo::internal::Serialize<::tracing::mojom::InterceptorConfigDataView>(
        in_interceptor_config, interceptor_config_fragment);
    fragment->interceptor_config.Set(
        interceptor_config_fragment.is_null() ? nullptr : interceptor_config_fragment.data());
    decltype(Traits::legacy_config(input)) in_legacy_config = Traits::legacy_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->legacy_config)::BaseType> legacy_config_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_legacy_config, legacy_config_fragment);
    fragment->legacy_config.Set(
        legacy_config_fragment.is_null() ? nullptr : legacy_config_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->legacy_config.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null legacy_config in DataSourceConfig struct");
    decltype(Traits::track_event_config_raw(input)) in_track_event_config_raw = Traits::track_event_config_raw(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->track_event_config_raw)::BaseType> track_event_config_raw_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
        in_track_event_config_raw, track_event_config_raw_fragment);
    fragment->track_event_config_raw.Set(
        track_event_config_raw_fragment.is_null() ? nullptr : track_event_config_raw_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->track_event_config_raw.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null track_event_config_raw in DataSourceConfig struct");
    decltype(Traits::etw_config_raw(input)) in_etw_config_raw = Traits::etw_config_raw(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->etw_config_raw)::BaseType> etw_config_raw_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
        in_etw_config_raw, etw_config_raw_fragment);
    fragment->etw_config_raw.Set(
        etw_config_raw_fragment.is_null() ? nullptr : etw_config_raw_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->etw_config_raw.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null etw_config_raw in DataSourceConfig struct");
    decltype(Traits::system_metrics_config_raw(input)) in_system_metrics_config_raw = Traits::system_metrics_config_raw(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->system_metrics_config_raw)::BaseType> system_metrics_config_raw_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
        in_system_metrics_config_raw, system_metrics_config_raw_fragment);
    fragment->system_metrics_config_raw.Set(
        system_metrics_config_raw_fragment.is_null() ? nullptr : system_metrics_config_raw_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->system_metrics_config_raw.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null system_metrics_config_raw in DataSourceConfig struct");
  }

  static bool Deserialize(::tracing::mojom::internal::DataSourceConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::DataSourceConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::DataSourceRegistrationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::DataSourceRegistrationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::DataSourceRegistration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in DataSourceRegistration struct");
    fragment->will_notify_on_start = Traits::will_notify_on_start(input);
    fragment->will_notify_on_stop = Traits::will_notify_on_stop(input);
    fragment->handles_incremental_state_clear = Traits::handles_incremental_state_clear(input);
  }

  static bool Deserialize(::tracing::mojom::internal::DataSourceRegistration_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::DataSourceRegistrationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::BufferConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::BufferConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::BufferConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->size_kb = Traits::size_kb(input);
    mojo::internal::Serialize<::tracing::mojom::BufferFillPolicy>(
        Traits::fill_policy(input), &fragment->fill_policy);
  }

  static bool Deserialize(::tracing::mojom::internal::BufferConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::BufferConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::DataSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::DataSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::DataSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::config(input)) in_config = Traits::config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->config)::BaseType> config_fragment(
            fragment.message());
    mojo::internal::Serialize<::tracing::mojom::DataSourceConfigDataView>(
        in_config, config_fragment);
    fragment->config.Set(
        config_fragment.is_null() ? nullptr : config_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->config.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null config in DataSource struct");
    decltype(Traits::producer_name_filter(input)) in_producer_name_filter = Traits::producer_name_filter(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->producer_name_filter)::BaseType>
        producer_name_filter_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& producer_name_filter_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_producer_name_filter, producer_name_filter_fragment, &producer_name_filter_validate_params);
    fragment->producer_name_filter.Set(
        producer_name_filter_fragment.is_null() ? nullptr : producer_name_filter_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->producer_name_filter.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null producer_name_filter in DataSource struct");
  }

  static bool Deserialize(::tracing::mojom::internal::DataSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::DataSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::PerfettoBuiltinDataSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::PerfettoBuiltinDataSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::PerfettoBuiltinDataSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->disable_clock_snapshotting = Traits::disable_clock_snapshotting(input);
    fragment->disable_trace_config = Traits::disable_trace_config(input);
    fragment->disable_system_info = Traits::disable_system_info(input);
    fragment->disable_service_events = Traits::disable_service_events(input);
    fragment->primary_trace_clock_id = Traits::primary_trace_clock_id(input);
  }

  static bool Deserialize(::tracing::mojom::internal::PerfettoBuiltinDataSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::PerfettoBuiltinDataSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::IncrementalStateConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::IncrementalStateConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::IncrementalStateConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->clear_period_ms = Traits::clear_period_ms(input);
  }

  static bool Deserialize(::tracing::mojom::internal::IncrementalStateConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::IncrementalStateConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::TraceConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::TraceConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::TraceConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::data_sources(input)) in_data_sources = Traits::data_sources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data_sources)::BaseType>
        data_sources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_sources_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::tracing::mojom::DataSourceDataView>>(
        in_data_sources, data_sources_fragment, &data_sources_validate_params);
    fragment->data_sources.Set(
        data_sources_fragment.is_null() ? nullptr : data_sources_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data_sources.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data_sources in TraceConfig struct");
    decltype(Traits::perfetto_builtin_data_source(input)) in_perfetto_builtin_data_source = Traits::perfetto_builtin_data_source(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->perfetto_builtin_data_source)::BaseType> perfetto_builtin_data_source_fragment(
            fragment.message());
    mojo::internal::Serialize<::tracing::mojom::PerfettoBuiltinDataSourceDataView>(
        in_perfetto_builtin_data_source, perfetto_builtin_data_source_fragment);
    fragment->perfetto_builtin_data_source.Set(
        perfetto_builtin_data_source_fragment.is_null() ? nullptr : perfetto_builtin_data_source_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->perfetto_builtin_data_source.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null perfetto_builtin_data_source in TraceConfig struct");
    decltype(Traits::buffers(input)) in_buffers = Traits::buffers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->buffers)::BaseType>
        buffers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& buffers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::tracing::mojom::BufferConfigDataView>>(
        in_buffers, buffers_fragment, &buffers_validate_params);
    fragment->buffers.Set(
        buffers_fragment.is_null() ? nullptr : buffers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->buffers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null buffers in TraceConfig struct");
    decltype(Traits::incremental_state_config(input)) in_incremental_state_config = Traits::incremental_state_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->incremental_state_config)::BaseType> incremental_state_config_fragment(
            fragment.message());
    mojo::internal::Serialize<::tracing::mojom::IncrementalStateConfigDataView>(
        in_incremental_state_config, incremental_state_config_fragment);
    fragment->incremental_state_config.Set(
        incremental_state_config_fragment.is_null() ? nullptr : incremental_state_config_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->incremental_state_config.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null incremental_state_config in TraceConfig struct");
    fragment->duration_ms = Traits::duration_ms(input);
    fragment->write_into_file = Traits::write_into_file(input);
    decltype(Traits::trace_uuid(input)) in_trace_uuid = Traits::trace_uuid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trace_uuid)::BaseType> trace_uuid_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
        in_trace_uuid, trace_uuid_fragment);
    fragment->trace_uuid.Set(
        trace_uuid_fragment.is_null() ? nullptr : trace_uuid_fragment.data());
    decltype(Traits::unique_session_name(input)) in_unique_session_name = Traits::unique_session_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unique_session_name)::BaseType> unique_session_name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_unique_session_name, unique_session_name_fragment);
    fragment->unique_session_name.Set(
        unique_session_name_fragment.is_null() ? nullptr : unique_session_name_fragment.data());
  }

  static bool Deserialize(::tracing::mojom::internal::TraceConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::TraceConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace tracing::mojom {



inline void ChunkPatchDataView::GetDataDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}


inline void ChunksToPatchDataView::GetPatchesDataView(
    mojo::ArrayDataView<ChunkPatchDataView>* output) {
  auto pointer = data_->patches.Get();
  *output = mojo::ArrayDataView<ChunkPatchDataView>(pointer, message_);
}


inline void CommitDataRequestDataView::GetChunksToMoveDataView(
    mojo::ArrayDataView<ChunksToMoveDataView>* output) {
  auto pointer = data_->chunks_to_move.Get();
  *output = mojo::ArrayDataView<ChunksToMoveDataView>(pointer, message_);
}
inline void CommitDataRequestDataView::GetChunksToPatchDataView(
    mojo::ArrayDataView<ChunksToPatchDataView>* output) {
  auto pointer = data_->chunks_to_patch.Get();
  *output = mojo::ArrayDataView<ChunksToPatchDataView>(pointer, message_);
}


inline void ChromeConfigDataView::GetTraceConfigDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->trace_config.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void InterceptorConfigDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void InterceptorConfigDataView::GetConsoleConfigDataView(
    ConsoleConfigDataView* output) {
  auto pointer = data_->console_config.Get();
  *output = ConsoleConfigDataView(pointer, message_);
}


inline void DataSourceConfigDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DataSourceConfigDataView::GetChromeConfigDataView(
    ChromeConfigDataView* output) {
  auto pointer = data_->chrome_config.Get();
  *output = ChromeConfigDataView(pointer, message_);
}
inline void DataSourceConfigDataView::GetInterceptorConfigDataView(
    InterceptorConfigDataView* output) {
  auto pointer = data_->interceptor_config.Get();
  *output = InterceptorConfigDataView(pointer, message_);
}
inline void DataSourceConfigDataView::GetLegacyConfigDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->legacy_config.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DataSourceConfigDataView::GetTrackEventConfigRawDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->track_event_config_raw.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}
inline void DataSourceConfigDataView::GetEtwConfigRawDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->etw_config_raw.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}
inline void DataSourceConfigDataView::GetSystemMetricsConfigRawDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->system_metrics_config_raw.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}


inline void DataSourceRegistrationDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void DataSourceDataView::GetConfigDataView(
    DataSourceConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = DataSourceConfigDataView(pointer, message_);
}
inline void DataSourceDataView::GetProducerNameFilterDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->producer_name_filter.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}






inline void TraceConfigDataView::GetDataSourcesDataView(
    mojo::ArrayDataView<DataSourceDataView>* output) {
  auto pointer = data_->data_sources.Get();
  *output = mojo::ArrayDataView<DataSourceDataView>(pointer, message_);
}
inline void TraceConfigDataView::GetPerfettoBuiltinDataSourceDataView(
    PerfettoBuiltinDataSourceDataView* output) {
  auto pointer = data_->perfetto_builtin_data_source.Get();
  *output = PerfettoBuiltinDataSourceDataView(pointer, message_);
}
inline void TraceConfigDataView::GetBuffersDataView(
    mojo::ArrayDataView<BufferConfigDataView>* output) {
  auto pointer = data_->buffers.Get();
  *output = mojo::ArrayDataView<BufferConfigDataView>(pointer, message_);
}
inline void TraceConfigDataView::GetIncrementalStateConfigDataView(
    IncrementalStateConfigDataView* output) {
  auto pointer = data_->incremental_state_config.Get();
  *output = IncrementalStateConfigDataView(pointer, message_);
}
inline void TraceConfigDataView::GetTraceUuidDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->trace_uuid.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void TraceConfigDataView::GetUniqueSessionNameDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->unique_session_name.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}



}  // tracing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(TRACING_MOJOM_SHARED) TraceFormatTraits<::tracing::mojom::ConsoleOutput> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tracing::mojom::ConsoleOutput value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(TRACING_MOJOM_SHARED) TraceFormatTraits<::tracing::mojom::BufferFillPolicy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tracing::mojom::BufferFillPolicy value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(TRACING_MOJOM_SHARED) TraceFormatTraits<::tracing::mojom::TracingClientPriority> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tracing::mojom::TracingClientPriority value);
};

} // namespace perfetto

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_SHARED_H_