// services/video_capture/public/mojom/video_source_provider.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/video_capture/public/mojom/video_source_provider.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/video_source_provider.mojom-params-data.h"
namespace video_capture {
namespace mojom {

NOINLINE static const char* VideoSourceProvider_GetSourceInfosResultToStringHelper(VideoSourceProvider_GetSourceInfosResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoSourceProvider_GetSourceInfosResult::kSuccess:
      return "kSuccess";
    case VideoSourceProvider_GetSourceInfosResult::kErrorDroppedRequest:
      return "kErrorDroppedRequest";
    default:
      return nullptr;
  }
}

std::string VideoSourceProvider_GetSourceInfosResultToString(VideoSourceProvider_GetSourceInfosResult value) {
  const char *str = VideoSourceProvider_GetSourceInfosResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoSourceProvider_GetSourceInfosResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoSourceProvider_GetSourceInfosResult value) {
  return os << VideoSourceProvider_GetSourceInfosResultToString(value);
}

namespace internal {


// static
bool VideoSourceProvider_GetSourceInfos_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoSourceProvider_GetSourceInfos_Params_Data* object =
      static_cast<const VideoSourceProvider_GetSourceInfos_Params_Data*>(data);

  return true;
}

VideoSourceProvider_GetSourceInfos_Params_Data::VideoSourceProvider_GetSourceInfos_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoSourceProvider_GetSourceInfos_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoSourceProvider_GetSourceInfos_ResponseParams_Data* object =
      static_cast<const VideoSourceProvider_GetSourceInfos_ResponseParams_Data*>(data);


  if (!::video_capture::mojom::internal::VideoSourceProvider_GetSourceInfosResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_infos, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_infos, validation_context,
                                         &source_infos_validate_params)) {
    return false;
  }

  return true;
}

VideoSourceProvider_GetSourceInfos_ResponseParams_Data::VideoSourceProvider_GetSourceInfos_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoSourceProvider_GetVideoSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoSourceProvider_GetVideoSource_Params_Data* object =
      static_cast<const VideoSourceProvider_GetVideoSource_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_id, validation_context,
                                         &source_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->stream, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->stream,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoSourceProvider_GetVideoSource_Params_Data::VideoSourceProvider_GetVideoSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoSourceProvider_AddSharedMemoryVirtualDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoSourceProvider_AddSharedMemoryVirtualDevice_Params_Data* object =
      static_cast<const VideoSourceProvider_AddSharedMemoryVirtualDevice_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->producer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->producer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->virtual_device_receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->virtual_device_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoSourceProvider_AddSharedMemoryVirtualDevice_Params_Data::VideoSourceProvider_AddSharedMemoryVirtualDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoSourceProvider_AddTextureVirtualDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoSourceProvider_AddTextureVirtualDevice_Params_Data* object =
      static_cast<const VideoSourceProvider_AddTextureVirtualDevice_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->virtual_device_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->virtual_device_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoSourceProvider_AddTextureVirtualDevice_Params_Data::VideoSourceProvider_AddTextureVirtualDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoSourceProvider_RegisterVirtualDevicesChangedObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoSourceProvider_RegisterVirtualDevicesChangedObserver_Params_Data* object =
      static_cast<const VideoSourceProvider_RegisterVirtualDevicesChangedObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoSourceProvider_RegisterVirtualDevicesChangedObserver_Params_Data::VideoSourceProvider_RegisterVirtualDevicesChangedObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoSourceProvider_RegisterDevicesChangedObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoSourceProvider_RegisterDevicesChangedObserver_Params_Data* object =
      static_cast<const VideoSourceProvider_RegisterDevicesChangedObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoSourceProvider_RegisterDevicesChangedObserver_Params_Data::VideoSourceProvider_RegisterDevicesChangedObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoSourceProvider_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoSourceProvider_Close_Params_Data* object =
      static_cast<const VideoSourceProvider_Close_Params_Data*>(data);

  return true;
}

VideoSourceProvider_Close_Params_Data::VideoSourceProvider_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoSourceProvider_Close_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoSourceProvider_Close_ResponseParams_Data* object =
      static_cast<const VideoSourceProvider_Close_ResponseParams_Data*>(data);

  return true;
}

VideoSourceProvider_Close_ResponseParams_Data::VideoSourceProvider_Close_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace video_capture

namespace perfetto {

// static
void TraceFormatTraits<::video_capture::mojom::VideoSourceProvider_GetSourceInfosResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::video_capture::mojom::VideoSourceProvider_GetSourceInfosResult value) {
  return std::move(context).WriteString(::video_capture::mojom::VideoSourceProvider_GetSourceInfosResultToString(value));
}

} // namespace perfetto