// services/video_effects/public/mojom/video_effects_processor.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_EFFECTS_PUBLIC_MOJOM_VIDEO_EFFECTS_PROCESSOR_MOJOM_PARAMS_DATA_H_
#define SERVICES_VIDEO_EFFECTS_PUBLIC_MOJOM_VIDEO_EFFECTS_PROCESSOR_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace video_effects::mojom {
namespace internal {
class  VideoEffectsProcessor_PostProcess_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::media::mojom::internal::VideoBufferHandle_Data input_frame_data;
  mojo::internal::Pointer<::media::mojom::internal::VideoFrameInfo_Data> input_frame_info;
  ::media::mojom::internal::VideoBufferHandle_Data result_frame_data;
  int32_t result_pixel_format;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<VideoEffectsProcessor_PostProcess_Params_Data>;

  VideoEffectsProcessor_PostProcess_Params_Data();
  ~VideoEffectsProcessor_PostProcess_Params_Data() = delete;
};
static_assert(sizeof(VideoEffectsProcessor_PostProcess_Params_Data) == 56,
              "Bad sizeof(VideoEffectsProcessor_PostProcess_Params_Data)");
class  VideoEffectsProcessor_PostProcess_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::PostProcessResult_Data result;

 private:
  friend class mojo::internal::MessageFragment<VideoEffectsProcessor_PostProcess_ResponseParams_Data>;

  VideoEffectsProcessor_PostProcess_ResponseParams_Data();
  ~VideoEffectsProcessor_PostProcess_ResponseParams_Data() = delete;
};
static_assert(sizeof(VideoEffectsProcessor_PostProcess_ResponseParams_Data) == 24,
              "Bad sizeof(VideoEffectsProcessor_PostProcess_ResponseParams_Data)");

}  // namespace internal


class VideoEffectsProcessor_PostProcess_ParamsDataView {
 public:
  VideoEffectsProcessor_PostProcess_ParamsDataView() = default;

  VideoEffectsProcessor_PostProcess_ParamsDataView(
      internal::VideoEffectsProcessor_PostProcess_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputFrameDataDataView(
      ::media::mojom::VideoBufferHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputFrameData(UserType* output) {
    
    auto* pointer = !data_->input_frame_data.is_null() ? &data_->input_frame_data : nullptr;
    return mojo::internal::Deserialize<::media::mojom::VideoBufferHandleDataView>(
        pointer, output, message_);
  }
  inline void GetInputFrameInfoDataView(
      ::media::mojom::VideoFrameInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputFrameInfo(UserType* output) {
    
    auto* pointer = data_->input_frame_info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameInfoDataView>(
        pointer, output, message_);
  }
  inline void GetResultFrameDataDataView(
      ::media::mojom::VideoBufferHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResultFrameData(UserType* output) {
    
    auto* pointer = !data_->result_frame_data.is_null() ? &data_->result_frame_data : nullptr;
    return mojo::internal::Deserialize<::media::mojom::VideoBufferHandleDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResultPixelFormat(UserType* output) const {
    auto data_value = data_->result_pixel_format;
    return mojo::internal::Deserialize<::media::mojom::VideoPixelFormat>(
        data_value, output);
  }
  ::media::mojom::VideoPixelFormat result_pixel_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoPixelFormat>(data_->result_pixel_format));
  }
 private:
  internal::VideoEffectsProcessor_PostProcess_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEffectsProcessor_PostProcess_ResponseParamsDataView {
 public:
  VideoEffectsProcessor_PostProcess_ResponseParamsDataView() = default;

  VideoEffectsProcessor_PostProcess_ResponseParamsDataView(
      internal::VideoEffectsProcessor_PostProcess_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      PostProcessResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::video_effects::mojom::PostProcessResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoEffectsProcessor_PostProcess_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void VideoEffectsProcessor_PostProcess_ParamsDataView::GetInputFrameDataDataView(
    ::media::mojom::VideoBufferHandleDataView* output) {
  auto pointer = &data_->input_frame_data;
  *output = ::media::mojom::VideoBufferHandleDataView(pointer, message_);
}
inline void VideoEffectsProcessor_PostProcess_ParamsDataView::GetInputFrameInfoDataView(
    ::media::mojom::VideoFrameInfoDataView* output) {
  auto pointer = data_->input_frame_info.Get();
  *output = ::media::mojom::VideoFrameInfoDataView(pointer, message_);
}
inline void VideoEffectsProcessor_PostProcess_ParamsDataView::GetResultFrameDataDataView(
    ::media::mojom::VideoBufferHandleDataView* output) {
  auto pointer = &data_->result_frame_data;
  *output = ::media::mojom::VideoBufferHandleDataView(pointer, message_);
}


inline void VideoEffectsProcessor_PostProcess_ResponseParamsDataView::GetResultDataView(
    PostProcessResultDataView* output) {
  auto pointer = &data_->result;
  *output = PostProcessResultDataView(pointer, message_);
}



}  // video_effects::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_VIDEO_EFFECTS_PUBLIC_MOJOM_VIDEO_EFFECTS_PROCESSOR_MOJOM_PARAMS_DATA_H_