// services/viz/public/mojom/compositing/bitmap_in_shared_memory.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BITMAP_IN_SHARED_MEMORY_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BITMAP_IN_SHARED_MEMORY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/bitmap_in_shared_memory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace viz::mojom {
class BitmapInSharedMemoryDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::BitmapInSharedMemoryDataView> {
  using Data = ::viz::mojom::internal::BitmapInSharedMemory_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class BitmapInSharedMemoryDataView {
 public:
  BitmapInSharedMemoryDataView() = default;

  BitmapInSharedMemoryDataView(
      internal::BitmapInSharedMemory_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageInfoDataView(
      ::skia::mojom::ImageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageInfo(UserType* output) {
    
    auto* pointer = data_->image_info.Get();
    return mojo::internal::Deserialize<::skia::mojom::ImageInfoDataView>(
        pointer, output, message_);
  }
  uint64_t row_bytes() const {
    return data_->row_bytes;
  }
  inline void GetPixelsDataView(
      ::mojo_base::mojom::WritableSharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPixels(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::WritableSharedMemoryRegionDataView, UserType>(),
    "Attempting to read the optional `pixels` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPixels` instead "
    "of `ReadPixels if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pixels.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::WritableSharedMemoryRegionDataView>(
        pointer, output, message_);
  }
 private:
  internal::BitmapInSharedMemory_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BitmapInSharedMemoryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BitmapInSharedMemoryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BitmapInSharedMemory_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::image_info(input)) in_image_info = Traits::image_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_info)::BaseType> image_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::ImageInfoDataView>(
        in_image_info, image_info_fragment);
    fragment->image_info.Set(
        image_info_fragment.is_null() ? nullptr : image_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->image_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_info in BitmapInSharedMemory struct");
    fragment->row_bytes = Traits::row_bytes(input);
    decltype(Traits::pixels(input)) in_pixels = Traits::pixels(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pixels)::BaseType> pixels_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::WritableSharedMemoryRegionDataView>(
        in_pixels, pixels_fragment);
    fragment->pixels.Set(
        pixels_fragment.is_null() ? nullptr : pixels_fragment.data());
  }

  static bool Deserialize(::viz::mojom::internal::BitmapInSharedMemory_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::BitmapInSharedMemoryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void BitmapInSharedMemoryDataView::GetImageInfoDataView(
    ::skia::mojom::ImageInfoDataView* output) {
  auto pointer = data_->image_info.Get();
  *output = ::skia::mojom::ImageInfoDataView(pointer, message_);
}
inline void BitmapInSharedMemoryDataView::GetPixelsDataView(
    ::mojo_base::mojom::WritableSharedMemoryRegionDataView* output) {
  auto pointer = data_->pixels.Get();
  *output = ::mojo_base::mojom::WritableSharedMemoryRegionDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BITMAP_IN_SHARED_MEMORY_MOJOM_SHARED_H_