// third_party/blink/public/mojom/ai/ai_writer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/ai/ai_writer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/ai/ai_writer.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* AIWriterToneToStringHelper(AIWriterTone value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AIWriterTone::kFormal:
      return "kFormal";
    case AIWriterTone::kNeutral:
      return "kNeutral";
    case AIWriterTone::kCasual:
      return "kCasual";
    default:
      return nullptr;
  }
}

std::string AIWriterToneToString(AIWriterTone value) {
  const char *str = AIWriterToneToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AIWriterTone value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AIWriterTone value) {
  return os << AIWriterToneToString(value);
}

NOINLINE static const char* AIWriterFormatToStringHelper(AIWriterFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AIWriterFormat::kPlainText:
      return "kPlainText";
    case AIWriterFormat::kMarkdown:
      return "kMarkdown";
    default:
      return nullptr;
  }
}

std::string AIWriterFormatToString(AIWriterFormat value) {
  const char *str = AIWriterFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AIWriterFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AIWriterFormat value) {
  return os << AIWriterFormatToString(value);
}

NOINLINE static const char* AIWriterLengthToStringHelper(AIWriterLength value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AIWriterLength::kShort:
      return "kShort";
    case AIWriterLength::kMedium:
      return "kMedium";
    case AIWriterLength::kLong:
      return "kLong";
    default:
      return nullptr;
  }
}

std::string AIWriterLengthToString(AIWriterLength value) {
  const char *str = AIWriterLengthToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AIWriterLength value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AIWriterLength value) {
  return os << AIWriterLengthToString(value);
}

namespace internal {


// static
bool AIWriterCreateOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIWriterCreateOptions_Data* object =
      static_cast<const AIWriterCreateOptions_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& shared_context_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->shared_context, validation_context,
                                         &shared_context_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::AIWriterTone_Data
        ::Validate(object->tone, validation_context))
    return false;


  if (!::blink::mojom::internal::AIWriterFormat_Data
        ::Validate(object->format, validation_context))
    return false;


  if (!::blink::mojom::internal::AIWriterLength_Data
        ::Validate(object->length, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expected_input_languages, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& expected_input_languages_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->expected_input_languages, validation_context,
                                         &expected_input_languages_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expected_context_languages, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& expected_context_languages_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->expected_context_languages, validation_context,
                                         &expected_context_languages_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_language, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& output_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->output_language, validation_context,
                                         &output_language_validate_params)) {
    return false;
  }

  return true;
}

AIWriterCreateOptions_Data::AIWriterCreateOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIWriter_Write_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIWriter_Write_Params_Data* object =
      static_cast<const AIWriter_Write_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input, validation_context,
                                         &input_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& context_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->context, validation_context,
                                         &context_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_responder, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_responder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AIWriter_Write_Params_Data::AIWriter_Write_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AIWriterTone>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AIWriterTone value) {
  return std::move(context).WriteString(::blink::mojom::AIWriterToneToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AIWriterFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AIWriterFormat value) {
  return std::move(context).WriteString(::blink::mojom::AIWriterFormatToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AIWriterLength>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AIWriterLength value) {
  return std::move(context).WriteString(::blink::mojom::AIWriterLengthToString(value));
}

} // namespace perfetto