// third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_ERROR_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_ERROR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_error.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class FileSystemAccessErrorDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FileSystemAccessErrorDataView> {
  using Data = ::blink::mojom::internal::FileSystemAccessError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class FileSystemAccessStatus : int32_t {
  
  kOk = 0,
  
  kPermissionDenied = 1,
  
  kSecurityError = 2,
  
  kNoModificationAllowedError = 3,
  
  kInvalidModificationError = 4,
  
  kNotSupportedError = 5,
  
  kInvalidState = 6,
  
  kInvalidArgument = 7,
  
  kOperationFailed = 8,
  
  kOperationAborted = 9,
  
  kFileError = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FileSystemAccessStatus value);
inline bool IsKnownEnumValue(FileSystemAccessStatus value) {
  return internal::FileSystemAccessStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FileSystemAccessErrorDataView {
 public:
  FileSystemAccessErrorDataView() = default;

  FileSystemAccessErrorDataView(
      internal::FileSystemAccessError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::blink::mojom::FileSystemAccessStatus>(
        data_value, output);
  }
  FileSystemAccessStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FileSystemAccessStatus>(data_->status));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFileError(UserType* output) const {
    auto data_value = data_->file_error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError file_error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->file_error));
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemAccessError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::FileSystemAccessStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FileSystemAccessStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FileSystemAccessStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FileSystemAccessStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::FileSystemAccessStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FileSystemAccessErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FileSystemAccessErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FileSystemAccessError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::FileSystemAccessStatus>(
        Traits::status(input), &fragment->status);
    mojo::internal::Serialize<::mojo_base::mojom::FileError>(
        Traits::file_error(input), &fragment->file_error);
    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_message, message_fragment);
    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->message.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in FileSystemAccessError struct");
  }

  static bool Deserialize(::blink::mojom::internal::FileSystemAccessError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FileSystemAccessErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void FileSystemAccessErrorDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::FileSystemAccessStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::FileSystemAccessStatus value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_ERROR_MOJOM_SHARED_H_