// third_party/blink/public/mojom/font_access/font_access.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/font_access/font_access.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/font_access/font_access.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* FontEnumerationStatusToStringHelper(FontEnumerationStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FontEnumerationStatus::kOk:
      return "kOk";
    case FontEnumerationStatus::kUnimplemented:
      return "kUnimplemented";
    case FontEnumerationStatus::kUnexpectedError:
      return "kUnexpectedError";
    case FontEnumerationStatus::kNeedsUserActivation:
      return "kNeedsUserActivation";
    case FontEnumerationStatus::kNotVisible:
      return "kNotVisible";
    case FontEnumerationStatus::kPermissionDenied:
      return "kPermissionDenied";
    default:
      return nullptr;
  }
}

std::string FontEnumerationStatusToString(FontEnumerationStatus value) {
  const char *str = FontEnumerationStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FontEnumerationStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FontEnumerationStatus value) {
  return os << FontEnumerationStatusToString(value);
}

namespace internal {


// static
bool FontData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FontData_Data* object =
      static_cast<const FontData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->postscript_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& postscript_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->postscript_name, validation_context,
                                         &postscript_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->full_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& full_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->full_name, validation_context,
                                         &full_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->family, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& family_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->family, validation_context,
                                         &family_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->style, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& style_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->style, validation_context,
                                         &style_validate_params)) {
    return false;
  }

  return true;
}

FontData_Data::FontData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontAccessManager_EnumerateLocalFonts_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FontAccessManager_EnumerateLocalFonts_Params_Data* object =
      static_cast<const FontAccessManager_EnumerateLocalFonts_Params_Data*>(data);

  return true;
}

FontAccessManager_EnumerateLocalFonts_Params_Data::FontAccessManager_EnumerateLocalFonts_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontAccessManager_EnumerateLocalFonts_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FontAccessManager_EnumerateLocalFonts_ResponseParams_Data* object =
      static_cast<const FontAccessManager_EnumerateLocalFonts_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::FontEnumerationStatus_Data
        ::Validate(object->enumeration_status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->enumeration_table, validation_context))
    return false;

  return true;
}

FontAccessManager_EnumerateLocalFonts_ResponseParams_Data::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FontEnumerationStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FontEnumerationStatus value) {
  return std::move(context).WriteString(::blink::mojom::FontEnumerationStatusToString(value));
}

} // namespace perfetto