// third_party/blink/public/mojom/input/input_handler.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/input/input_handler.mojom-shared-internal.h"
#include "cc/mojom/browser_controls_offset_tag_modifications.mojom-shared.h"
#include "cc/mojom/browser_controls_state.mojom-shared.h"
#include "cc/mojom/overscroll_behavior.mojom-shared.h"
#include "cc/mojom/touch_action.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/input/gesture_event.mojom-shared.h"
#include "third_party/blink/public/mojom/input/handwriting_gesture_result.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_event_result.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_event.mojom-shared.h"
#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-shared.h"
#include "third_party/blink/public/mojom/input/pointer_lock_result.mojom-shared.h"
#include "third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-shared.h"
#include "third_party/blink/public/mojom/input/touch_event.mojom-shared.h"
#include "third_party/blink/public/mojom/selection_menu/selection_menu_behavior.mojom-shared.h"
#include "ui/base/ime/mojom/ime_types.mojom-shared.h"
#include "ui/events/mojom/event_constants.mojom-shared.h"
#include "ui/events/mojom/event_latency_metadata.mojom-shared.h"
#include "ui/events/mojom/event.mojom-shared.h"
#include "ui/events/mojom/scroll_granularity.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"
#include "ui/latency/mojom/latency_info.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace blink::mojom {
class KeyDataDataView;

class PointerDataDataView;

class WheelDataDataView;

class MouseDataDataView;

class ScrollDataDataView;

class PinchBeginDataDataView;

class PinchUpdateDataDataView;

class PinchEndDataDataView;

class FlingDataDataView;

class TapDataDataView;

class TapDownDataDataView;

class GestureDataDataView;

class TouchPointDataView;

class TouchDataDataView;

class EventDataView;

class DidOverscrollParamsDataView;

class TouchActionOptionalDataView;

class EditCommandDataView;

class SelectAroundCaretResultDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::KeyDataDataView> {
  using Data = ::blink::mojom::internal::KeyData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PointerDataDataView> {
  using Data = ::blink::mojom::internal::PointerData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WheelDataDataView> {
  using Data = ::blink::mojom::internal::WheelData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MouseDataDataView> {
  using Data = ::blink::mojom::internal::MouseData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ScrollDataDataView> {
  using Data = ::blink::mojom::internal::ScrollData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PinchBeginDataDataView> {
  using Data = ::blink::mojom::internal::PinchBeginData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PinchUpdateDataDataView> {
  using Data = ::blink::mojom::internal::PinchUpdateData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PinchEndDataDataView> {
  using Data = ::blink::mojom::internal::PinchEndData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FlingDataDataView> {
  using Data = ::blink::mojom::internal::FlingData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TapDataDataView> {
  using Data = ::blink::mojom::internal::TapData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TapDownDataDataView> {
  using Data = ::blink::mojom::internal::TapDownData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GestureDataDataView> {
  using Data = ::blink::mojom::internal::GestureData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TouchPointDataView> {
  using Data = ::blink::mojom::internal::TouchPoint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TouchDataDataView> {
  using Data = ::blink::mojom::internal::TouchData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::EventDataView> {
  using Data = ::blink::mojom::internal::Event_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DidOverscrollParamsDataView> {
  using Data = ::blink::mojom::internal::DidOverscrollParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TouchActionOptionalDataView> {
  using Data = ::blink::mojom::internal::TouchActionOptional_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::EditCommandDataView> {
  using Data = ::blink::mojom::internal::EditCommand_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SelectAroundCaretResultDataView> {
  using Data = ::blink::mojom::internal::SelectAroundCaretResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class SelectionGranularity : int32_t {
  
  kWord = 0,
  
  kSentence = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SelectionGranularity value);
inline bool IsKnownEnumValue(SelectionGranularity value) {
  return internal::SelectionGranularity_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PanAction : int32_t {
  
  kNone = 0,
  
  kScroll = 1,
  
  kMoveCursorOrScroll = 2,
  
  kStylusWritable = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PanAction value);
inline bool IsKnownEnumValue(PanAction value) {
  return internal::PanAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FocusState : int32_t {
  
  kFocused = 0,
  
  kNotFocusedAndActive = 1,
  
  kNotFocusedAndNotActive = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FocusState value);
inline bool IsKnownEnumValue(FocusState value) {
  return internal::FocusState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WidgetInputHandlerHostInterfaceBase {};

using WidgetInputHandlerHostPtrDataView =
    mojo::InterfacePtrDataView<WidgetInputHandlerHostInterfaceBase>;
using WidgetInputHandlerHostRequestDataView =
    mojo::InterfaceRequestDataView<WidgetInputHandlerHostInterfaceBase>;
using WidgetInputHandlerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WidgetInputHandlerHostInterfaceBase>;
using WidgetInputHandlerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WidgetInputHandlerHostInterfaceBase>;
class FrameWidgetInputHandlerInterfaceBase {};

using FrameWidgetInputHandlerPtrDataView =
    mojo::InterfacePtrDataView<FrameWidgetInputHandlerInterfaceBase>;
using FrameWidgetInputHandlerRequestDataView =
    mojo::InterfaceRequestDataView<FrameWidgetInputHandlerInterfaceBase>;
using FrameWidgetInputHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameWidgetInputHandlerInterfaceBase>;
using FrameWidgetInputHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameWidgetInputHandlerInterfaceBase>;
class WidgetInputHandlerInterfaceBase {};

using WidgetInputHandlerPtrDataView =
    mojo::InterfacePtrDataView<WidgetInputHandlerInterfaceBase>;
using WidgetInputHandlerRequestDataView =
    mojo::InterfaceRequestDataView<WidgetInputHandlerInterfaceBase>;
using WidgetInputHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WidgetInputHandlerInterfaceBase>;
using WidgetInputHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WidgetInputHandlerInterfaceBase>;


class KeyDataDataView {
 public:
  KeyDataDataView() = default;

  KeyDataDataView(
      internal::KeyData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t dom_key() const {
    return data_->dom_key;
  }
  int32_t dom_code() const {
    return data_->dom_code;
  }
  int32_t windows_key_code() const {
    return data_->windows_key_code;
  }
  int32_t native_key_code() const {
    return data_->native_key_code;
  }
  bool is_system_key() const {
    return data_->is_system_key;
  }
  bool is_browser_shortcut() const {
    return data_->is_browser_shortcut;
  }
  inline void GetTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUnmodifiedTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnmodifiedText(UserType* output) {
    
    auto* pointer = data_->unmodified_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::KeyData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PointerDataDataView {
 public:
  PointerDataDataView() = default;

  PointerDataDataView(
      internal::PointerData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t pointer_id() const {
    return data_->pointer_id;
  }
  float force() const {
    return data_->force;
  }
  double tilt_x() const {
    return data_->tilt_x;
  }
  double tilt_y() const {
    return data_->tilt_y;
  }
  float tangential_pressure() const {
    return data_->tangential_pressure;
  }
  int32_t twist() const {
    return data_->twist;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadButton(UserType* output) const {
    auto data_value = data_->button;
    return mojo::internal::Deserialize<::blink::mojom::Button>(
        data_value, output);
  }
  ::blink::mojom::Button button() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::Button>(data_->button));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPointerType(UserType* output) const {
    auto data_value = data_->pointer_type;
    return mojo::internal::Deserialize<::ui::mojom::EventPointerType>(
        data_value, output);
  }
  ::ui::mojom::EventPointerType pointer_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::EventPointerType>(data_->pointer_type));
  }
  int32_t movement_x() const {
    return data_->movement_x;
  }
  int32_t movement_y() const {
    return data_->movement_y;
  }
  bool is_raw_movement_event() const {
    return data_->is_raw_movement_event;
  }
  inline void GetWidgetPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidgetPosition(UserType* output) {
    
    auto* pointer = data_->widget_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetScreenPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScreenPosition(UserType* output) {
    
    auto* pointer = data_->screen_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetMouseDataDataView(
      MouseDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMouseData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::MouseDataDataView, UserType>(),
    "Attempting to read the optional `mouse_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMouseData` instead "
    "of `ReadMouseData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mouse_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::MouseDataDataView>(
        pointer, output, message_);
  }
  int32_t device_id() const {
    return data_->device_id;
  }
 private:
  internal::PointerData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WheelDataDataView {
 public:
  WheelDataDataView() = default;

  WheelDataDataView(
      internal::WheelData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float delta_x() const {
    return data_->delta_x;
  }
  float delta_y() const {
    return data_->delta_y;
  }
  float wheel_ticks_x() const {
    return data_->wheel_ticks_x;
  }
  float wheel_ticks_y() const {
    return data_->wheel_ticks_y;
  }
  float acceleration_ratio_x() const {
    return data_->acceleration_ratio_x;
  }
  float acceleration_ratio_y() const {
    return data_->acceleration_ratio_y;
  }
  uint8_t phase() const {
    return data_->phase;
  }
  uint8_t momentum_phase() const {
    return data_->momentum_phase;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCancelable(UserType* output) const {
    auto data_value = data_->cancelable;
    return mojo::internal::Deserialize<::blink::mojom::DispatchType>(
        data_value, output);
  }
  ::blink::mojom::DispatchType cancelable() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DispatchType>(data_->cancelable));
  }
  uint8_t event_action() const {
    return data_->event_action;
  }
  uint8_t delta_units() const {
    return data_->delta_units;
  }
 private:
  internal::WheelData_Data* data_ = nullptr;
};


class MouseDataDataView {
 public:
  MouseDataDataView() = default;

  MouseDataDataView(
      internal::MouseData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t click_count() const {
    return data_->click_count;
  }
  inline void GetWheelDataDataView(
      WheelDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWheelData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::WheelDataDataView, UserType>(),
    "Attempting to read the optional `wheel_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWheelData` instead "
    "of `ReadWheelData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->wheel_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::WheelDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::MouseData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollDataDataView {
 public:
  ScrollDataDataView() = default;

  ScrollDataDataView(
      internal::ScrollData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float delta_x() const {
    return data_->delta_x;
  }
  float delta_y() const {
    return data_->delta_y;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDeltaUnits(UserType* output) const {
    auto data_value = data_->delta_units;
    return mojo::internal::Deserialize<::ui::mojom::ScrollGranularity>(
        data_value, output);
  }
  ::ui::mojom::ScrollGranularity delta_units() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::ScrollGranularity>(data_->delta_units));
  }
  bool target_viewport() const {
    return data_->target_viewport;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInertialPhase(UserType* output) const {
    auto data_value = data_->inertial_phase;
    return mojo::internal::Deserialize<::blink::mojom::InertialPhaseState>(
        data_value, output);
  }
  ::blink::mojom::InertialPhaseState inertial_phase() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InertialPhaseState>(data_->inertial_phase));
  }
  bool synthetic() const {
    return data_->synthetic;
  }
  int32_t pointer_count() const {
    return data_->pointer_count;
  }
  bool cursor_control() const {
    return data_->cursor_control;
  }
 private:
  internal::ScrollData_Data* data_ = nullptr;
};


class PinchBeginDataDataView {
 public:
  PinchBeginDataDataView() = default;

  PinchBeginDataDataView(
      internal::PinchBeginData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool needs_wheel_event() const {
    return data_->needs_wheel_event;
  }
 private:
  internal::PinchBeginData_Data* data_ = nullptr;
};


class PinchUpdateDataDataView {
 public:
  PinchUpdateDataDataView() = default;

  PinchUpdateDataDataView(
      internal::PinchUpdateData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float scale() const {
    return data_->scale;
  }
  bool zoom_disabled() const {
    return data_->zoom_disabled;
  }
  bool needs_wheel_event() const {
    return data_->needs_wheel_event;
  }
 private:
  internal::PinchUpdateData_Data* data_ = nullptr;
};


class PinchEndDataDataView {
 public:
  PinchEndDataDataView() = default;

  PinchEndDataDataView(
      internal::PinchEndData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool needs_wheel_event() const {
    return data_->needs_wheel_event;
  }
 private:
  internal::PinchEndData_Data* data_ = nullptr;
};


class FlingDataDataView {
 public:
  FlingDataDataView() = default;

  FlingDataDataView(
      internal::FlingData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float velocity_x() const {
    return data_->velocity_x;
  }
  float velocity_y() const {
    return data_->velocity_y;
  }
  bool target_viewport() const {
    return data_->target_viewport;
  }
  bool prevent_boosting() const {
    return data_->prevent_boosting;
  }
 private:
  internal::FlingData_Data* data_ = nullptr;
};


class TapDataDataView {
 public:
  TapDataDataView() = default;

  TapDataDataView(
      internal::TapData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t tap_count() const {
    return data_->tap_count;
  }
  bool needs_wheel_event() const {
    return data_->needs_wheel_event;
  }
 private:
  internal::TapData_Data* data_ = nullptr;
};


class TapDownDataDataView {
 public:
  TapDownDataDataView() = default;

  TapDownDataDataView(
      internal::TapDownData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t tap_down_count() const {
    return data_->tap_down_count;
  }
 private:
  internal::TapDownData_Data* data_ = nullptr;
};


class GestureDataDataView {
 public:
  GestureDataDataView() = default;

  GestureDataDataView(
      internal::GestureData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScreenPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScreenPosition(UserType* output) {
    
    auto* pointer = data_->screen_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetWidgetPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidgetPosition(UserType* output) {
    
    auto* pointer = data_->widget_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSourceDevice(UserType* output) const {
    auto data_value = data_->source_device;
    return mojo::internal::Deserialize<::blink::mojom::GestureDevice>(
        data_value, output);
  }
  ::blink::mojom::GestureDevice source_device() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::GestureDevice>(data_->source_device));
  }
  bool is_source_touch_event_set_blocking() const {
    return data_->is_source_touch_event_set_blocking;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryPointerType(UserType* output) const {
    auto data_value = data_->primary_pointer_type;
    return mojo::internal::Deserialize<::ui::mojom::EventPointerType>(
        data_value, output);
  }
  ::ui::mojom::EventPointerType primary_pointer_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::EventPointerType>(data_->primary_pointer_type));
  }
  int32_t primary_unique_touch_event_id() const {
    return data_->primary_unique_touch_event_id;
  }
  int32_t unique_touch_event_id() const {
    return data_->unique_touch_event_id;
  }
  inline void GetContactSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContactSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `contact_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContactSize` instead "
    "of `ReadContactSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->contact_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetScrollDataDataView(
      ScrollDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ScrollDataDataView, UserType>(),
    "Attempting to read the optional `scroll_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScrollData` instead "
    "of `ReadScrollData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->scroll_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::ScrollDataDataView>(
        pointer, output, message_);
  }
  inline void GetPinchBeginDataDataView(
      PinchBeginDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPinchBeginData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PinchBeginDataDataView, UserType>(),
    "Attempting to read the optional `pinch_begin_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPinchBeginData` instead "
    "of `ReadPinchBeginData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pinch_begin_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PinchBeginDataDataView>(
        pointer, output, message_);
  }
  inline void GetPinchUpdateDataDataView(
      PinchUpdateDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPinchUpdateData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PinchUpdateDataDataView, UserType>(),
    "Attempting to read the optional `pinch_update_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPinchUpdateData` instead "
    "of `ReadPinchUpdateData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pinch_update_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PinchUpdateDataDataView>(
        pointer, output, message_);
  }
  inline void GetPinchEndDataDataView(
      PinchEndDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPinchEndData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PinchEndDataDataView, UserType>(),
    "Attempting to read the optional `pinch_end_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPinchEndData` instead "
    "of `ReadPinchEndData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pinch_end_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PinchEndDataDataView>(
        pointer, output, message_);
  }
  inline void GetTapDataDataView(
      TapDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTapData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::TapDataDataView, UserType>(),
    "Attempting to read the optional `tap_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTapData` instead "
    "of `ReadTapData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tap_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::TapDataDataView>(
        pointer, output, message_);
  }
  inline void GetTapDownDataDataView(
      TapDownDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTapDownData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::TapDownDataDataView, UserType>(),
    "Attempting to read the optional `tap_down_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTapDownData` instead "
    "of `ReadTapDownData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tap_down_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::TapDownDataDataView>(
        pointer, output, message_);
  }
  inline void GetFlingDataDataView(
      FlingDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFlingData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FlingDataDataView, UserType>(),
    "Attempting to read the optional `fling_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFlingData` instead "
    "of `ReadFlingData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fling_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::FlingDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::GestureData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TouchPointDataView {
 public:
  TouchPointDataView() = default;

  TouchPointDataView(
      internal::TouchPoint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::blink::mojom::TouchState>(
        data_value, output);
  }
  ::blink::mojom::TouchState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::TouchState>(data_->state));
  }
  float radius_x() const {
    return data_->radius_x;
  }
  float radius_y() const {
    return data_->radius_y;
  }
  float rotation_angle() const {
    return data_->rotation_angle;
  }
  inline void GetPointerDataDataView(
      PointerDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointerData(UserType* output) {
    
    auto* pointer = data_->pointer_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PointerDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::TouchPoint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TouchDataDataView {
 public:
  TouchDataDataView() = default;

  TouchDataDataView(
      internal::TouchData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCancelable(UserType* output) const {
    auto data_value = data_->cancelable;
    return mojo::internal::Deserialize<::blink::mojom::DispatchType>(
        data_value, output);
  }
  ::blink::mojom::DispatchType cancelable() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DispatchType>(data_->cancelable));
  }
  bool moved_beyond_slop_region() const {
    return data_->moved_beyond_slop_region;
  }
  bool touch_start_or_first_move() const {
    return data_->touch_start_or_first_move;
  }
  bool hovering() const {
    return data_->hovering;
  }
  uint32_t unique_touch_event_id() const {
    return data_->unique_touch_event_id;
  }
  inline void GetTouchesDataView(
      mojo::ArrayDataView<TouchPointDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTouches(UserType* output) {
    
    auto* pointer = data_->touches.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::TouchPointDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TouchData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EventDataView {
 public:
  EventDataView() = default;

  EventDataView(
      internal::Event_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::EventType>(
        data_value, output);
  }
  ::blink::mojom::EventType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::EventType>(data_->type));
  }
  int32_t modifiers() const {
    return data_->modifiers;
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetLatencyDataView(
      ::ui::mojom::LatencyInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatency(UserType* output) {
    
    auto* pointer = data_->latency.Get();
    return mojo::internal::Deserialize<::ui::mojom::LatencyInfoDataView>(
        pointer, output, message_);
  }
  inline void GetEventLatencyMetadataDataView(
      ::ui::mojom::EventLatencyMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventLatencyMetadata(UserType* output) {
    
    auto* pointer = data_->event_latency_metadata.Get();
    return mojo::internal::Deserialize<::ui::mojom::EventLatencyMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetKeyDataDataView(
      KeyDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::KeyDataDataView, UserType>(),
    "Attempting to read the optional `key_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeyData` instead "
    "of `ReadKeyData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->key_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::KeyDataDataView>(
        pointer, output, message_);
  }
  inline void GetPointerDataDataView(
      PointerDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointerData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PointerDataDataView, UserType>(),
    "Attempting to read the optional `pointer_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPointerData` instead "
    "of `ReadPointerData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pointer_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PointerDataDataView>(
        pointer, output, message_);
  }
  inline void GetGestureDataDataView(
      GestureDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGestureData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::GestureDataDataView, UserType>(),
    "Attempting to read the optional `gesture_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGestureData` instead "
    "of `ReadGestureData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->gesture_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::GestureDataDataView>(
        pointer, output, message_);
  }
  inline void GetTouchDataDataView(
      TouchDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTouchData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::TouchDataDataView, UserType>(),
    "Attempting to read the optional `touch_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTouchData` instead "
    "of `ReadTouchData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->touch_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::TouchDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::Event_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DidOverscrollParamsDataView {
 public:
  DidOverscrollParamsDataView() = default;

  DidOverscrollParamsDataView(
      internal::DidOverscrollParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAccumulatedOverscrollDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccumulatedOverscroll(UserType* output) {
    
    auto* pointer = data_->accumulated_overscroll.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetLatestOverscrollDeltaDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatestOverscrollDelta(UserType* output) {
    
    auto* pointer = data_->latest_overscroll_delta.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetCurrentFlingVelocityDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrentFlingVelocity(UserType* output) {
    
    auto* pointer = data_->current_fling_velocity.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetCausalEventViewportPointDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCausalEventViewportPoint(UserType* output) {
    
    auto* pointer = data_->causal_event_viewport_point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetOverscrollBehaviorDataView(
      ::cc::mojom::OverscrollBehaviorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOverscrollBehavior(UserType* output) {
    
    auto* pointer = data_->overscroll_behavior.Get();
    return mojo::internal::Deserialize<::cc::mojom::OverscrollBehaviorDataView>(
        pointer, output, message_);
  }
 private:
  internal::DidOverscrollParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TouchActionOptionalDataView {
 public:
  TouchActionOptionalDataView() = default;

  TouchActionOptionalDataView(
      internal::TouchActionOptional_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadTouchAction(UserType* output) const {
    auto data_value = data_->touch_action;
    return mojo::internal::Deserialize<::cc::mojom::TouchAction>(
        data_value, output);
  }
  ::cc::mojom::TouchAction touch_action() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::cc::mojom::TouchAction>(data_->touch_action));
  }
 private:
  internal::TouchActionOptional_Data* data_ = nullptr;
};


class EditCommandDataView {
 public:
  EditCommandDataView() = default;

  EditCommandDataView(
      internal::EditCommand_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::EditCommand_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SelectAroundCaretResultDataView {
 public:
  SelectAroundCaretResultDataView() = default;

  SelectAroundCaretResultDataView(
      internal::SelectAroundCaretResult_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t extended_start_adjust() const {
    return data_->extended_start_adjust;
  }
  int32_t extended_end_adjust() const {
    return data_->extended_end_adjust;
  }
  int32_t word_start_adjust() const {
    return data_->word_start_adjust;
  }
  int32_t word_end_adjust() const {
    return data_->word_end_adjust;
  }
 private:
  internal::SelectAroundCaretResult_Data* data_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::SelectionGranularity>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SelectionGranularity> {};

template <>
struct hash<::blink::mojom::PanAction>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PanAction> {};

template <>
struct hash<::blink::mojom::FocusState>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FocusState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SelectionGranularity, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SelectionGranularity, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SelectionGranularity>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PanAction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PanAction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::PanAction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FocusState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FocusState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::FocusState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::KeyDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::KeyDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::KeyData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->dom_key = Traits::dom_key(input);
    fragment->dom_code = Traits::dom_code(input);
    fragment->windows_key_code = Traits::windows_key_code(input);
    fragment->native_key_code = Traits::native_key_code(input);
    fragment->is_system_key = Traits::is_system_key(input);
    fragment->is_browser_shortcut = Traits::is_browser_shortcut(input);
    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_text, text_fragment);
    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text in KeyData struct");
    decltype(Traits::unmodified_text(input)) in_unmodified_text = Traits::unmodified_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unmodified_text)::BaseType> unmodified_text_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_unmodified_text, unmodified_text_fragment);
    fragment->unmodified_text.Set(
        unmodified_text_fragment.is_null() ? nullptr : unmodified_text_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->unmodified_text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null unmodified_text in KeyData struct");
  }

  static bool Deserialize(::blink::mojom::internal::KeyData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::KeyDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PointerDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PointerDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PointerData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->pointer_id = Traits::pointer_id(input);
    fragment->force = Traits::force(input);
    fragment->tilt_x = Traits::tilt_x(input);
    fragment->tilt_y = Traits::tilt_y(input);
    fragment->tangential_pressure = Traits::tangential_pressure(input);
    fragment->twist = Traits::twist(input);
    mojo::internal::Serialize<::blink::mojom::Button>(
        Traits::button(input), &fragment->button);
    mojo::internal::Serialize<::ui::mojom::EventPointerType>(
        Traits::pointer_type(input), &fragment->pointer_type);
    fragment->movement_x = Traits::movement_x(input);
    fragment->movement_y = Traits::movement_y(input);
    fragment->is_raw_movement_event = Traits::is_raw_movement_event(input);
    decltype(Traits::widget_position(input)) in_widget_position = Traits::widget_position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->widget_position)::BaseType> widget_position_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_widget_position, widget_position_fragment);
    fragment->widget_position.Set(
        widget_position_fragment.is_null() ? nullptr : widget_position_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->widget_position.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null widget_position in PointerData struct");
    decltype(Traits::screen_position(input)) in_screen_position = Traits::screen_position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->screen_position)::BaseType> screen_position_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_screen_position, screen_position_fragment);
    fragment->screen_position.Set(
        screen_position_fragment.is_null() ? nullptr : screen_position_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->screen_position.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null screen_position in PointerData struct");
    decltype(Traits::mouse_data(input)) in_mouse_data = Traits::mouse_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mouse_data)::BaseType> mouse_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::MouseDataDataView>(
        in_mouse_data, mouse_data_fragment);
    fragment->mouse_data.Set(
        mouse_data_fragment.is_null() ? nullptr : mouse_data_fragment.data());
    fragment->device_id = Traits::device_id(input);
  }

  static bool Deserialize(::blink::mojom::internal::PointerData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PointerDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WheelDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WheelDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WheelData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->delta_x = Traits::delta_x(input);
    fragment->delta_y = Traits::delta_y(input);
    fragment->wheel_ticks_x = Traits::wheel_ticks_x(input);
    fragment->wheel_ticks_y = Traits::wheel_ticks_y(input);
    fragment->acceleration_ratio_x = Traits::acceleration_ratio_x(input);
    fragment->acceleration_ratio_y = Traits::acceleration_ratio_y(input);
    fragment->phase = Traits::phase(input);
    fragment->momentum_phase = Traits::momentum_phase(input);
    mojo::internal::Serialize<::blink::mojom::DispatchType>(
        Traits::cancelable(input), &fragment->cancelable);
    fragment->event_action = Traits::event_action(input);
    fragment->delta_units = Traits::delta_units(input);
  }

  static bool Deserialize(::blink::mojom::internal::WheelData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WheelDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MouseDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MouseDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MouseData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->click_count = Traits::click_count(input);
    decltype(Traits::wheel_data(input)) in_wheel_data = Traits::wheel_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->wheel_data)::BaseType> wheel_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::WheelDataDataView>(
        in_wheel_data, wheel_data_fragment);
    fragment->wheel_data.Set(
        wheel_data_fragment.is_null() ? nullptr : wheel_data_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::MouseData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MouseDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ScrollDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ScrollDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ScrollData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->delta_x = Traits::delta_x(input);
    fragment->delta_y = Traits::delta_y(input);
    mojo::internal::Serialize<::ui::mojom::ScrollGranularity>(
        Traits::delta_units(input), &fragment->delta_units);
    fragment->target_viewport = Traits::target_viewport(input);
    mojo::internal::Serialize<::blink::mojom::InertialPhaseState>(
        Traits::inertial_phase(input), &fragment->inertial_phase);
    fragment->synthetic = Traits::synthetic(input);
    fragment->pointer_count = Traits::pointer_count(input);
    fragment->cursor_control = Traits::cursor_control(input);
  }

  static bool Deserialize(::blink::mojom::internal::ScrollData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ScrollDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PinchBeginDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PinchBeginDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PinchBeginData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->needs_wheel_event = Traits::needs_wheel_event(input);
  }

  static bool Deserialize(::blink::mojom::internal::PinchBeginData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PinchBeginDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PinchUpdateDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PinchUpdateDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PinchUpdateData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->scale = Traits::scale(input);
    fragment->zoom_disabled = Traits::zoom_disabled(input);
    fragment->needs_wheel_event = Traits::needs_wheel_event(input);
  }

  static bool Deserialize(::blink::mojom::internal::PinchUpdateData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PinchUpdateDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PinchEndDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PinchEndDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PinchEndData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->needs_wheel_event = Traits::needs_wheel_event(input);
  }

  static bool Deserialize(::blink::mojom::internal::PinchEndData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PinchEndDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FlingDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FlingDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FlingData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->velocity_x = Traits::velocity_x(input);
    fragment->velocity_y = Traits::velocity_y(input);
    fragment->target_viewport = Traits::target_viewport(input);
    fragment->prevent_boosting = Traits::prevent_boosting(input);
  }

  static bool Deserialize(::blink::mojom::internal::FlingData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FlingDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TapDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TapDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TapData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->tap_count = Traits::tap_count(input);
    fragment->needs_wheel_event = Traits::needs_wheel_event(input);
  }

  static bool Deserialize(::blink::mojom::internal::TapData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TapDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TapDownDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TapDownDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TapDownData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->tap_down_count = Traits::tap_down_count(input);
  }

  static bool Deserialize(::blink::mojom::internal::TapDownData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TapDownDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GestureDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::GestureDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::GestureData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::screen_position(input)) in_screen_position = Traits::screen_position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->screen_position)::BaseType> screen_position_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_screen_position, screen_position_fragment);
    fragment->screen_position.Set(
        screen_position_fragment.is_null() ? nullptr : screen_position_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->screen_position.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null screen_position in GestureData struct");
    decltype(Traits::widget_position(input)) in_widget_position = Traits::widget_position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->widget_position)::BaseType> widget_position_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_widget_position, widget_position_fragment);
    fragment->widget_position.Set(
        widget_position_fragment.is_null() ? nullptr : widget_position_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->widget_position.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null widget_position in GestureData struct");
    mojo::internal::Serialize<::blink::mojom::GestureDevice>(
        Traits::source_device(input), &fragment->source_device);
    fragment->is_source_touch_event_set_blocking = Traits::is_source_touch_event_set_blocking(input);
    mojo::internal::Serialize<::ui::mojom::EventPointerType>(
        Traits::primary_pointer_type(input), &fragment->primary_pointer_type);
    fragment->primary_unique_touch_event_id = Traits::primary_unique_touch_event_id(input);
    fragment->unique_touch_event_id = Traits::unique_touch_event_id(input);
    decltype(Traits::contact_size(input)) in_contact_size = Traits::contact_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->contact_size)::BaseType> contact_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_contact_size, contact_size_fragment);
    fragment->contact_size.Set(
        contact_size_fragment.is_null() ? nullptr : contact_size_fragment.data());
    decltype(Traits::scroll_data(input)) in_scroll_data = Traits::scroll_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_data)::BaseType> scroll_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ScrollDataDataView>(
        in_scroll_data, scroll_data_fragment);
    fragment->scroll_data.Set(
        scroll_data_fragment.is_null() ? nullptr : scroll_data_fragment.data());
    decltype(Traits::pinch_begin_data(input)) in_pinch_begin_data = Traits::pinch_begin_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pinch_begin_data)::BaseType> pinch_begin_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PinchBeginDataDataView>(
        in_pinch_begin_data, pinch_begin_data_fragment);
    fragment->pinch_begin_data.Set(
        pinch_begin_data_fragment.is_null() ? nullptr : pinch_begin_data_fragment.data());
    decltype(Traits::pinch_update_data(input)) in_pinch_update_data = Traits::pinch_update_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pinch_update_data)::BaseType> pinch_update_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PinchUpdateDataDataView>(
        in_pinch_update_data, pinch_update_data_fragment);
    fragment->pinch_update_data.Set(
        pinch_update_data_fragment.is_null() ? nullptr : pinch_update_data_fragment.data());
    decltype(Traits::pinch_end_data(input)) in_pinch_end_data = Traits::pinch_end_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pinch_end_data)::BaseType> pinch_end_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PinchEndDataDataView>(
        in_pinch_end_data, pinch_end_data_fragment);
    fragment->pinch_end_data.Set(
        pinch_end_data_fragment.is_null() ? nullptr : pinch_end_data_fragment.data());
    decltype(Traits::tap_data(input)) in_tap_data = Traits::tap_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tap_data)::BaseType> tap_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::TapDataDataView>(
        in_tap_data, tap_data_fragment);
    fragment->tap_data.Set(
        tap_data_fragment.is_null() ? nullptr : tap_data_fragment.data());
    decltype(Traits::tap_down_data(input)) in_tap_down_data = Traits::tap_down_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tap_down_data)::BaseType> tap_down_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::TapDownDataDataView>(
        in_tap_down_data, tap_down_data_fragment);
    fragment->tap_down_data.Set(
        tap_down_data_fragment.is_null() ? nullptr : tap_down_data_fragment.data());
    decltype(Traits::fling_data(input)) in_fling_data = Traits::fling_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fling_data)::BaseType> fling_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FlingDataDataView>(
        in_fling_data, fling_data_fragment);
    fragment->fling_data.Set(
        fling_data_fragment.is_null() ? nullptr : fling_data_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::GestureData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GestureDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TouchPointDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TouchPointDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TouchPoint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::TouchState>(
        Traits::state(input), &fragment->state);
    fragment->radius_x = Traits::radius_x(input);
    fragment->radius_y = Traits::radius_y(input);
    fragment->rotation_angle = Traits::rotation_angle(input);
    decltype(Traits::pointer_data(input)) in_pointer_data = Traits::pointer_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pointer_data)::BaseType> pointer_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PointerDataDataView>(
        in_pointer_data, pointer_data_fragment);
    fragment->pointer_data.Set(
        pointer_data_fragment.is_null() ? nullptr : pointer_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pointer_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pointer_data in TouchPoint struct");
  }

  static bool Deserialize(::blink::mojom::internal::TouchPoint_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TouchPointDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TouchDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TouchDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TouchData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::DispatchType>(
        Traits::cancelable(input), &fragment->cancelable);
    fragment->moved_beyond_slop_region = Traits::moved_beyond_slop_region(input);
    fragment->touch_start_or_first_move = Traits::touch_start_or_first_move(input);
    fragment->hovering = Traits::hovering(input);
    fragment->unique_touch_event_id = Traits::unique_touch_event_id(input);
    decltype(Traits::touches(input)) in_touches = Traits::touches(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->touches)::BaseType>
        touches_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& touches_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::TouchPointDataView>>(
        in_touches, touches_fragment, &touches_validate_params);
    fragment->touches.Set(
        touches_fragment.is_null() ? nullptr : touches_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->touches.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null touches in TouchData struct");
  }

  static bool Deserialize(::blink::mojom::internal::TouchData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TouchDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EventDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::EventDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::Event_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::EventType>(
        Traits::type(input), &fragment->type);
    fragment->modifiers = Traits::modifiers(input);
    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_timestamp, timestamp_fragment);
    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in Event struct");
    decltype(Traits::latency(input)) in_latency = Traits::latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->latency)::BaseType> latency_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::LatencyInfoDataView>(
        in_latency, latency_fragment);
    fragment->latency.Set(
        latency_fragment.is_null() ? nullptr : latency_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->latency.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null latency in Event struct");
    decltype(Traits::event_latency_metadata(input)) in_event_latency_metadata = Traits::event_latency_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->event_latency_metadata)::BaseType> event_latency_metadata_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::EventLatencyMetadataDataView>(
        in_event_latency_metadata, event_latency_metadata_fragment);
    fragment->event_latency_metadata.Set(
        event_latency_metadata_fragment.is_null() ? nullptr : event_latency_metadata_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->event_latency_metadata.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_latency_metadata in Event struct");
    decltype(Traits::key_data(input)) in_key_data = Traits::key_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_data)::BaseType> key_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::KeyDataDataView>(
        in_key_data, key_data_fragment);
    fragment->key_data.Set(
        key_data_fragment.is_null() ? nullptr : key_data_fragment.data());
    decltype(Traits::pointer_data(input)) in_pointer_data = Traits::pointer_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pointer_data)::BaseType> pointer_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PointerDataDataView>(
        in_pointer_data, pointer_data_fragment);
    fragment->pointer_data.Set(
        pointer_data_fragment.is_null() ? nullptr : pointer_data_fragment.data());
    decltype(Traits::gesture_data(input)) in_gesture_data = Traits::gesture_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gesture_data)::BaseType> gesture_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::GestureDataDataView>(
        in_gesture_data, gesture_data_fragment);
    fragment->gesture_data.Set(
        gesture_data_fragment.is_null() ? nullptr : gesture_data_fragment.data());
    decltype(Traits::touch_data(input)) in_touch_data = Traits::touch_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->touch_data)::BaseType> touch_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::TouchDataDataView>(
        in_touch_data, touch_data_fragment);
    fragment->touch_data.Set(
        touch_data_fragment.is_null() ? nullptr : touch_data_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::Event_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::EventDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DidOverscrollParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DidOverscrollParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DidOverscrollParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::accumulated_overscroll(input)) in_accumulated_overscroll = Traits::accumulated_overscroll(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accumulated_overscroll)::BaseType> accumulated_overscroll_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_accumulated_overscroll, accumulated_overscroll_fragment);
    fragment->accumulated_overscroll.Set(
        accumulated_overscroll_fragment.is_null() ? nullptr : accumulated_overscroll_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->accumulated_overscroll.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accumulated_overscroll in DidOverscrollParams struct");
    decltype(Traits::latest_overscroll_delta(input)) in_latest_overscroll_delta = Traits::latest_overscroll_delta(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->latest_overscroll_delta)::BaseType> latest_overscroll_delta_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_latest_overscroll_delta, latest_overscroll_delta_fragment);
    fragment->latest_overscroll_delta.Set(
        latest_overscroll_delta_fragment.is_null() ? nullptr : latest_overscroll_delta_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->latest_overscroll_delta.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null latest_overscroll_delta in DidOverscrollParams struct");
    decltype(Traits::current_fling_velocity(input)) in_current_fling_velocity = Traits::current_fling_velocity(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->current_fling_velocity)::BaseType> current_fling_velocity_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_current_fling_velocity, current_fling_velocity_fragment);
    fragment->current_fling_velocity.Set(
        current_fling_velocity_fragment.is_null() ? nullptr : current_fling_velocity_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->current_fling_velocity.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null current_fling_velocity in DidOverscrollParams struct");
    decltype(Traits::causal_event_viewport_point(input)) in_causal_event_viewport_point = Traits::causal_event_viewport_point(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->causal_event_viewport_point)::BaseType> causal_event_viewport_point_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_causal_event_viewport_point, causal_event_viewport_point_fragment);
    fragment->causal_event_viewport_point.Set(
        causal_event_viewport_point_fragment.is_null() ? nullptr : causal_event_viewport_point_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->causal_event_viewport_point.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null causal_event_viewport_point in DidOverscrollParams struct");
    decltype(Traits::overscroll_behavior(input)) in_overscroll_behavior = Traits::overscroll_behavior(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->overscroll_behavior)::BaseType> overscroll_behavior_fragment(
            fragment.message());
    mojo::internal::Serialize<::cc::mojom::OverscrollBehaviorDataView>(
        in_overscroll_behavior, overscroll_behavior_fragment);
    fragment->overscroll_behavior.Set(
        overscroll_behavior_fragment.is_null() ? nullptr : overscroll_behavior_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->overscroll_behavior.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null overscroll_behavior in DidOverscrollParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::DidOverscrollParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DidOverscrollParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TouchActionOptionalDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TouchActionOptionalDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TouchActionOptional_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::cc::mojom::TouchAction>(
        Traits::touch_action(input), &fragment->touch_action);
  }

  static bool Deserialize(::blink::mojom::internal::TouchActionOptional_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TouchActionOptionalDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EditCommandDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::EditCommandDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::EditCommand_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in EditCommand struct");
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in EditCommand struct");
  }

  static bool Deserialize(::blink::mojom::internal::EditCommand_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::EditCommandDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SelectAroundCaretResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SelectAroundCaretResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SelectAroundCaretResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->extended_start_adjust = Traits::extended_start_adjust(input);
    fragment->extended_end_adjust = Traits::extended_end_adjust(input);
    fragment->word_start_adjust = Traits::word_start_adjust(input);
    fragment->word_end_adjust = Traits::word_end_adjust(input);
  }

  static bool Deserialize(::blink::mojom::internal::SelectAroundCaretResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SelectAroundCaretResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void KeyDataDataView::GetTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void KeyDataDataView::GetUnmodifiedTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->unmodified_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void PointerDataDataView::GetWidgetPositionDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->widget_position.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void PointerDataDataView::GetScreenPositionDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->screen_position.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void PointerDataDataView::GetMouseDataDataView(
    MouseDataDataView* output) {
  auto pointer = data_->mouse_data.Get();
  *output = MouseDataDataView(pointer, message_);
}




inline void MouseDataDataView::GetWheelDataDataView(
    WheelDataDataView* output) {
  auto pointer = data_->wheel_data.Get();
  *output = WheelDataDataView(pointer, message_);
}
















inline void GestureDataDataView::GetScreenPositionDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->screen_position.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void GestureDataDataView::GetWidgetPositionDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->widget_position.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void GestureDataDataView::GetContactSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->contact_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void GestureDataDataView::GetScrollDataDataView(
    ScrollDataDataView* output) {
  auto pointer = data_->scroll_data.Get();
  *output = ScrollDataDataView(pointer, message_);
}
inline void GestureDataDataView::GetPinchBeginDataDataView(
    PinchBeginDataDataView* output) {
  auto pointer = data_->pinch_begin_data.Get();
  *output = PinchBeginDataDataView(pointer, message_);
}
inline void GestureDataDataView::GetPinchUpdateDataDataView(
    PinchUpdateDataDataView* output) {
  auto pointer = data_->pinch_update_data.Get();
  *output = PinchUpdateDataDataView(pointer, message_);
}
inline void GestureDataDataView::GetPinchEndDataDataView(
    PinchEndDataDataView* output) {
  auto pointer = data_->pinch_end_data.Get();
  *output = PinchEndDataDataView(pointer, message_);
}
inline void GestureDataDataView::GetTapDataDataView(
    TapDataDataView* output) {
  auto pointer = data_->tap_data.Get();
  *output = TapDataDataView(pointer, message_);
}
inline void GestureDataDataView::GetTapDownDataDataView(
    TapDownDataDataView* output) {
  auto pointer = data_->tap_down_data.Get();
  *output = TapDownDataDataView(pointer, message_);
}
inline void GestureDataDataView::GetFlingDataDataView(
    FlingDataDataView* output) {
  auto pointer = data_->fling_data.Get();
  *output = FlingDataDataView(pointer, message_);
}


inline void TouchPointDataView::GetPointerDataDataView(
    PointerDataDataView* output) {
  auto pointer = data_->pointer_data.Get();
  *output = PointerDataDataView(pointer, message_);
}


inline void TouchDataDataView::GetTouchesDataView(
    mojo::ArrayDataView<TouchPointDataView>* output) {
  auto pointer = data_->touches.Get();
  *output = mojo::ArrayDataView<TouchPointDataView>(pointer, message_);
}


inline void EventDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void EventDataView::GetLatencyDataView(
    ::ui::mojom::LatencyInfoDataView* output) {
  auto pointer = data_->latency.Get();
  *output = ::ui::mojom::LatencyInfoDataView(pointer, message_);
}
inline void EventDataView::GetEventLatencyMetadataDataView(
    ::ui::mojom::EventLatencyMetadataDataView* output) {
  auto pointer = data_->event_latency_metadata.Get();
  *output = ::ui::mojom::EventLatencyMetadataDataView(pointer, message_);
}
inline void EventDataView::GetKeyDataDataView(
    KeyDataDataView* output) {
  auto pointer = data_->key_data.Get();
  *output = KeyDataDataView(pointer, message_);
}
inline void EventDataView::GetPointerDataDataView(
    PointerDataDataView* output) {
  auto pointer = data_->pointer_data.Get();
  *output = PointerDataDataView(pointer, message_);
}
inline void EventDataView::GetGestureDataDataView(
    GestureDataDataView* output) {
  auto pointer = data_->gesture_data.Get();
  *output = GestureDataDataView(pointer, message_);
}
inline void EventDataView::GetTouchDataDataView(
    TouchDataDataView* output) {
  auto pointer = data_->touch_data.Get();
  *output = TouchDataDataView(pointer, message_);
}


inline void DidOverscrollParamsDataView::GetAccumulatedOverscrollDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->accumulated_overscroll.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void DidOverscrollParamsDataView::GetLatestOverscrollDeltaDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->latest_overscroll_delta.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void DidOverscrollParamsDataView::GetCurrentFlingVelocityDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->current_fling_velocity.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void DidOverscrollParamsDataView::GetCausalEventViewportPointDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->causal_event_viewport_point.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void DidOverscrollParamsDataView::GetOverscrollBehaviorDataView(
    ::cc::mojom::OverscrollBehaviorDataView* output) {
  auto pointer = data_->overscroll_behavior.Get();
  *output = ::cc::mojom::OverscrollBehaviorDataView(pointer, message_);
}




inline void EditCommandDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void EditCommandDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, message_);
}





}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SelectionGranularity> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SelectionGranularity value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::PanAction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::PanAction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::FocusState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::FocusState value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_SHARED_H_