// third_party/blink/public/mojom/memory_usage_monitor_linux.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/memory_usage_monitor_linux.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/memory_usage_monitor_linux.mojom-params-data.h"
#include "third_party/blink/public/mojom/memory_usage_monitor_linux.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/memory_usage_monitor_linux.mojom-import-headers.h"
#include "third_party/blink/public/mojom/memory_usage_monitor_linux.mojom-test-utils.h"


namespace blink::mojom {
const char MemoryUsageMonitorLinux::Name_[] = "blink.mojom.MemoryUsageMonitorLinux";

MemoryUsageMonitorLinux::IPCStableHashFunction MemoryUsageMonitorLinux::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MemoryUsageMonitorLinux>(message.name())) {
    case messages::MemoryUsageMonitorLinux::kSetProcFiles: {
      return &MemoryUsageMonitorLinux::SetProcFiles_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MemoryUsageMonitorLinux::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MemoryUsageMonitorLinux>(message.name())) {
      case messages::MemoryUsageMonitorLinux::kSetProcFiles:
            return "Receive blink::mojom::MemoryUsageMonitorLinux::SetProcFiles";
    }
  } else {
    switch (static_cast<messages::MemoryUsageMonitorLinux>(message.name())) {
      case messages::MemoryUsageMonitorLinux::kSetProcFiles:
            return "Receive reply blink::mojom::MemoryUsageMonitorLinux::SetProcFiles";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MemoryUsageMonitorLinux::SetProcFiles_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::MemoryUsageMonitorLinux::SetProcFiles");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MemoryUsageMonitorLinuxProxy::MemoryUsageMonitorLinuxProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MemoryUsageMonitorLinuxProxy::SetProcFiles(
    ::base::File in_statm_file, ::base::File in_status_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MemoryUsageMonitorLinux::SetProcFiles", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("statm_file"), in_statm_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status_file"), in_status_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MemoryUsageMonitorLinux::kSetProcFiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MemoryUsageMonitorLinux_SetProcFiles_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->statm_file)::BaseType> statm_file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
      in_statm_file, statm_file_fragment);
  params->statm_file.Set(
      statm_file_fragment.is_null() ? nullptr : statm_file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->statm_file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null statm_file in MemoryUsageMonitorLinux.SetProcFiles request");
  mojo::internal::MessageFragment<
      typename decltype(params->status_file)::BaseType> status_file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
      in_status_file, status_file_fragment);
  params->status_file.Set(
      status_file_fragment.is_null() ? nullptr : status_file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status_file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status_file in MemoryUsageMonitorLinux.SetProcFiles request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MemoryUsageMonitorLinux::Name_);
  message.set_method_name("SetProcFiles");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MemoryUsageMonitorLinuxStubDispatch::Accept(
    MemoryUsageMonitorLinux* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MemoryUsageMonitorLinux>(message->header()->name)) {
    case messages::MemoryUsageMonitorLinux::kSetProcFiles: {
      DCHECK(message->is_serialized());
      internal::MemoryUsageMonitorLinux_SetProcFiles_Params_Data* params =
          reinterpret_cast<internal::MemoryUsageMonitorLinux_SetProcFiles_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MemoryUsageMonitorLinux.0
      bool success = true;
      ::base::File p_statm_file{};
      ::base::File p_status_file{};
      MemoryUsageMonitorLinux_SetProcFiles_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatmFile(&p_statm_file))
        success = false;
      if (success && !input_data_view.ReadStatusFile(&p_status_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MemoryUsageMonitorLinux::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetProcFiles(        
        std::move(p_statm_file), 
        std::move(p_status_file));
      return true;
    }
  }
  return false;
}

// static
bool MemoryUsageMonitorLinuxStubDispatch::AcceptWithResponder(
    MemoryUsageMonitorLinux* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MemoryUsageMonitorLinux>(message->header()->name)) {
    case messages::MemoryUsageMonitorLinux::kSetProcFiles: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMemoryUsageMonitorLinuxValidationInfo[] = {
    {base::to_underlying(messages::MemoryUsageMonitorLinux::kSetProcFiles),
     { &internal::MemoryUsageMonitorLinux_SetProcFiles_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MemoryUsageMonitorLinuxRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::MemoryUsageMonitorLinux::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMemoryUsageMonitorLinuxValidationInfo);
}



}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void MemoryUsageMonitorLinuxInterceptorForTesting::SetProcFiles(::base::File statm_file, ::base::File status_file) {
  GetForwardingInterface()->SetProcFiles(
    std::move(statm_file)
    , 
    std::move(status_file)
    );
}
MemoryUsageMonitorLinuxAsyncWaiter::MemoryUsageMonitorLinuxAsyncWaiter(
    MemoryUsageMonitorLinux* proxy) : proxy_(proxy) {}

MemoryUsageMonitorLinuxAsyncWaiter::~MemoryUsageMonitorLinuxAsyncWaiter() = default;






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif