// third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {
// static
bool SerializedStaticBitmapImage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SerializedStaticBitmapImage_Data* object = static_cast<const SerializedStaticBitmapImage_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SerializedStaticBitmapImage_Tag::kBitmap: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_bitmap, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_bitmap, validation_context))
        return false;
      return true;
    }
    case SerializedStaticBitmapImage_Tag::kAcceleratedImage: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_accelerated_image, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_accelerated_image, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SerializedStaticBitmapImage");
      return false;
    }
  }
}


// static
bool SharedImageUsageSet_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedImageUsageSet_Data* object =
      static_cast<const SharedImageUsageSet_Data*>(data);

  return true;
}

SharedImageUsageSet_Data::SharedImageUsageSet_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AcceleratedStaticBitmapImage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AcceleratedStaticBitmapImage_Data* object =
      static_cast<const AcceleratedStaticBitmapImage_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shared_image, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shared_image, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->release_callback, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->release_callback,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AcceleratedStaticBitmapImage_Data::AcceleratedStaticBitmapImage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ImageReleaseCallback_Release_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ImageReleaseCallback_Release_Params_Data* object =
      static_cast<const ImageReleaseCallback_Release_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  return true;
}

ImageReleaseCallback_Release_Params_Data::ImageReleaseCallback_Release_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink