// third_party/blink/public/mojom/payments/payment_request.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/payments/payment_request.mojom-shared-internal.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace payments::mojom {
class PaymentResponseDataView;

class PayerDetailDataView;

class PaymentItemDataView;

class PaymentShippingOptionDataView;

class SecurePaymentConfirmationRequestDataView;

class NetworkOrIssuerInformationDataView;

class PaymentMethodDataDataView;

class PaymentDetailsModifierDataView;

class PaymentDetailsDataView;

class PaymentOptionsDataView;



}  // payments::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::payments::mojom::PaymentResponseDataView> {
  using Data = ::payments::mojom::internal::PaymentResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PayerDetailDataView> {
  using Data = ::payments::mojom::internal::PayerDetail_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentItemDataView> {
  using Data = ::payments::mojom::internal::PaymentItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentShippingOptionDataView> {
  using Data = ::payments::mojom::internal::PaymentShippingOption_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::SecurePaymentConfirmationRequestDataView> {
  using Data = ::payments::mojom::internal::SecurePaymentConfirmationRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::NetworkOrIssuerInformationDataView> {
  using Data = ::payments::mojom::internal::NetworkOrIssuerInformation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentMethodDataDataView> {
  using Data = ::payments::mojom::internal::PaymentMethodData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentDetailsModifierDataView> {
  using Data = ::payments::mojom::internal::PaymentDetailsModifier_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentDetailsDataView> {
  using Data = ::payments::mojom::internal::PaymentDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentOptionsDataView> {
  using Data = ::payments::mojom::internal::PaymentOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace payments::mojom {


enum class PaymentErrorReason : int32_t {
  
  UNKNOWN = 0,
  
  USER_CANCEL = 1,
  
  NOT_SUPPORTED = 2,
  
  NOT_SUPPORTED_FOR_INVALID_ORIGIN_OR_SSL = 3,
  
  ALREADY_SHOWING = 4,
  
  INVALID_DATA_FROM_RENDERER = 5,
  
  NOT_ALLOWED_ERROR = 6,
  
  USER_OPT_OUT = 7,
  
  USER_ACTIVATION_REQUIRED = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PaymentErrorReason value);
inline bool IsKnownEnumValue(PaymentErrorReason value) {
  return internal::PaymentErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CanMakePaymentQueryResult : int32_t {
  
  CAN_MAKE_PAYMENT = 0,
  
  CANNOT_MAKE_PAYMENT = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CanMakePaymentQueryResult value);
inline bool IsKnownEnumValue(CanMakePaymentQueryResult value) {
  return internal::CanMakePaymentQueryResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HasEnrolledInstrumentQueryResult : int32_t {
  
  HAS_ENROLLED_INSTRUMENT = 0,
  
  HAS_NO_ENROLLED_INSTRUMENT = 1,
  
  QUERY_QUOTA_EXCEEDED = 2,
  
  WARNING_HAS_ENROLLED_INSTRUMENT = 3,
  
  WARNING_HAS_NO_ENROLLED_INSTRUMENT = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, HasEnrolledInstrumentQueryResult value);
inline bool IsKnownEnumValue(HasEnrolledInstrumentQueryResult value) {
  return internal::HasEnrolledInstrumentQueryResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AndroidPayEnvironment : int32_t {
  
  PRODUCTION = 0,
  
  TEST = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AndroidPayEnvironment value);
inline bool IsKnownEnumValue(AndroidPayEnvironment value) {
  return internal::AndroidPayEnvironment_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BasicCardNetwork : int32_t {
  
  AMEX = 0,
  
  DINERS = 1,
  
  DISCOVER = 2,
  
  JCB = 3,
  
  MASTERCARD = 4,
  
  MIR = 5,
  
  UNIONPAY = 6,
  
  VISA = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BasicCardNetwork value);
inline bool IsKnownEnumValue(BasicCardNetwork value) {
  return internal::BasicCardNetwork_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PaymentShippingType : int32_t {
  
  SHIPPING = 0,
  
  DELIVERY = 1,
  
  PICKUP = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PaymentShippingType value);
inline bool IsKnownEnumValue(PaymentShippingType value) {
  return internal::PaymentShippingType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PaymentComplete : int32_t {
  
  FAIL = 0,
  
  SUCCESS = 1,
  
  UNKNOWN = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PaymentComplete value);
inline bool IsKnownEnumValue(PaymentComplete value) {
  return internal::PaymentComplete_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PaymentRequestClientInterfaceBase {};

using PaymentRequestClientPtrDataView =
    mojo::InterfacePtrDataView<PaymentRequestClientInterfaceBase>;
using PaymentRequestClientRequestDataView =
    mojo::InterfaceRequestDataView<PaymentRequestClientInterfaceBase>;
using PaymentRequestClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PaymentRequestClientInterfaceBase>;
using PaymentRequestClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PaymentRequestClientInterfaceBase>;
class PaymentRequestInterfaceBase {};

using PaymentRequestPtrDataView =
    mojo::InterfacePtrDataView<PaymentRequestInterfaceBase>;
using PaymentRequestRequestDataView =
    mojo::InterfaceRequestDataView<PaymentRequestInterfaceBase>;
using PaymentRequestAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PaymentRequestInterfaceBase>;
using PaymentRequestAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PaymentRequestInterfaceBase>;


class PaymentResponseDataView {
 public:
  PaymentResponseDataView() = default;

  PaymentResponseDataView(
      internal::PaymentResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMethodNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethodName(UserType* output) {
    
    auto* pointer = data_->method_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStringifiedDetailsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringifiedDetails(UserType* output) {
    
    auto* pointer = data_->stringified_details.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetShippingAddressDataView(
      ::payments::mojom::PaymentAddressDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingAddress(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::PaymentAddressDataView, UserType>(),
    "Attempting to read the optional `shipping_address` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShippingAddress` instead "
    "of `ReadShippingAddress if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shipping_address.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentAddressDataView>(
        pointer, output, message_);
  }
  inline void GetShippingOptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingOption(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `shipping_option` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShippingOption` instead "
    "of `ReadShippingOption if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shipping_option.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPayerDataView(
      PayerDetailDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayer(UserType* output) {
    
    auto* pointer = data_->payer.Get();
    return mojo::internal::Deserialize<::payments::mojom::PayerDetailDataView>(
        pointer, output, message_);
  }
  inline void GetGetAssertionAuthenticatorResponseDataView(
      ::blink::mojom::GetAssertionAuthenticatorResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGetAssertionAuthenticatorResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::GetAssertionAuthenticatorResponseDataView, UserType>(),
    "Attempting to read the optional `get_assertion_authenticator_response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGetAssertionAuthenticatorResponse` instead "
    "of `ReadGetAssertionAuthenticatorResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->get_assertion_authenticator_response.Get();
    return mojo::internal::Deserialize<::blink::mojom::GetAssertionAuthenticatorResponseDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PayerDetailDataView {
 public:
  PayerDetailDataView() = default;

  PayerDetailDataView(
      internal::PayerDetail_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEmailDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmail(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `email` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEmail` instead "
    "of `ReadEmail if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->email.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPhoneDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPhone(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `phone` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPhone` instead "
    "of `ReadPhone if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->phone.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PayerDetail_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentItemDataView {
 public:
  PaymentItemDataView() = default;

  PaymentItemDataView(
      internal::PaymentItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAmountDataView(
      ::payments::mojom::PaymentCurrencyAmountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAmount(UserType* output) {
    
    auto* pointer = data_->amount.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        pointer, output, message_);
  }
  bool pending() const {
    return data_->pending;
  }
 private:
  internal::PaymentItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentShippingOptionDataView {
 public:
  PaymentShippingOptionDataView() = default;

  PaymentShippingOptionDataView(
      internal::PaymentShippingOption_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAmountDataView(
      ::payments::mojom::PaymentCurrencyAmountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAmount(UserType* output) {
    
    auto* pointer = data_->amount.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        pointer, output, message_);
  }
  bool selected() const {
    return data_->selected;
  }
 private:
  internal::PaymentShippingOption_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SecurePaymentConfirmationRequestDataView {
 public:
  SecurePaymentConfirmationRequestDataView() = default;

  SecurePaymentConfirmationRequestDataView(
      internal::SecurePaymentConfirmationRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCredentialIdsDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredentialIds(UserType* output) {
    
    auto* pointer = data_->credential_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  inline void GetChallengeDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChallenge(UserType* output) {
    
    auto* pointer = data_->challenge.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetInstrumentDataView(
      ::blink::mojom::PaymentCredentialInstrumentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstrument(UserType* output) {
    
    auto* pointer = data_->instrument.Get();
    return mojo::internal::Deserialize<::blink::mojom::PaymentCredentialInstrumentDataView>(
        pointer, output, message_);
  }
  inline void GetTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimeout` instead "
    "of `ReadTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetPayeeOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayeeOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `payee_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPayeeOrigin` instead "
    "of `ReadPayeeOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payee_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetPayeeNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayeeName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `payee_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPayeeName` instead "
    "of `ReadPayeeName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payee_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRpIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRpId(UserType* output) {
    
    auto* pointer = data_->rp_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExtensionsDataView(
      ::blink::mojom::AuthenticationExtensionsClientInputsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AuthenticationExtensionsClientInputsDataView, UserType>(),
    "Attempting to read the optional `extensions` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExtensions` instead "
    "of `ReadExtensions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->extensions.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuthenticationExtensionsClientInputsDataView>(
        pointer, output, message_);
  }
  bool show_opt_out() const {
    return data_->show_opt_out;
  }
  inline void GetNetworkInfoDataView(
      NetworkOrIssuerInformationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetworkInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::NetworkOrIssuerInformationDataView, UserType>(),
    "Attempting to read the optional `network_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNetworkInfo` instead "
    "of `ReadNetworkInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->network_info.Get();
    return mojo::internal::Deserialize<::payments::mojom::NetworkOrIssuerInformationDataView>(
        pointer, output, message_);
  }
  inline void GetIssuerInfoDataView(
      NetworkOrIssuerInformationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssuerInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::NetworkOrIssuerInformationDataView, UserType>(),
    "Attempting to read the optional `issuer_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIssuerInfo` instead "
    "of `ReadIssuerInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->issuer_info.Get();
    return mojo::internal::Deserialize<::payments::mojom::NetworkOrIssuerInformationDataView>(
        pointer, output, message_);
  }
 private:
  internal::SecurePaymentConfirmationRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkOrIssuerInformationDataView {
 public:
  NetworkOrIssuerInformationDataView() = default;

  NetworkOrIssuerInformationDataView(
      internal::NetworkOrIssuerInformation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIconDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkOrIssuerInformation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentMethodDataDataView {
 public:
  PaymentMethodDataDataView() = default;

  PaymentMethodDataDataView(
      internal::PaymentMethodData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSupportedMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedMethod(UserType* output) {
    
    auto* pointer = data_->supported_method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStringifiedDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringifiedData(UserType* output) {
    
    auto* pointer = data_->stringified_data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEnvironment(UserType* output) const {
    auto data_value = data_->environment;
    return mojo::internal::Deserialize<::payments::mojom::AndroidPayEnvironment>(
        data_value, output);
  }
  AndroidPayEnvironment environment() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::payments::mojom::AndroidPayEnvironment>(data_->environment));
  }
  int32_t min_google_play_services_version() const {
    return data_->min_google_play_services_version;
  }
  int32_t api_version() const {
    return data_->api_version;
  }
  inline void GetSupportedNetworksDataView(
      mojo::ArrayDataView<BasicCardNetwork>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedNetworks(UserType* output) {
    
    auto* pointer = data_->supported_networks.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::BasicCardNetwork>>(
        pointer, output, message_);
  }
  inline void GetSecurePaymentConfirmationDataView(
      SecurePaymentConfirmationRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSecurePaymentConfirmation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::SecurePaymentConfirmationRequestDataView, UserType>(),
    "Attempting to read the optional `secure_payment_confirmation` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSecurePaymentConfirmation` instead "
    "of `ReadSecurePaymentConfirmation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->secure_payment_confirmation.Get();
    return mojo::internal::Deserialize<::payments::mojom::SecurePaymentConfirmationRequestDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentMethodData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentDetailsModifierDataView {
 public:
  PaymentDetailsModifierDataView() = default;

  PaymentDetailsModifierDataView(
      internal::PaymentDetailsModifier_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTotalDataView(
      PaymentItemDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotal(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::PaymentItemDataView, UserType>(),
    "Attempting to read the optional `total` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTotal` instead "
    "of `ReadTotal if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->total.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentItemDataView>(
        pointer, output, message_);
  }
  inline void GetAdditionalDisplayItemsDataView(
      mojo::ArrayDataView<PaymentItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdditionalDisplayItems(UserType* output) {
    
    auto* pointer = data_->additional_display_items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentItemDataView>>(
        pointer, output, message_);
  }
  inline void GetMethodDataDataView(
      PaymentMethodDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethodData(UserType* output) {
    
    auto* pointer = data_->method_data.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentMethodDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentDetailsModifier_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentDetailsDataView {
 public:
  PaymentDetailsDataView() = default;

  PaymentDetailsDataView(
      internal::PaymentDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTotalDataView(
      PaymentItemDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotal(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::PaymentItemDataView, UserType>(),
    "Attempting to read the optional `total` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTotal` instead "
    "of `ReadTotal if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->total.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentItemDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayItemsDataView(
      mojo::ArrayDataView<PaymentItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayItems(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::payments::mojom::PaymentItemDataView>, UserType>(),
    "Attempting to read the optional `display_items` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDisplayItems` instead "
    "of `ReadDisplayItems if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->display_items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentItemDataView>>(
        pointer, output, message_);
  }
  inline void GetShippingOptionsDataView(
      mojo::ArrayDataView<PaymentShippingOptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>, UserType>(),
    "Attempting to read the optional `shipping_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShippingOptions` instead "
    "of `ReadShippingOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shipping_options.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>>(
        pointer, output, message_);
  }
  inline void GetModifiersDataView(
      mojo::ArrayDataView<PaymentDetailsModifierDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModifiers(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>, UserType>(),
    "Attempting to read the optional `modifiers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadModifiers` instead "
    "of `ReadModifiers if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->modifiers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>>(
        pointer, output, message_);
  }
  inline void GetErrorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) {
    
    auto* pointer = data_->error.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetShippingAddressErrorsDataView(
      ::payments::mojom::AddressErrorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingAddressErrors(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::AddressErrorsDataView, UserType>(),
    "Attempting to read the optional `shipping_address_errors` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShippingAddressErrors` instead "
    "of `ReadShippingAddressErrors if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shipping_address_errors.Get();
    return mojo::internal::Deserialize<::payments::mojom::AddressErrorsDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStringifiedPaymentMethodErrorsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringifiedPaymentMethodErrors(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `stringified_payment_method_errors` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStringifiedPaymentMethodErrors` instead "
    "of `ReadStringifiedPaymentMethodErrors if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->stringified_payment_method_errors.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentOptionsDataView {
 public:
  PaymentOptionsDataView() = default;

  PaymentOptionsDataView(
      internal::PaymentOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool request_payer_name() const {
    return data_->request_payer_name;
  }
  bool request_payer_email() const {
    return data_->request_payer_email;
  }
  bool request_payer_phone() const {
    return data_->request_payer_phone;
  }
  bool request_shipping() const {
    return data_->request_shipping;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadShippingType(UserType* output) const {
    auto data_value = data_->shipping_type;
    return mojo::internal::Deserialize<::payments::mojom::PaymentShippingType>(
        data_value, output);
  }
  PaymentShippingType shipping_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::payments::mojom::PaymentShippingType>(data_->shipping_type));
  }
 private:
  internal::PaymentOptions_Data* data_ = nullptr;
};


}  // payments::mojom

namespace std {

template <>
struct hash<::payments::mojom::PaymentErrorReason>
    : public mojo::internal::EnumHashImpl<::payments::mojom::PaymentErrorReason> {};

template <>
struct hash<::payments::mojom::CanMakePaymentQueryResult>
    : public mojo::internal::EnumHashImpl<::payments::mojom::CanMakePaymentQueryResult> {};

template <>
struct hash<::payments::mojom::HasEnrolledInstrumentQueryResult>
    : public mojo::internal::EnumHashImpl<::payments::mojom::HasEnrolledInstrumentQueryResult> {};

template <>
struct hash<::payments::mojom::AndroidPayEnvironment>
    : public mojo::internal::EnumHashImpl<::payments::mojom::AndroidPayEnvironment> {};

template <>
struct hash<::payments::mojom::BasicCardNetwork>
    : public mojo::internal::EnumHashImpl<::payments::mojom::BasicCardNetwork> {};

template <>
struct hash<::payments::mojom::PaymentShippingType>
    : public mojo::internal::EnumHashImpl<::payments::mojom::PaymentShippingType> {};

template <>
struct hash<::payments::mojom::PaymentComplete>
    : public mojo::internal::EnumHashImpl<::payments::mojom::PaymentComplete> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::PaymentErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::PaymentErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::CanMakePaymentQueryResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::CanMakePaymentQueryResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::CanMakePaymentQueryResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::HasEnrolledInstrumentQueryResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::HasEnrolledInstrumentQueryResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::HasEnrolledInstrumentQueryResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::AndroidPayEnvironment, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::AndroidPayEnvironment, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::AndroidPayEnvironment>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::BasicCardNetwork, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::BasicCardNetwork, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::BasicCardNetwork>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentShippingType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::PaymentShippingType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::PaymentShippingType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentComplete, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::PaymentComplete, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::PaymentComplete>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::method_name(input)) in_method_name = Traits::method_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method_name)::BaseType> method_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_method_name, method_name_fragment);
    fragment->method_name.Set(
        method_name_fragment.is_null() ? nullptr : method_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->method_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method_name in PaymentResponse struct");
    decltype(Traits::stringified_details(input)) in_stringified_details = Traits::stringified_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stringified_details)::BaseType> stringified_details_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_stringified_details, stringified_details_fragment);
    fragment->stringified_details.Set(
        stringified_details_fragment.is_null() ? nullptr : stringified_details_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->stringified_details.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null stringified_details in PaymentResponse struct");
    decltype(Traits::shipping_address(input)) in_shipping_address = Traits::shipping_address(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shipping_address)::BaseType> shipping_address_fragment(
            fragment.message());
    mojo::internal::Serialize<::payments::mojom::PaymentAddressDataView>(
        in_shipping_address, shipping_address_fragment);
    fragment->shipping_address.Set(
        shipping_address_fragment.is_null() ? nullptr : shipping_address_fragment.data());
    decltype(Traits::shipping_option(input)) in_shipping_option = Traits::shipping_option(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shipping_option)::BaseType> shipping_option_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_shipping_option, shipping_option_fragment);
    fragment->shipping_option.Set(
        shipping_option_fragment.is_null() ? nullptr : shipping_option_fragment.data());
    decltype(Traits::payer(input)) in_payer = Traits::payer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payer)::BaseType> payer_fragment(
            fragment.message());
    mojo::internal::Serialize<::payments::mojom::PayerDetailDataView>(
        in_payer, payer_fragment);
    fragment->payer.Set(
        payer_fragment.is_null() ? nullptr : payer_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->payer.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null payer in PaymentResponse struct");
    decltype(Traits::get_assertion_authenticator_response(input)) in_get_assertion_authenticator_response = Traits::get_assertion_authenticator_response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->get_assertion_authenticator_response)::BaseType> get_assertion_authenticator_response_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::GetAssertionAuthenticatorResponseDataView>(
        in_get_assertion_authenticator_response, get_assertion_authenticator_response_fragment);
    fragment->get_assertion_authenticator_response.Set(
        get_assertion_authenticator_response_fragment.is_null() ? nullptr : get_assertion_authenticator_response_fragment.data());
  }

  static bool Deserialize(::payments::mojom::internal::PaymentResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PayerDetailDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PayerDetailDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PayerDetail_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::email(input)) in_email = Traits::email(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->email)::BaseType> email_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_email, email_fragment);
    fragment->email.Set(
        email_fragment.is_null() ? nullptr : email_fragment.data());
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    decltype(Traits::phone(input)) in_phone = Traits::phone(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->phone)::BaseType> phone_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_phone, phone_fragment);
    fragment->phone.Set(
        phone_fragment.is_null() ? nullptr : phone_fragment.data());
  }

  static bool Deserialize(::payments::mojom::internal::PayerDetail_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PayerDetailDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_label, label_fragment);
    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->label.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in PaymentItem struct");
    decltype(Traits::amount(input)) in_amount = Traits::amount(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->amount)::BaseType> amount_fragment(
            fragment.message());
    mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        in_amount, amount_fragment);
    fragment->amount.Set(
        amount_fragment.is_null() ? nullptr : amount_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->amount.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null amount in PaymentItem struct");
    fragment->pending = Traits::pending(input);
  }

  static bool Deserialize(::payments::mojom::internal::PaymentItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentShippingOptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentShippingOptionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentShippingOption_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in PaymentShippingOption struct");
    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_label, label_fragment);
    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->label.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in PaymentShippingOption struct");
    decltype(Traits::amount(input)) in_amount = Traits::amount(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->amount)::BaseType> amount_fragment(
            fragment.message());
    mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        in_amount, amount_fragment);
    fragment->amount.Set(
        amount_fragment.is_null() ? nullptr : amount_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->amount.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null amount in PaymentShippingOption struct");
    fragment->selected = Traits::selected(input);
  }

  static bool Deserialize(::payments::mojom::internal::PaymentShippingOption_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentShippingOptionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::SecurePaymentConfirmationRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::SecurePaymentConfirmationRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::SecurePaymentConfirmationRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::credential_ids(input)) in_credential_ids = Traits::credential_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->credential_ids)::BaseType>
        credential_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& credential_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        in_credential_ids, credential_ids_fragment, &credential_ids_validate_params);
    fragment->credential_ids.Set(
        credential_ids_fragment.is_null() ? nullptr : credential_ids_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->credential_ids.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null credential_ids in SecurePaymentConfirmationRequest struct");
    decltype(Traits::challenge(input)) in_challenge = Traits::challenge(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->challenge)::BaseType>
        challenge_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& challenge_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_challenge, challenge_fragment, &challenge_validate_params);
    fragment->challenge.Set(
        challenge_fragment.is_null() ? nullptr : challenge_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->challenge.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null challenge in SecurePaymentConfirmationRequest struct");
    decltype(Traits::instrument(input)) in_instrument = Traits::instrument(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instrument)::BaseType> instrument_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PaymentCredentialInstrumentDataView>(
        in_instrument, instrument_fragment);
    fragment->instrument.Set(
        instrument_fragment.is_null() ? nullptr : instrument_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->instrument.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null instrument in SecurePaymentConfirmationRequest struct");
    decltype(Traits::timeout(input)) in_timeout = Traits::timeout(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timeout)::BaseType> timeout_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_timeout, timeout_fragment);
    fragment->timeout.Set(
        timeout_fragment.is_null() ? nullptr : timeout_fragment.data());
    decltype(Traits::payee_origin(input)) in_payee_origin = Traits::payee_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payee_origin)::BaseType> payee_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_payee_origin, payee_origin_fragment);
    fragment->payee_origin.Set(
        payee_origin_fragment.is_null() ? nullptr : payee_origin_fragment.data());
    decltype(Traits::payee_name(input)) in_payee_name = Traits::payee_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payee_name)::BaseType> payee_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_payee_name, payee_name_fragment);
    fragment->payee_name.Set(
        payee_name_fragment.is_null() ? nullptr : payee_name_fragment.data());
    decltype(Traits::rp_id(input)) in_rp_id = Traits::rp_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rp_id)::BaseType> rp_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_rp_id, rp_id_fragment);
    fragment->rp_id.Set(
        rp_id_fragment.is_null() ? nullptr : rp_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->rp_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rp_id in SecurePaymentConfirmationRequest struct");
    decltype(Traits::extensions(input)) in_extensions = Traits::extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extensions)::BaseType> extensions_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::AuthenticationExtensionsClientInputsDataView>(
        in_extensions, extensions_fragment);
    fragment->extensions.Set(
        extensions_fragment.is_null() ? nullptr : extensions_fragment.data());
    fragment->show_opt_out = Traits::show_opt_out(input);
    decltype(Traits::network_info(input)) in_network_info = Traits::network_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->network_info)::BaseType> network_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::payments::mojom::NetworkOrIssuerInformationDataView>(
        in_network_info, network_info_fragment);
    fragment->network_info.Set(
        network_info_fragment.is_null() ? nullptr : network_info_fragment.data());
    decltype(Traits::issuer_info(input)) in_issuer_info = Traits::issuer_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issuer_info)::BaseType> issuer_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::payments::mojom::NetworkOrIssuerInformationDataView>(
        in_issuer_info, issuer_info_fragment);
    fragment->issuer_info.Set(
        issuer_info_fragment.is_null() ? nullptr : issuer_info_fragment.data());
  }

  static bool Deserialize(::payments::mojom::internal::SecurePaymentConfirmationRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::SecurePaymentConfirmationRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::NetworkOrIssuerInformationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::NetworkOrIssuerInformationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::NetworkOrIssuerInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in NetworkOrIssuerInformation struct");
    decltype(Traits::icon(input)) in_icon = Traits::icon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon)::BaseType> icon_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_icon, icon_fragment);
    fragment->icon.Set(
        icon_fragment.is_null() ? nullptr : icon_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->icon.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icon in NetworkOrIssuerInformation struct");
  }

  static bool Deserialize(::payments::mojom::internal::NetworkOrIssuerInformation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::NetworkOrIssuerInformationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentMethodDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentMethodDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentMethodData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::supported_method(input)) in_supported_method = Traits::supported_method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_method)::BaseType> supported_method_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_supported_method, supported_method_fragment);
    fragment->supported_method.Set(
        supported_method_fragment.is_null() ? nullptr : supported_method_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->supported_method.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_method in PaymentMethodData struct");
    decltype(Traits::stringified_data(input)) in_stringified_data = Traits::stringified_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stringified_data)::BaseType> stringified_data_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_stringified_data, stringified_data_fragment);
    fragment->stringified_data.Set(
        stringified_data_fragment.is_null() ? nullptr : stringified_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->stringified_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null stringified_data in PaymentMethodData struct");
    mojo::internal::Serialize<::payments::mojom::AndroidPayEnvironment>(
        Traits::environment(input), &fragment->environment);
    fragment->min_google_play_services_version = Traits::min_google_play_services_version(input);
    fragment->api_version = Traits::api_version(input);
    decltype(Traits::supported_networks(input)) in_supported_networks = Traits::supported_networks(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_networks)::BaseType>
        supported_networks_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_networks_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::payments::mojom::internal::BasicCardNetwork_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::BasicCardNetwork>>(
        in_supported_networks, supported_networks_fragment, &supported_networks_validate_params);
    fragment->supported_networks.Set(
        supported_networks_fragment.is_null() ? nullptr : supported_networks_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->supported_networks.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_networks in PaymentMethodData struct");
    decltype(Traits::secure_payment_confirmation(input)) in_secure_payment_confirmation = Traits::secure_payment_confirmation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->secure_payment_confirmation)::BaseType> secure_payment_confirmation_fragment(
            fragment.message());
    mojo::internal::Serialize<::payments::mojom::SecurePaymentConfirmationRequestDataView>(
        in_secure_payment_confirmation, secure_payment_confirmation_fragment);
    fragment->secure_payment_confirmation.Set(
        secure_payment_confirmation_fragment.is_null() ? nullptr : secure_payment_confirmation_fragment.data());
  }

  static bool Deserialize(::payments::mojom::internal::PaymentMethodData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentMethodDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentDetailsModifierDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentDetailsModifierDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentDetailsModifier_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::total(input)) in_total = Traits::total(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->total)::BaseType> total_fragment(
            fragment.message());
    mojo::internal::Serialize<::payments::mojom::PaymentItemDataView>(
        in_total, total_fragment);
    fragment->total.Set(
        total_fragment.is_null() ? nullptr : total_fragment.data());
    decltype(Traits::additional_display_items(input)) in_additional_display_items = Traits::additional_display_items(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->additional_display_items)::BaseType>
        additional_display_items_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& additional_display_items_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentItemDataView>>(
        in_additional_display_items, additional_display_items_fragment, &additional_display_items_validate_params);
    fragment->additional_display_items.Set(
        additional_display_items_fragment.is_null() ? nullptr : additional_display_items_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->additional_display_items.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null additional_display_items in PaymentDetailsModifier struct");
    decltype(Traits::method_data(input)) in_method_data = Traits::method_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method_data)::BaseType> method_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::payments::mojom::PaymentMethodDataDataView>(
        in_method_data, method_data_fragment);
    fragment->method_data.Set(
        method_data_fragment.is_null() ? nullptr : method_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->method_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method_data in PaymentDetailsModifier struct");
  }

  static bool Deserialize(::payments::mojom::internal::PaymentDetailsModifier_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentDetailsModifierDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::total(input)) in_total = Traits::total(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->total)::BaseType> total_fragment(
            fragment.message());
    mojo::internal::Serialize<::payments::mojom::PaymentItemDataView>(
        in_total, total_fragment);
    fragment->total.Set(
        total_fragment.is_null() ? nullptr : total_fragment.data());
    decltype(Traits::display_items(input)) in_display_items = Traits::display_items(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_items)::BaseType>
        display_items_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& display_items_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentItemDataView>>(
        in_display_items, display_items_fragment, &display_items_validate_params);
    fragment->display_items.Set(
        display_items_fragment.is_null() ? nullptr : display_items_fragment.data());
    decltype(Traits::shipping_options(input)) in_shipping_options = Traits::shipping_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shipping_options)::BaseType>
        shipping_options_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& shipping_options_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>>(
        in_shipping_options, shipping_options_fragment, &shipping_options_validate_params);
    fragment->shipping_options.Set(
        shipping_options_fragment.is_null() ? nullptr : shipping_options_fragment.data());
    decltype(Traits::modifiers(input)) in_modifiers = Traits::modifiers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->modifiers)::BaseType>
        modifiers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& modifiers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>>(
        in_modifiers, modifiers_fragment, &modifiers_validate_params);
    fragment->modifiers.Set(
        modifiers_fragment.is_null() ? nullptr : modifiers_fragment.data());
    decltype(Traits::error(input)) in_error = Traits::error(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->error)::BaseType> error_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_error, error_fragment);
    fragment->error.Set(
        error_fragment.is_null() ? nullptr : error_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->error.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null error in PaymentDetails struct");
    decltype(Traits::shipping_address_errors(input)) in_shipping_address_errors = Traits::shipping_address_errors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shipping_address_errors)::BaseType> shipping_address_errors_fragment(
            fragment.message());
    mojo::internal::Serialize<::payments::mojom::AddressErrorsDataView>(
        in_shipping_address_errors, shipping_address_errors_fragment);
    fragment->shipping_address_errors.Set(
        shipping_address_errors_fragment.is_null() ? nullptr : shipping_address_errors_fragment.data());
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    decltype(Traits::stringified_payment_method_errors(input)) in_stringified_payment_method_errors = Traits::stringified_payment_method_errors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stringified_payment_method_errors)::BaseType> stringified_payment_method_errors_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_stringified_payment_method_errors, stringified_payment_method_errors_fragment);
    fragment->stringified_payment_method_errors.Set(
        stringified_payment_method_errors_fragment.is_null() ? nullptr : stringified_payment_method_errors_fragment.data());
  }

  static bool Deserialize(::payments::mojom::internal::PaymentDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->request_payer_name = Traits::request_payer_name(input);
    fragment->request_payer_email = Traits::request_payer_email(input);
    fragment->request_payer_phone = Traits::request_payer_phone(input);
    fragment->request_shipping = Traits::request_shipping(input);
    mojo::internal::Serialize<::payments::mojom::PaymentShippingType>(
        Traits::shipping_type(input), &fragment->shipping_type);
  }

  static bool Deserialize(::payments::mojom::internal::PaymentOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace payments::mojom {

inline void PaymentResponseDataView::GetMethodNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentResponseDataView::GetStringifiedDetailsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->stringified_details.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentResponseDataView::GetShippingAddressDataView(
    ::payments::mojom::PaymentAddressDataView* output) {
  auto pointer = data_->shipping_address.Get();
  *output = ::payments::mojom::PaymentAddressDataView(pointer, message_);
}
inline void PaymentResponseDataView::GetShippingOptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->shipping_option.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentResponseDataView::GetPayerDataView(
    PayerDetailDataView* output) {
  auto pointer = data_->payer.Get();
  *output = PayerDetailDataView(pointer, message_);
}
inline void PaymentResponseDataView::GetGetAssertionAuthenticatorResponseDataView(
    ::blink::mojom::GetAssertionAuthenticatorResponseDataView* output) {
  auto pointer = data_->get_assertion_authenticator_response.Get();
  *output = ::blink::mojom::GetAssertionAuthenticatorResponseDataView(pointer, message_);
}


inline void PayerDetailDataView::GetEmailDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->email.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PayerDetailDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PayerDetailDataView::GetPhoneDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->phone.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PaymentItemDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentItemDataView::GetAmountDataView(
    ::payments::mojom::PaymentCurrencyAmountDataView* output) {
  auto pointer = data_->amount.Get();
  *output = ::payments::mojom::PaymentCurrencyAmountDataView(pointer, message_);
}


inline void PaymentShippingOptionDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentShippingOptionDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentShippingOptionDataView::GetAmountDataView(
    ::payments::mojom::PaymentCurrencyAmountDataView* output) {
  auto pointer = data_->amount.Get();
  *output = ::payments::mojom::PaymentCurrencyAmountDataView(pointer, message_);
}


inline void SecurePaymentConfirmationRequestDataView::GetCredentialIdsDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->credential_ids.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetChallengeDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->challenge.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetInstrumentDataView(
    ::blink::mojom::PaymentCredentialInstrumentDataView* output) {
  auto pointer = data_->instrument.Get();
  *output = ::blink::mojom::PaymentCredentialInstrumentDataView(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetPayeeOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->payee_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetPayeeNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->payee_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetRpIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->rp_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetExtensionsDataView(
    ::blink::mojom::AuthenticationExtensionsClientInputsDataView* output) {
  auto pointer = data_->extensions.Get();
  *output = ::blink::mojom::AuthenticationExtensionsClientInputsDataView(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetNetworkInfoDataView(
    NetworkOrIssuerInformationDataView* output) {
  auto pointer = data_->network_info.Get();
  *output = NetworkOrIssuerInformationDataView(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetIssuerInfoDataView(
    NetworkOrIssuerInformationDataView* output) {
  auto pointer = data_->issuer_info.Get();
  *output = NetworkOrIssuerInformationDataView(pointer, message_);
}


inline void NetworkOrIssuerInformationDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NetworkOrIssuerInformationDataView::GetIconDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->icon.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void PaymentMethodDataDataView::GetSupportedMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->supported_method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentMethodDataDataView::GetStringifiedDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->stringified_data.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentMethodDataDataView::GetSupportedNetworksDataView(
    mojo::ArrayDataView<BasicCardNetwork>* output) {
  auto pointer = data_->supported_networks.Get();
  *output = mojo::ArrayDataView<BasicCardNetwork>(pointer, message_);
}
inline void PaymentMethodDataDataView::GetSecurePaymentConfirmationDataView(
    SecurePaymentConfirmationRequestDataView* output) {
  auto pointer = data_->secure_payment_confirmation.Get();
  *output = SecurePaymentConfirmationRequestDataView(pointer, message_);
}


inline void PaymentDetailsModifierDataView::GetTotalDataView(
    PaymentItemDataView* output) {
  auto pointer = data_->total.Get();
  *output = PaymentItemDataView(pointer, message_);
}
inline void PaymentDetailsModifierDataView::GetAdditionalDisplayItemsDataView(
    mojo::ArrayDataView<PaymentItemDataView>* output) {
  auto pointer = data_->additional_display_items.Get();
  *output = mojo::ArrayDataView<PaymentItemDataView>(pointer, message_);
}
inline void PaymentDetailsModifierDataView::GetMethodDataDataView(
    PaymentMethodDataDataView* output) {
  auto pointer = data_->method_data.Get();
  *output = PaymentMethodDataDataView(pointer, message_);
}


inline void PaymentDetailsDataView::GetTotalDataView(
    PaymentItemDataView* output) {
  auto pointer = data_->total.Get();
  *output = PaymentItemDataView(pointer, message_);
}
inline void PaymentDetailsDataView::GetDisplayItemsDataView(
    mojo::ArrayDataView<PaymentItemDataView>* output) {
  auto pointer = data_->display_items.Get();
  *output = mojo::ArrayDataView<PaymentItemDataView>(pointer, message_);
}
inline void PaymentDetailsDataView::GetShippingOptionsDataView(
    mojo::ArrayDataView<PaymentShippingOptionDataView>* output) {
  auto pointer = data_->shipping_options.Get();
  *output = mojo::ArrayDataView<PaymentShippingOptionDataView>(pointer, message_);
}
inline void PaymentDetailsDataView::GetModifiersDataView(
    mojo::ArrayDataView<PaymentDetailsModifierDataView>* output) {
  auto pointer = data_->modifiers.Get();
  *output = mojo::ArrayDataView<PaymentDetailsModifierDataView>(pointer, message_);
}
inline void PaymentDetailsDataView::GetErrorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentDetailsDataView::GetShippingAddressErrorsDataView(
    ::payments::mojom::AddressErrorsDataView* output) {
  auto pointer = data_->shipping_address_errors.Get();
  *output = ::payments::mojom::AddressErrorsDataView(pointer, message_);
}
inline void PaymentDetailsDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentDetailsDataView::GetStringifiedPaymentMethodErrorsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->stringified_payment_method_errors.Get();
  *output = mojo::StringDataView(pointer, message_);
}





}  // payments::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::PaymentErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::PaymentErrorReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::CanMakePaymentQueryResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::CanMakePaymentQueryResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::HasEnrolledInstrumentQueryResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::HasEnrolledInstrumentQueryResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::AndroidPayEnvironment> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::AndroidPayEnvironment value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::BasicCardNetwork> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::BasicCardNetwork value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::PaymentShippingType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::PaymentShippingType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::PaymentComplete> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::PaymentComplete value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_SHARED_H_