// third_party/blink/public/mojom/quota/quota_manager_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/quota/quota_manager_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/quota/quota_manager_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/quota/quota_manager_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/quota/quota_manager_host.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/quota/quota_manager_host.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
const char QuotaManagerHost::Name_[] = "blink.mojom.QuotaManagerHost";

QuotaManagerHost::IPCStableHashFunction QuotaManagerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::QuotaManagerHost>(message.name())) {
    case messages::QuotaManagerHost::kQueryStorageUsageAndQuota: {
      return &QuotaManagerHost::QueryStorageUsageAndQuota_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* QuotaManagerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::QuotaManagerHost>(message.name())) {
      case messages::QuotaManagerHost::kQueryStorageUsageAndQuota:
            return "Receive blink::mojom::QuotaManagerHost::QueryStorageUsageAndQuota";
    }
  } else {
    switch (static_cast<messages::QuotaManagerHost>(message.name())) {
      case messages::QuotaManagerHost::kQueryStorageUsageAndQuota:
            return "Receive reply blink::mojom::QuotaManagerHost::QueryStorageUsageAndQuota";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t QuotaManagerHost::QueryStorageUsageAndQuota_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::QuotaManagerHost::QueryStorageUsageAndQuota");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class QuotaManagerHost_QueryStorageUsageAndQuota_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaManagerHost_QueryStorageUsageAndQuota_ForwardToCallback(
      QuotaManagerHost::QueryStorageUsageAndQuotaCallback callback
      ) : callback_(std::move(callback)) {
  }

  QuotaManagerHost_QueryStorageUsageAndQuota_ForwardToCallback(const QuotaManagerHost_QueryStorageUsageAndQuota_ForwardToCallback&) = delete;
  QuotaManagerHost_QueryStorageUsageAndQuota_ForwardToCallback& operator=(const QuotaManagerHost_QueryStorageUsageAndQuota_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  QuotaManagerHost::QueryStorageUsageAndQuotaCallback callback_;
};

QuotaManagerHostProxy::QuotaManagerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuotaManagerHostProxy::QueryStorageUsageAndQuota(
    QueryStorageUsageAndQuotaCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::QuotaManagerHost::QueryStorageUsageAndQuota");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaManagerHost::kQueryStorageUsageAndQuota), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::QuotaManagerHost_QueryStorageUsageAndQuota_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaManagerHost::Name_);
  message.set_method_name("QueryStorageUsageAndQuota");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaManagerHost_QueryStorageUsageAndQuota_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static QuotaManagerHost::QueryStorageUsageAndQuotaCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder> proxy(
        new QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaManagerHost::QueryStorageUsageAndQuotaCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::QuotaStatusCode in_error, int64_t in_current_usage, int64_t in_current_quota, ::blink::mojom::blink::UsageBreakdownPtr in_usage_breakdown);
};

bool QuotaManagerHost_QueryStorageUsageAndQuota_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for QuotaManagerHost.0
  bool success = true;
  ::blink::mojom::blink::QuotaStatusCode p_error{};
  int64_t p_current_usage{};
  int64_t p_current_quota{};
  ::blink::mojom::blink::UsageBreakdownPtr p_usage_breakdown{};
  QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_current_usage = input_data_view.current_usage();
  if (success)
    p_current_quota = input_data_view.current_quota();
  if (success && !input_data_view.ReadUsageBreakdown(&p_usage_breakdown))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaManagerHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_current_usage), 
std::move(p_current_quota), 
std::move(p_usage_breakdown));
  return true;
}

void QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder::Run(
    ::blink::mojom::blink::QuotaStatusCode in_error, int64_t in_current_usage, int64_t in_current_quota, ::blink::mojom::blink::UsageBreakdownPtr in_usage_breakdown) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::QuotaManagerHost::QueryStorageUsageAndQuota", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::blink::QuotaStatusCode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_usage"), in_current_usage,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_quota"), in_current_quota,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage_breakdown"), in_usage_breakdown,
                        "<value of type ::blink::mojom::blink::UsageBreakdownPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaManagerHost::kQueryStorageUsageAndQuota), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::QuotaStatusCode>(
      in_error, &params->error);
  params->current_usage = in_current_usage;
  params->current_quota = in_current_quota;
  mojo::internal::MessageFragment<
      typename decltype(params->usage_breakdown)::BaseType> usage_breakdown_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::UsageBreakdownDataView>(
      in_usage_breakdown, usage_breakdown_fragment);
  params->usage_breakdown.Set(
      usage_breakdown_fragment.is_null() ? nullptr : usage_breakdown_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->usage_breakdown.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null usage_breakdown in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaManagerHost::Name_);
  message.set_method_name("QueryStorageUsageAndQuota");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool QuotaManagerHostStubDispatch::Accept(
    QuotaManagerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::QuotaManagerHost>(message->header()->name)) {
    case messages::QuotaManagerHost::kQueryStorageUsageAndQuota: {
      break;
    }
  }
  return false;
}

// static
bool QuotaManagerHostStubDispatch::AcceptWithResponder(
    QuotaManagerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::QuotaManagerHost>(message->header()->name)) {
    case messages::QuotaManagerHost::kQueryStorageUsageAndQuota: {
      internal::QuotaManagerHost_QueryStorageUsageAndQuota_Params_Data* params =
          reinterpret_cast<
              internal::QuotaManagerHost_QueryStorageUsageAndQuota_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for QuotaManagerHost.0
      bool success = true;
      QuotaManagerHost_QueryStorageUsageAndQuota_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaManagerHost::Name_, 0, false);
        return false;
      }
      QuotaManagerHost::QueryStorageUsageAndQuotaCallback callback =
          QuotaManagerHost_QueryStorageUsageAndQuota_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryStorageUsageAndQuota(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kQuotaManagerHostValidationInfo[] = {
    { &internal::QuotaManagerHost_QueryStorageUsageAndQuota_Params_Data::Validate,
     &internal::QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams_Data::Validate},
};

bool QuotaManagerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::QuotaManagerHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kQuotaManagerHostValidationInfo);
}

bool QuotaManagerHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::QuotaManagerHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kQuotaManagerHostValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void QuotaManagerHostInterceptorForTesting::QueryStorageUsageAndQuota(QueryStorageUsageAndQuotaCallback callback) {
  GetForwardingInterface()->QueryStorageUsageAndQuota(std::move(callback));
}
QuotaManagerHostAsyncWaiter::QuotaManagerHostAsyncWaiter(
    QuotaManagerHost* proxy) : proxy_(proxy) {}

QuotaManagerHostAsyncWaiter::~QuotaManagerHostAsyncWaiter() = default;

void QuotaManagerHostAsyncWaiter::QueryStorageUsageAndQuota(
    ::blink::mojom::blink::QuotaStatusCode* out_error, int64_t* out_current_usage, int64_t* out_current_quota, ::blink::mojom::blink::UsageBreakdownPtr* out_usage_breakdown) {
  base::RunLoop loop;
  proxy_->QueryStorageUsageAndQuota(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::QuotaStatusCode* out_error
,
             int64_t* out_current_usage
,
             int64_t* out_current_quota
,
             ::blink::mojom::blink::UsageBreakdownPtr* out_usage_breakdown
,
             ::blink::mojom::blink::QuotaStatusCode error,
             int64_t current_usage,
             int64_t current_quota,
             ::blink::mojom::blink::UsageBreakdownPtr usage_breakdown) {*out_error = std::move(error);*out_current_usage = std::move(current_usage);*out_current_quota = std::move(current_quota);*out_usage_breakdown = std::move(usage_breakdown);
            loop->Quit();
          },
          &loop,
          out_error,
          out_current_usage,
          out_current_quota,
          out_usage_breakdown));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif