// third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_FETCH_RESPONSE_CALLBACK_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_FETCH_RESPONSE_CALLBACK_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-forward.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-forward.h"
#include "services/network/public/mojom/url_request.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class ServiceWorkerFetchResponseCallbackProxy;

template <typename ImplRefTraits>
class ServiceWorkerFetchResponseCallbackStub;

class ServiceWorkerFetchResponseCallbackRequestValidator;


class BLINK_COMMON_EXPORT ServiceWorkerFetchResponseCallback
    : public ServiceWorkerFetchResponseCallbackInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerFetchResponseCallbackInterfaceBase;
  using Proxy_ = ServiceWorkerFetchResponseCallbackProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerFetchResponseCallbackStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerFetchResponseCallbackRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnResponseMinVersion = 0,
    kOnResponseStreamMinVersion = 0,
    kOnFallbackMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnResponseStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFallback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerFetchResponseCallback() = default;

  
  virtual void OnResponse(::blink::mojom::FetchAPIResponsePtr response, ServiceWorkerFetchEventTimingPtr timing) = 0;

  
  virtual void OnResponseStream(::blink::mojom::FetchAPIResponsePtr response, ::blink::mojom::ServiceWorkerStreamHandlePtr body_as_stream, ServiceWorkerFetchEventTimingPtr timing) = 0;

  
  virtual void OnFallback(std::optional<::network::DataElementChunkedDataPipe> request_body, ServiceWorkerFetchEventTimingPtr timing) = 0;
};



class BLINK_COMMON_EXPORT ServiceWorkerFetchResponseCallbackProxy
    : public ServiceWorkerFetchResponseCallback {
 public:
  using InterfaceType = ServiceWorkerFetchResponseCallback;

  explicit ServiceWorkerFetchResponseCallbackProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnResponse(::blink::mojom::FetchAPIResponsePtr response, ServiceWorkerFetchEventTimingPtr timing) final;
  
  void OnResponseStream(::blink::mojom::FetchAPIResponsePtr response, ::blink::mojom::ServiceWorkerStreamHandlePtr body_as_stream, ServiceWorkerFetchEventTimingPtr timing) final;
  
  void OnFallback(std::optional<::network::DataElementChunkedDataPipe> request_body, ServiceWorkerFetchEventTimingPtr timing) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ServiceWorkerFetchResponseCallbackStubDispatch {
 public:
  static bool Accept(ServiceWorkerFetchResponseCallback* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerFetchResponseCallback* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerFetchResponseCallback>>
class ServiceWorkerFetchResponseCallbackStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerFetchResponseCallbackStub() = default;
  ~ServiceWorkerFetchResponseCallbackStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerFetchResponseCallbackStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerFetchResponseCallbackStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ServiceWorkerFetchResponseCallbackRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT ServiceWorkerFetchEventTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerFetchEventTiming, T>::value>;
  using DataView = ServiceWorkerFetchEventTimingDataView;
  using Data_ = internal::ServiceWorkerFetchEventTiming_Data;

  template <typename... Args>
  static ServiceWorkerFetchEventTimingPtr New(Args&&... args) {
    return ServiceWorkerFetchEventTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerFetchEventTimingPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerFetchEventTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerFetchEventTiming>::Convert(*this);
  }


  ServiceWorkerFetchEventTiming();

  ServiceWorkerFetchEventTiming(
      ::base::TimeTicks dispatch_event_time,
      ::base::TimeTicks respond_with_settled_time);


  ~ServiceWorkerFetchEventTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerFetchEventTimingPtr>
  ServiceWorkerFetchEventTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerFetchEventTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerFetchEventTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerFetchEventTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerFetchEventTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerFetchEventTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerFetchEventTiming_UnserializedMessageContext<
            UserType, ServiceWorkerFetchEventTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerFetchEventTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerFetchEventTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerFetchEventTiming_UnserializedMessageContext<
            UserType, ServiceWorkerFetchEventTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerFetchEventTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks dispatch_event_time;
  
  ::base::TimeTicks respond_with_settled_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerFetchEventTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerFetchEventTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerFetchEventTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerFetchEventTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ServiceWorkerFetchEventTimingPtr ServiceWorkerFetchEventTiming::Clone() const {
  return New(
      mojo::Clone(dispatch_event_time),
      mojo::Clone(respond_with_settled_time)
  );
}

template <typename T, ServiceWorkerFetchEventTiming::EnableIfSame<T>*>
bool ServiceWorkerFetchEventTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dispatch_event_time, other_struct.dispatch_event_time))
    return false;
  if (!mojo::Equals(this->respond_with_settled_time, other_struct.respond_with_settled_time))
    return false;
  return true;
}

template <typename T, ServiceWorkerFetchEventTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.dispatch_event_time < rhs.dispatch_event_time)
    return true;
  if (rhs.dispatch_event_time < lhs.dispatch_event_time)
    return false;
  if (lhs.respond_with_settled_time < rhs.respond_with_settled_time)
    return true;
  if (rhs.respond_with_settled_time < lhs.respond_with_settled_time)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerFetchEventTiming::DataView,
                                         ::blink::mojom::ServiceWorkerFetchEventTimingPtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerFetchEventTimingPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerFetchEventTimingPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ServiceWorkerFetchEventTiming::dispatch_event_time)& dispatch_event_time(
      const ::blink::mojom::ServiceWorkerFetchEventTimingPtr& input) {
    return input->dispatch_event_time;
  }

  static const decltype(::blink::mojom::ServiceWorkerFetchEventTiming::respond_with_settled_time)& respond_with_settled_time(
      const ::blink::mojom::ServiceWorkerFetchEventTimingPtr& input) {
    return input->respond_with_settled_time;
  }

  static bool Read(::blink::mojom::ServiceWorkerFetchEventTiming::DataView input, ::blink::mojom::ServiceWorkerFetchEventTimingPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_FETCH_RESPONSE_CALLBACK_MOJOM_H_