// third_party/blink/public/mojom/service_worker/service_worker_object.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_OBJECT_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_OBJECT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_database.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_state.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class ServiceWorkerObjectHostProxy;

template <typename ImplRefTraits>
class ServiceWorkerObjectHostStub;

class ServiceWorkerObjectHostRequestValidator;
class ServiceWorkerObjectHostResponseValidator;


class BLINK_COMMON_EXPORT ServiceWorkerObjectHost
    : public ServiceWorkerObjectHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerObjectHostInterfaceBase;
  using Proxy_ = ServiceWorkerObjectHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerObjectHostStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerObjectHostRequestValidator;
  using ResponseValidator_ = ServiceWorkerObjectHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kPostMessageToServiceWorkerMinVersion = 0,
    kTerminateForTestingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PostMessageToServiceWorker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TerminateForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerObjectHost() = default;

  
  virtual void PostMessageToServiceWorker(::blink::TransferableMessage message) = 0;


  using TerminateForTestingCallback = base::OnceCallback<void()>;
  
  virtual void TerminateForTesting(TerminateForTestingCallback callback) = 0;
};

class ServiceWorkerObjectProxy;

template <typename ImplRefTraits>
class ServiceWorkerObjectStub;

class ServiceWorkerObjectRequestValidator;


class BLINK_COMMON_EXPORT ServiceWorkerObject
    : public ServiceWorkerObjectInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerObjectInterfaceBase;
  using Proxy_ = ServiceWorkerObjectProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerObjectStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerObjectRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStateChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerObject() = default;

  
  virtual void StateChanged(::blink::mojom::ServiceWorkerState state) = 0;
};



class BLINK_COMMON_EXPORT ServiceWorkerObjectHostProxy
    : public ServiceWorkerObjectHost {
 public:
  using InterfaceType = ServiceWorkerObjectHost;

  explicit ServiceWorkerObjectHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PostMessageToServiceWorker(::blink::TransferableMessage message) final;
  
  void TerminateForTesting(TerminateForTestingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT ServiceWorkerObjectProxy
    : public ServiceWorkerObject {
 public:
  using InterfaceType = ServiceWorkerObject;

  explicit ServiceWorkerObjectProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StateChanged(::blink::mojom::ServiceWorkerState state) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ServiceWorkerObjectHostStubDispatch {
 public:
  static bool Accept(ServiceWorkerObjectHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerObjectHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerObjectHost>>
class ServiceWorkerObjectHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerObjectHostStub() = default;
  ~ServiceWorkerObjectHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerObjectHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerObjectHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ServiceWorkerObjectStubDispatch {
 public:
  static bool Accept(ServiceWorkerObject* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerObject* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerObject>>
class ServiceWorkerObjectStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerObjectStub() = default;
  ~ServiceWorkerObjectStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerObjectStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerObjectStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ServiceWorkerObjectHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ServiceWorkerObjectRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ServiceWorkerObjectHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT ServiceWorkerObjectInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerObjectInfo, T>::value>;
  using DataView = ServiceWorkerObjectInfoDataView;
  using Data_ = internal::ServiceWorkerObjectInfo_Data;

  template <typename... Args>
  static ServiceWorkerObjectInfoPtr New(Args&&... args) {
    return ServiceWorkerObjectInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerObjectInfoPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerObjectInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerObjectInfo>::Convert(*this);
  }


  ServiceWorkerObjectInfo();

  ServiceWorkerObjectInfo(
      int64_t version_id,
      ::blink::mojom::ServiceWorkerState state,
      const ::GURL& url,
      ::mojo::PendingAssociatedRemote<ServiceWorkerObjectHost> host_remote,
      ::mojo::PendingAssociatedReceiver<ServiceWorkerObject> receiver);

ServiceWorkerObjectInfo(const ServiceWorkerObjectInfo&) = delete;
ServiceWorkerObjectInfo& operator=(const ServiceWorkerObjectInfo&) = delete;

  ~ServiceWorkerObjectInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerObjectInfoPtr>
  ServiceWorkerObjectInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerObjectInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerObjectInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerObjectInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerObjectInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerObjectInfo_UnserializedMessageContext<
            UserType, ServiceWorkerObjectInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerObjectInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerObjectInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerObjectInfo_UnserializedMessageContext<
            UserType, ServiceWorkerObjectInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerObjectInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t version_id;
  
  ::blink::mojom::ServiceWorkerState state;
  
  ::GURL url;
  
  ::mojo::PendingAssociatedRemote<ServiceWorkerObjectHost> host_remote;
  
  ::mojo::PendingAssociatedReceiver<ServiceWorkerObject> receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerObjectInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerObjectInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerObjectInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerObjectInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ServiceWorkerObjectInfoPtr ServiceWorkerObjectInfo::Clone() const {
  return New(
      mojo::Clone(version_id),
      mojo::Clone(state),
      mojo::Clone(url),
      mojo::Clone(host_remote),
      mojo::Clone(receiver)
  );
}

template <typename T, ServiceWorkerObjectInfo::EnableIfSame<T>*>
bool ServiceWorkerObjectInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->version_id, other_struct.version_id))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->host_remote, other_struct.host_remote))
    return false;
  if (!mojo::Equals(this->receiver, other_struct.receiver))
    return false;
  return true;
}

template <typename T, ServiceWorkerObjectInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.version_id < rhs.version_id)
    return true;
  if (rhs.version_id < lhs.version_id)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.host_remote < rhs.host_remote)
    return true;
  if (rhs.host_remote < lhs.host_remote)
    return false;
  if (lhs.receiver < rhs.receiver)
    return true;
  if (rhs.receiver < lhs.receiver)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerObjectInfo::DataView,
                                         ::blink::mojom::ServiceWorkerObjectInfoPtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerObjectInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerObjectInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::ServiceWorkerObjectInfo::version_id) version_id(
      const ::blink::mojom::ServiceWorkerObjectInfoPtr& input) {
    return input->version_id;
  }

  static decltype(::blink::mojom::ServiceWorkerObjectInfo::state) state(
      const ::blink::mojom::ServiceWorkerObjectInfoPtr& input) {
    return input->state;
  }

  static const decltype(::blink::mojom::ServiceWorkerObjectInfo::url)& url(
      const ::blink::mojom::ServiceWorkerObjectInfoPtr& input) {
    return input->url;
  }

  static  decltype(::blink::mojom::ServiceWorkerObjectInfo::host_remote)& host_remote(
       ::blink::mojom::ServiceWorkerObjectInfoPtr& input) {
    return input->host_remote;
  }

  static  decltype(::blink::mojom::ServiceWorkerObjectInfo::receiver)& receiver(
       ::blink::mojom::ServiceWorkerObjectInfoPtr& input) {
    return input->receiver;
  }

  static bool Read(::blink::mojom::ServiceWorkerObjectInfo::DataView input, ::blink::mojom::ServiceWorkerObjectInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_OBJECT_MOJOM_H_