// third_party/blink/public/mojom/usb/web_usb_service.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_USB_WEB_USB_SERVICE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_USB_WEB_USB_SERVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/device/public/mojom/usb_device.mojom-blink-forward.h"
#include "services/device/public/mojom/usb_enumeration_options.mojom-blink.h"
#include "services/device/public/mojom/usb_manager_client.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class WebUsbServiceProxy;

template <typename ImplRefTraits>
class WebUsbServiceStub;

class WebUsbServiceRequestValidator;
class WebUsbServiceResponseValidator;


class PLATFORM_EXPORT WebUsbService
    : public WebUsbServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebUsbServiceInterfaceBase;
  using Proxy_ = WebUsbServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebUsbServiceStub<ImplRefTraits>;

  using RequestValidator_ = WebUsbServiceRequestValidator;
  using ResponseValidator_ = WebUsbServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDevicesMinVersion = 0,
    kGetDeviceMinVersion = 0,
    kGetPermissionMinVersion = 0,
    kForgetDeviceMinVersion = 0,
    kSetClientMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetDevices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPermission_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForgetDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebUsbService() = default;


  using GetDevicesCallback = base::OnceCallback<void(WTF::Vector<::device::mojom::blink::UsbDeviceInfoPtr>)>;
  
  virtual void GetDevices(GetDevicesCallback callback) = 0;

  
  virtual void GetDevice(const WTF::String& guid, ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> device_receiver) = 0;


  using GetPermissionCallback = base::OnceCallback<void(::device::mojom::blink::UsbDeviceInfoPtr)>;
  
  virtual void GetPermission(WebUsbRequestDeviceOptionsPtr options, GetPermissionCallback callback) = 0;


  using ForgetDeviceCallback = base::OnceCallback<void()>;
  
  virtual void ForgetDevice(const WTF::String& guid, ForgetDeviceCallback callback) = 0;

  
  virtual void SetClient(::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> client) = 0;
};



class PLATFORM_EXPORT WebUsbServiceProxy
    : public WebUsbService {
 public:
  using InterfaceType = WebUsbService;

  explicit WebUsbServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDevices(GetDevicesCallback callback) final;
  
  void GetDevice(const WTF::String& guid, ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> device_receiver) final;
  
  void GetPermission(WebUsbRequestDeviceOptionsPtr options, GetPermissionCallback callback) final;
  
  void ForgetDevice(const WTF::String& guid, ForgetDeviceCallback callback) final;
  
  void SetClient(::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT WebUsbServiceStubDispatch {
 public:
  static bool Accept(WebUsbService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebUsbService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebUsbService>>
class WebUsbServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebUsbServiceStub() = default;
  ~WebUsbServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebUsbServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebUsbServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT WebUsbServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT WebUsbServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT WebUsbRequestDeviceOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUsbRequestDeviceOptions, T>::value>;
  using DataView = WebUsbRequestDeviceOptionsDataView;
  using Data_ = internal::WebUsbRequestDeviceOptions_Data;

  template <typename... Args>
  static WebUsbRequestDeviceOptionsPtr New(Args&&... args) {
    return WebUsbRequestDeviceOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUsbRequestDeviceOptionsPtr From(const U& u) {
    return mojo::TypeConverter<WebUsbRequestDeviceOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUsbRequestDeviceOptions>::Convert(*this);
  }


  WebUsbRequestDeviceOptions();

  WebUsbRequestDeviceOptions(
      WTF::Vector<::device::mojom::blink::UsbDeviceFilterPtr> filters,
      WTF::Vector<::device::mojom::blink::UsbDeviceFilterPtr> exclusion_filters);

WebUsbRequestDeviceOptions(const WebUsbRequestDeviceOptions&) = delete;
WebUsbRequestDeviceOptions& operator=(const WebUsbRequestDeviceOptions&) = delete;

  ~WebUsbRequestDeviceOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUsbRequestDeviceOptionsPtr>
  WebUsbRequestDeviceOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUsbRequestDeviceOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUsbRequestDeviceOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUsbRequestDeviceOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUsbRequestDeviceOptions::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUsbRequestDeviceOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUsbRequestDeviceOptions_UnserializedMessageContext<
            UserType, WebUsbRequestDeviceOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUsbRequestDeviceOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUsbRequestDeviceOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUsbRequestDeviceOptions_UnserializedMessageContext<
            UserType, WebUsbRequestDeviceOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUsbRequestDeviceOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::Vector<::device::mojom::blink::UsbDeviceFilterPtr> filters;
  
  WTF::Vector<::device::mojom::blink::UsbDeviceFilterPtr> exclusion_filters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUsbRequestDeviceOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUsbRequestDeviceOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUsbRequestDeviceOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUsbRequestDeviceOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebUsbRequestDeviceOptionsPtr WebUsbRequestDeviceOptions::Clone() const {
  return New(
      mojo::Clone(filters),
      mojo::Clone(exclusion_filters)
  );
}

template <typename T, WebUsbRequestDeviceOptions::EnableIfSame<T>*>
bool WebUsbRequestDeviceOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  if (!mojo::Equals(this->exclusion_filters, other_struct.exclusion_filters))
    return false;
  return true;
}

template <typename T, WebUsbRequestDeviceOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.filters < rhs.filters)
    return true;
  if (rhs.filters < lhs.filters)
    return false;
  if (lhs.exclusion_filters < rhs.exclusion_filters)
    return true;
  if (rhs.exclusion_filters < lhs.exclusion_filters)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WebUsbRequestDeviceOptions::DataView,
                                         ::blink::mojom::blink::WebUsbRequestDeviceOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::WebUsbRequestDeviceOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WebUsbRequestDeviceOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::WebUsbRequestDeviceOptions::filters)& filters(
      const ::blink::mojom::blink::WebUsbRequestDeviceOptionsPtr& input) {
    return input->filters;
  }

  static const decltype(::blink::mojom::blink::WebUsbRequestDeviceOptions::exclusion_filters)& exclusion_filters(
      const ::blink::mojom::blink::WebUsbRequestDeviceOptionsPtr& input) {
    return input->exclusion_filters;
  }

  static bool Read(::blink::mojom::blink::WebUsbRequestDeviceOptions::DataView input, ::blink::mojom::blink::WebUsbRequestDeviceOptionsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_USB_WEB_USB_SERVICE_MOJOM_BLINK_H_