// ui/base/mojom/window_open_disposition.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_MOJOM_WINDOW_OPEN_DISPOSITION_MOJOM_SHARED_H_
#define UI_BASE_MOJOM_WINDOW_OPEN_DISPOSITION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/base/mojom/window_open_disposition.mojom-shared-internal.h"







namespace ui::mojom {
class ClickModifiersDataView;



}  // ui::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::mojom::ClickModifiersDataView> {
  using Data = ::ui::mojom::internal::ClickModifiers_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ui::mojom {


enum class WindowOpenDisposition : int32_t {
  
  UNKNOWN = 0,
  
  CURRENT_TAB = 1,
  
  SINGLETON_TAB = 2,
  
  NEW_FOREGROUND_TAB = 3,
  
  NEW_BACKGROUND_TAB = 4,
  
  NEW_POPUP = 5,
  
  NEW_WINDOW = 6,
  
  SAVE_TO_DISK = 7,
  
  OFF_THE_RECORD = 8,
  
  IGNORE_ACTION = 9,
  
  SWITCH_TO_TAB = 10,
  
  NEW_PICTURE_IN_PICTURE = 11,
  kMinValue = 0,
  kMaxValue = 11,
};

 std::ostream& operator<<(std::ostream& os, WindowOpenDisposition value);
inline bool IsKnownEnumValue(WindowOpenDisposition value) {
  return internal::WindowOpenDisposition_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ClickModifiersDataView {
 public:
  ClickModifiersDataView() = default;

  ClickModifiersDataView(
      internal::ClickModifiers_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool middle_button() const {
    return data_->middle_button;
  }
  bool alt_key() const {
    return data_->alt_key;
  }
  bool ctrl_key() const {
    return data_->ctrl_key;
  }
  bool meta_key() const {
    return data_->meta_key;
  }
  bool shift_key() const {
    return data_->shift_key;
  }
 private:
  internal::ClickModifiers_Data* data_ = nullptr;
};


}  // ui::mojom

namespace std {

template <>
struct hash<::ui::mojom::WindowOpenDisposition>
    : public mojo::internal::EnumHashImpl<::ui::mojom::WindowOpenDisposition> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::WindowOpenDisposition, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ui::mojom::WindowOpenDisposition, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ui::mojom::WindowOpenDisposition>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::ClickModifiersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::ClickModifiersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::ClickModifiers_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->middle_button = Traits::middle_button(input);
    fragment->alt_key = Traits::alt_key(input);
    fragment->ctrl_key = Traits::ctrl_key(input);
    fragment->meta_key = Traits::meta_key(input);
    fragment->shift_key = Traits::shift_key(input);
  }

  static bool Deserialize(::ui::mojom::internal::ClickModifiers_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::ClickModifiersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ui::mojom {




}  // ui::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::ui::mojom::WindowOpenDisposition> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ui::mojom::WindowOpenDisposition value);
};

} // namespace perfetto

#endif  // UI_BASE_MOJOM_WINDOW_OPEN_DISPOSITION_MOJOM_SHARED_H_