// ui/gfx/mojom/rrect_f.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_RRECT_F_MOJOM_BLINK_H_
#define UI_GFX_MOJOM_RRECT_F_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/rrect_f.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/rrect_f.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/rrect_f.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gfx::mojom::blink {








class  RRectF {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RRectF, T>::value>;
  using DataView = RRectFDataView;
  using Data_ = internal::RRectF_Data;

  template <typename... Args>
  static RRectFPtr New(Args&&... args) {
    return RRectFPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RRectFPtr From(const U& u) {
    return mojo::TypeConverter<RRectFPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RRectF>::Convert(*this);
  }


  RRectF();

  RRectF(
      RRectFType type,
      const ::gfx::RectF& rect,
      const ::gfx::Vector2dF& upper_left,
      const ::gfx::Vector2dF& upper_right,
      const ::gfx::Vector2dF& lower_right,
      const ::gfx::Vector2dF& lower_left);


  ~RRectF();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RRectFPtr>
  RRectFPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RRectF::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RRectF::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RRectF::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RRectF::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RRectF::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RRectF_UnserializedMessageContext<
            UserType, RRectF::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RRectF::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RRectF::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RRectF_UnserializedMessageContext<
            UserType, RRectF::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RRectF::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  RRectFType type;
  
  ::gfx::RectF rect;
  
  ::gfx::Vector2dF upper_left;
  
  ::gfx::Vector2dF upper_right;
  
  ::gfx::Vector2dF lower_right;
  
  ::gfx::Vector2dF lower_left;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RRectF::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RRectF::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RRectF::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RRectF::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RRectFPtr RRectF::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(rect),
      mojo::Clone(upper_left),
      mojo::Clone(upper_right),
      mojo::Clone(lower_right),
      mojo::Clone(lower_left)
  );
}

template <typename T, RRectF::EnableIfSame<T>*>
bool RRectF::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->rect, other_struct.rect))
    return false;
  if (!mojo::Equals(this->upper_left, other_struct.upper_left))
    return false;
  if (!mojo::Equals(this->upper_right, other_struct.upper_right))
    return false;
  if (!mojo::Equals(this->lower_right, other_struct.lower_right))
    return false;
  if (!mojo::Equals(this->lower_left, other_struct.lower_left))
    return false;
  return true;
}

template <typename T, RRectF::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.rect < rhs.rect)
    return true;
  if (rhs.rect < lhs.rect)
    return false;
  if (lhs.upper_left < rhs.upper_left)
    return true;
  if (rhs.upper_left < lhs.upper_left)
    return false;
  if (lhs.upper_right < rhs.upper_right)
    return true;
  if (rhs.upper_right < lhs.upper_right)
    return false;
  if (lhs.lower_right < rhs.lower_right)
    return true;
  if (rhs.lower_right < lhs.lower_right)
    return false;
  if (lhs.lower_left < rhs.lower_left)
    return true;
  if (rhs.lower_left < lhs.lower_left)
    return false;
  return false;
}


}  // gfx::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::blink::RRectF::DataView,
                                         ::gfx::mojom::blink::RRectFPtr> {
  static bool IsNull(const ::gfx::mojom::blink::RRectFPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::RRectFPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::blink::RRectF::type) type(
      const ::gfx::mojom::blink::RRectFPtr& input) {
    return input->type;
  }

  static const decltype(::gfx::mojom::blink::RRectF::rect)& rect(
      const ::gfx::mojom::blink::RRectFPtr& input) {
    return input->rect;
  }

  static const decltype(::gfx::mojom::blink::RRectF::upper_left)& upper_left(
      const ::gfx::mojom::blink::RRectFPtr& input) {
    return input->upper_left;
  }

  static const decltype(::gfx::mojom::blink::RRectF::upper_right)& upper_right(
      const ::gfx::mojom::blink::RRectFPtr& input) {
    return input->upper_right;
  }

  static const decltype(::gfx::mojom::blink::RRectF::lower_right)& lower_right(
      const ::gfx::mojom::blink::RRectFPtr& input) {
    return input->lower_right;
  }

  static const decltype(::gfx::mojom::blink::RRectF::lower_left)& lower_left(
      const ::gfx::mojom::blink::RRectFPtr& input) {
    return input->lower_left;
  }

  static bool Read(::gfx::mojom::blink::RRectF::DataView input, ::gfx::mojom::blink::RRectFPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_RRECT_F_MOJOM_BLINK_H_