// components/autofill/content/common/mojom/autofill_driver.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/autofill/content/common/mojom/autofill_driver.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/autofill/content/common/mojom/autofill_driver.mojom-params-data.h"
#include "components/autofill/content/common/mojom/autofill_driver.mojom-shared-message-ids.h"

#include "components/autofill/content/common/mojom/autofill_driver.mojom-import-headers.h"
#include "components/autofill/content/common/mojom/autofill_driver.mojom-test-utils.h"


namespace autofill::mojom {
const char AutofillDriver::Name_[] = "autofill.mojom.AutofillDriver";

AutofillDriver::IPCStableHashFunction AutofillDriver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AutofillDriver>(message.name())) {
    case messages::AutofillDriver::kFormsSeen: {
      return &AutofillDriver::FormsSeen_Sym::IPCStableHash;
    }
    case messages::AutofillDriver::kFormSubmitted: {
      return &AutofillDriver::FormSubmitted_Sym::IPCStableHash;
    }
    case messages::AutofillDriver::kCaretMovedInFormField: {
      return &AutofillDriver::CaretMovedInFormField_Sym::IPCStableHash;
    }
    case messages::AutofillDriver::kTextFieldValueChanged: {
      return &AutofillDriver::TextFieldValueChanged_Sym::IPCStableHash;
    }
    case messages::AutofillDriver::kDidEndTextFieldEditing: {
      return &AutofillDriver::DidEndTextFieldEditing_Sym::IPCStableHash;
    }
    case messages::AutofillDriver::kTextFieldDidScroll: {
      return &AutofillDriver::TextFieldDidScroll_Sym::IPCStableHash;
    }
    case messages::AutofillDriver::kSelectControlSelectionChanged: {
      return &AutofillDriver::SelectControlSelectionChanged_Sym::IPCStableHash;
    }
    case messages::AutofillDriver::kSelectFieldOptionsDidChange: {
      return &AutofillDriver::SelectFieldOptionsDidChange_Sym::IPCStableHash;
    }
    case messages::AutofillDriver::kFocusOnFormField: {
      return &AutofillDriver::FocusOnFormField_Sym::IPCStableHash;
    }
    case messages::AutofillDriver::kFocusOnNonFormField: {
      return &AutofillDriver::FocusOnNonFormField_Sym::IPCStableHash;
    }
    case messages::AutofillDriver::kAskForValuesToFill: {
      return &AutofillDriver::AskForValuesToFill_Sym::IPCStableHash;
    }
    case messages::AutofillDriver::kHidePopup: {
      return &AutofillDriver::HidePopup_Sym::IPCStableHash;
    }
    case messages::AutofillDriver::kDidFillAutofillFormData: {
      return &AutofillDriver::DidFillAutofillFormData_Sym::IPCStableHash;
    }
    case messages::AutofillDriver::kJavaScriptChangedAutofilledValue: {
      return &AutofillDriver::JavaScriptChangedAutofilledValue_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AutofillDriver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AutofillDriver>(message.name())) {
      case messages::AutofillDriver::kFormsSeen:
            return "Receive autofill::mojom::AutofillDriver::FormsSeen";
      case messages::AutofillDriver::kFormSubmitted:
            return "Receive autofill::mojom::AutofillDriver::FormSubmitted";
      case messages::AutofillDriver::kCaretMovedInFormField:
            return "Receive autofill::mojom::AutofillDriver::CaretMovedInFormField";
      case messages::AutofillDriver::kTextFieldValueChanged:
            return "Receive autofill::mojom::AutofillDriver::TextFieldValueChanged";
      case messages::AutofillDriver::kDidEndTextFieldEditing:
            return "Receive autofill::mojom::AutofillDriver::DidEndTextFieldEditing";
      case messages::AutofillDriver::kTextFieldDidScroll:
            return "Receive autofill::mojom::AutofillDriver::TextFieldDidScroll";
      case messages::AutofillDriver::kSelectControlSelectionChanged:
            return "Receive autofill::mojom::AutofillDriver::SelectControlSelectionChanged";
      case messages::AutofillDriver::kSelectFieldOptionsDidChange:
            return "Receive autofill::mojom::AutofillDriver::SelectFieldOptionsDidChange";
      case messages::AutofillDriver::kFocusOnFormField:
            return "Receive autofill::mojom::AutofillDriver::FocusOnFormField";
      case messages::AutofillDriver::kFocusOnNonFormField:
            return "Receive autofill::mojom::AutofillDriver::FocusOnNonFormField";
      case messages::AutofillDriver::kAskForValuesToFill:
            return "Receive autofill::mojom::AutofillDriver::AskForValuesToFill";
      case messages::AutofillDriver::kHidePopup:
            return "Receive autofill::mojom::AutofillDriver::HidePopup";
      case messages::AutofillDriver::kDidFillAutofillFormData:
            return "Receive autofill::mojom::AutofillDriver::DidFillAutofillFormData";
      case messages::AutofillDriver::kJavaScriptChangedAutofilledValue:
            return "Receive autofill::mojom::AutofillDriver::JavaScriptChangedAutofilledValue";
    }
  } else {
    switch (static_cast<messages::AutofillDriver>(message.name())) {
      case messages::AutofillDriver::kFormsSeen:
            return "Receive reply autofill::mojom::AutofillDriver::FormsSeen";
      case messages::AutofillDriver::kFormSubmitted:
            return "Receive reply autofill::mojom::AutofillDriver::FormSubmitted";
      case messages::AutofillDriver::kCaretMovedInFormField:
            return "Receive reply autofill::mojom::AutofillDriver::CaretMovedInFormField";
      case messages::AutofillDriver::kTextFieldValueChanged:
            return "Receive reply autofill::mojom::AutofillDriver::TextFieldValueChanged";
      case messages::AutofillDriver::kDidEndTextFieldEditing:
            return "Receive reply autofill::mojom::AutofillDriver::DidEndTextFieldEditing";
      case messages::AutofillDriver::kTextFieldDidScroll:
            return "Receive reply autofill::mojom::AutofillDriver::TextFieldDidScroll";
      case messages::AutofillDriver::kSelectControlSelectionChanged:
            return "Receive reply autofill::mojom::AutofillDriver::SelectControlSelectionChanged";
      case messages::AutofillDriver::kSelectFieldOptionsDidChange:
            return "Receive reply autofill::mojom::AutofillDriver::SelectFieldOptionsDidChange";
      case messages::AutofillDriver::kFocusOnFormField:
            return "Receive reply autofill::mojom::AutofillDriver::FocusOnFormField";
      case messages::AutofillDriver::kFocusOnNonFormField:
            return "Receive reply autofill::mojom::AutofillDriver::FocusOnNonFormField";
      case messages::AutofillDriver::kAskForValuesToFill:
            return "Receive reply autofill::mojom::AutofillDriver::AskForValuesToFill";
      case messages::AutofillDriver::kHidePopup:
            return "Receive reply autofill::mojom::AutofillDriver::HidePopup";
      case messages::AutofillDriver::kDidFillAutofillFormData:
            return "Receive reply autofill::mojom::AutofillDriver::DidFillAutofillFormData";
      case messages::AutofillDriver::kJavaScriptChangedAutofilledValue:
            return "Receive reply autofill::mojom::AutofillDriver::JavaScriptChangedAutofilledValue";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AutofillDriver::FormsSeen_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::FormsSeen");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillDriver::FormSubmitted_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::FormSubmitted");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillDriver::CaretMovedInFormField_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::CaretMovedInFormField");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillDriver::TextFieldValueChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::TextFieldValueChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillDriver::DidEndTextFieldEditing_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::DidEndTextFieldEditing");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillDriver::TextFieldDidScroll_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::TextFieldDidScroll");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillDriver::SelectControlSelectionChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::SelectControlSelectionChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillDriver::SelectFieldOptionsDidChange_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::SelectFieldOptionsDidChange");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillDriver::FocusOnFormField_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::FocusOnFormField");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillDriver::FocusOnNonFormField_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::FocusOnNonFormField");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillDriver::AskForValuesToFill_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::AskForValuesToFill");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillDriver::HidePopup_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::HidePopup");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillDriver::DidFillAutofillFormData_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::DidFillAutofillFormData");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillDriver::JavaScriptChangedAutofilledValue_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::AutofillDriver::JavaScriptChangedAutofilledValue");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AutofillDriverProxy::AutofillDriverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AutofillDriverProxy::FormsSeen(
    const std::vector<::autofill::FormData>& in_updated_forms, const std::vector<::autofill::FormRendererId>& in_removed_forms) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillDriver::FormsSeen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("updated_forms"), in_updated_forms,
                        "<value of type const std::vector<::autofill::FormData>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("removed_forms"), in_removed_forms,
                        "<value of type const std::vector<::autofill::FormRendererId>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kFormsSeen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_FormsSeen_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->updated_forms)::BaseType>
      updated_forms_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& updated_forms_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FormDataDataView>>(
      in_updated_forms, updated_forms_fragment, &updated_forms_validate_params);
  params->updated_forms.Set(
      updated_forms_fragment.is_null() ? nullptr : updated_forms_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->updated_forms.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null updated_forms in AutofillDriver.FormsSeen request");
  mojo::internal::MessageFragment<
      typename decltype(params->removed_forms)::BaseType>
      removed_forms_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& removed_forms_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FormRendererIdDataView>>(
      in_removed_forms, removed_forms_fragment, &removed_forms_validate_params);
  params->removed_forms.Set(
      removed_forms_fragment.is_null() ? nullptr : removed_forms_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->removed_forms.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null removed_forms in AutofillDriver.FormsSeen request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("FormsSeen");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillDriverProxy::FormSubmitted(
    const ::autofill::FormData& in_form, ::autofill::mojom::SubmissionSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillDriver::FormSubmitted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type const ::autofill::FormData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::autofill::mojom::SubmissionSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kFormSubmitted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_FormSubmitted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form, form_fragment);
  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form in AutofillDriver.FormSubmitted request");
  mojo::internal::Serialize<::autofill::mojom::SubmissionSource>(
      in_source, &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("FormSubmitted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillDriverProxy::CaretMovedInFormField(
    const ::autofill::FormData& in_form, ::autofill::FieldRendererId in_field_id, const ::gfx::Rect& in_caret_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillDriver::CaretMovedInFormField", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type const ::autofill::FormData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_id"), in_field_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("caret_bounds"), in_caret_bounds,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kCaretMovedInFormField), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_CaretMovedInFormField_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form, form_fragment);
  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form in AutofillDriver.CaretMovedInFormField request");
  mojo::internal::MessageFragment<
      typename decltype(params->field_id)::BaseType> field_id_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
      in_field_id, field_id_fragment);
  params->field_id.Set(
      field_id_fragment.is_null() ? nullptr : field_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->field_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null field_id in AutofillDriver.CaretMovedInFormField request");
  mojo::internal::MessageFragment<
      typename decltype(params->caret_bounds)::BaseType> caret_bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_caret_bounds, caret_bounds_fragment);
  params->caret_bounds.Set(
      caret_bounds_fragment.is_null() ? nullptr : caret_bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->caret_bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null caret_bounds in AutofillDriver.CaretMovedInFormField request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("CaretMovedInFormField");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillDriverProxy::TextFieldValueChanged(
    const ::autofill::FormData& in_form, ::autofill::FieldRendererId in_field_id, ::base::TimeTicks in_timestamp) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillDriver::TextFieldValueChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type const ::autofill::FormData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_id"), in_field_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timestamp"), in_timestamp,
                        "<value of type ::base::TimeTicks>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kTextFieldValueChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_TextFieldValueChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form, form_fragment);
  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form in AutofillDriver.TextFieldValueChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->field_id)::BaseType> field_id_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
      in_field_id, field_id_fragment);
  params->field_id.Set(
      field_id_fragment.is_null() ? nullptr : field_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->field_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null field_id in AutofillDriver.TextFieldValueChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->timestamp)::BaseType> timestamp_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_timestamp, timestamp_fragment);
  params->timestamp.Set(
      timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timestamp.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamp in AutofillDriver.TextFieldValueChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("TextFieldValueChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillDriverProxy::DidEndTextFieldEditing(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::AutofillDriver::DidEndTextFieldEditing");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kDidEndTextFieldEditing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_DidEndTextFieldEditing_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("DidEndTextFieldEditing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillDriverProxy::TextFieldDidScroll(
    const ::autofill::FormData& in_form, ::autofill::FieldRendererId in_field_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillDriver::TextFieldDidScroll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type const ::autofill::FormData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_id"), in_field_id,
                        "<value of type ::autofill::FieldRendererId>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kTextFieldDidScroll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_TextFieldDidScroll_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form, form_fragment);
  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form in AutofillDriver.TextFieldDidScroll request");
  mojo::internal::MessageFragment<
      typename decltype(params->field_id)::BaseType> field_id_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
      in_field_id, field_id_fragment);
  params->field_id.Set(
      field_id_fragment.is_null() ? nullptr : field_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->field_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null field_id in AutofillDriver.TextFieldDidScroll request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("TextFieldDidScroll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillDriverProxy::SelectControlSelectionChanged(
    const ::autofill::FormData& in_form, ::autofill::FieldRendererId in_field_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillDriver::SelectControlSelectionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type const ::autofill::FormData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_id"), in_field_id,
                        "<value of type ::autofill::FieldRendererId>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kSelectControlSelectionChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_SelectControlSelectionChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form, form_fragment);
  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form in AutofillDriver.SelectControlSelectionChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->field_id)::BaseType> field_id_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
      in_field_id, field_id_fragment);
  params->field_id.Set(
      field_id_fragment.is_null() ? nullptr : field_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->field_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null field_id in AutofillDriver.SelectControlSelectionChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("SelectControlSelectionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillDriverProxy::SelectFieldOptionsDidChange(
    const ::autofill::FormData& in_form) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillDriver::SelectFieldOptionsDidChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type const ::autofill::FormData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kSelectFieldOptionsDidChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_SelectFieldOptionsDidChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form, form_fragment);
  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form in AutofillDriver.SelectFieldOptionsDidChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("SelectFieldOptionsDidChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillDriverProxy::FocusOnFormField(
    const ::autofill::FormData& in_form, ::autofill::FieldRendererId in_field_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillDriver::FocusOnFormField", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type const ::autofill::FormData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_id"), in_field_id,
                        "<value of type ::autofill::FieldRendererId>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kFocusOnFormField), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_FocusOnFormField_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form, form_fragment);
  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form in AutofillDriver.FocusOnFormField request");
  mojo::internal::MessageFragment<
      typename decltype(params->field_id)::BaseType> field_id_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
      in_field_id, field_id_fragment);
  params->field_id.Set(
      field_id_fragment.is_null() ? nullptr : field_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->field_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null field_id in AutofillDriver.FocusOnFormField request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("FocusOnFormField");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillDriverProxy::FocusOnNonFormField(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::AutofillDriver::FocusOnNonFormField");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kFocusOnNonFormField), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_FocusOnNonFormField_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("FocusOnNonFormField");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillDriverProxy::AskForValuesToFill(
    const ::autofill::FormData& in_form, ::autofill::FieldRendererId in_field_id, const ::gfx::Rect& in_caret_bounds, ::autofill::mojom::AutofillSuggestionTriggerSource in_trigger_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillDriver::AskForValuesToFill", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type const ::autofill::FormData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_id"), in_field_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("caret_bounds"), in_caret_bounds,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trigger_source"), in_trigger_source,
                        "<value of type ::autofill::mojom::AutofillSuggestionTriggerSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kAskForValuesToFill), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_AskForValuesToFill_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form, form_fragment);
  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form in AutofillDriver.AskForValuesToFill request");
  mojo::internal::MessageFragment<
      typename decltype(params->field_id)::BaseType> field_id_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
      in_field_id, field_id_fragment);
  params->field_id.Set(
      field_id_fragment.is_null() ? nullptr : field_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->field_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null field_id in AutofillDriver.AskForValuesToFill request");
  mojo::internal::MessageFragment<
      typename decltype(params->caret_bounds)::BaseType> caret_bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_caret_bounds, caret_bounds_fragment);
  params->caret_bounds.Set(
      caret_bounds_fragment.is_null() ? nullptr : caret_bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->caret_bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null caret_bounds in AutofillDriver.AskForValuesToFill request");
  mojo::internal::Serialize<::autofill::mojom::AutofillSuggestionTriggerSource>(
      in_trigger_source, &params->trigger_source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("AskForValuesToFill");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillDriverProxy::HidePopup(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::AutofillDriver::HidePopup");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kHidePopup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_HidePopup_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("HidePopup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillDriverProxy::DidFillAutofillFormData(
    const ::autofill::FormData& in_form, ::base::TimeTicks in_timestamp) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillDriver::DidFillAutofillFormData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type const ::autofill::FormData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timestamp"), in_timestamp,
                        "<value of type ::base::TimeTicks>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kDidFillAutofillFormData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_DidFillAutofillFormData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form, form_fragment);
  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form in AutofillDriver.DidFillAutofillFormData request");
  mojo::internal::MessageFragment<
      typename decltype(params->timestamp)::BaseType> timestamp_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_timestamp, timestamp_fragment);
  params->timestamp.Set(
      timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timestamp.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamp in AutofillDriver.DidFillAutofillFormData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("DidFillAutofillFormData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillDriverProxy::JavaScriptChangedAutofilledValue(
    const ::autofill::FormData& in_form, ::autofill::FieldRendererId in_field_id, const ::std::u16string& in_old_value, bool in_formatting_only) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::AutofillDriver::JavaScriptChangedAutofilledValue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type const ::autofill::FormData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_id"), in_field_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_value"), in_old_value,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("formatting_only"), in_formatting_only,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillDriver::kJavaScriptChangedAutofilledValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::AutofillDriver_JavaScriptChangedAutofilledValue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form, form_fragment);
  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form in AutofillDriver.JavaScriptChangedAutofilledValue request");
  mojo::internal::MessageFragment<
      typename decltype(params->field_id)::BaseType> field_id_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
      in_field_id, field_id_fragment);
  params->field_id.Set(
      field_id_fragment.is_null() ? nullptr : field_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->field_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null field_id in AutofillDriver.JavaScriptChangedAutofilledValue request");
  mojo::internal::MessageFragment<
      typename decltype(params->old_value)::BaseType> old_value_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_old_value, old_value_fragment);
  params->old_value.Set(
      old_value_fragment.is_null() ? nullptr : old_value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->old_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null old_value in AutofillDriver.JavaScriptChangedAutofilledValue request");
  params->formatting_only = in_formatting_only;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillDriver::Name_);
  message.set_method_name("JavaScriptChangedAutofilledValue");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AutofillDriverStubDispatch::Accept(
    AutofillDriver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AutofillDriver>(message->header()->name)) {
    case messages::AutofillDriver::kFormsSeen: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_FormsSeen_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_FormsSeen_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.0
      bool success = true;
      std::vector<::autofill::FormData> p_updated_forms{};
      std::vector<::autofill::FormRendererId> p_removed_forms{};
      AutofillDriver_FormsSeen_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdatedForms(&p_updated_forms))
        success = false;
      if (success && !input_data_view.ReadRemovedForms(&p_removed_forms))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FormsSeen(        
        std::move(p_updated_forms), 
        std::move(p_removed_forms));
      return true;
    }
    case messages::AutofillDriver::kFormSubmitted: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_FormSubmitted_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_FormSubmitted_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.1
      bool success = true;
      ::autofill::FormData p_form{};
      ::autofill::mojom::SubmissionSource p_source{};
      AutofillDriver_FormSubmitted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForm(&p_form))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FormSubmitted(        
        std::move(p_form), 
        std::move(p_source));
      return true;
    }
    case messages::AutofillDriver::kCaretMovedInFormField: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_CaretMovedInFormField_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_CaretMovedInFormField_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.2
      bool success = true;
      ::autofill::FormData p_form{};
      ::autofill::FieldRendererId p_field_id{};
      ::gfx::Rect p_caret_bounds{};
      AutofillDriver_CaretMovedInFormField_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForm(&p_form))
        success = false;
      if (success && !input_data_view.ReadFieldId(&p_field_id))
        success = false;
      if (success && !input_data_view.ReadCaretBounds(&p_caret_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CaretMovedInFormField(        
        std::move(p_form), 
        std::move(p_field_id), 
        std::move(p_caret_bounds));
      return true;
    }
    case messages::AutofillDriver::kTextFieldValueChanged: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_TextFieldValueChanged_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_TextFieldValueChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.3
      bool success = true;
      ::autofill::FormData p_form{};
      ::autofill::FieldRendererId p_field_id{};
      ::base::TimeTicks p_timestamp{};
      AutofillDriver_TextFieldValueChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForm(&p_form))
        success = false;
      if (success && !input_data_view.ReadFieldId(&p_field_id))
        success = false;
      if (success && !input_data_view.ReadTimestamp(&p_timestamp))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TextFieldValueChanged(        
        std::move(p_form), 
        std::move(p_field_id), 
        std::move(p_timestamp));
      return true;
    }
    case messages::AutofillDriver::kDidEndTextFieldEditing: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_DidEndTextFieldEditing_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_DidEndTextFieldEditing_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.4
      bool success = true;
      AutofillDriver_DidEndTextFieldEditing_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidEndTextFieldEditing(        );
      return true;
    }
    case messages::AutofillDriver::kTextFieldDidScroll: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_TextFieldDidScroll_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_TextFieldDidScroll_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.5
      bool success = true;
      ::autofill::FormData p_form{};
      ::autofill::FieldRendererId p_field_id{};
      AutofillDriver_TextFieldDidScroll_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForm(&p_form))
        success = false;
      if (success && !input_data_view.ReadFieldId(&p_field_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TextFieldDidScroll(        
        std::move(p_form), 
        std::move(p_field_id));
      return true;
    }
    case messages::AutofillDriver::kSelectControlSelectionChanged: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_SelectControlSelectionChanged_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_SelectControlSelectionChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.6
      bool success = true;
      ::autofill::FormData p_form{};
      ::autofill::FieldRendererId p_field_id{};
      AutofillDriver_SelectControlSelectionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForm(&p_form))
        success = false;
      if (success && !input_data_view.ReadFieldId(&p_field_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectControlSelectionChanged(        
        std::move(p_form), 
        std::move(p_field_id));
      return true;
    }
    case messages::AutofillDriver::kSelectFieldOptionsDidChange: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_SelectFieldOptionsDidChange_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_SelectFieldOptionsDidChange_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.7
      bool success = true;
      ::autofill::FormData p_form{};
      AutofillDriver_SelectFieldOptionsDidChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForm(&p_form))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectFieldOptionsDidChange(        
        std::move(p_form));
      return true;
    }
    case messages::AutofillDriver::kFocusOnFormField: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_FocusOnFormField_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_FocusOnFormField_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.8
      bool success = true;
      ::autofill::FormData p_form{};
      ::autofill::FieldRendererId p_field_id{};
      AutofillDriver_FocusOnFormField_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForm(&p_form))
        success = false;
      if (success && !input_data_view.ReadFieldId(&p_field_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusOnFormField(        
        std::move(p_form), 
        std::move(p_field_id));
      return true;
    }
    case messages::AutofillDriver::kFocusOnNonFormField: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_FocusOnNonFormField_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_FocusOnNonFormField_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.9
      bool success = true;
      AutofillDriver_FocusOnNonFormField_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusOnNonFormField(        );
      return true;
    }
    case messages::AutofillDriver::kAskForValuesToFill: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_AskForValuesToFill_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_AskForValuesToFill_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.10
      bool success = true;
      ::autofill::FormData p_form{};
      ::autofill::FieldRendererId p_field_id{};
      ::gfx::Rect p_caret_bounds{};
      ::autofill::mojom::AutofillSuggestionTriggerSource p_trigger_source{};
      AutofillDriver_AskForValuesToFill_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForm(&p_form))
        success = false;
      if (success && !input_data_view.ReadFieldId(&p_field_id))
        success = false;
      if (success && !input_data_view.ReadCaretBounds(&p_caret_bounds))
        success = false;
      if (success && !input_data_view.ReadTriggerSource(&p_trigger_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AskForValuesToFill(        
        std::move(p_form), 
        std::move(p_field_id), 
        std::move(p_caret_bounds), 
        std::move(p_trigger_source));
      return true;
    }
    case messages::AutofillDriver::kHidePopup: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_HidePopup_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_HidePopup_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.11
      bool success = true;
      AutofillDriver_HidePopup_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HidePopup(        );
      return true;
    }
    case messages::AutofillDriver::kDidFillAutofillFormData: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_DidFillAutofillFormData_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_DidFillAutofillFormData_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.12
      bool success = true;
      ::autofill::FormData p_form{};
      ::base::TimeTicks p_timestamp{};
      AutofillDriver_DidFillAutofillFormData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForm(&p_form))
        success = false;
      if (success && !input_data_view.ReadTimestamp(&p_timestamp))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFillAutofillFormData(        
        std::move(p_form), 
        std::move(p_timestamp));
      return true;
    }
    case messages::AutofillDriver::kJavaScriptChangedAutofilledValue: {
      DCHECK(message->is_serialized());
      internal::AutofillDriver_JavaScriptChangedAutofilledValue_Params_Data* params =
          reinterpret_cast<internal::AutofillDriver_JavaScriptChangedAutofilledValue_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AutofillDriver.13
      bool success = true;
      ::autofill::FormData p_form{};
      ::autofill::FieldRendererId p_field_id{};
      ::std::u16string p_old_value{};
      bool p_formatting_only{};
      AutofillDriver_JavaScriptChangedAutofilledValue_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForm(&p_form))
        success = false;
      if (success && !input_data_view.ReadFieldId(&p_field_id))
        success = false;
      if (success && !input_data_view.ReadOldValue(&p_old_value))
        success = false;
      if (success)
        p_formatting_only = input_data_view.formatting_only();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillDriver::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JavaScriptChangedAutofilledValue(        
        std::move(p_form), 
        std::move(p_field_id), 
        std::move(p_old_value), 
        std::move(p_formatting_only));
      return true;
    }
  }
  return false;
}

// static
bool AutofillDriverStubDispatch::AcceptWithResponder(
    AutofillDriver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AutofillDriver>(message->header()->name)) {
    case messages::AutofillDriver::kFormsSeen: {
      break;
    }
    case messages::AutofillDriver::kFormSubmitted: {
      break;
    }
    case messages::AutofillDriver::kCaretMovedInFormField: {
      break;
    }
    case messages::AutofillDriver::kTextFieldValueChanged: {
      break;
    }
    case messages::AutofillDriver::kDidEndTextFieldEditing: {
      break;
    }
    case messages::AutofillDriver::kTextFieldDidScroll: {
      break;
    }
    case messages::AutofillDriver::kSelectControlSelectionChanged: {
      break;
    }
    case messages::AutofillDriver::kSelectFieldOptionsDidChange: {
      break;
    }
    case messages::AutofillDriver::kFocusOnFormField: {
      break;
    }
    case messages::AutofillDriver::kFocusOnNonFormField: {
      break;
    }
    case messages::AutofillDriver::kAskForValuesToFill: {
      break;
    }
    case messages::AutofillDriver::kHidePopup: {
      break;
    }
    case messages::AutofillDriver::kDidFillAutofillFormData: {
      break;
    }
    case messages::AutofillDriver::kJavaScriptChangedAutofilledValue: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAutofillDriverValidationInfo[] = {
    {base::to_underlying(messages::AutofillDriver::kFormsSeen),
     { &internal::AutofillDriver_FormsSeen_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AutofillDriver::kFormSubmitted),
     { &internal::AutofillDriver_FormSubmitted_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AutofillDriver::kCaretMovedInFormField),
     { &internal::AutofillDriver_CaretMovedInFormField_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AutofillDriver::kTextFieldValueChanged),
     { &internal::AutofillDriver_TextFieldValueChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AutofillDriver::kDidEndTextFieldEditing),
     { &internal::AutofillDriver_DidEndTextFieldEditing_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AutofillDriver::kTextFieldDidScroll),
     { &internal::AutofillDriver_TextFieldDidScroll_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AutofillDriver::kSelectControlSelectionChanged),
     { &internal::AutofillDriver_SelectControlSelectionChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AutofillDriver::kSelectFieldOptionsDidChange),
     { &internal::AutofillDriver_SelectFieldOptionsDidChange_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AutofillDriver::kFocusOnFormField),
     { &internal::AutofillDriver_FocusOnFormField_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AutofillDriver::kFocusOnNonFormField),
     { &internal::AutofillDriver_FocusOnNonFormField_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AutofillDriver::kAskForValuesToFill),
     { &internal::AutofillDriver_AskForValuesToFill_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AutofillDriver::kHidePopup),
     { &internal::AutofillDriver_HidePopup_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AutofillDriver::kDidFillAutofillFormData),
     { &internal::AutofillDriver_DidFillAutofillFormData_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AutofillDriver::kJavaScriptChangedAutofilledValue),
     { &internal::AutofillDriver_JavaScriptChangedAutofilledValue_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AutofillDriverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::autofill::mojom::AutofillDriver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAutofillDriverValidationInfo);
}

const char PasswordManagerDriver::Name_[] = "autofill.mojom.PasswordManagerDriver";

PasswordManagerDriver::IPCStableHashFunction PasswordManagerDriver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PasswordManagerDriver>(message.name())) {
    case messages::PasswordManagerDriver::kPasswordFormsParsed: {
      return &PasswordManagerDriver::PasswordFormsParsed_Sym::IPCStableHash;
    }
    case messages::PasswordManagerDriver::kPasswordFormsRendered: {
      return &PasswordManagerDriver::PasswordFormsRendered_Sym::IPCStableHash;
    }
    case messages::PasswordManagerDriver::kPasswordFormSubmitted: {
      return &PasswordManagerDriver::PasswordFormSubmitted_Sym::IPCStableHash;
    }
    case messages::PasswordManagerDriver::kInformAboutUserInput: {
      return &PasswordManagerDriver::InformAboutUserInput_Sym::IPCStableHash;
    }
    case messages::PasswordManagerDriver::kDynamicFormSubmission: {
      return &PasswordManagerDriver::DynamicFormSubmission_Sym::IPCStableHash;
    }
    case messages::PasswordManagerDriver::kPasswordFormCleared: {
      return &PasswordManagerDriver::PasswordFormCleared_Sym::IPCStableHash;
    }
    case messages::PasswordManagerDriver::kRecordSavePasswordProgress: {
      return &PasswordManagerDriver::RecordSavePasswordProgress_Sym::IPCStableHash;
    }
    case messages::PasswordManagerDriver::kUserModifiedPasswordField: {
      return &PasswordManagerDriver::UserModifiedPasswordField_Sym::IPCStableHash;
    }
    case messages::PasswordManagerDriver::kUserModifiedNonPasswordField: {
      return &PasswordManagerDriver::UserModifiedNonPasswordField_Sym::IPCStableHash;
    }
    case messages::PasswordManagerDriver::kShowPasswordSuggestions: {
      return &PasswordManagerDriver::ShowPasswordSuggestions_Sym::IPCStableHash;
    }
    case messages::PasswordManagerDriver::kCheckSafeBrowsingReputation: {
      return &PasswordManagerDriver::CheckSafeBrowsingReputation_Sym::IPCStableHash;
    }
    case messages::PasswordManagerDriver::kFocusedInputChanged: {
      return &PasswordManagerDriver::FocusedInputChanged_Sym::IPCStableHash;
    }
    case messages::PasswordManagerDriver::kLogFirstFillingResult: {
      return &PasswordManagerDriver::LogFirstFillingResult_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PasswordManagerDriver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PasswordManagerDriver>(message.name())) {
      case messages::PasswordManagerDriver::kPasswordFormsParsed:
            return "Receive autofill::mojom::PasswordManagerDriver::PasswordFormsParsed";
      case messages::PasswordManagerDriver::kPasswordFormsRendered:
            return "Receive autofill::mojom::PasswordManagerDriver::PasswordFormsRendered";
      case messages::PasswordManagerDriver::kPasswordFormSubmitted:
            return "Receive autofill::mojom::PasswordManagerDriver::PasswordFormSubmitted";
      case messages::PasswordManagerDriver::kInformAboutUserInput:
            return "Receive autofill::mojom::PasswordManagerDriver::InformAboutUserInput";
      case messages::PasswordManagerDriver::kDynamicFormSubmission:
            return "Receive autofill::mojom::PasswordManagerDriver::DynamicFormSubmission";
      case messages::PasswordManagerDriver::kPasswordFormCleared:
            return "Receive autofill::mojom::PasswordManagerDriver::PasswordFormCleared";
      case messages::PasswordManagerDriver::kRecordSavePasswordProgress:
            return "Receive autofill::mojom::PasswordManagerDriver::RecordSavePasswordProgress";
      case messages::PasswordManagerDriver::kUserModifiedPasswordField:
            return "Receive autofill::mojom::PasswordManagerDriver::UserModifiedPasswordField";
      case messages::PasswordManagerDriver::kUserModifiedNonPasswordField:
            return "Receive autofill::mojom::PasswordManagerDriver::UserModifiedNonPasswordField";
      case messages::PasswordManagerDriver::kShowPasswordSuggestions:
            return "Receive autofill::mojom::PasswordManagerDriver::ShowPasswordSuggestions";
      case messages::PasswordManagerDriver::kCheckSafeBrowsingReputation:
            return "Receive autofill::mojom::PasswordManagerDriver::CheckSafeBrowsingReputation";
      case messages::PasswordManagerDriver::kFocusedInputChanged:
            return "Receive autofill::mojom::PasswordManagerDriver::FocusedInputChanged";
      case messages::PasswordManagerDriver::kLogFirstFillingResult:
            return "Receive autofill::mojom::PasswordManagerDriver::LogFirstFillingResult";
    }
  } else {
    switch (static_cast<messages::PasswordManagerDriver>(message.name())) {
      case messages::PasswordManagerDriver::kPasswordFormsParsed:
            return "Receive reply autofill::mojom::PasswordManagerDriver::PasswordFormsParsed";
      case messages::PasswordManagerDriver::kPasswordFormsRendered:
            return "Receive reply autofill::mojom::PasswordManagerDriver::PasswordFormsRendered";
      case messages::PasswordManagerDriver::kPasswordFormSubmitted:
            return "Receive reply autofill::mojom::PasswordManagerDriver::PasswordFormSubmitted";
      case messages::PasswordManagerDriver::kInformAboutUserInput:
            return "Receive reply autofill::mojom::PasswordManagerDriver::InformAboutUserInput";
      case messages::PasswordManagerDriver::kDynamicFormSubmission:
            return "Receive reply autofill::mojom::PasswordManagerDriver::DynamicFormSubmission";
      case messages::PasswordManagerDriver::kPasswordFormCleared:
            return "Receive reply autofill::mojom::PasswordManagerDriver::PasswordFormCleared";
      case messages::PasswordManagerDriver::kRecordSavePasswordProgress:
            return "Receive reply autofill::mojom::PasswordManagerDriver::RecordSavePasswordProgress";
      case messages::PasswordManagerDriver::kUserModifiedPasswordField:
            return "Receive reply autofill::mojom::PasswordManagerDriver::UserModifiedPasswordField";
      case messages::PasswordManagerDriver::kUserModifiedNonPasswordField:
            return "Receive reply autofill::mojom::PasswordManagerDriver::UserModifiedNonPasswordField";
      case messages::PasswordManagerDriver::kShowPasswordSuggestions:
            return "Receive reply autofill::mojom::PasswordManagerDriver::ShowPasswordSuggestions";
      case messages::PasswordManagerDriver::kCheckSafeBrowsingReputation:
            return "Receive reply autofill::mojom::PasswordManagerDriver::CheckSafeBrowsingReputation";
      case messages::PasswordManagerDriver::kFocusedInputChanged:
            return "Receive reply autofill::mojom::PasswordManagerDriver::FocusedInputChanged";
      case messages::PasswordManagerDriver::kLogFirstFillingResult:
            return "Receive reply autofill::mojom::PasswordManagerDriver::LogFirstFillingResult";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PasswordManagerDriver::PasswordFormsParsed_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordManagerDriver::PasswordFormsParsed");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordManagerDriver::PasswordFormsRendered_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordManagerDriver::PasswordFormsRendered");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordManagerDriver::PasswordFormSubmitted_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordManagerDriver::PasswordFormSubmitted");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordManagerDriver::InformAboutUserInput_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordManagerDriver::InformAboutUserInput");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordManagerDriver::DynamicFormSubmission_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordManagerDriver::DynamicFormSubmission");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordManagerDriver::PasswordFormCleared_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordManagerDriver::PasswordFormCleared");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordManagerDriver::RecordSavePasswordProgress_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordManagerDriver::RecordSavePasswordProgress");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordManagerDriver::UserModifiedPasswordField_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordManagerDriver::UserModifiedPasswordField");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordManagerDriver::UserModifiedNonPasswordField_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordManagerDriver::UserModifiedNonPasswordField");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordManagerDriver::ShowPasswordSuggestions_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordManagerDriver::ShowPasswordSuggestions");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordManagerDriver::CheckSafeBrowsingReputation_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordManagerDriver::CheckSafeBrowsingReputation");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordManagerDriver::FocusedInputChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordManagerDriver::FocusedInputChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordManagerDriver::LogFirstFillingResult_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordManagerDriver::LogFirstFillingResult");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PasswordManagerDriverProxy::PasswordManagerDriverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PasswordManagerDriverProxy::PasswordFormsParsed(
    const std::vector<::autofill::FormData>& in_forms_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordManagerDriver::PasswordFormsParsed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("forms_data"), in_forms_data,
                        "<value of type const std::vector<::autofill::FormData>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordManagerDriver::kPasswordFormsParsed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordManagerDriver_PasswordFormsParsed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->forms_data)::BaseType>
      forms_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& forms_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FormDataDataView>>(
      in_forms_data, forms_data_fragment, &forms_data_validate_params);
  params->forms_data.Set(
      forms_data_fragment.is_null() ? nullptr : forms_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->forms_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null forms_data in PasswordManagerDriver.PasswordFormsParsed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordManagerDriver::Name_);
  message.set_method_name("PasswordFormsParsed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordManagerDriverProxy::PasswordFormsRendered(
    const std::vector<::autofill::FormData>& in_visible_forms_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordManagerDriver::PasswordFormsRendered", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible_forms_data"), in_visible_forms_data,
                        "<value of type const std::vector<::autofill::FormData>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordManagerDriver::kPasswordFormsRendered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordManagerDriver_PasswordFormsRendered_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->visible_forms_data)::BaseType>
      visible_forms_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& visible_forms_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FormDataDataView>>(
      in_visible_forms_data, visible_forms_data_fragment, &visible_forms_data_validate_params);
  params->visible_forms_data.Set(
      visible_forms_data_fragment.is_null() ? nullptr : visible_forms_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->visible_forms_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visible_forms_data in PasswordManagerDriver.PasswordFormsRendered request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordManagerDriver::Name_);
  message.set_method_name("PasswordFormsRendered");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordManagerDriverProxy::PasswordFormSubmitted(
    const ::autofill::FormData& in_form_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordManagerDriver::PasswordFormSubmitted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form_data"), in_form_data,
                        "<value of type const ::autofill::FormData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordManagerDriver::kPasswordFormSubmitted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordManagerDriver_PasswordFormSubmitted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form_data)::BaseType> form_data_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form_data, form_data_fragment);
  params->form_data.Set(
      form_data_fragment.is_null() ? nullptr : form_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_data in PasswordManagerDriver.PasswordFormSubmitted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordManagerDriver::Name_);
  message.set_method_name("PasswordFormSubmitted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordManagerDriverProxy::InformAboutUserInput(
    const ::autofill::FormData& in_form_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordManagerDriver::InformAboutUserInput", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form_data"), in_form_data,
                        "<value of type const ::autofill::FormData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordManagerDriver::kInformAboutUserInput), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordManagerDriver_InformAboutUserInput_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form_data)::BaseType> form_data_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form_data, form_data_fragment);
  params->form_data.Set(
      form_data_fragment.is_null() ? nullptr : form_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_data in PasswordManagerDriver.InformAboutUserInput request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordManagerDriver::Name_);
  message.set_method_name("InformAboutUserInput");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordManagerDriverProxy::DynamicFormSubmission(
    ::autofill::mojom::SubmissionIndicatorEvent in_submission_indication_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordManagerDriver::DynamicFormSubmission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("submission_indication_event"), in_submission_indication_event,
                        "<value of type ::autofill::mojom::SubmissionIndicatorEvent>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordManagerDriver::kDynamicFormSubmission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordManagerDriver_DynamicFormSubmission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::autofill::mojom::SubmissionIndicatorEvent>(
      in_submission_indication_event, &params->submission_indication_event);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordManagerDriver::Name_);
  message.set_method_name("DynamicFormSubmission");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordManagerDriverProxy::PasswordFormCleared(
    const ::autofill::FormData& in_form_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordManagerDriver::PasswordFormCleared", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form_data"), in_form_data,
                        "<value of type const ::autofill::FormData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordManagerDriver::kPasswordFormCleared), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordManagerDriver_PasswordFormCleared_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form_data)::BaseType> form_data_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form_data, form_data_fragment);
  params->form_data.Set(
      form_data_fragment.is_null() ? nullptr : form_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_data in PasswordManagerDriver.PasswordFormCleared request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordManagerDriver::Name_);
  message.set_method_name("PasswordFormCleared");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordManagerDriverProxy::RecordSavePasswordProgress(
    const std::string& in_log) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordManagerDriver::RecordSavePasswordProgress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log"), in_log,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordManagerDriver::kRecordSavePasswordProgress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordManagerDriver_RecordSavePasswordProgress_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->log)::BaseType> log_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_log, log_fragment);
  params->log.Set(
      log_fragment.is_null() ? nullptr : log_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->log.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null log in PasswordManagerDriver.RecordSavePasswordProgress request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordManagerDriver::Name_);
  message.set_method_name("RecordSavePasswordProgress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordManagerDriverProxy::UserModifiedPasswordField(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::PasswordManagerDriver::UserModifiedPasswordField");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordManagerDriver::kUserModifiedPasswordField), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordManagerDriver_UserModifiedPasswordField_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordManagerDriver::Name_);
  message.set_method_name("UserModifiedPasswordField");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordManagerDriverProxy::UserModifiedNonPasswordField(
    ::autofill::FieldRendererId in_renderer_id, const ::std::u16string& in_value, bool in_autocomplete_attribute_has_username, bool in_is_likely_otp) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordManagerDriver::UserModifiedNonPasswordField", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("renderer_id"), in_renderer_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("autocomplete_attribute_has_username"), in_autocomplete_attribute_has_username,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_likely_otp"), in_is_likely_otp,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordManagerDriver::kUserModifiedNonPasswordField), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordManagerDriver_UserModifiedNonPasswordField_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->renderer_id)::BaseType> renderer_id_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
      in_renderer_id, renderer_id_fragment);
  params->renderer_id.Set(
      renderer_id_fragment.is_null() ? nullptr : renderer_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->renderer_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null renderer_id in PasswordManagerDriver.UserModifiedNonPasswordField request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_value, value_fragment);
  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in PasswordManagerDriver.UserModifiedNonPasswordField request");
  params->autocomplete_attribute_has_username = in_autocomplete_attribute_has_username;
  params->is_likely_otp = in_is_likely_otp;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordManagerDriver::Name_);
  message.set_method_name("UserModifiedNonPasswordField");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordManagerDriverProxy::ShowPasswordSuggestions(
    const ::autofill::PasswordSuggestionRequest& in_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordManagerDriver::ShowPasswordSuggestions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type const ::autofill::PasswordSuggestionRequest&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordManagerDriver::kShowPasswordSuggestions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordManagerDriver_ShowPasswordSuggestions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::PasswordSuggestionRequestDataView>(
      in_request, request_fragment);
  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in PasswordManagerDriver.ShowPasswordSuggestions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordManagerDriver::Name_);
  message.set_method_name("ShowPasswordSuggestions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordManagerDriverProxy::CheckSafeBrowsingReputation(
    const ::GURL& in_form_action, const ::GURL& in_frame_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordManagerDriver::CheckSafeBrowsingReputation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form_action"), in_form_action,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_url"), in_frame_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordManagerDriver::kCheckSafeBrowsingReputation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordManagerDriver_CheckSafeBrowsingReputation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form_action)::BaseType> form_action_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_form_action, form_action_fragment);
  params->form_action.Set(
      form_action_fragment.is_null() ? nullptr : form_action_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form_action.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_action in PasswordManagerDriver.CheckSafeBrowsingReputation request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_url)::BaseType> frame_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_frame_url, frame_url_fragment);
  params->frame_url.Set(
      frame_url_fragment.is_null() ? nullptr : frame_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_url in PasswordManagerDriver.CheckSafeBrowsingReputation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordManagerDriver::Name_);
  message.set_method_name("CheckSafeBrowsingReputation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordManagerDriverProxy::FocusedInputChanged(
    ::autofill::FieldRendererId in_focused_field_id, ::autofill::mojom::FocusedFieldType in_focused_field_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordManagerDriver::FocusedInputChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focused_field_id"), in_focused_field_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focused_field_type"), in_focused_field_type,
                        "<value of type ::autofill::mojom::FocusedFieldType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordManagerDriver::kFocusedInputChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordManagerDriver_FocusedInputChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->focused_field_id)::BaseType> focused_field_id_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
      in_focused_field_id, focused_field_id_fragment);
  params->focused_field_id.Set(
      focused_field_id_fragment.is_null() ? nullptr : focused_field_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->focused_field_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null focused_field_id in PasswordManagerDriver.FocusedInputChanged request");
  mojo::internal::Serialize<::autofill::mojom::FocusedFieldType>(
      in_focused_field_type, &params->focused_field_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordManagerDriver::Name_);
  message.set_method_name("FocusedInputChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordManagerDriverProxy::LogFirstFillingResult(
    ::autofill::FormRendererId in_form_renderer_id, int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordManagerDriver::LogFirstFillingResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form_renderer_id"), in_form_renderer_id,
                        "<value of type ::autofill::FormRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordManagerDriver::kLogFirstFillingResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordManagerDriver_LogFirstFillingResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form_renderer_id)::BaseType> form_renderer_id_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormRendererIdDataView>(
      in_form_renderer_id, form_renderer_id_fragment);
  params->form_renderer_id.Set(
      form_renderer_id_fragment.is_null() ? nullptr : form_renderer_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form_renderer_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_renderer_id in PasswordManagerDriver.LogFirstFillingResult request");
  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordManagerDriver::Name_);
  message.set_method_name("LogFirstFillingResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PasswordManagerDriverStubDispatch::Accept(
    PasswordManagerDriver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PasswordManagerDriver>(message->header()->name)) {
    case messages::PasswordManagerDriver::kPasswordFormsParsed: {
      DCHECK(message->is_serialized());
      internal::PasswordManagerDriver_PasswordFormsParsed_Params_Data* params =
          reinterpret_cast<internal::PasswordManagerDriver_PasswordFormsParsed_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordManagerDriver.0
      bool success = true;
      std::vector<::autofill::FormData> p_forms_data{};
      PasswordManagerDriver_PasswordFormsParsed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormsData(&p_forms_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordManagerDriver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PasswordFormsParsed(        
        std::move(p_forms_data));
      return true;
    }
    case messages::PasswordManagerDriver::kPasswordFormsRendered: {
      DCHECK(message->is_serialized());
      internal::PasswordManagerDriver_PasswordFormsRendered_Params_Data* params =
          reinterpret_cast<internal::PasswordManagerDriver_PasswordFormsRendered_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordManagerDriver.1
      bool success = true;
      std::vector<::autofill::FormData> p_visible_forms_data{};
      PasswordManagerDriver_PasswordFormsRendered_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisibleFormsData(&p_visible_forms_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordManagerDriver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PasswordFormsRendered(        
        std::move(p_visible_forms_data));
      return true;
    }
    case messages::PasswordManagerDriver::kPasswordFormSubmitted: {
      DCHECK(message->is_serialized());
      internal::PasswordManagerDriver_PasswordFormSubmitted_Params_Data* params =
          reinterpret_cast<internal::PasswordManagerDriver_PasswordFormSubmitted_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordManagerDriver.2
      bool success = true;
      ::autofill::FormData p_form_data{};
      PasswordManagerDriver_PasswordFormSubmitted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormData(&p_form_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordManagerDriver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PasswordFormSubmitted(        
        std::move(p_form_data));
      return true;
    }
    case messages::PasswordManagerDriver::kInformAboutUserInput: {
      DCHECK(message->is_serialized());
      internal::PasswordManagerDriver_InformAboutUserInput_Params_Data* params =
          reinterpret_cast<internal::PasswordManagerDriver_InformAboutUserInput_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordManagerDriver.3
      bool success = true;
      ::autofill::FormData p_form_data{};
      PasswordManagerDriver_InformAboutUserInput_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormData(&p_form_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordManagerDriver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InformAboutUserInput(        
        std::move(p_form_data));
      return true;
    }
    case messages::PasswordManagerDriver::kDynamicFormSubmission: {
      DCHECK(message->is_serialized());
      internal::PasswordManagerDriver_DynamicFormSubmission_Params_Data* params =
          reinterpret_cast<internal::PasswordManagerDriver_DynamicFormSubmission_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordManagerDriver.4
      bool success = true;
      ::autofill::mojom::SubmissionIndicatorEvent p_submission_indication_event{};
      PasswordManagerDriver_DynamicFormSubmission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSubmissionIndicationEvent(&p_submission_indication_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordManagerDriver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DynamicFormSubmission(        
        std::move(p_submission_indication_event));
      return true;
    }
    case messages::PasswordManagerDriver::kPasswordFormCleared: {
      DCHECK(message->is_serialized());
      internal::PasswordManagerDriver_PasswordFormCleared_Params_Data* params =
          reinterpret_cast<internal::PasswordManagerDriver_PasswordFormCleared_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordManagerDriver.5
      bool success = true;
      ::autofill::FormData p_form_data{};
      PasswordManagerDriver_PasswordFormCleared_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormData(&p_form_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordManagerDriver::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PasswordFormCleared(        
        std::move(p_form_data));
      return true;
    }
    case messages::PasswordManagerDriver::kRecordSavePasswordProgress: {
      DCHECK(message->is_serialized());
      internal::PasswordManagerDriver_RecordSavePasswordProgress_Params_Data* params =
          reinterpret_cast<internal::PasswordManagerDriver_RecordSavePasswordProgress_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordManagerDriver.6
      bool success = true;
      std::string p_log{};
      PasswordManagerDriver_RecordSavePasswordProgress_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLog(&p_log))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordManagerDriver::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordSavePasswordProgress(        
        std::move(p_log));
      return true;
    }
    case messages::PasswordManagerDriver::kUserModifiedPasswordField: {
      DCHECK(message->is_serialized());
      internal::PasswordManagerDriver_UserModifiedPasswordField_Params_Data* params =
          reinterpret_cast<internal::PasswordManagerDriver_UserModifiedPasswordField_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordManagerDriver.7
      bool success = true;
      PasswordManagerDriver_UserModifiedPasswordField_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordManagerDriver::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UserModifiedPasswordField(        );
      return true;
    }
    case messages::PasswordManagerDriver::kUserModifiedNonPasswordField: {
      DCHECK(message->is_serialized());
      internal::PasswordManagerDriver_UserModifiedNonPasswordField_Params_Data* params =
          reinterpret_cast<internal::PasswordManagerDriver_UserModifiedNonPasswordField_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordManagerDriver.8
      bool success = true;
      ::autofill::FieldRendererId p_renderer_id{};
      ::std::u16string p_value{};
      bool p_autocomplete_attribute_has_username{};
      bool p_is_likely_otp{};
      PasswordManagerDriver_UserModifiedNonPasswordField_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRendererId(&p_renderer_id))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (success)
        p_autocomplete_attribute_has_username = input_data_view.autocomplete_attribute_has_username();
      if (success)
        p_is_likely_otp = input_data_view.is_likely_otp();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordManagerDriver::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UserModifiedNonPasswordField(        
        std::move(p_renderer_id), 
        std::move(p_value), 
        std::move(p_autocomplete_attribute_has_username), 
        std::move(p_is_likely_otp));
      return true;
    }
    case messages::PasswordManagerDriver::kShowPasswordSuggestions: {
      DCHECK(message->is_serialized());
      internal::PasswordManagerDriver_ShowPasswordSuggestions_Params_Data* params =
          reinterpret_cast<internal::PasswordManagerDriver_ShowPasswordSuggestions_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordManagerDriver.9
      bool success = true;
      ::autofill::PasswordSuggestionRequest p_request{};
      PasswordManagerDriver_ShowPasswordSuggestions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordManagerDriver::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowPasswordSuggestions(        
        std::move(p_request));
      return true;
    }
    case messages::PasswordManagerDriver::kCheckSafeBrowsingReputation: {
      DCHECK(message->is_serialized());
      internal::PasswordManagerDriver_CheckSafeBrowsingReputation_Params_Data* params =
          reinterpret_cast<internal::PasswordManagerDriver_CheckSafeBrowsingReputation_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordManagerDriver.10
      bool success = true;
      ::GURL p_form_action{};
      ::GURL p_frame_url{};
      PasswordManagerDriver_CheckSafeBrowsingReputation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormAction(&p_form_action))
        success = false;
      if (success && !input_data_view.ReadFrameUrl(&p_frame_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordManagerDriver::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CheckSafeBrowsingReputation(        
        std::move(p_form_action), 
        std::move(p_frame_url));
      return true;
    }
    case messages::PasswordManagerDriver::kFocusedInputChanged: {
      DCHECK(message->is_serialized());
      internal::PasswordManagerDriver_FocusedInputChanged_Params_Data* params =
          reinterpret_cast<internal::PasswordManagerDriver_FocusedInputChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordManagerDriver.11
      bool success = true;
      ::autofill::FieldRendererId p_focused_field_id{};
      ::autofill::mojom::FocusedFieldType p_focused_field_type{};
      PasswordManagerDriver_FocusedInputChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFocusedFieldId(&p_focused_field_id))
        success = false;
      if (success && !input_data_view.ReadFocusedFieldType(&p_focused_field_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordManagerDriver::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusedInputChanged(        
        std::move(p_focused_field_id), 
        std::move(p_focused_field_type));
      return true;
    }
    case messages::PasswordManagerDriver::kLogFirstFillingResult: {
      DCHECK(message->is_serialized());
      internal::PasswordManagerDriver_LogFirstFillingResult_Params_Data* params =
          reinterpret_cast<internal::PasswordManagerDriver_LogFirstFillingResult_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordManagerDriver.12
      bool success = true;
      ::autofill::FormRendererId p_form_renderer_id{};
      int32_t p_result{};
      PasswordManagerDriver_LogFirstFillingResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormRendererId(&p_form_renderer_id))
        success = false;
      if (success)
        p_result = input_data_view.result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordManagerDriver::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogFirstFillingResult(        
        std::move(p_form_renderer_id), 
        std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool PasswordManagerDriverStubDispatch::AcceptWithResponder(
    PasswordManagerDriver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PasswordManagerDriver>(message->header()->name)) {
    case messages::PasswordManagerDriver::kPasswordFormsParsed: {
      break;
    }
    case messages::PasswordManagerDriver::kPasswordFormsRendered: {
      break;
    }
    case messages::PasswordManagerDriver::kPasswordFormSubmitted: {
      break;
    }
    case messages::PasswordManagerDriver::kInformAboutUserInput: {
      break;
    }
    case messages::PasswordManagerDriver::kDynamicFormSubmission: {
      break;
    }
    case messages::PasswordManagerDriver::kPasswordFormCleared: {
      break;
    }
    case messages::PasswordManagerDriver::kRecordSavePasswordProgress: {
      break;
    }
    case messages::PasswordManagerDriver::kUserModifiedPasswordField: {
      break;
    }
    case messages::PasswordManagerDriver::kUserModifiedNonPasswordField: {
      break;
    }
    case messages::PasswordManagerDriver::kShowPasswordSuggestions: {
      break;
    }
    case messages::PasswordManagerDriver::kCheckSafeBrowsingReputation: {
      break;
    }
    case messages::PasswordManagerDriver::kFocusedInputChanged: {
      break;
    }
    case messages::PasswordManagerDriver::kLogFirstFillingResult: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPasswordManagerDriverValidationInfo[] = {
    {base::to_underlying(messages::PasswordManagerDriver::kPasswordFormsParsed),
     { &internal::PasswordManagerDriver_PasswordFormsParsed_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordManagerDriver::kPasswordFormsRendered),
     { &internal::PasswordManagerDriver_PasswordFormsRendered_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordManagerDriver::kPasswordFormSubmitted),
     { &internal::PasswordManagerDriver_PasswordFormSubmitted_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordManagerDriver::kInformAboutUserInput),
     { &internal::PasswordManagerDriver_InformAboutUserInput_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordManagerDriver::kDynamicFormSubmission),
     { &internal::PasswordManagerDriver_DynamicFormSubmission_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordManagerDriver::kPasswordFormCleared),
     { &internal::PasswordManagerDriver_PasswordFormCleared_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordManagerDriver::kRecordSavePasswordProgress),
     { &internal::PasswordManagerDriver_RecordSavePasswordProgress_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordManagerDriver::kUserModifiedPasswordField),
     { &internal::PasswordManagerDriver_UserModifiedPasswordField_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordManagerDriver::kUserModifiedNonPasswordField),
     { &internal::PasswordManagerDriver_UserModifiedNonPasswordField_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordManagerDriver::kShowPasswordSuggestions),
     { &internal::PasswordManagerDriver_ShowPasswordSuggestions_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordManagerDriver::kCheckSafeBrowsingReputation),
     { &internal::PasswordManagerDriver_CheckSafeBrowsingReputation_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordManagerDriver::kFocusedInputChanged),
     { &internal::PasswordManagerDriver_FocusedInputChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordManagerDriver::kLogFirstFillingResult),
     { &internal::PasswordManagerDriver_LogFirstFillingResult_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PasswordManagerDriverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::autofill::mojom::PasswordManagerDriver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPasswordManagerDriverValidationInfo);
}

const char PasswordGenerationDriver::Name_[] = "autofill.mojom.PasswordGenerationDriver";

PasswordGenerationDriver::IPCStableHashFunction PasswordGenerationDriver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PasswordGenerationDriver>(message.name())) {
    case messages::PasswordGenerationDriver::kAutomaticGenerationAvailable: {
      return &PasswordGenerationDriver::AutomaticGenerationAvailable_Sym::IPCStableHash;
    }
    case messages::PasswordGenerationDriver::kShowPasswordEditingPopup: {
      return &PasswordGenerationDriver::ShowPasswordEditingPopup_Sym::IPCStableHash;
    }
    case messages::PasswordGenerationDriver::kPasswordGenerationRejectedByTyping: {
      return &PasswordGenerationDriver::PasswordGenerationRejectedByTyping_Sym::IPCStableHash;
    }
    case messages::PasswordGenerationDriver::kPresaveGeneratedPassword: {
      return &PasswordGenerationDriver::PresaveGeneratedPassword_Sym::IPCStableHash;
    }
    case messages::PasswordGenerationDriver::kPasswordNoLongerGenerated: {
      return &PasswordGenerationDriver::PasswordNoLongerGenerated_Sym::IPCStableHash;
    }
    case messages::PasswordGenerationDriver::kFrameWasScrolled: {
      return &PasswordGenerationDriver::FrameWasScrolled_Sym::IPCStableHash;
    }
    case messages::PasswordGenerationDriver::kGenerationElementLostFocus: {
      return &PasswordGenerationDriver::GenerationElementLostFocus_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PasswordGenerationDriver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PasswordGenerationDriver>(message.name())) {
      case messages::PasswordGenerationDriver::kAutomaticGenerationAvailable:
            return "Receive autofill::mojom::PasswordGenerationDriver::AutomaticGenerationAvailable";
      case messages::PasswordGenerationDriver::kShowPasswordEditingPopup:
            return "Receive autofill::mojom::PasswordGenerationDriver::ShowPasswordEditingPopup";
      case messages::PasswordGenerationDriver::kPasswordGenerationRejectedByTyping:
            return "Receive autofill::mojom::PasswordGenerationDriver::PasswordGenerationRejectedByTyping";
      case messages::PasswordGenerationDriver::kPresaveGeneratedPassword:
            return "Receive autofill::mojom::PasswordGenerationDriver::PresaveGeneratedPassword";
      case messages::PasswordGenerationDriver::kPasswordNoLongerGenerated:
            return "Receive autofill::mojom::PasswordGenerationDriver::PasswordNoLongerGenerated";
      case messages::PasswordGenerationDriver::kFrameWasScrolled:
            return "Receive autofill::mojom::PasswordGenerationDriver::FrameWasScrolled";
      case messages::PasswordGenerationDriver::kGenerationElementLostFocus:
            return "Receive autofill::mojom::PasswordGenerationDriver::GenerationElementLostFocus";
    }
  } else {
    switch (static_cast<messages::PasswordGenerationDriver>(message.name())) {
      case messages::PasswordGenerationDriver::kAutomaticGenerationAvailable:
            return "Receive reply autofill::mojom::PasswordGenerationDriver::AutomaticGenerationAvailable";
      case messages::PasswordGenerationDriver::kShowPasswordEditingPopup:
            return "Receive reply autofill::mojom::PasswordGenerationDriver::ShowPasswordEditingPopup";
      case messages::PasswordGenerationDriver::kPasswordGenerationRejectedByTyping:
            return "Receive reply autofill::mojom::PasswordGenerationDriver::PasswordGenerationRejectedByTyping";
      case messages::PasswordGenerationDriver::kPresaveGeneratedPassword:
            return "Receive reply autofill::mojom::PasswordGenerationDriver::PresaveGeneratedPassword";
      case messages::PasswordGenerationDriver::kPasswordNoLongerGenerated:
            return "Receive reply autofill::mojom::PasswordGenerationDriver::PasswordNoLongerGenerated";
      case messages::PasswordGenerationDriver::kFrameWasScrolled:
            return "Receive reply autofill::mojom::PasswordGenerationDriver::FrameWasScrolled";
      case messages::PasswordGenerationDriver::kGenerationElementLostFocus:
            return "Receive reply autofill::mojom::PasswordGenerationDriver::GenerationElementLostFocus";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PasswordGenerationDriver::AutomaticGenerationAvailable_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordGenerationDriver::AutomaticGenerationAvailable");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordGenerationDriver::ShowPasswordEditingPopup_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordGenerationDriver::ShowPasswordEditingPopup");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordGenerationDriver::PasswordGenerationRejectedByTyping_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordGenerationDriver::PasswordGenerationRejectedByTyping");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordGenerationDriver::PresaveGeneratedPassword_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordGenerationDriver::PresaveGeneratedPassword");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordGenerationDriver::PasswordNoLongerGenerated_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordGenerationDriver::PasswordNoLongerGenerated");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordGenerationDriver::FrameWasScrolled_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordGenerationDriver::FrameWasScrolled");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PasswordGenerationDriver::GenerationElementLostFocus_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)autofill::mojom::PasswordGenerationDriver::GenerationElementLostFocus");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PasswordGenerationDriverProxy::PasswordGenerationDriverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PasswordGenerationDriverProxy::AutomaticGenerationAvailable(
    const ::autofill::password_generation::PasswordGenerationUIData& in_password_generation_ui_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordGenerationDriver::AutomaticGenerationAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password_generation_ui_data"), in_password_generation_ui_data,
                        "<value of type const ::autofill::password_generation::PasswordGenerationUIData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordGenerationDriver::kAutomaticGenerationAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordGenerationDriver_AutomaticGenerationAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->password_generation_ui_data)::BaseType> password_generation_ui_data_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::PasswordGenerationUIDataDataView>(
      in_password_generation_ui_data, password_generation_ui_data_fragment);
  params->password_generation_ui_data.Set(
      password_generation_ui_data_fragment.is_null() ? nullptr : password_generation_ui_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->password_generation_ui_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null password_generation_ui_data in PasswordGenerationDriver.AutomaticGenerationAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordGenerationDriver::Name_);
  message.set_method_name("AutomaticGenerationAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordGenerationDriverProxy::ShowPasswordEditingPopup(
    const ::gfx::RectF& in_bounds, const ::autofill::FormData& in_form_data, ::autofill::FieldRendererId in_field_renderer_id, const ::std::u16string& in_password_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordGenerationDriver::ShowPasswordEditingPopup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::RectF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form_data"), in_form_data,
                        "<value of type const ::autofill::FormData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("field_renderer_id"), in_field_renderer_id,
                        "<value of type ::autofill::FieldRendererId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password_value"), in_password_value,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordGenerationDriver::kShowPasswordEditingPopup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordGenerationDriver_ShowPasswordEditingPopup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_bounds, bounds_fragment);
  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in PasswordGenerationDriver.ShowPasswordEditingPopup request");
  mojo::internal::MessageFragment<
      typename decltype(params->form_data)::BaseType> form_data_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form_data, form_data_fragment);
  params->form_data.Set(
      form_data_fragment.is_null() ? nullptr : form_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_data in PasswordGenerationDriver.ShowPasswordEditingPopup request");
  mojo::internal::MessageFragment<
      typename decltype(params->field_renderer_id)::BaseType> field_renderer_id_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView>(
      in_field_renderer_id, field_renderer_id_fragment);
  params->field_renderer_id.Set(
      field_renderer_id_fragment.is_null() ? nullptr : field_renderer_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->field_renderer_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null field_renderer_id in PasswordGenerationDriver.ShowPasswordEditingPopup request");
  mojo::internal::MessageFragment<
      typename decltype(params->password_value)::BaseType> password_value_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_password_value, password_value_fragment);
  params->password_value.Set(
      password_value_fragment.is_null() ? nullptr : password_value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->password_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null password_value in PasswordGenerationDriver.ShowPasswordEditingPopup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordGenerationDriver::Name_);
  message.set_method_name("ShowPasswordEditingPopup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordGenerationDriverProxy::PasswordGenerationRejectedByTyping(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::PasswordGenerationDriver::PasswordGenerationRejectedByTyping");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordGenerationDriver::kPasswordGenerationRejectedByTyping), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordGenerationDriver_PasswordGenerationRejectedByTyping_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordGenerationDriver::Name_);
  message.set_method_name("PasswordGenerationRejectedByTyping");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordGenerationDriverProxy::PresaveGeneratedPassword(
    const ::autofill::FormData& in_form_data, const ::std::u16string& in_password_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordGenerationDriver::PresaveGeneratedPassword", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form_data"), in_form_data,
                        "<value of type const ::autofill::FormData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password_value"), in_password_value,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordGenerationDriver::kPresaveGeneratedPassword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordGenerationDriver_PresaveGeneratedPassword_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form_data)::BaseType> form_data_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form_data, form_data_fragment);
  params->form_data.Set(
      form_data_fragment.is_null() ? nullptr : form_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_data in PasswordGenerationDriver.PresaveGeneratedPassword request");
  mojo::internal::MessageFragment<
      typename decltype(params->password_value)::BaseType> password_value_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_password_value, password_value_fragment);
  params->password_value.Set(
      password_value_fragment.is_null() ? nullptr : password_value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->password_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null password_value in PasswordGenerationDriver.PresaveGeneratedPassword request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordGenerationDriver::Name_);
  message.set_method_name("PresaveGeneratedPassword");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordGenerationDriverProxy::PasswordNoLongerGenerated(
    const ::autofill::FormData& in_form_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send autofill::mojom::PasswordGenerationDriver::PasswordNoLongerGenerated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form_data"), in_form_data,
                        "<value of type const ::autofill::FormData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordGenerationDriver::kPasswordNoLongerGenerated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordGenerationDriver_PasswordNoLongerGenerated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form_data)::BaseType> form_data_fragment(
          params.message());
  mojo::internal::Serialize<::autofill::mojom::FormDataDataView>(
      in_form_data, form_data_fragment);
  params->form_data.Set(
      form_data_fragment.is_null() ? nullptr : form_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->form_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_data in PasswordGenerationDriver.PasswordNoLongerGenerated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordGenerationDriver::Name_);
  message.set_method_name("PasswordNoLongerGenerated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordGenerationDriverProxy::FrameWasScrolled(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::PasswordGenerationDriver::FrameWasScrolled");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordGenerationDriver::kFrameWasScrolled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordGenerationDriver_FrameWasScrolled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordGenerationDriver::Name_);
  message.set_method_name("FrameWasScrolled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PasswordGenerationDriverProxy::GenerationElementLostFocus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send autofill::mojom::PasswordGenerationDriver::GenerationElementLostFocus");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PasswordGenerationDriver::kGenerationElementLostFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::autofill::mojom::internal::PasswordGenerationDriver_GenerationElementLostFocus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PasswordGenerationDriver::Name_);
  message.set_method_name("GenerationElementLostFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PasswordGenerationDriverStubDispatch::Accept(
    PasswordGenerationDriver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PasswordGenerationDriver>(message->header()->name)) {
    case messages::PasswordGenerationDriver::kAutomaticGenerationAvailable: {
      DCHECK(message->is_serialized());
      internal::PasswordGenerationDriver_AutomaticGenerationAvailable_Params_Data* params =
          reinterpret_cast<internal::PasswordGenerationDriver_AutomaticGenerationAvailable_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordGenerationDriver.0
      bool success = true;
      ::autofill::password_generation::PasswordGenerationUIData p_password_generation_ui_data{};
      PasswordGenerationDriver_AutomaticGenerationAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPasswordGenerationUiData(&p_password_generation_ui_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordGenerationDriver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AutomaticGenerationAvailable(        
        std::move(p_password_generation_ui_data));
      return true;
    }
    case messages::PasswordGenerationDriver::kShowPasswordEditingPopup: {
      DCHECK(message->is_serialized());
      internal::PasswordGenerationDriver_ShowPasswordEditingPopup_Params_Data* params =
          reinterpret_cast<internal::PasswordGenerationDriver_ShowPasswordEditingPopup_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordGenerationDriver.1
      bool success = true;
      ::gfx::RectF p_bounds{};
      ::autofill::FormData p_form_data{};
      ::autofill::FieldRendererId p_field_renderer_id{};
      ::std::u16string p_password_value{};
      PasswordGenerationDriver_ShowPasswordEditingPopup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (success && !input_data_view.ReadFormData(&p_form_data))
        success = false;
      if (success && !input_data_view.ReadFieldRendererId(&p_field_renderer_id))
        success = false;
      if (success && !input_data_view.ReadPasswordValue(&p_password_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordGenerationDriver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowPasswordEditingPopup(        
        std::move(p_bounds), 
        std::move(p_form_data), 
        std::move(p_field_renderer_id), 
        std::move(p_password_value));
      return true;
    }
    case messages::PasswordGenerationDriver::kPasswordGenerationRejectedByTyping: {
      DCHECK(message->is_serialized());
      internal::PasswordGenerationDriver_PasswordGenerationRejectedByTyping_Params_Data* params =
          reinterpret_cast<internal::PasswordGenerationDriver_PasswordGenerationRejectedByTyping_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordGenerationDriver.2
      bool success = true;
      PasswordGenerationDriver_PasswordGenerationRejectedByTyping_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordGenerationDriver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PasswordGenerationRejectedByTyping(        );
      return true;
    }
    case messages::PasswordGenerationDriver::kPresaveGeneratedPassword: {
      DCHECK(message->is_serialized());
      internal::PasswordGenerationDriver_PresaveGeneratedPassword_Params_Data* params =
          reinterpret_cast<internal::PasswordGenerationDriver_PresaveGeneratedPassword_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordGenerationDriver.3
      bool success = true;
      ::autofill::FormData p_form_data{};
      ::std::u16string p_password_value{};
      PasswordGenerationDriver_PresaveGeneratedPassword_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormData(&p_form_data))
        success = false;
      if (success && !input_data_view.ReadPasswordValue(&p_password_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordGenerationDriver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PresaveGeneratedPassword(        
        std::move(p_form_data), 
        std::move(p_password_value));
      return true;
    }
    case messages::PasswordGenerationDriver::kPasswordNoLongerGenerated: {
      DCHECK(message->is_serialized());
      internal::PasswordGenerationDriver_PasswordNoLongerGenerated_Params_Data* params =
          reinterpret_cast<internal::PasswordGenerationDriver_PasswordNoLongerGenerated_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordGenerationDriver.4
      bool success = true;
      ::autofill::FormData p_form_data{};
      PasswordGenerationDriver_PasswordNoLongerGenerated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormData(&p_form_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordGenerationDriver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PasswordNoLongerGenerated(        
        std::move(p_form_data));
      return true;
    }
    case messages::PasswordGenerationDriver::kFrameWasScrolled: {
      DCHECK(message->is_serialized());
      internal::PasswordGenerationDriver_FrameWasScrolled_Params_Data* params =
          reinterpret_cast<internal::PasswordGenerationDriver_FrameWasScrolled_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordGenerationDriver.5
      bool success = true;
      PasswordGenerationDriver_FrameWasScrolled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordGenerationDriver::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FrameWasScrolled(        );
      return true;
    }
    case messages::PasswordGenerationDriver::kGenerationElementLostFocus: {
      DCHECK(message->is_serialized());
      internal::PasswordGenerationDriver_GenerationElementLostFocus_Params_Data* params =
          reinterpret_cast<internal::PasswordGenerationDriver_GenerationElementLostFocus_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PasswordGenerationDriver.6
      bool success = true;
      PasswordGenerationDriver_GenerationElementLostFocus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PasswordGenerationDriver::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GenerationElementLostFocus(        );
      return true;
    }
  }
  return false;
}

// static
bool PasswordGenerationDriverStubDispatch::AcceptWithResponder(
    PasswordGenerationDriver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PasswordGenerationDriver>(message->header()->name)) {
    case messages::PasswordGenerationDriver::kAutomaticGenerationAvailable: {
      break;
    }
    case messages::PasswordGenerationDriver::kShowPasswordEditingPopup: {
      break;
    }
    case messages::PasswordGenerationDriver::kPasswordGenerationRejectedByTyping: {
      break;
    }
    case messages::PasswordGenerationDriver::kPresaveGeneratedPassword: {
      break;
    }
    case messages::PasswordGenerationDriver::kPasswordNoLongerGenerated: {
      break;
    }
    case messages::PasswordGenerationDriver::kFrameWasScrolled: {
      break;
    }
    case messages::PasswordGenerationDriver::kGenerationElementLostFocus: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPasswordGenerationDriverValidationInfo[] = {
    {base::to_underlying(messages::PasswordGenerationDriver::kAutomaticGenerationAvailable),
     { &internal::PasswordGenerationDriver_AutomaticGenerationAvailable_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordGenerationDriver::kShowPasswordEditingPopup),
     { &internal::PasswordGenerationDriver_ShowPasswordEditingPopup_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordGenerationDriver::kPasswordGenerationRejectedByTyping),
     { &internal::PasswordGenerationDriver_PasswordGenerationRejectedByTyping_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordGenerationDriver::kPresaveGeneratedPassword),
     { &internal::PasswordGenerationDriver_PresaveGeneratedPassword_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordGenerationDriver::kPasswordNoLongerGenerated),
     { &internal::PasswordGenerationDriver_PasswordNoLongerGenerated_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordGenerationDriver::kFrameWasScrolled),
     { &internal::PasswordGenerationDriver_FrameWasScrolled_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PasswordGenerationDriver::kGenerationElementLostFocus),
     { &internal::PasswordGenerationDriver_GenerationElementLostFocus_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PasswordGenerationDriverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::autofill::mojom::PasswordGenerationDriver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPasswordGenerationDriverValidationInfo);
}



}  // autofill::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace autofill::mojom {


void AutofillDriverInterceptorForTesting::FormsSeen(const std::vector<::autofill::FormData>& updated_forms, const std::vector<::autofill::FormRendererId>& removed_forms) {
  GetForwardingInterface()->FormsSeen(
    std::move(updated_forms)
    , 
    std::move(removed_forms)
    );
}
void AutofillDriverInterceptorForTesting::FormSubmitted(const ::autofill::FormData& form, ::autofill::mojom::SubmissionSource source) {
  GetForwardingInterface()->FormSubmitted(
    std::move(form)
    , 
    std::move(source)
    );
}
void AutofillDriverInterceptorForTesting::CaretMovedInFormField(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, const ::gfx::Rect& caret_bounds) {
  GetForwardingInterface()->CaretMovedInFormField(
    std::move(form)
    , 
    std::move(field_id)
    , 
    std::move(caret_bounds)
    );
}
void AutofillDriverInterceptorForTesting::TextFieldValueChanged(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, ::base::TimeTicks timestamp) {
  GetForwardingInterface()->TextFieldValueChanged(
    std::move(form)
    , 
    std::move(field_id)
    , 
    std::move(timestamp)
    );
}
void AutofillDriverInterceptorForTesting::DidEndTextFieldEditing() {
  GetForwardingInterface()->DidEndTextFieldEditing();
}
void AutofillDriverInterceptorForTesting::TextFieldDidScroll(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id) {
  GetForwardingInterface()->TextFieldDidScroll(
    std::move(form)
    , 
    std::move(field_id)
    );
}
void AutofillDriverInterceptorForTesting::SelectControlSelectionChanged(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id) {
  GetForwardingInterface()->SelectControlSelectionChanged(
    std::move(form)
    , 
    std::move(field_id)
    );
}
void AutofillDriverInterceptorForTesting::SelectFieldOptionsDidChange(const ::autofill::FormData& form) {
  GetForwardingInterface()->SelectFieldOptionsDidChange(
    std::move(form)
    );
}
void AutofillDriverInterceptorForTesting::FocusOnFormField(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id) {
  GetForwardingInterface()->FocusOnFormField(
    std::move(form)
    , 
    std::move(field_id)
    );
}
void AutofillDriverInterceptorForTesting::FocusOnNonFormField() {
  GetForwardingInterface()->FocusOnNonFormField();
}
void AutofillDriverInterceptorForTesting::AskForValuesToFill(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, const ::gfx::Rect& caret_bounds, ::autofill::mojom::AutofillSuggestionTriggerSource trigger_source) {
  GetForwardingInterface()->AskForValuesToFill(
    std::move(form)
    , 
    std::move(field_id)
    , 
    std::move(caret_bounds)
    , 
    std::move(trigger_source)
    );
}
void AutofillDriverInterceptorForTesting::HidePopup() {
  GetForwardingInterface()->HidePopup();
}
void AutofillDriverInterceptorForTesting::DidFillAutofillFormData(const ::autofill::FormData& form, ::base::TimeTicks timestamp) {
  GetForwardingInterface()->DidFillAutofillFormData(
    std::move(form)
    , 
    std::move(timestamp)
    );
}
void AutofillDriverInterceptorForTesting::JavaScriptChangedAutofilledValue(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, const ::std::u16string& old_value, bool formatting_only) {
  GetForwardingInterface()->JavaScriptChangedAutofilledValue(
    std::move(form)
    , 
    std::move(field_id)
    , 
    std::move(old_value)
    , 
    std::move(formatting_only)
    );
}
AutofillDriverAsyncWaiter::AutofillDriverAsyncWaiter(
    AutofillDriver* proxy) : proxy_(proxy) {}

AutofillDriverAsyncWaiter::~AutofillDriverAsyncWaiter() = default;




void PasswordManagerDriverInterceptorForTesting::PasswordFormsParsed(const std::vector<::autofill::FormData>& forms_data) {
  GetForwardingInterface()->PasswordFormsParsed(
    std::move(forms_data)
    );
}
void PasswordManagerDriverInterceptorForTesting::PasswordFormsRendered(const std::vector<::autofill::FormData>& visible_forms_data) {
  GetForwardingInterface()->PasswordFormsRendered(
    std::move(visible_forms_data)
    );
}
void PasswordManagerDriverInterceptorForTesting::PasswordFormSubmitted(const ::autofill::FormData& form_data) {
  GetForwardingInterface()->PasswordFormSubmitted(
    std::move(form_data)
    );
}
void PasswordManagerDriverInterceptorForTesting::InformAboutUserInput(const ::autofill::FormData& form_data) {
  GetForwardingInterface()->InformAboutUserInput(
    std::move(form_data)
    );
}
void PasswordManagerDriverInterceptorForTesting::DynamicFormSubmission(::autofill::mojom::SubmissionIndicatorEvent submission_indication_event) {
  GetForwardingInterface()->DynamicFormSubmission(
    std::move(submission_indication_event)
    );
}
void PasswordManagerDriverInterceptorForTesting::PasswordFormCleared(const ::autofill::FormData& form_data) {
  GetForwardingInterface()->PasswordFormCleared(
    std::move(form_data)
    );
}
void PasswordManagerDriverInterceptorForTesting::RecordSavePasswordProgress(const std::string& log) {
  GetForwardingInterface()->RecordSavePasswordProgress(
    std::move(log)
    );
}
void PasswordManagerDriverInterceptorForTesting::UserModifiedPasswordField() {
  GetForwardingInterface()->UserModifiedPasswordField();
}
void PasswordManagerDriverInterceptorForTesting::UserModifiedNonPasswordField(::autofill::FieldRendererId renderer_id, const ::std::u16string& value, bool autocomplete_attribute_has_username, bool is_likely_otp) {
  GetForwardingInterface()->UserModifiedNonPasswordField(
    std::move(renderer_id)
    , 
    std::move(value)
    , 
    std::move(autocomplete_attribute_has_username)
    , 
    std::move(is_likely_otp)
    );
}
void PasswordManagerDriverInterceptorForTesting::ShowPasswordSuggestions(const ::autofill::PasswordSuggestionRequest& request) {
  GetForwardingInterface()->ShowPasswordSuggestions(
    std::move(request)
    );
}
void PasswordManagerDriverInterceptorForTesting::CheckSafeBrowsingReputation(const ::GURL& form_action, const ::GURL& frame_url) {
  GetForwardingInterface()->CheckSafeBrowsingReputation(
    std::move(form_action)
    , 
    std::move(frame_url)
    );
}
void PasswordManagerDriverInterceptorForTesting::FocusedInputChanged(::autofill::FieldRendererId focused_field_id, ::autofill::mojom::FocusedFieldType focused_field_type) {
  GetForwardingInterface()->FocusedInputChanged(
    std::move(focused_field_id)
    , 
    std::move(focused_field_type)
    );
}
void PasswordManagerDriverInterceptorForTesting::LogFirstFillingResult(::autofill::FormRendererId form_renderer_id, int32_t result) {
  GetForwardingInterface()->LogFirstFillingResult(
    std::move(form_renderer_id)
    , 
    std::move(result)
    );
}
PasswordManagerDriverAsyncWaiter::PasswordManagerDriverAsyncWaiter(
    PasswordManagerDriver* proxy) : proxy_(proxy) {}

PasswordManagerDriverAsyncWaiter::~PasswordManagerDriverAsyncWaiter() = default;




void PasswordGenerationDriverInterceptorForTesting::AutomaticGenerationAvailable(const ::autofill::password_generation::PasswordGenerationUIData& password_generation_ui_data) {
  GetForwardingInterface()->AutomaticGenerationAvailable(
    std::move(password_generation_ui_data)
    );
}
void PasswordGenerationDriverInterceptorForTesting::ShowPasswordEditingPopup(const ::gfx::RectF& bounds, const ::autofill::FormData& form_data, ::autofill::FieldRendererId field_renderer_id, const ::std::u16string& password_value) {
  GetForwardingInterface()->ShowPasswordEditingPopup(
    std::move(bounds)
    , 
    std::move(form_data)
    , 
    std::move(field_renderer_id)
    , 
    std::move(password_value)
    );
}
void PasswordGenerationDriverInterceptorForTesting::PasswordGenerationRejectedByTyping() {
  GetForwardingInterface()->PasswordGenerationRejectedByTyping();
}
void PasswordGenerationDriverInterceptorForTesting::PresaveGeneratedPassword(const ::autofill::FormData& form_data, const ::std::u16string& password_value) {
  GetForwardingInterface()->PresaveGeneratedPassword(
    std::move(form_data)
    , 
    std::move(password_value)
    );
}
void PasswordGenerationDriverInterceptorForTesting::PasswordNoLongerGenerated(const ::autofill::FormData& form_data) {
  GetForwardingInterface()->PasswordNoLongerGenerated(
    std::move(form_data)
    );
}
void PasswordGenerationDriverInterceptorForTesting::FrameWasScrolled() {
  GetForwardingInterface()->FrameWasScrolled();
}
void PasswordGenerationDriverInterceptorForTesting::GenerationElementLostFocus() {
  GetForwardingInterface()->GenerationElementLostFocus();
}
PasswordGenerationDriverAsyncWaiter::PasswordGenerationDriverAsyncWaiter(
    PasswordGenerationDriver* proxy) : proxy_(proxy) {}

PasswordGenerationDriverAsyncWaiter::~PasswordGenerationDriverAsyncWaiter() = default;






}  // autofill::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif