// content/common/associated_interfaces.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_ASSOCIATED_INTERFACES_MOJOM_H_
#define CONTENT_COMMON_ASSOCIATED_INTERFACES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/associated_interfaces.mojom-features.h"  // IWYU pragma: export
#include "content/common/associated_interfaces.mojom-shared.h"  // IWYU pragma: export
#include "content/common/associated_interfaces.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/associated_interfaces/associated_interfaces.mojom-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace content::mojom {

class RouteProviderProxy;

template <typename ImplRefTraits>
class RouteProviderStub;

class RouteProviderRequestValidator;


class CONTENT_EXPORT RouteProvider
    : public RouteProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RouteProviderInterfaceBase;
  using Proxy_ = RouteProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = RouteProviderStub<ImplRefTraits>;

  using RequestValidator_ = RouteProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kGetRouteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetRoute_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RouteProvider() = default;

  
  virtual void GetRoute(const ::blink::LocalFrameToken& frame_token, ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> receiver) = 0;
};



class CONTENT_EXPORT RouteProviderProxy
    : public RouteProvider {
 public:
  using InterfaceType = RouteProvider;

  explicit RouteProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetRoute(const ::blink::LocalFrameToken& frame_token, ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT RouteProviderStubDispatch {
 public:
  static bool Accept(RouteProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RouteProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RouteProvider>>
class RouteProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RouteProviderStub() = default;
  ~RouteProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RouteProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RouteProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT RouteProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // content::mojom

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_ASSOCIATED_INTERFACES_MOJOM_H_