// content/common/pepper_plugin.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_PEPPER_PLUGIN_MOJOM_H_
#define CONTENT_COMMON_PEPPER_PLUGIN_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/pepper_plugin.mojom-features.h"  // IWYU pragma: export
#include "content/common/pepper_plugin.mojom-shared.h"  // IWYU pragma: export
#include "content/common/pepper_plugin.mojom-forward.h"  // IWYU pragma: export
#include "content/public/common/webplugininfo.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/process_id.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace content::mojom {

class PepperHostProxy;

template <typename ImplRefTraits>
class PepperHostStub;

class PepperHostRequestValidator;
class PepperHostResponseValidator;


class CONTENT_EXPORT PepperHost
    : public PepperHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    140265437, 
    458238197, 
    832909343
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PepperHostInterfaceBase;
  using Proxy_ = PepperHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PepperHostStub<ImplRefTraits>;

  using RequestValidator_ = PepperHostRequestValidator;
  using ResponseValidator_ = PepperHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInstanceCreatedMinVersion = 0,
    kBindHungDetectorHostMinVersion = 0,
    kGetPluginInfoMinVersion = 0,
    kDidCreateInProcessInstanceMinVersion = 0,
    kDidDeleteInProcessInstanceMinVersion = 0,
    kDidCreateOutOfProcessPepperInstanceMinVersion = 0,
    kDidDeleteOutOfProcessPepperInstanceMinVersion = 0,
    kOpenChannelToPepperPluginMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct InstanceCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindHungDetectorHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPluginInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidCreateInProcessInstance_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidDeleteInProcessInstance_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidCreateOutOfProcessPepperInstance_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidDeleteOutOfProcessPepperInstance_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenChannelToPepperPlugin_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PepperHost() = default;

  
  virtual void InstanceCreated(int32_t instance_id, ::mojo::PendingAssociatedRemote<PepperPluginInstance> instance, ::mojo::PendingAssociatedReceiver<PepperPluginInstanceHost> host) = 0;

  
  virtual void BindHungDetectorHost(::mojo::PendingReceiver<PepperHungDetectorHost> host, int32_t plugin_child_id, const ::base::FilePath& plugin_path) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetPluginInfo(const ::GURL& url, const std::string& mime_type, bool* out_found, ::content::WebPluginInfo* out_plugin_info, std::string* out_actual_mime_type);

  using GetPluginInfoCallback = base::OnceCallback<void(bool, const ::content::WebPluginInfo&, const std::string&)>;
  
  virtual void GetPluginInfo(const ::GURL& url, const std::string& mime_type, GetPluginInfoCallback callback) = 0;

  
  virtual void DidCreateInProcessInstance(int32_t instance_id, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url) = 0;

  
  virtual void DidDeleteInProcessInstance(int32_t instance_id) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DidCreateOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url, bool is_privileged_context);

  using DidCreateOutOfProcessPepperInstanceCallback = base::OnceCallback<void()>;
  
  virtual void DidCreateOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url, bool is_privileged_context, DidCreateOutOfProcessPepperInstanceCallback callback) = 0;

  
  virtual void DidDeleteOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool OpenChannelToPepperPlugin(const ::url::Origin& embedder_origin, const ::base::FilePath& path, const std::optional<::url::Origin>& origin_lock, ::mojo::ScopedMessagePipeHandle* out_handle_to_channel, ::base::ProcessId* out_plugin_pid, int32_t* out_plugin_child_id);

  using OpenChannelToPepperPluginCallback = base::OnceCallback<void(::mojo::ScopedMessagePipeHandle, ::base::ProcessId, int32_t)>;
  
  virtual void OpenChannelToPepperPlugin(const ::url::Origin& embedder_origin, const ::base::FilePath& path, const std::optional<::url::Origin>& origin_lock, OpenChannelToPepperPluginCallback callback) = 0;
};

class PepperHungDetectorHostProxy;

template <typename ImplRefTraits>
class PepperHungDetectorHostStub;

class PepperHungDetectorHostRequestValidator;


class CONTENT_EXPORT PepperHungDetectorHost
    : public PepperHungDetectorHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PepperHungDetectorHostInterfaceBase;
  using Proxy_ = PepperHungDetectorHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PepperHungDetectorHostStub<ImplRefTraits>;

  using RequestValidator_ = PepperHungDetectorHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kPluginHungMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PluginHung_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PepperHungDetectorHost() = default;

  
  virtual void PluginHung(bool is_hung) = 0;
};

class PepperPluginInstanceHostProxy;

template <typename ImplRefTraits>
class PepperPluginInstanceHostStub;

class PepperPluginInstanceHostRequestValidator;


class CONTENT_EXPORT PepperPluginInstanceHost
    : public PepperPluginInstanceHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PepperPluginInstanceHostInterfaceBase;
  using Proxy_ = PepperPluginInstanceHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PepperPluginInstanceHostStub<ImplRefTraits>;

  using RequestValidator_ = PepperPluginInstanceHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartsPlaybackMinVersion = 0,
    kStopsPlaybackMinVersion = 0,
    kInstanceCrashedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartsPlayback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopsPlayback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InstanceCrashed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PepperPluginInstanceHost() = default;

  
  virtual void StartsPlayback() = 0;

  
  virtual void StopsPlayback() = 0;

  
  virtual void InstanceCrashed(const ::base::FilePath& plugin_path, ::base::ProcessId plugin_pid) = 0;
};

class PepperPluginInstanceProxy;

template <typename ImplRefTraits>
class PepperPluginInstanceStub;

class PepperPluginInstanceRequestValidator;


class CONTENT_EXPORT PepperPluginInstance
    : public PepperPluginInstanceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PepperPluginInstanceInterfaceBase;
  using Proxy_ = PepperPluginInstanceProxy;

  template <typename ImplRefTraits>
  using Stub_ = PepperPluginInstanceStub<ImplRefTraits>;

  using RequestValidator_ = PepperPluginInstanceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetVolumeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetVolume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PepperPluginInstance() = default;

  
  virtual void SetVolume(double volume) = 0;
};



class CONTENT_EXPORT PepperHostProxy
    : public PepperHost {
 public:
  using InterfaceType = PepperHost;

  explicit PepperHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void InstanceCreated(int32_t instance_id, ::mojo::PendingAssociatedRemote<PepperPluginInstance> instance, ::mojo::PendingAssociatedReceiver<PepperPluginInstanceHost> host) final;
  
  void BindHungDetectorHost(::mojo::PendingReceiver<PepperHungDetectorHost> host, int32_t plugin_child_id, const ::base::FilePath& plugin_path) final;
  
  bool GetPluginInfo(const ::GURL& url, const std::string& mime_type, bool* out_found, ::content::WebPluginInfo* out_plugin_info, std::string* out_actual_mime_type) final;
  
  void GetPluginInfo(const ::GURL& url, const std::string& mime_type, GetPluginInfoCallback callback) final;
  
  void DidCreateInProcessInstance(int32_t instance_id, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url) final;
  
  void DidDeleteInProcessInstance(int32_t instance_id) final;
  
  bool DidCreateOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url, bool is_privileged_context) final;
  
  void DidCreateOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url, bool is_privileged_context, DidCreateOutOfProcessPepperInstanceCallback callback) final;
  
  void DidDeleteOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external) final;
  
  bool OpenChannelToPepperPlugin(const ::url::Origin& embedder_origin, const ::base::FilePath& path, const std::optional<::url::Origin>& origin_lock, ::mojo::ScopedMessagePipeHandle* out_handle_to_channel, ::base::ProcessId* out_plugin_pid, int32_t* out_plugin_child_id) final;
  
  void OpenChannelToPepperPlugin(const ::url::Origin& embedder_origin, const ::base::FilePath& path, const std::optional<::url::Origin>& origin_lock, OpenChannelToPepperPluginCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT PepperHungDetectorHostProxy
    : public PepperHungDetectorHost {
 public:
  using InterfaceType = PepperHungDetectorHost;

  explicit PepperHungDetectorHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PluginHung(bool is_hung) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT PepperPluginInstanceHostProxy
    : public PepperPluginInstanceHost {
 public:
  using InterfaceType = PepperPluginInstanceHost;

  explicit PepperPluginInstanceHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartsPlayback() final;
  
  void StopsPlayback() final;
  
  void InstanceCrashed(const ::base::FilePath& plugin_path, ::base::ProcessId plugin_pid) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT PepperPluginInstanceProxy
    : public PepperPluginInstance {
 public:
  using InterfaceType = PepperPluginInstance;

  explicit PepperPluginInstanceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetVolume(double volume) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT PepperHostStubDispatch {
 public:
  static bool Accept(PepperHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PepperHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PepperHost>>
class PepperHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PepperHostStub() = default;
  ~PepperHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PepperHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PepperHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT PepperHungDetectorHostStubDispatch {
 public:
  static bool Accept(PepperHungDetectorHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PepperHungDetectorHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PepperHungDetectorHost>>
class PepperHungDetectorHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PepperHungDetectorHostStub() = default;
  ~PepperHungDetectorHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PepperHungDetectorHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PepperHungDetectorHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT PepperPluginInstanceHostStubDispatch {
 public:
  static bool Accept(PepperPluginInstanceHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PepperPluginInstanceHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PepperPluginInstanceHost>>
class PepperPluginInstanceHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PepperPluginInstanceHostStub() = default;
  ~PepperPluginInstanceHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PepperPluginInstanceHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PepperPluginInstanceHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT PepperPluginInstanceStubDispatch {
 public:
  static bool Accept(PepperPluginInstance* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PepperPluginInstance* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PepperPluginInstance>>
class PepperPluginInstanceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PepperPluginInstanceStub() = default;
  ~PepperPluginInstanceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PepperPluginInstanceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PepperPluginInstanceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT PepperHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT PepperHungDetectorHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT PepperPluginInstanceHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT PepperPluginInstanceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT PepperHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // content::mojom

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_PEPPER_PLUGIN_MOJOM_H_