// device/vr/public/mojom/xr_hand_tracking_data.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* XRHandJointToStringHelper(XRHandJoint value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRHandJoint::kWrist:
      return "kWrist";
    case XRHandJoint::kThumbMetacarpal:
      return "kThumbMetacarpal";
    case XRHandJoint::kThumbPhalanxProximal:
      return "kThumbPhalanxProximal";
    case XRHandJoint::kThumbPhalanxDistal:
      return "kThumbPhalanxDistal";
    case XRHandJoint::kThumbTip:
      return "kThumbTip";
    case XRHandJoint::kIndexFingerMetacarpal:
      return "kIndexFingerMetacarpal";
    case XRHandJoint::kIndexFingerPhalanxProximal:
      return "kIndexFingerPhalanxProximal";
    case XRHandJoint::kIndexFingerPhalanxIntermediate:
      return "kIndexFingerPhalanxIntermediate";
    case XRHandJoint::kIndexFingerPhalanxDistal:
      return "kIndexFingerPhalanxDistal";
    case XRHandJoint::kIndexFingerTip:
      return "kIndexFingerTip";
    case XRHandJoint::kMiddleFingerMetacarpal:
      return "kMiddleFingerMetacarpal";
    case XRHandJoint::kMiddleFingerPhalanxProximal:
      return "kMiddleFingerPhalanxProximal";
    case XRHandJoint::kMiddleFingerPhalanxIntermediate:
      return "kMiddleFingerPhalanxIntermediate";
    case XRHandJoint::kMiddleFingerPhalanxDistal:
      return "kMiddleFingerPhalanxDistal";
    case XRHandJoint::kMiddleFingerTip:
      return "kMiddleFingerTip";
    case XRHandJoint::kRingFingerMetacarpal:
      return "kRingFingerMetacarpal";
    case XRHandJoint::kRingFingerPhalanxProximal:
      return "kRingFingerPhalanxProximal";
    case XRHandJoint::kRingFingerPhalanxIntermediate:
      return "kRingFingerPhalanxIntermediate";
    case XRHandJoint::kRingFingerPhalanxDistal:
      return "kRingFingerPhalanxDistal";
    case XRHandJoint::kRingFingerTip:
      return "kRingFingerTip";
    case XRHandJoint::kPinkyFingerMetacarpal:
      return "kPinkyFingerMetacarpal";
    case XRHandJoint::kPinkyFingerPhalanxProximal:
      return "kPinkyFingerPhalanxProximal";
    case XRHandJoint::kPinkyFingerPhalanxIntermediate:
      return "kPinkyFingerPhalanxIntermediate";
    case XRHandJoint::kPinkyFingerPhalanxDistal:
      return "kPinkyFingerPhalanxDistal";
    case XRHandJoint::kPinkyFingerTip:
      return "kPinkyFingerTip";
    default:
      return nullptr;
  }
}

std::string XRHandJointToString(XRHandJoint value) {
  const char *str = XRHandJointToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRHandJoint value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRHandJoint value) {
  return os << XRHandJointToString(value);
}

namespace internal {


// static
bool XRHandJointData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRHandJointData_Data* object =
      static_cast<const XRHandJointData_Data*>(data);


  if (!::device::mojom::internal::XRHandJoint_Data
        ::Validate(object->joint, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mojo_from_joint, validation_context))
    return false;

  return true;
}

XRHandJointData_Data::XRHandJointData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHandTrackingData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRHandTrackingData_Data* object =
      static_cast<const XRHandTrackingData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hand_joint_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hand_joint_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hand_joint_data, validation_context,
                                         &hand_joint_data_validate_params)) {
    return false;
  }

  return true;
}

XRHandTrackingData_Data::XRHandTrackingData_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRHandJoint>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRHandJoint value) {
  return std::move(context).WriteString(::device::mojom::XRHandJointToString(value));
}

} // namespace perfetto