// extensions/common/mojom/renderer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/renderer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/renderer.mojom-params-data.h"
#include "extensions/common/mojom/renderer.mojom-shared-message-ids.h"

#include "extensions/common/mojom/renderer.mojom-import-headers.h"
#include "extensions/common/mojom/renderer.mojom-test-utils.h"


namespace extensions::mojom {
ExtensionLoadedParams::ExtensionLoadedParams()
    : manifest(),
      location(),
      path(),
      active_permissions(),
      withheld_permissions(),
      tab_specific_permissions(),
      policy_blocked_hosts(),
      policy_allowed_hosts(),
      uses_default_policy_blocked_allowed_hosts(),
      id(),
      worker_activation_token(),
      creation_flags(),
      guid() {}

ExtensionLoadedParams::ExtensionLoadedParams(
    ::base::Value::Dict manifest_in,
    ::extensions::mojom::ManifestLocation location_in,
    const ::base::FilePath& path_in,
    ::extensions::PermissionSet active_permissions_in,
    ::extensions::PermissionSet withheld_permissions_in,
    base::flat_map<int32_t, ::extensions::PermissionSet> tab_specific_permissions_in,
    ::extensions::URLPatternSet policy_blocked_hosts_in,
    ::extensions::URLPatternSet policy_allowed_hosts_in,
    bool uses_default_policy_blocked_allowed_hosts_in,
    const std::string& id_in,
    const std::optional<::base::UnguessableToken>& worker_activation_token_in,
    int32_t creation_flags_in,
    const std::string& guid_in)
    : manifest(std::move(manifest_in)),
      location(std::move(location_in)),
      path(std::move(path_in)),
      active_permissions(std::move(active_permissions_in)),
      withheld_permissions(std::move(withheld_permissions_in)),
      tab_specific_permissions(std::move(tab_specific_permissions_in)),
      policy_blocked_hosts(std::move(policy_blocked_hosts_in)),
      policy_allowed_hosts(std::move(policy_allowed_hosts_in)),
      uses_default_policy_blocked_allowed_hosts(std::move(uses_default_policy_blocked_allowed_hosts_in)),
      id(std::move(id_in)),
      worker_activation_token(std::move(worker_activation_token_in)),
      creation_flags(std::move(creation_flags_in)),
      guid(std::move(guid_in)) {}

ExtensionLoadedParams::~ExtensionLoadedParams() = default;

void ExtensionLoadedParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manifest"), this->manifest,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value::Dict>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location"), this->location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::ManifestLocation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_permissions"), this->active_permissions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::PermissionSet>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "withheld_permissions"), this->withheld_permissions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::PermissionSet>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_specific_permissions"), this->tab_specific_permissions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<int32_t, ::extensions::PermissionSet>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_blocked_hosts"), this->policy_blocked_hosts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::URLPatternSet>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_allowed_hosts"), this->policy_allowed_hosts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::URLPatternSet>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uses_default_policy_blocked_allowed_hosts"), this->uses_default_policy_blocked_allowed_hosts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "worker_activation_token"), this->worker_activation_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "creation_flags"), this->creation_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "guid"), this->guid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExtensionLoadedParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UserScriptWorldInfo::UserScriptWorldInfo()
    : extension_id(),
      world_id(),
      csp(),
      enable_messaging() {}

UserScriptWorldInfo::UserScriptWorldInfo(
    const std::string& extension_id_in,
    const std::optional<std::string>& world_id_in,
    const std::optional<std::string>& csp_in,
    bool enable_messaging_in)
    : extension_id(std::move(extension_id_in)),
      world_id(std::move(world_id_in)),
      csp(std::move(csp_in)),
      enable_messaging(std::move(enable_messaging_in)) {}

UserScriptWorldInfo::~UserScriptWorldInfo() = default;

void UserScriptWorldInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extension_id"), this->extension_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "world_id"), this->world_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "csp"), this->csp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_messaging"), this->enable_messaging,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UserScriptWorldInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char Renderer::Name_[] = "extensions.mojom.Renderer";

Renderer::IPCStableHashFunction Renderer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Renderer>(message.name())) {
    case messages::Renderer::kActivateExtension: {
      return &Renderer::ActivateExtension_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetActivityLoggingEnabled: {
      return &Renderer::SetActivityLoggingEnabled_Sym::IPCStableHash;
    }
    case messages::Renderer::kLoadExtensions: {
      return &Renderer::LoadExtensions_Sym::IPCStableHash;
    }
    case messages::Renderer::kUnloadExtension: {
      return &Renderer::UnloadExtension_Sym::IPCStableHash;
    }
    case messages::Renderer::kSuspendExtension: {
      return &Renderer::SuspendExtension_Sym::IPCStableHash;
    }
    case messages::Renderer::kCancelSuspendExtension: {
      return &Renderer::CancelSuspendExtension_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetDeveloperMode: {
      return &Renderer::SetDeveloperMode_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetSessionInfo: {
      return &Renderer::SetSessionInfo_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetSystemFont: {
      return &Renderer::SetSystemFont_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetWebViewPartitionID: {
      return &Renderer::SetWebViewPartitionID_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetScriptingAllowlist: {
      return &Renderer::SetScriptingAllowlist_Sym::IPCStableHash;
    }
    case messages::Renderer::kUpdateUserScriptWorlds: {
      return &Renderer::UpdateUserScriptWorlds_Sym::IPCStableHash;
    }
    case messages::Renderer::kClearUserScriptWorldConfig: {
      return &Renderer::ClearUserScriptWorldConfig_Sym::IPCStableHash;
    }
    case messages::Renderer::kShouldSuspend: {
      return &Renderer::ShouldSuspend_Sym::IPCStableHash;
    }
    case messages::Renderer::kTransferBlobs: {
      return &Renderer::TransferBlobs_Sym::IPCStableHash;
    }
    case messages::Renderer::kUpdatePermissions: {
      return &Renderer::UpdatePermissions_Sym::IPCStableHash;
    }
    case messages::Renderer::kUpdateDefaultPolicyHostRestrictions: {
      return &Renderer::UpdateDefaultPolicyHostRestrictions_Sym::IPCStableHash;
    }
    case messages::Renderer::kUpdateUserHostRestrictions: {
      return &Renderer::UpdateUserHostRestrictions_Sym::IPCStableHash;
    }
    case messages::Renderer::kUpdateTabSpecificPermissions: {
      return &Renderer::UpdateTabSpecificPermissions_Sym::IPCStableHash;
    }
    case messages::Renderer::kUpdateUserScripts: {
      return &Renderer::UpdateUserScripts_Sym::IPCStableHash;
    }
    case messages::Renderer::kClearTabSpecificPermissions: {
      return &Renderer::ClearTabSpecificPermissions_Sym::IPCStableHash;
    }
    case messages::Renderer::kWatchPages: {
      return &Renderer::WatchPages_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Renderer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Renderer>(message.name())) {
      case messages::Renderer::kActivateExtension:
            return "Receive extensions::mojom::Renderer::ActivateExtension";
      case messages::Renderer::kSetActivityLoggingEnabled:
            return "Receive extensions::mojom::Renderer::SetActivityLoggingEnabled";
      case messages::Renderer::kLoadExtensions:
            return "Receive extensions::mojom::Renderer::LoadExtensions";
      case messages::Renderer::kUnloadExtension:
            return "Receive extensions::mojom::Renderer::UnloadExtension";
      case messages::Renderer::kSuspendExtension:
            return "Receive extensions::mojom::Renderer::SuspendExtension";
      case messages::Renderer::kCancelSuspendExtension:
            return "Receive extensions::mojom::Renderer::CancelSuspendExtension";
      case messages::Renderer::kSetDeveloperMode:
            return "Receive extensions::mojom::Renderer::SetDeveloperMode";
      case messages::Renderer::kSetSessionInfo:
            return "Receive extensions::mojom::Renderer::SetSessionInfo";
      case messages::Renderer::kSetSystemFont:
            return "Receive extensions::mojom::Renderer::SetSystemFont";
      case messages::Renderer::kSetWebViewPartitionID:
            return "Receive extensions::mojom::Renderer::SetWebViewPartitionID";
      case messages::Renderer::kSetScriptingAllowlist:
            return "Receive extensions::mojom::Renderer::SetScriptingAllowlist";
      case messages::Renderer::kUpdateUserScriptWorlds:
            return "Receive extensions::mojom::Renderer::UpdateUserScriptWorlds";
      case messages::Renderer::kClearUserScriptWorldConfig:
            return "Receive extensions::mojom::Renderer::ClearUserScriptWorldConfig";
      case messages::Renderer::kShouldSuspend:
            return "Receive extensions::mojom::Renderer::ShouldSuspend";
      case messages::Renderer::kTransferBlobs:
            return "Receive extensions::mojom::Renderer::TransferBlobs";
      case messages::Renderer::kUpdatePermissions:
            return "Receive extensions::mojom::Renderer::UpdatePermissions";
      case messages::Renderer::kUpdateDefaultPolicyHostRestrictions:
            return "Receive extensions::mojom::Renderer::UpdateDefaultPolicyHostRestrictions";
      case messages::Renderer::kUpdateUserHostRestrictions:
            return "Receive extensions::mojom::Renderer::UpdateUserHostRestrictions";
      case messages::Renderer::kUpdateTabSpecificPermissions:
            return "Receive extensions::mojom::Renderer::UpdateTabSpecificPermissions";
      case messages::Renderer::kUpdateUserScripts:
            return "Receive extensions::mojom::Renderer::UpdateUserScripts";
      case messages::Renderer::kClearTabSpecificPermissions:
            return "Receive extensions::mojom::Renderer::ClearTabSpecificPermissions";
      case messages::Renderer::kWatchPages:
            return "Receive extensions::mojom::Renderer::WatchPages";
    }
  } else {
    switch (static_cast<messages::Renderer>(message.name())) {
      case messages::Renderer::kActivateExtension:
            return "Receive reply extensions::mojom::Renderer::ActivateExtension";
      case messages::Renderer::kSetActivityLoggingEnabled:
            return "Receive reply extensions::mojom::Renderer::SetActivityLoggingEnabled";
      case messages::Renderer::kLoadExtensions:
            return "Receive reply extensions::mojom::Renderer::LoadExtensions";
      case messages::Renderer::kUnloadExtension:
            return "Receive reply extensions::mojom::Renderer::UnloadExtension";
      case messages::Renderer::kSuspendExtension:
            return "Receive reply extensions::mojom::Renderer::SuspendExtension";
      case messages::Renderer::kCancelSuspendExtension:
            return "Receive reply extensions::mojom::Renderer::CancelSuspendExtension";
      case messages::Renderer::kSetDeveloperMode:
            return "Receive reply extensions::mojom::Renderer::SetDeveloperMode";
      case messages::Renderer::kSetSessionInfo:
            return "Receive reply extensions::mojom::Renderer::SetSessionInfo";
      case messages::Renderer::kSetSystemFont:
            return "Receive reply extensions::mojom::Renderer::SetSystemFont";
      case messages::Renderer::kSetWebViewPartitionID:
            return "Receive reply extensions::mojom::Renderer::SetWebViewPartitionID";
      case messages::Renderer::kSetScriptingAllowlist:
            return "Receive reply extensions::mojom::Renderer::SetScriptingAllowlist";
      case messages::Renderer::kUpdateUserScriptWorlds:
            return "Receive reply extensions::mojom::Renderer::UpdateUserScriptWorlds";
      case messages::Renderer::kClearUserScriptWorldConfig:
            return "Receive reply extensions::mojom::Renderer::ClearUserScriptWorldConfig";
      case messages::Renderer::kShouldSuspend:
            return "Receive reply extensions::mojom::Renderer::ShouldSuspend";
      case messages::Renderer::kTransferBlobs:
            return "Receive reply extensions::mojom::Renderer::TransferBlobs";
      case messages::Renderer::kUpdatePermissions:
            return "Receive reply extensions::mojom::Renderer::UpdatePermissions";
      case messages::Renderer::kUpdateDefaultPolicyHostRestrictions:
            return "Receive reply extensions::mojom::Renderer::UpdateDefaultPolicyHostRestrictions";
      case messages::Renderer::kUpdateUserHostRestrictions:
            return "Receive reply extensions::mojom::Renderer::UpdateUserHostRestrictions";
      case messages::Renderer::kUpdateTabSpecificPermissions:
            return "Receive reply extensions::mojom::Renderer::UpdateTabSpecificPermissions";
      case messages::Renderer::kUpdateUserScripts:
            return "Receive reply extensions::mojom::Renderer::UpdateUserScripts";
      case messages::Renderer::kClearTabSpecificPermissions:
            return "Receive reply extensions::mojom::Renderer::ClearTabSpecificPermissions";
      case messages::Renderer::kWatchPages:
            return "Receive reply extensions::mojom::Renderer::WatchPages";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Renderer::ActivateExtension_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::ActivateExtension");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetActivityLoggingEnabled_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::SetActivityLoggingEnabled");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::LoadExtensions_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::LoadExtensions");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::UnloadExtension_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::UnloadExtension");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SuspendExtension_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::SuspendExtension");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::CancelSuspendExtension_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::CancelSuspendExtension");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetDeveloperMode_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::SetDeveloperMode");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetSessionInfo_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::SetSessionInfo");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetSystemFont_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::SetSystemFont");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetWebViewPartitionID_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::SetWebViewPartitionID");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetScriptingAllowlist_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::SetScriptingAllowlist");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::UpdateUserScriptWorlds_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::UpdateUserScriptWorlds");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::ClearUserScriptWorldConfig_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::ClearUserScriptWorldConfig");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::ShouldSuspend_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::ShouldSuspend");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::TransferBlobs_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::TransferBlobs");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::UpdatePermissions_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::UpdatePermissions");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::UpdateDefaultPolicyHostRestrictions_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::UpdateDefaultPolicyHostRestrictions");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::UpdateUserHostRestrictions_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::UpdateUserHostRestrictions");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::UpdateTabSpecificPermissions_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::UpdateTabSpecificPermissions");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::UpdateUserScripts_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::UpdateUserScripts");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::ClearTabSpecificPermissions_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::ClearTabSpecificPermissions");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::WatchPages_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::Renderer::WatchPages");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Renderer_SuspendExtension_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Renderer_SuspendExtension_ForwardToCallback(
      Renderer::SuspendExtensionCallback callback
      ) : callback_(std::move(callback)) {
  }

  Renderer_SuspendExtension_ForwardToCallback(const Renderer_SuspendExtension_ForwardToCallback&) = delete;
  Renderer_SuspendExtension_ForwardToCallback& operator=(const Renderer_SuspendExtension_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Renderer::SuspendExtensionCallback callback_;
};

class Renderer_ShouldSuspend_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Renderer_ShouldSuspend_ForwardToCallback(
      Renderer::ShouldSuspendCallback callback
      ) : callback_(std::move(callback)) {
  }

  Renderer_ShouldSuspend_ForwardToCallback(const Renderer_ShouldSuspend_ForwardToCallback&) = delete;
  Renderer_ShouldSuspend_ForwardToCallback& operator=(const Renderer_ShouldSuspend_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Renderer::ShouldSuspendCallback callback_;
};

class Renderer_TransferBlobs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Renderer_TransferBlobs_ForwardToCallback(
      Renderer::TransferBlobsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Renderer_TransferBlobs_ForwardToCallback(const Renderer_TransferBlobs_ForwardToCallback&) = delete;
  Renderer_TransferBlobs_ForwardToCallback& operator=(const Renderer_TransferBlobs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Renderer::TransferBlobsCallback callback_;
};

RendererProxy::RendererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererProxy::ActivateExtension(
    const std::string& in_extension_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::ActivateExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kActivateExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_ActivateExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.ActivateExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("ActivateExtension");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetActivityLoggingEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::SetActivityLoggingEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetActivityLoggingEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetActivityLoggingEnabled_Params_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetActivityLoggingEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::LoadExtensions(
    std::vector<ExtensionLoadedParamsPtr> in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::LoadExtensions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type std::vector<ExtensionLoadedParamsPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kLoadExtensions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_LoadExtensions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType>
      params_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::ExtensionLoadedParamsDataView>>(
      in_params, params_fragment, &params_validate_params);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in Renderer.LoadExtensions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("LoadExtensions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::UnloadExtension(
    const std::string& in_extension_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::UnloadExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kUnloadExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UnloadExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.UnloadExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UnloadExtension");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SuspendExtension(
    const std::string& in_extension_id, SuspendExtensionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::SuspendExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSuspendExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SuspendExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.SuspendExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SuspendExtension");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Renderer_SuspendExtension_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RendererProxy::CancelSuspendExtension(
    const std::string& in_extension_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::CancelSuspendExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kCancelSuspendExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_CancelSuspendExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.CancelSuspendExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("CancelSuspendExtension");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetDeveloperMode(
    bool in_developer_mode_only) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::SetDeveloperMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("developer_mode_only"), in_developer_mode_only,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetDeveloperMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetDeveloperMode_Params_Data> params(
          message);
  params.Allocate();
  params->developer_mode_only = in_developer_mode_only;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetDeveloperMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetSessionInfo(
    version_info::Channel in_channel, ::extensions::mojom::FeatureSessionType in_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::SetSessionInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel"), in_channel,
                        "<value of type version_info::Channel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::extensions::mojom::FeatureSessionType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetSessionInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetSessionInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::extensions::mojom::Channel>(
      in_channel, &params->channel);
  mojo::internal::Serialize<::extensions::mojom::FeatureSessionType>(
      in_session, &params->session);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetSessionInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetSystemFont(
    const std::string& in_font_family, const std::string& in_font_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::SetSystemFont", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_family"), in_font_family,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_size"), in_font_size,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetSystemFont), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetSystemFont_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->font_family)::BaseType> font_family_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_font_family, font_family_fragment);
  params->font_family.Set(
      font_family_fragment.is_null() ? nullptr : font_family_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->font_family.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null font_family in Renderer.SetSystemFont request");
  mojo::internal::MessageFragment<
      typename decltype(params->font_size)::BaseType> font_size_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_font_size, font_size_fragment);
  params->font_size.Set(
      font_size_fragment.is_null() ? nullptr : font_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->font_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null font_size in Renderer.SetSystemFont request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetSystemFont");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetWebViewPartitionID(
    const std::string& in_partition_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::SetWebViewPartitionID", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("partition_id"), in_partition_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetWebViewPartitionID), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetWebViewPartitionID_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->partition_id)::BaseType> partition_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_partition_id, partition_id_fragment);
  params->partition_id.Set(
      partition_id_fragment.is_null() ? nullptr : partition_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->partition_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null partition_id in Renderer.SetWebViewPartitionID request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetWebViewPartitionID");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetScriptingAllowlist(
    const std::vector<std::string>& in_extension_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::SetScriptingAllowlist", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_ids"), in_extension_ids,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetScriptingAllowlist), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetScriptingAllowlist_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_ids)::BaseType>
      extension_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& extension_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_extension_ids, extension_ids_fragment, &extension_ids_validate_params);
  params->extension_ids.Set(
      extension_ids_fragment.is_null() ? nullptr : extension_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_ids in Renderer.SetScriptingAllowlist request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetScriptingAllowlist");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::UpdateUserScriptWorlds(
    std::vector<UserScriptWorldInfoPtr> in_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::UpdateUserScriptWorlds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("infos"), in_infos,
                        "<value of type std::vector<UserScriptWorldInfoPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kUpdateUserScriptWorlds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UpdateUserScriptWorlds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->infos)::BaseType>
      infos_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::UserScriptWorldInfoDataView>>(
      in_infos, infos_fragment, &infos_validate_params);
  params->infos.Set(
      infos_fragment.is_null() ? nullptr : infos_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->infos.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null infos in Renderer.UpdateUserScriptWorlds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdateUserScriptWorlds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::ClearUserScriptWorldConfig(
    const std::string& in_extension_id, const std::optional<std::string>& in_world_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::ClearUserScriptWorldConfig", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("world_id"), in_world_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kClearUserScriptWorldConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_ClearUserScriptWorldConfig_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.ClearUserScriptWorldConfig request");
  mojo::internal::MessageFragment<
      typename decltype(params->world_id)::BaseType> world_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_world_id, world_id_fragment);
  params->world_id.Set(
      world_id_fragment.is_null() ? nullptr : world_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("ClearUserScriptWorldConfig");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::ShouldSuspend(
    ShouldSuspendCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send extensions::mojom::Renderer::ShouldSuspend");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kShouldSuspend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_ShouldSuspend_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("ShouldSuspend");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Renderer_ShouldSuspend_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RendererProxy::TransferBlobs(
    TransferBlobsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send extensions::mojom::Renderer::TransferBlobs");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kTransferBlobs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_TransferBlobs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("TransferBlobs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Renderer_TransferBlobs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RendererProxy::UpdatePermissions(
    const std::string& in_extension_id, ::extensions::PermissionSet in_active_permissions, ::extensions::PermissionSet in_withheld_permissions, ::extensions::URLPatternSet in_policy_blocked_hosts, ::extensions::URLPatternSet in_policy_allowed_hosts, bool in_uses_default_policy_host_restrictions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::UpdatePermissions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active_permissions"), in_active_permissions,
                        "<value of type ::extensions::PermissionSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("withheld_permissions"), in_withheld_permissions,
                        "<value of type ::extensions::PermissionSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_blocked_hosts"), in_policy_blocked_hosts,
                        "<value of type ::extensions::URLPatternSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_allowed_hosts"), in_policy_allowed_hosts,
                        "<value of type ::extensions::URLPatternSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uses_default_policy_host_restrictions"), in_uses_default_policy_host_restrictions,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kUpdatePermissions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UpdatePermissions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.UpdatePermissions request");
  mojo::internal::MessageFragment<
      typename decltype(params->active_permissions)::BaseType> active_permissions_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::PermissionSetDataView>(
      in_active_permissions, active_permissions_fragment);
  params->active_permissions.Set(
      active_permissions_fragment.is_null() ? nullptr : active_permissions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->active_permissions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null active_permissions in Renderer.UpdatePermissions request");
  mojo::internal::MessageFragment<
      typename decltype(params->withheld_permissions)::BaseType> withheld_permissions_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::PermissionSetDataView>(
      in_withheld_permissions, withheld_permissions_fragment);
  params->withheld_permissions.Set(
      withheld_permissions_fragment.is_null() ? nullptr : withheld_permissions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->withheld_permissions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null withheld_permissions in Renderer.UpdatePermissions request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy_blocked_hosts)::BaseType> policy_blocked_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_policy_blocked_hosts, policy_blocked_hosts_fragment);
  params->policy_blocked_hosts.Set(
      policy_blocked_hosts_fragment.is_null() ? nullptr : policy_blocked_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_blocked_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_blocked_hosts in Renderer.UpdatePermissions request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy_allowed_hosts)::BaseType> policy_allowed_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_policy_allowed_hosts, policy_allowed_hosts_fragment);
  params->policy_allowed_hosts.Set(
      policy_allowed_hosts_fragment.is_null() ? nullptr : policy_allowed_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_allowed_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_allowed_hosts in Renderer.UpdatePermissions request");
  params->uses_default_policy_host_restrictions = in_uses_default_policy_host_restrictions;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdatePermissions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::UpdateDefaultPolicyHostRestrictions(
    ::extensions::URLPatternSet in_default_policy_blocked_hosts, ::extensions::URLPatternSet in_default_policy_allowed_hosts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::UpdateDefaultPolicyHostRestrictions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_policy_blocked_hosts"), in_default_policy_blocked_hosts,
                        "<value of type ::extensions::URLPatternSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_policy_allowed_hosts"), in_default_policy_allowed_hosts,
                        "<value of type ::extensions::URLPatternSet>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kUpdateDefaultPolicyHostRestrictions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->default_policy_blocked_hosts)::BaseType> default_policy_blocked_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_default_policy_blocked_hosts, default_policy_blocked_hosts_fragment);
  params->default_policy_blocked_hosts.Set(
      default_policy_blocked_hosts_fragment.is_null() ? nullptr : default_policy_blocked_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->default_policy_blocked_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_policy_blocked_hosts in Renderer.UpdateDefaultPolicyHostRestrictions request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_policy_allowed_hosts)::BaseType> default_policy_allowed_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_default_policy_allowed_hosts, default_policy_allowed_hosts_fragment);
  params->default_policy_allowed_hosts.Set(
      default_policy_allowed_hosts_fragment.is_null() ? nullptr : default_policy_allowed_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->default_policy_allowed_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_policy_allowed_hosts in Renderer.UpdateDefaultPolicyHostRestrictions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdateDefaultPolicyHostRestrictions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::UpdateUserHostRestrictions(
    ::extensions::URLPatternSet in_user_blocked_hosts, ::extensions::URLPatternSet in_user_allowed_hosts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::UpdateUserHostRestrictions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_blocked_hosts"), in_user_blocked_hosts,
                        "<value of type ::extensions::URLPatternSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_allowed_hosts"), in_user_allowed_hosts,
                        "<value of type ::extensions::URLPatternSet>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kUpdateUserHostRestrictions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UpdateUserHostRestrictions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->user_blocked_hosts)::BaseType> user_blocked_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_user_blocked_hosts, user_blocked_hosts_fragment);
  params->user_blocked_hosts.Set(
      user_blocked_hosts_fragment.is_null() ? nullptr : user_blocked_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->user_blocked_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_blocked_hosts in Renderer.UpdateUserHostRestrictions request");
  mojo::internal::MessageFragment<
      typename decltype(params->user_allowed_hosts)::BaseType> user_allowed_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_user_allowed_hosts, user_allowed_hosts_fragment);
  params->user_allowed_hosts.Set(
      user_allowed_hosts_fragment.is_null() ? nullptr : user_allowed_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->user_allowed_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_allowed_hosts in Renderer.UpdateUserHostRestrictions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdateUserHostRestrictions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::UpdateTabSpecificPermissions(
    const std::string& in_extension_id, ::extensions::URLPatternSet in_new_hosts, int32_t in_tab_id, bool in_update_origin_allowlist) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::UpdateTabSpecificPermissions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_hosts"), in_new_hosts,
                        "<value of type ::extensions::URLPatternSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_origin_allowlist"), in_update_origin_allowlist,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kUpdateTabSpecificPermissions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UpdateTabSpecificPermissions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.UpdateTabSpecificPermissions request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_hosts)::BaseType> new_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_new_hosts, new_hosts_fragment);
  params->new_hosts.Set(
      new_hosts_fragment.is_null() ? nullptr : new_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_hosts in Renderer.UpdateTabSpecificPermissions request");
  params->tab_id = in_tab_id;
  params->update_origin_allowlist = in_update_origin_allowlist;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdateTabSpecificPermissions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::UpdateUserScripts(
    ::base::ReadOnlySharedMemoryRegion in_region, ::extensions::mojom::HostIDPtr in_owner) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::UpdateUserScripts", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("owner"), in_owner,
                        "<value of type ::extensions::mojom::HostIDPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kUpdateUserScripts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UpdateUserScripts_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_region, region_fragment);
  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null region in Renderer.UpdateUserScripts request");
  mojo::internal::MessageFragment<
      typename decltype(params->owner)::BaseType> owner_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::HostIDDataView>(
      in_owner, owner_fragment);
  params->owner.Set(
      owner_fragment.is_null() ? nullptr : owner_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->owner.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null owner in Renderer.UpdateUserScripts request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdateUserScripts");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::ClearTabSpecificPermissions(
    const std::vector<std::string>& in_extension_ids, int32_t in_tab_id, bool in_update_origin_allowlist) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::ClearTabSpecificPermissions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_ids"), in_extension_ids,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_origin_allowlist"), in_update_origin_allowlist,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kClearTabSpecificPermissions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_ClearTabSpecificPermissions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_ids)::BaseType>
      extension_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& extension_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_extension_ids, extension_ids_fragment, &extension_ids_validate_params);
  params->extension_ids.Set(
      extension_ids_fragment.is_null() ? nullptr : extension_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_ids in Renderer.ClearTabSpecificPermissions request");
  params->tab_id = in_tab_id;
  params->update_origin_allowlist = in_update_origin_allowlist;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("ClearTabSpecificPermissions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::WatchPages(
    const std::vector<std::string>& in_css_selectors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::Renderer::WatchPages", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("css_selectors"), in_css_selectors,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kWatchPages), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_WatchPages_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->css_selectors)::BaseType>
      css_selectors_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& css_selectors_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_css_selectors, css_selectors_fragment, &css_selectors_validate_params);
  params->css_selectors.Set(
      css_selectors_fragment.is_null() ? nullptr : css_selectors_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->css_selectors.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null css_selectors in Renderer.WatchPages request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("WatchPages");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Renderer_SuspendExtension_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Renderer::SuspendExtensionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Renderer_SuspendExtension_ProxyToResponder> proxy(
        new Renderer_SuspendExtension_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Renderer_SuspendExtension_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Renderer_SuspendExtension_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Renderer_SuspendExtension_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Renderer::SuspendExtensionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Renderer_SuspendExtension_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Renderer_SuspendExtension_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Renderer_SuspendExtension_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Renderer.4
  bool success = true;
  Renderer_SuspendExtension_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Renderer::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void Renderer_SuspendExtension_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply extensions::mojom::Renderer::SuspendExtension");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSuspendExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SuspendExtension_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SuspendExtension");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Renderer_ShouldSuspend_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Renderer::ShouldSuspendCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Renderer_ShouldSuspend_ProxyToResponder> proxy(
        new Renderer_ShouldSuspend_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Renderer_ShouldSuspend_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Renderer_ShouldSuspend_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Renderer_ShouldSuspend_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Renderer::ShouldSuspendCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Renderer_ShouldSuspend_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Renderer_ShouldSuspend_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Renderer_ShouldSuspend_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Renderer.13
  bool success = true;
  Renderer_ShouldSuspend_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Renderer::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void Renderer_ShouldSuspend_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply extensions::mojom::Renderer::ShouldSuspend");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kShouldSuspend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_ShouldSuspend_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("ShouldSuspend");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Renderer_TransferBlobs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Renderer::TransferBlobsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Renderer_TransferBlobs_ProxyToResponder> proxy(
        new Renderer_TransferBlobs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Renderer_TransferBlobs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Renderer_TransferBlobs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Renderer_TransferBlobs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Renderer::TransferBlobsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Renderer_TransferBlobs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Renderer_TransferBlobs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Renderer_TransferBlobs_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Renderer.14
  bool success = true;
  Renderer_TransferBlobs_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Renderer::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void Renderer_TransferBlobs_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply extensions::mojom::Renderer::TransferBlobs");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kTransferBlobs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_TransferBlobs_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("TransferBlobs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RendererStubDispatch::Accept(
    Renderer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Renderer>(message->header()->name)) {
    case messages::Renderer::kActivateExtension: {
      DCHECK(message->is_serialized());
      internal::Renderer_ActivateExtension_Params_Data* params =
          reinterpret_cast<internal::Renderer_ActivateExtension_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.0
      bool success = true;
      std::string p_extension_id{};
      Renderer_ActivateExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivateExtension(        
        std::move(p_extension_id));
      return true;
    }
    case messages::Renderer::kSetActivityLoggingEnabled: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetActivityLoggingEnabled_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetActivityLoggingEnabled_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.1
      bool success = true;
      bool p_enabled{};
      Renderer_SetActivityLoggingEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetActivityLoggingEnabled(        
        std::move(p_enabled));
      return true;
    }
    case messages::Renderer::kLoadExtensions: {
      DCHECK(message->is_serialized());
      internal::Renderer_LoadExtensions_Params_Data* params =
          reinterpret_cast<internal::Renderer_LoadExtensions_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.2
      bool success = true;
      std::vector<ExtensionLoadedParamsPtr> p_params{};
      Renderer_LoadExtensions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadExtensions(        
        std::move(p_params));
      return true;
    }
    case messages::Renderer::kUnloadExtension: {
      DCHECK(message->is_serialized());
      internal::Renderer_UnloadExtension_Params_Data* params =
          reinterpret_cast<internal::Renderer_UnloadExtension_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.3
      bool success = true;
      std::string p_extension_id{};
      Renderer_UnloadExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnloadExtension(        
        std::move(p_extension_id));
      return true;
    }
    case messages::Renderer::kSuspendExtension: {
      break;
    }
    case messages::Renderer::kCancelSuspendExtension: {
      DCHECK(message->is_serialized());
      internal::Renderer_CancelSuspendExtension_Params_Data* params =
          reinterpret_cast<internal::Renderer_CancelSuspendExtension_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.5
      bool success = true;
      std::string p_extension_id{};
      Renderer_CancelSuspendExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelSuspendExtension(        
        std::move(p_extension_id));
      return true;
    }
    case messages::Renderer::kSetDeveloperMode: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetDeveloperMode_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetDeveloperMode_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.6
      bool success = true;
      bool p_developer_mode_only{};
      Renderer_SetDeveloperMode_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_developer_mode_only = input_data_view.developer_mode_only();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDeveloperMode(        
        std::move(p_developer_mode_only));
      return true;
    }
    case messages::Renderer::kSetSessionInfo: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetSessionInfo_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetSessionInfo_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.7
      bool success = true;
      version_info::Channel p_channel{};
      ::extensions::mojom::FeatureSessionType p_session{};
      Renderer_SetSessionInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChannel(&p_channel))
        success = false;
      if (success && !input_data_view.ReadSession(&p_session))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSessionInfo(        
        std::move(p_channel), 
        std::move(p_session));
      return true;
    }
    case messages::Renderer::kSetSystemFont: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetSystemFont_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetSystemFont_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.8
      bool success = true;
      std::string p_font_family{};
      std::string p_font_size{};
      Renderer_SetSystemFont_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFontFamily(&p_font_family))
        success = false;
      if (success && !input_data_view.ReadFontSize(&p_font_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSystemFont(        
        std::move(p_font_family), 
        std::move(p_font_size));
      return true;
    }
    case messages::Renderer::kSetWebViewPartitionID: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetWebViewPartitionID_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetWebViewPartitionID_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.9
      bool success = true;
      std::string p_partition_id{};
      Renderer_SetWebViewPartitionID_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPartitionId(&p_partition_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWebViewPartitionID(        
        std::move(p_partition_id));
      return true;
    }
    case messages::Renderer::kSetScriptingAllowlist: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetScriptingAllowlist_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetScriptingAllowlist_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.10
      bool success = true;
      std::vector<std::string> p_extension_ids{};
      Renderer_SetScriptingAllowlist_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionIds(&p_extension_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetScriptingAllowlist(        
        std::move(p_extension_ids));
      return true;
    }
    case messages::Renderer::kUpdateUserScriptWorlds: {
      DCHECK(message->is_serialized());
      internal::Renderer_UpdateUserScriptWorlds_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdateUserScriptWorlds_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.11
      bool success = true;
      std::vector<UserScriptWorldInfoPtr> p_infos{};
      Renderer_UpdateUserScriptWorlds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfos(&p_infos))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUserScriptWorlds(        
        std::move(p_infos));
      return true;
    }
    case messages::Renderer::kClearUserScriptWorldConfig: {
      DCHECK(message->is_serialized());
      internal::Renderer_ClearUserScriptWorldConfig_Params_Data* params =
          reinterpret_cast<internal::Renderer_ClearUserScriptWorldConfig_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.12
      bool success = true;
      std::string p_extension_id{};
      std::optional<std::string> p_world_id{};
      Renderer_ClearUserScriptWorldConfig_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadWorldId(&p_world_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearUserScriptWorldConfig(        
        std::move(p_extension_id), 
        std::move(p_world_id));
      return true;
    }
    case messages::Renderer::kShouldSuspend: {
      break;
    }
    case messages::Renderer::kTransferBlobs: {
      break;
    }
    case messages::Renderer::kUpdatePermissions: {
      DCHECK(message->is_serialized());
      internal::Renderer_UpdatePermissions_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdatePermissions_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.15
      bool success = true;
      std::string p_extension_id{};
      ::extensions::PermissionSet p_active_permissions{};
      ::extensions::PermissionSet p_withheld_permissions{};
      ::extensions::URLPatternSet p_policy_blocked_hosts{};
      ::extensions::URLPatternSet p_policy_allowed_hosts{};
      bool p_uses_default_policy_host_restrictions{};
      Renderer_UpdatePermissions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadActivePermissions(&p_active_permissions))
        success = false;
      if (success && !input_data_view.ReadWithheldPermissions(&p_withheld_permissions))
        success = false;
      if (success && !input_data_view.ReadPolicyBlockedHosts(&p_policy_blocked_hosts))
        success = false;
      if (success && !input_data_view.ReadPolicyAllowedHosts(&p_policy_allowed_hosts))
        success = false;
      if (success)
        p_uses_default_policy_host_restrictions = input_data_view.uses_default_policy_host_restrictions();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdatePermissions(        
        std::move(p_extension_id), 
        std::move(p_active_permissions), 
        std::move(p_withheld_permissions), 
        std::move(p_policy_blocked_hosts), 
        std::move(p_policy_allowed_hosts), 
        std::move(p_uses_default_policy_host_restrictions));
      return true;
    }
    case messages::Renderer::kUpdateDefaultPolicyHostRestrictions: {
      DCHECK(message->is_serialized());
      internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.16
      bool success = true;
      ::extensions::URLPatternSet p_default_policy_blocked_hosts{};
      ::extensions::URLPatternSet p_default_policy_allowed_hosts{};
      Renderer_UpdateDefaultPolicyHostRestrictions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDefaultPolicyBlockedHosts(&p_default_policy_blocked_hosts))
        success = false;
      if (success && !input_data_view.ReadDefaultPolicyAllowedHosts(&p_default_policy_allowed_hosts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDefaultPolicyHostRestrictions(        
        std::move(p_default_policy_blocked_hosts), 
        std::move(p_default_policy_allowed_hosts));
      return true;
    }
    case messages::Renderer::kUpdateUserHostRestrictions: {
      DCHECK(message->is_serialized());
      internal::Renderer_UpdateUserHostRestrictions_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdateUserHostRestrictions_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.17
      bool success = true;
      ::extensions::URLPatternSet p_user_blocked_hosts{};
      ::extensions::URLPatternSet p_user_allowed_hosts{};
      Renderer_UpdateUserHostRestrictions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUserBlockedHosts(&p_user_blocked_hosts))
        success = false;
      if (success && !input_data_view.ReadUserAllowedHosts(&p_user_allowed_hosts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUserHostRestrictions(        
        std::move(p_user_blocked_hosts), 
        std::move(p_user_allowed_hosts));
      return true;
    }
    case messages::Renderer::kUpdateTabSpecificPermissions: {
      DCHECK(message->is_serialized());
      internal::Renderer_UpdateTabSpecificPermissions_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdateTabSpecificPermissions_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.18
      bool success = true;
      std::string p_extension_id{};
      ::extensions::URLPatternSet p_new_hosts{};
      int32_t p_tab_id{};
      bool p_update_origin_allowlist{};
      Renderer_UpdateTabSpecificPermissions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadNewHosts(&p_new_hosts))
        success = false;
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_update_origin_allowlist = input_data_view.update_origin_allowlist();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTabSpecificPermissions(        
        std::move(p_extension_id), 
        std::move(p_new_hosts), 
        std::move(p_tab_id), 
        std::move(p_update_origin_allowlist));
      return true;
    }
    case messages::Renderer::kUpdateUserScripts: {
      DCHECK(message->is_serialized());
      internal::Renderer_UpdateUserScripts_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdateUserScripts_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.19
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_region{};
      ::extensions::mojom::HostIDPtr p_owner{};
      Renderer_UpdateUserScripts_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (success && !input_data_view.ReadOwner(&p_owner))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUserScripts(        
        std::move(p_region), 
        std::move(p_owner));
      return true;
    }
    case messages::Renderer::kClearTabSpecificPermissions: {
      DCHECK(message->is_serialized());
      internal::Renderer_ClearTabSpecificPermissions_Params_Data* params =
          reinterpret_cast<internal::Renderer_ClearTabSpecificPermissions_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.20
      bool success = true;
      std::vector<std::string> p_extension_ids{};
      int32_t p_tab_id{};
      bool p_update_origin_allowlist{};
      Renderer_ClearTabSpecificPermissions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionIds(&p_extension_ids))
        success = false;
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_update_origin_allowlist = input_data_view.update_origin_allowlist();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearTabSpecificPermissions(        
        std::move(p_extension_ids), 
        std::move(p_tab_id), 
        std::move(p_update_origin_allowlist));
      return true;
    }
    case messages::Renderer::kWatchPages: {
      DCHECK(message->is_serialized());
      internal::Renderer_WatchPages_Params_Data* params =
          reinterpret_cast<internal::Renderer_WatchPages_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Renderer.21
      bool success = true;
      std::vector<std::string> p_css_selectors{};
      Renderer_WatchPages_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCssSelectors(&p_css_selectors))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WatchPages(        
        std::move(p_css_selectors));
      return true;
    }
  }
  return false;
}

// static
bool RendererStubDispatch::AcceptWithResponder(
    Renderer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Renderer>(message->header()->name)) {
    case messages::Renderer::kActivateExtension: {
      break;
    }
    case messages::Renderer::kSetActivityLoggingEnabled: {
      break;
    }
    case messages::Renderer::kLoadExtensions: {
      break;
    }
    case messages::Renderer::kUnloadExtension: {
      break;
    }
    case messages::Renderer::kSuspendExtension: {
      internal::Renderer_SuspendExtension_Params_Data* params =
          reinterpret_cast<
              internal::Renderer_SuspendExtension_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Renderer.4
      bool success = true;
      std::string p_extension_id{};
      Renderer_SuspendExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 4, false);
        return false;
      }
      Renderer::SuspendExtensionCallback callback =
          Renderer_SuspendExtension_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuspendExtension(        
        std::move(p_extension_id), std::move(callback));
      return true;
    }
    case messages::Renderer::kCancelSuspendExtension: {
      break;
    }
    case messages::Renderer::kSetDeveloperMode: {
      break;
    }
    case messages::Renderer::kSetSessionInfo: {
      break;
    }
    case messages::Renderer::kSetSystemFont: {
      break;
    }
    case messages::Renderer::kSetWebViewPartitionID: {
      break;
    }
    case messages::Renderer::kSetScriptingAllowlist: {
      break;
    }
    case messages::Renderer::kUpdateUserScriptWorlds: {
      break;
    }
    case messages::Renderer::kClearUserScriptWorldConfig: {
      break;
    }
    case messages::Renderer::kShouldSuspend: {
      internal::Renderer_ShouldSuspend_Params_Data* params =
          reinterpret_cast<
              internal::Renderer_ShouldSuspend_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Renderer.13
      bool success = true;
      Renderer_ShouldSuspend_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 13, false);
        return false;
      }
      Renderer::ShouldSuspendCallback callback =
          Renderer_ShouldSuspend_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShouldSuspend(std::move(callback));
      return true;
    }
    case messages::Renderer::kTransferBlobs: {
      internal::Renderer_TransferBlobs_Params_Data* params =
          reinterpret_cast<
              internal::Renderer_TransferBlobs_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Renderer.14
      bool success = true;
      Renderer_TransferBlobs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 14, false);
        return false;
      }
      Renderer::TransferBlobsCallback callback =
          Renderer_TransferBlobs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TransferBlobs(std::move(callback));
      return true;
    }
    case messages::Renderer::kUpdatePermissions: {
      break;
    }
    case messages::Renderer::kUpdateDefaultPolicyHostRestrictions: {
      break;
    }
    case messages::Renderer::kUpdateUserHostRestrictions: {
      break;
    }
    case messages::Renderer::kUpdateTabSpecificPermissions: {
      break;
    }
    case messages::Renderer::kUpdateUserScripts: {
      break;
    }
    case messages::Renderer::kClearTabSpecificPermissions: {
      break;
    }
    case messages::Renderer::kWatchPages: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRendererValidationInfo[] = {
    {base::to_underlying(messages::Renderer::kActivateExtension),
     { &internal::Renderer_ActivateExtension_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kSetActivityLoggingEnabled),
     { &internal::Renderer_SetActivityLoggingEnabled_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kLoadExtensions),
     { &internal::Renderer_LoadExtensions_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kUnloadExtension),
     { &internal::Renderer_UnloadExtension_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kSuspendExtension),
     { &internal::Renderer_SuspendExtension_Params_Data::Validate,
      &internal::Renderer_SuspendExtension_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Renderer::kCancelSuspendExtension),
     { &internal::Renderer_CancelSuspendExtension_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kSetDeveloperMode),
     { &internal::Renderer_SetDeveloperMode_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kSetSessionInfo),
     { &internal::Renderer_SetSessionInfo_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kSetSystemFont),
     { &internal::Renderer_SetSystemFont_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kSetWebViewPartitionID),
     { &internal::Renderer_SetWebViewPartitionID_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kSetScriptingAllowlist),
     { &internal::Renderer_SetScriptingAllowlist_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kUpdateUserScriptWorlds),
     { &internal::Renderer_UpdateUserScriptWorlds_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kClearUserScriptWorldConfig),
     { &internal::Renderer_ClearUserScriptWorldConfig_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kShouldSuspend),
     { &internal::Renderer_ShouldSuspend_Params_Data::Validate,
      &internal::Renderer_ShouldSuspend_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Renderer::kTransferBlobs),
     { &internal::Renderer_TransferBlobs_Params_Data::Validate,
      &internal::Renderer_TransferBlobs_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Renderer::kUpdatePermissions),
     { &internal::Renderer_UpdatePermissions_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kUpdateDefaultPolicyHostRestrictions),
     { &internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kUpdateUserHostRestrictions),
     { &internal::Renderer_UpdateUserHostRestrictions_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kUpdateTabSpecificPermissions),
     { &internal::Renderer_UpdateTabSpecificPermissions_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kUpdateUserScripts),
     { &internal::Renderer_UpdateUserScripts_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kClearTabSpecificPermissions),
     { &internal::Renderer_ClearTabSpecificPermissions_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Renderer::kWatchPages),
     { &internal::Renderer_WatchPages_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RendererRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::Renderer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRendererValidationInfo);
}

bool RendererResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::Renderer::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kRendererValidationInfo);

}


}  // extensions::mojom


namespace mojo {


// static
bool StructTraits<::extensions::mojom::ExtensionLoadedParams::DataView, ::extensions::mojom::ExtensionLoadedParamsPtr>::Read(
    ::extensions::mojom::ExtensionLoadedParams::DataView input,
    ::extensions::mojom::ExtensionLoadedParamsPtr* output) {
  bool success = true;
  ::extensions::mojom::ExtensionLoadedParamsPtr result(::extensions::mojom::ExtensionLoadedParams::New());
  
      if (success && !input.ReadManifest(&result->manifest))
        success = false;
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadActivePermissions(&result->active_permissions))
        success = false;
      if (success && !input.ReadWithheldPermissions(&result->withheld_permissions))
        success = false;
      if (success && !input.ReadTabSpecificPermissions(&result->tab_specific_permissions))
        success = false;
      if (success && !input.ReadPolicyBlockedHosts(&result->policy_blocked_hosts))
        success = false;
      if (success && !input.ReadPolicyAllowedHosts(&result->policy_allowed_hosts))
        success = false;
      if (success)
        result->uses_default_policy_blocked_allowed_hosts = input.uses_default_policy_blocked_allowed_hosts();
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadWorkerActivationToken(&result->worker_activation_token))
        success = false;
      if (success)
        result->creation_flags = input.creation_flags();
      if (success && !input.ReadGuid(&result->guid))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::UserScriptWorldInfo::DataView, ::extensions::mojom::UserScriptWorldInfoPtr>::Read(
    ::extensions::mojom::UserScriptWorldInfo::DataView input,
    ::extensions::mojom::UserScriptWorldInfoPtr* output) {
  bool success = true;
  ::extensions::mojom::UserScriptWorldInfoPtr result(::extensions::mojom::UserScriptWorldInfo::New());
  
      if (success && !input.ReadExtensionId(&result->extension_id))
        success = false;
      if (success && !input.ReadWorldId(&result->world_id))
        success = false;
      if (success && !input.ReadCsp(&result->csp))
        success = false;
      if (success)
        result->enable_messaging = input.enable_messaging();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mojom {


void RendererInterceptorForTesting::ActivateExtension(const std::string& extension_id) {
  GetForwardingInterface()->ActivateExtension(
    std::move(extension_id)
    );
}
void RendererInterceptorForTesting::SetActivityLoggingEnabled(bool enabled) {
  GetForwardingInterface()->SetActivityLoggingEnabled(
    std::move(enabled)
    );
}
void RendererInterceptorForTesting::LoadExtensions(std::vector<ExtensionLoadedParamsPtr> params) {
  GetForwardingInterface()->LoadExtensions(
    std::move(params)
    );
}
void RendererInterceptorForTesting::UnloadExtension(const std::string& extension_id) {
  GetForwardingInterface()->UnloadExtension(
    std::move(extension_id)
    );
}
void RendererInterceptorForTesting::SuspendExtension(const std::string& extension_id, SuspendExtensionCallback callback) {
  GetForwardingInterface()->SuspendExtension(
    std::move(extension_id)
    , std::move(callback));
}
void RendererInterceptorForTesting::CancelSuspendExtension(const std::string& extension_id) {
  GetForwardingInterface()->CancelSuspendExtension(
    std::move(extension_id)
    );
}
void RendererInterceptorForTesting::SetDeveloperMode(bool developer_mode_only) {
  GetForwardingInterface()->SetDeveloperMode(
    std::move(developer_mode_only)
    );
}
void RendererInterceptorForTesting::SetSessionInfo(version_info::Channel channel, ::extensions::mojom::FeatureSessionType session) {
  GetForwardingInterface()->SetSessionInfo(
    std::move(channel)
    , 
    std::move(session)
    );
}
void RendererInterceptorForTesting::SetSystemFont(const std::string& font_family, const std::string& font_size) {
  GetForwardingInterface()->SetSystemFont(
    std::move(font_family)
    , 
    std::move(font_size)
    );
}
void RendererInterceptorForTesting::SetWebViewPartitionID(const std::string& partition_id) {
  GetForwardingInterface()->SetWebViewPartitionID(
    std::move(partition_id)
    );
}
void RendererInterceptorForTesting::SetScriptingAllowlist(const std::vector<std::string>& extension_ids) {
  GetForwardingInterface()->SetScriptingAllowlist(
    std::move(extension_ids)
    );
}
void RendererInterceptorForTesting::UpdateUserScriptWorlds(std::vector<UserScriptWorldInfoPtr> infos) {
  GetForwardingInterface()->UpdateUserScriptWorlds(
    std::move(infos)
    );
}
void RendererInterceptorForTesting::ClearUserScriptWorldConfig(const std::string& extension_id, const std::optional<std::string>& world_id) {
  GetForwardingInterface()->ClearUserScriptWorldConfig(
    std::move(extension_id)
    , 
    std::move(world_id)
    );
}
void RendererInterceptorForTesting::ShouldSuspend(ShouldSuspendCallback callback) {
  GetForwardingInterface()->ShouldSuspend(std::move(callback));
}
void RendererInterceptorForTesting::TransferBlobs(TransferBlobsCallback callback) {
  GetForwardingInterface()->TransferBlobs(std::move(callback));
}
void RendererInterceptorForTesting::UpdatePermissions(const std::string& extension_id, ::extensions::PermissionSet active_permissions, ::extensions::PermissionSet withheld_permissions, ::extensions::URLPatternSet policy_blocked_hosts, ::extensions::URLPatternSet policy_allowed_hosts, bool uses_default_policy_host_restrictions) {
  GetForwardingInterface()->UpdatePermissions(
    std::move(extension_id)
    , 
    std::move(active_permissions)
    , 
    std::move(withheld_permissions)
    , 
    std::move(policy_blocked_hosts)
    , 
    std::move(policy_allowed_hosts)
    , 
    std::move(uses_default_policy_host_restrictions)
    );
}
void RendererInterceptorForTesting::UpdateDefaultPolicyHostRestrictions(::extensions::URLPatternSet default_policy_blocked_hosts, ::extensions::URLPatternSet default_policy_allowed_hosts) {
  GetForwardingInterface()->UpdateDefaultPolicyHostRestrictions(
    std::move(default_policy_blocked_hosts)
    , 
    std::move(default_policy_allowed_hosts)
    );
}
void RendererInterceptorForTesting::UpdateUserHostRestrictions(::extensions::URLPatternSet user_blocked_hosts, ::extensions::URLPatternSet user_allowed_hosts) {
  GetForwardingInterface()->UpdateUserHostRestrictions(
    std::move(user_blocked_hosts)
    , 
    std::move(user_allowed_hosts)
    );
}
void RendererInterceptorForTesting::UpdateTabSpecificPermissions(const std::string& extension_id, ::extensions::URLPatternSet new_hosts, int32_t tab_id, bool update_origin_allowlist) {
  GetForwardingInterface()->UpdateTabSpecificPermissions(
    std::move(extension_id)
    , 
    std::move(new_hosts)
    , 
    std::move(tab_id)
    , 
    std::move(update_origin_allowlist)
    );
}
void RendererInterceptorForTesting::UpdateUserScripts(::base::ReadOnlySharedMemoryRegion region, ::extensions::mojom::HostIDPtr owner) {
  GetForwardingInterface()->UpdateUserScripts(
    std::move(region)
    , 
    std::move(owner)
    );
}
void RendererInterceptorForTesting::ClearTabSpecificPermissions(const std::vector<std::string>& extension_ids, int32_t tab_id, bool update_origin_allowlist) {
  GetForwardingInterface()->ClearTabSpecificPermissions(
    std::move(extension_ids)
    , 
    std::move(tab_id)
    , 
    std::move(update_origin_allowlist)
    );
}
void RendererInterceptorForTesting::WatchPages(const std::vector<std::string>& css_selectors) {
  GetForwardingInterface()->WatchPages(
    std::move(css_selectors)
    );
}
RendererAsyncWaiter::RendererAsyncWaiter(
    Renderer* proxy) : proxy_(proxy) {}

RendererAsyncWaiter::~RendererAsyncWaiter() = default;

void RendererAsyncWaiter::SuspendExtension(
    const std::string& extension_id) {
  base::RunLoop loop;
  proxy_->SuspendExtension(
      std::move(extension_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void RendererAsyncWaiter::ShouldSuspend(
    ) {
  base::RunLoop loop;
  proxy_->ShouldSuspend(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void RendererAsyncWaiter::TransferBlobs(
    ) {
  base::RunLoop loop;
  proxy_->TransferBlobs(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // extensions::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif