// gpu/ipc/common/shared_image_metadata.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/shared_image_metadata.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/shared_image_metadata.mojom-params-data.h"
namespace gpu {
namespace mojom {

namespace internal {


// static
bool SharedImageMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedImageMetadata_Data* object =
      static_cast<const SharedImageMetadata_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->format, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->format, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_space, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color_space, validation_context))
    return false;


  if (!::skia::mojom::internal::SurfaceOrigin_Data
        ::Validate(object->surface_origin, validation_context))
    return false;


  if (!::skia::mojom::internal::AlphaType_Data
        ::Validate(object->alpha_type, validation_context))
    return false;

  return true;
}

SharedImageMetadata_Data::SharedImageMetadata_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu