// media/mojo/mojom/content_decryption_module.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/content_decryption_module.mojom-shared-internal.h"
#include "media/mojo/mojom/decryptor.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace media::mojom {
using CdmConfigDataView = mojo::native::NativeStructDataView;

class CdmPromiseResultDataView;

class CdmKeyInformationDataView;

class CdmContextDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::CdmPromiseResultDataView> {
  using Data = ::media::mojom::internal::CdmPromiseResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::CdmKeyInformationDataView> {
  using Data = ::media::mojom::internal::CdmKeyInformation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::CdmContextDataView> {
  using Data = ::media::mojom::internal::CdmContext_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
using EmeInitDataType = mojo::NativeEnum;
using CdmSessionType = mojo::NativeEnum;
using CdmMessageType = mojo::NativeEnum;


enum class CdmKeyStatus : int32_t {
  
  USABLE = 0,
  
  INTERNAL_ERROR = 1,
  
  EXPIRED = 2,
  
  OUTPUT_RESTRICTED = 3,
  
  OUTPUT_DOWNSCALED = 4,
  
  KEY_STATUS_PENDING = 5,
  
  RELEASED = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, CdmKeyStatus value);
inline bool IsKnownEnumValue(CdmKeyStatus value) {
  return internal::CdmKeyStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
using HdcpVersion = mojo::NativeEnum;
using CdmPromiseResult_Exception = mojo::NativeEnum;
// Interface base classes. They are used for type safety check.
class ContentDecryptionModuleInterfaceBase {};

using ContentDecryptionModulePtrDataView =
    mojo::InterfacePtrDataView<ContentDecryptionModuleInterfaceBase>;
using ContentDecryptionModuleRequestDataView =
    mojo::InterfaceRequestDataView<ContentDecryptionModuleInterfaceBase>;
using ContentDecryptionModuleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ContentDecryptionModuleInterfaceBase>;
using ContentDecryptionModuleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ContentDecryptionModuleInterfaceBase>;
class ContentDecryptionModuleClientInterfaceBase {};

using ContentDecryptionModuleClientPtrDataView =
    mojo::InterfacePtrDataView<ContentDecryptionModuleClientInterfaceBase>;
using ContentDecryptionModuleClientRequestDataView =
    mojo::InterfaceRequestDataView<ContentDecryptionModuleClientInterfaceBase>;
using ContentDecryptionModuleClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ContentDecryptionModuleClientInterfaceBase>;
using ContentDecryptionModuleClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ContentDecryptionModuleClientInterfaceBase>;
class CdmFactoryInterfaceBase {};

using CdmFactoryPtrDataView =
    mojo::InterfacePtrDataView<CdmFactoryInterfaceBase>;
using CdmFactoryRequestDataView =
    mojo::InterfaceRequestDataView<CdmFactoryInterfaceBase>;
using CdmFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CdmFactoryInterfaceBase>;
using CdmFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CdmFactoryInterfaceBase>;


class CdmPromiseResultDataView {
 public:
  CdmPromiseResultDataView() = default;

  CdmPromiseResultDataView(
      internal::CdmPromiseResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadException(UserType* output) const {
    auto data_value = data_->exception;
    return mojo::internal::Deserialize<::media::mojom::CdmPromiseResult_Exception>(
        data_value, output);
  }
  CdmPromiseResult_Exception exception() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CdmPromiseResult_Exception>(data_->exception));
  }
  uint32_t system_code() const {
    return data_->system_code;
  }
  inline void GetErrorMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMessage(UserType* output) {
    
    auto* pointer = data_->error_message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CdmPromiseResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CdmKeyInformationDataView {
 public:
  CdmKeyInformationDataView() = default;

  CdmKeyInformationDataView(
      internal::CdmKeyInformation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyId(UserType* output) {
    
    auto* pointer = data_->key_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::media::mojom::CdmKeyStatus>(
        data_value, output);
  }
  CdmKeyStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CdmKeyStatus>(data_->status));
  }
  uint32_t system_code() const {
    return data_->system_code;
  }
 private:
  internal::CdmKeyInformation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CdmContextDataView {
 public:
  CdmContextDataView() = default;

  CdmContextDataView(
      internal::CdmContext_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCdmIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCdmId(UserType* output) {
    
    auto* pointer = data_->cdm_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeDecryptor() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::DecryptorInterfaceBase>>(
            &data_->decryptor, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CdmContext_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

namespace std {

template <>
struct hash<::media::mojom::CdmKeyStatus>
    : public mojo::internal::EnumHashImpl<::media::mojom::CdmKeyStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CdmKeyStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::CdmKeyStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::CdmKeyStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CdmPromiseResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CdmPromiseResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CdmPromiseResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->success = Traits::success(input);
    mojo::internal::Serialize<::media::mojom::CdmPromiseResult_Exception>(
        Traits::exception(input), &fragment->exception);
    fragment->system_code = Traits::system_code(input);
    decltype(Traits::error_message(input)) in_error_message = Traits::error_message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->error_message)::BaseType> error_message_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_error_message, error_message_fragment);
    fragment->error_message.Set(
        error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->error_message.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null error_message in CdmPromiseResult struct");
  }

  static bool Deserialize(::media::mojom::internal::CdmPromiseResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::CdmPromiseResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CdmKeyInformationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CdmKeyInformationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CdmKeyInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::key_id(input)) in_key_id = Traits::key_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_id)::BaseType>
        key_id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& key_id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_key_id, key_id_fragment, &key_id_validate_params);
    fragment->key_id.Set(
        key_id_fragment.is_null() ? nullptr : key_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->key_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_id in CdmKeyInformation struct");
    mojo::internal::Serialize<::media::mojom::CdmKeyStatus>(
        Traits::status(input), &fragment->status);
    fragment->system_code = Traits::system_code(input);
  }

  static bool Deserialize(::media::mojom::internal::CdmKeyInformation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::CdmKeyInformationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CdmContextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CdmContextDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CdmContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::cdm_id(input)) in_cdm_id = Traits::cdm_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cdm_id)::BaseType> cdm_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_cdm_id, cdm_id_fragment);
    fragment->cdm_id.Set(
        cdm_id_fragment.is_null() ? nullptr : cdm_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cdm_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cdm_id in CdmContext struct");
    decltype(Traits::decryptor(input)) in_decryptor = Traits::decryptor(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::DecryptorInterfaceBase>>(
        in_decryptor, &fragment->decryptor, &fragment.message());
  }

  static bool Deserialize(::media::mojom::internal::CdmContext_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::CdmContextDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void CdmPromiseResultDataView::GetErrorMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CdmKeyInformationDataView::GetKeyIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->key_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void CdmContextDataView::GetCdmIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->cdm_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::CdmKeyStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::CdmKeyStatus value);
};

} // namespace perfetto

#endif  // MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_SHARED_H_