// media/mojo/mojom/stable/stable_video_decoder.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_STABLE_STABLE_VIDEO_DECODER_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_STABLE_STABLE_VIDEO_DECODER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::stable::mojom {
namespace internal {
class  MediaLog_AddLogRecord_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::stable::mojom::internal::MediaLogRecord_Data> event;

 private:
  friend class mojo::internal::MessageFragment<MediaLog_AddLogRecord_Params_Data>;

  MediaLog_AddLogRecord_Params_Data();
  ~MediaLog_AddLogRecord_Params_Data() = delete;
};
static_assert(sizeof(MediaLog_AddLogRecord_Params_Data) == 16,
              "Bad sizeof(MediaLog_AddLogRecord_Params_Data)");
class  VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> release_token;

 private:
  friend class mojo::internal::MessageFragment<VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data>;

  VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data();
  ~VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data() = delete;
};
static_assert(sizeof(VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data) == 16,
              "Bad sizeof(VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data)");
class  VideoDecoderClient_OnVideoFrameDecoded_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::stable::mojom::internal::VideoFrame_Data> frame;
  uint8_t can_read_without_stalling : 1;
  uint8_t pad1_[7];
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> release_token;

 private:
  friend class mojo::internal::MessageFragment<VideoDecoderClient_OnVideoFrameDecoded_Params_Data>;

  VideoDecoderClient_OnVideoFrameDecoded_Params_Data();
  ~VideoDecoderClient_OnVideoFrameDecoded_Params_Data() = delete;
};
static_assert(sizeof(VideoDecoderClient_OnVideoFrameDecoded_Params_Data) == 32,
              "Bad sizeof(VideoDecoderClient_OnVideoFrameDecoded_Params_Data)");
class  VideoDecoderClient_OnWaiting_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t reason;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<VideoDecoderClient_OnWaiting_Params_Data>;

  VideoDecoderClient_OnWaiting_Params_Data();
  ~VideoDecoderClient_OnWaiting_Params_Data() = delete;
};
static_assert(sizeof(VideoDecoderClient_OnWaiting_Params_Data) == 16,
              "Bad sizeof(VideoDecoderClient_OnWaiting_Params_Data)");
class  CdmContextEventCallback_EventCallback_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t event;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<CdmContextEventCallback_EventCallback_Params_Data>;

  CdmContextEventCallback_EventCallback_Params_Data();
  ~CdmContextEventCallback_EventCallback_Params_Data() = delete;
};
static_assert(sizeof(CdmContextEventCallback_EventCallback_Params_Data) == 16,
              "Bad sizeof(CdmContextEventCallback_EventCallback_Params_Data)");
class  StableCdmContext_GetHwKeyData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::stable::mojom::internal::DecryptConfig_Data> decrypt_config;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> hw_identifier;

 private:
  friend class mojo::internal::MessageFragment<StableCdmContext_GetHwKeyData_Params_Data>;

  StableCdmContext_GetHwKeyData_Params_Data();
  ~StableCdmContext_GetHwKeyData_Params_Data() = delete;
};
static_assert(sizeof(StableCdmContext_GetHwKeyData_Params_Data) == 24,
              "Bad sizeof(StableCdmContext_GetHwKeyData_Params_Data)");
class  StableCdmContext_GetHwKeyData_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> key_data;

 private:
  friend class mojo::internal::MessageFragment<StableCdmContext_GetHwKeyData_ResponseParams_Data>;

  StableCdmContext_GetHwKeyData_ResponseParams_Data();
  ~StableCdmContext_GetHwKeyData_ResponseParams_Data() = delete;
};
static_assert(sizeof(StableCdmContext_GetHwKeyData_ResponseParams_Data) == 24,
              "Bad sizeof(StableCdmContext_GetHwKeyData_ResponseParams_Data)");
class  StableCdmContext_RegisterEventCallback_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data callback;

 private:
  friend class mojo::internal::MessageFragment<StableCdmContext_RegisterEventCallback_Params_Data>;

  StableCdmContext_RegisterEventCallback_Params_Data();
  ~StableCdmContext_RegisterEventCallback_Params_Data() = delete;
};
static_assert(sizeof(StableCdmContext_RegisterEventCallback_Params_Data) == 16,
              "Bad sizeof(StableCdmContext_RegisterEventCallback_Params_Data)");
class  StableCdmContext_GetHwConfigData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<StableCdmContext_GetHwConfigData_Params_Data>;

  StableCdmContext_GetHwConfigData_Params_Data();
  ~StableCdmContext_GetHwConfigData_Params_Data() = delete;
};
static_assert(sizeof(StableCdmContext_GetHwConfigData_Params_Data) == 8,
              "Bad sizeof(StableCdmContext_GetHwConfigData_Params_Data)");
class  StableCdmContext_GetHwConfigData_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t pad0_[7];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> config_data;

 private:
  friend class mojo::internal::MessageFragment<StableCdmContext_GetHwConfigData_ResponseParams_Data>;

  StableCdmContext_GetHwConfigData_ResponseParams_Data();
  ~StableCdmContext_GetHwConfigData_ResponseParams_Data() = delete;
};
static_assert(sizeof(StableCdmContext_GetHwConfigData_ResponseParams_Data) == 24,
              "Bad sizeof(StableCdmContext_GetHwConfigData_ResponseParams_Data)");
class  StableCdmContext_GetScreenResolutions_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<StableCdmContext_GetScreenResolutions_Params_Data>;

  StableCdmContext_GetScreenResolutions_Params_Data();
  ~StableCdmContext_GetScreenResolutions_Params_Data() = delete;
};
static_assert(sizeof(StableCdmContext_GetScreenResolutions_Params_Data) == 8,
              "Bad sizeof(StableCdmContext_GetScreenResolutions_Params_Data)");
class  StableCdmContext_GetScreenResolutions_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::gfx::mojom::internal::Size_Data>>> resolutions;

 private:
  friend class mojo::internal::MessageFragment<StableCdmContext_GetScreenResolutions_ResponseParams_Data>;

  StableCdmContext_GetScreenResolutions_ResponseParams_Data();
  ~StableCdmContext_GetScreenResolutions_ResponseParams_Data() = delete;
};
static_assert(sizeof(StableCdmContext_GetScreenResolutions_ResponseParams_Data) == 16,
              "Bad sizeof(StableCdmContext_GetScreenResolutions_ResponseParams_Data)");
class  StableCdmContext_AllocateSecureBuffer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t size;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<StableCdmContext_AllocateSecureBuffer_Params_Data>;

  StableCdmContext_AllocateSecureBuffer_Params_Data();
  ~StableCdmContext_AllocateSecureBuffer_Params_Data() = delete;
};
static_assert(sizeof(StableCdmContext_AllocateSecureBuffer_Params_Data) == 16,
              "Bad sizeof(StableCdmContext_AllocateSecureBuffer_Params_Data)");
class  StableCdmContext_AllocateSecureBuffer_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data secure_buffer;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<StableCdmContext_AllocateSecureBuffer_ResponseParams_Data>;

  StableCdmContext_AllocateSecureBuffer_ResponseParams_Data();
  ~StableCdmContext_AllocateSecureBuffer_ResponseParams_Data() = delete;
};
static_assert(sizeof(StableCdmContext_AllocateSecureBuffer_ResponseParams_Data) == 16,
              "Bad sizeof(StableCdmContext_AllocateSecureBuffer_ResponseParams_Data)");
class  StableCdmContext_ParseEncryptedSliceHeader_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t secure_handle;
  uint32_t offset;
  uint8_t pad1_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> stream_data;

 private:
  friend class mojo::internal::MessageFragment<StableCdmContext_ParseEncryptedSliceHeader_Params_Data>;

  StableCdmContext_ParseEncryptedSliceHeader_Params_Data();
  ~StableCdmContext_ParseEncryptedSliceHeader_Params_Data() = delete;
};
static_assert(sizeof(StableCdmContext_ParseEncryptedSliceHeader_Params_Data) == 32,
              "Bad sizeof(StableCdmContext_ParseEncryptedSliceHeader_Params_Data)");
class  StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t pad0_[7];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> slice_header;

 private:
  friend class mojo::internal::MessageFragment<StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data>;

  StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data();
  ~StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data() = delete;
};
static_assert(sizeof(StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data) == 24,
              "Bad sizeof(StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data)");
class  StableCdmContext_DecryptVideoBuffer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::stable::mojom::internal::DecoderBuffer_Data> buffer;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> bytes;

 private:
  friend class mojo::internal::MessageFragment<StableCdmContext_DecryptVideoBuffer_Params_Data>;

  StableCdmContext_DecryptVideoBuffer_Params_Data();
  ~StableCdmContext_DecryptVideoBuffer_Params_Data() = delete;
};
static_assert(sizeof(StableCdmContext_DecryptVideoBuffer_Params_Data) == 24,
              "Bad sizeof(StableCdmContext_DecryptVideoBuffer_Params_Data)");
class  StableCdmContext_DecryptVideoBuffer_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::media::stable::mojom::internal::DecoderBuffer_Data> decoder_buffer;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> bytes;

 private:
  friend class mojo::internal::MessageFragment<StableCdmContext_DecryptVideoBuffer_ResponseParams_Data>;

  StableCdmContext_DecryptVideoBuffer_ResponseParams_Data();
  ~StableCdmContext_DecryptVideoBuffer_ResponseParams_Data() = delete;
};
static_assert(sizeof(StableCdmContext_DecryptVideoBuffer_ResponseParams_Data) == 32,
              "Bad sizeof(StableCdmContext_DecryptVideoBuffer_ResponseParams_Data)");
class  StableVideoDecoder_GetSupportedConfigs_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<StableVideoDecoder_GetSupportedConfigs_Params_Data>;

  StableVideoDecoder_GetSupportedConfigs_Params_Data();
  ~StableVideoDecoder_GetSupportedConfigs_Params_Data() = delete;
};
static_assert(sizeof(StableVideoDecoder_GetSupportedConfigs_Params_Data) == 8,
              "Bad sizeof(StableVideoDecoder_GetSupportedConfigs_Params_Data)");
class  StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::media::stable::mojom::internal::SupportedVideoDecoderConfig_Data>>> supported_configs;
  int32_t decoder_type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data>;

  StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data();
  ~StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data() = delete;
};
static_assert(sizeof(StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data) == 24,
              "Bad sizeof(StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data)");
class  StableVideoDecoder_Construct_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedInterface_Data client;
  mojo::internal::Interface_Data media_log;
  mojo::internal::Handle_Data video_frame_handle_releaser;
  mojo::internal::Handle_Data decoder_buffer_pipe;
  mojo::internal::Pointer<::media::stable::mojom::internal::ColorSpace_Data> target_color_space;

 private:
  friend class mojo::internal::MessageFragment<StableVideoDecoder_Construct_Params_Data>;

  StableVideoDecoder_Construct_Params_Data();
  ~StableVideoDecoder_Construct_Params_Data() = delete;
};
static_assert(sizeof(StableVideoDecoder_Construct_Params_Data) == 40,
              "Bad sizeof(StableVideoDecoder_Construct_Params_Data)");
class  StableVideoDecoder_Initialize_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::stable::mojom::internal::VideoDecoderConfig_Data> config;
  uint8_t low_delay : 1;
  uint8_t pad1_[3];
  mojo::internal::Interface_Data cdm_context;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<StableVideoDecoder_Initialize_Params_Data>;

  StableVideoDecoder_Initialize_Params_Data();
  ~StableVideoDecoder_Initialize_Params_Data() = delete;
};
static_assert(sizeof(StableVideoDecoder_Initialize_Params_Data) == 32,
              "Bad sizeof(StableVideoDecoder_Initialize_Params_Data)");
class  StableVideoDecoder_Initialize_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::stable::mojom::internal::Status_Data> status;
  uint8_t needs_bitstream_conversion : 1;
  uint8_t needs_transcryption : 1;
  uint8_t pad2_[3];
  int32_t max_decode_requests;
  int32_t decoder_type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<StableVideoDecoder_Initialize_ResponseParams_Data>;

  StableVideoDecoder_Initialize_ResponseParams_Data();
  ~StableVideoDecoder_Initialize_ResponseParams_Data() = delete;
};
static_assert(sizeof(StableVideoDecoder_Initialize_ResponseParams_Data) == 32,
              "Bad sizeof(StableVideoDecoder_Initialize_ResponseParams_Data)");
class  StableVideoDecoder_Decode_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::stable::mojom::internal::DecoderBuffer_Data> buffer;

 private:
  friend class mojo::internal::MessageFragment<StableVideoDecoder_Decode_Params_Data>;

  StableVideoDecoder_Decode_Params_Data();
  ~StableVideoDecoder_Decode_Params_Data() = delete;
};
static_assert(sizeof(StableVideoDecoder_Decode_Params_Data) == 16,
              "Bad sizeof(StableVideoDecoder_Decode_Params_Data)");
class  StableVideoDecoder_Decode_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::stable::mojom::internal::Status_Data> status;

 private:
  friend class mojo::internal::MessageFragment<StableVideoDecoder_Decode_ResponseParams_Data>;

  StableVideoDecoder_Decode_ResponseParams_Data();
  ~StableVideoDecoder_Decode_ResponseParams_Data() = delete;
};
static_assert(sizeof(StableVideoDecoder_Decode_ResponseParams_Data) == 16,
              "Bad sizeof(StableVideoDecoder_Decode_ResponseParams_Data)");
class  StableVideoDecoder_Reset_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<StableVideoDecoder_Reset_Params_Data>;

  StableVideoDecoder_Reset_Params_Data();
  ~StableVideoDecoder_Reset_Params_Data() = delete;
};
static_assert(sizeof(StableVideoDecoder_Reset_Params_Data) == 8,
              "Bad sizeof(StableVideoDecoder_Reset_Params_Data)");
class  StableVideoDecoder_Reset_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<StableVideoDecoder_Reset_ResponseParams_Data>;

  StableVideoDecoder_Reset_ResponseParams_Data();
  ~StableVideoDecoder_Reset_ResponseParams_Data() = delete;
};
static_assert(sizeof(StableVideoDecoder_Reset_ResponseParams_Data) == 8,
              "Bad sizeof(StableVideoDecoder_Reset_ResponseParams_Data)");
class  StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  mojo::internal::Interface_Data tracker;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data>;

  StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data();
  ~StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data() = delete;
};
static_assert(sizeof(StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data) == 24,
              "Bad sizeof(StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data)");
class  StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::GpuFeatureInfo_Data> gpu_feature_info;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data>;

  StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data();
  ~StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data() = delete;
};
static_assert(sizeof(StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data) == 24,
              "Bad sizeof(StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data)");

}  // namespace internal


class MediaLog_AddLogRecord_ParamsDataView {
 public:
  MediaLog_AddLogRecord_ParamsDataView() = default;

  MediaLog_AddLogRecord_ParamsDataView(
      internal::MediaLog_AddLogRecord_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEventDataView(
      ::media::stable::mojom::MediaLogRecordDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEvent(UserType* output) {
    
    auto* pointer = data_->event.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::MediaLogRecordDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaLog_AddLogRecord_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsDataView {
 public:
  VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsDataView() = default;

  VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsDataView(
      internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReleaseTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReleaseToken(UserType* output) {
    
    auto* pointer = data_->release_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecoderClient_OnVideoFrameDecoded_ParamsDataView {
 public:
  VideoDecoderClient_OnVideoFrameDecoded_ParamsDataView() = default;

  VideoDecoderClient_OnVideoFrameDecoded_ParamsDataView(
      internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameDataView(
      ::media::stable::mojom::VideoFrameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrame(UserType* output) {
    
    auto* pointer = data_->frame.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::VideoFrameDataView>(
        pointer, output, message_);
  }
  bool can_read_without_stalling() const {
    return data_->can_read_without_stalling;
  }
  inline void GetReleaseTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReleaseToken(UserType* output) {
    
    auto* pointer = data_->release_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecoderClient_OnWaiting_ParamsDataView {
 public:
  VideoDecoderClient_OnWaiting_ParamsDataView() = default;

  VideoDecoderClient_OnWaiting_ParamsDataView(
      internal::VideoDecoderClient_OnWaiting_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::media::stable::mojom::WaitingReason>(
        data_value, output);
  }
  ::media::stable::mojom::WaitingReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::WaitingReason>(data_->reason));
  }
 private:
  internal::VideoDecoderClient_OnWaiting_Params_Data* data_ = nullptr;
};


class CdmContextEventCallback_EventCallback_ParamsDataView {
 public:
  CdmContextEventCallback_EventCallback_ParamsDataView() = default;

  CdmContextEventCallback_EventCallback_ParamsDataView(
      internal::CdmContextEventCallback_EventCallback_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadEvent(UserType* output) const {
    auto data_value = data_->event;
    return mojo::internal::Deserialize<::media::stable::mojom::CdmContextEvent>(
        data_value, output);
  }
  ::media::stable::mojom::CdmContextEvent event() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::CdmContextEvent>(data_->event));
  }
 private:
  internal::CdmContextEventCallback_EventCallback_Params_Data* data_ = nullptr;
};


class StableCdmContext_GetHwKeyData_ParamsDataView {
 public:
  StableCdmContext_GetHwKeyData_ParamsDataView() = default;

  StableCdmContext_GetHwKeyData_ParamsDataView(
      internal::StableCdmContext_GetHwKeyData_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDecryptConfigDataView(
      ::media::stable::mojom::DecryptConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecryptConfig(UserType* output) {
    
    auto* pointer = data_->decrypt_config.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::DecryptConfigDataView>(
        pointer, output, message_);
  }
  inline void GetHwIdentifierDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHwIdentifier(UserType* output) {
    
    auto* pointer = data_->hw_identifier.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::StableCdmContext_GetHwKeyData_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableCdmContext_GetHwKeyData_ResponseParamsDataView {
 public:
  StableCdmContext_GetHwKeyData_ResponseParamsDataView() = default;

  StableCdmContext_GetHwKeyData_ResponseParamsDataView(
      internal::StableCdmContext_GetHwKeyData_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::media::stable::mojom::DecryptStatus>(
        data_value, output);
  }
  ::media::stable::mojom::DecryptStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::DecryptStatus>(data_->status));
  }
  inline void GetKeyDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyData(UserType* output) {
    
    auto* pointer = data_->key_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::StableCdmContext_GetHwKeyData_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableCdmContext_RegisterEventCallback_ParamsDataView {
 public:
  StableCdmContext_RegisterEventCallback_ParamsDataView() = default;

  StableCdmContext_RegisterEventCallback_ParamsDataView(
      internal::StableCdmContext_RegisterEventCallback_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeCallback() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::stable::mojom::CdmContextEventCallbackInterfaceBase>>(
            &data_->callback, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::StableCdmContext_RegisterEventCallback_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableCdmContext_GetHwConfigData_ParamsDataView {
 public:
  StableCdmContext_GetHwConfigData_ParamsDataView() = default;

  StableCdmContext_GetHwConfigData_ParamsDataView(
      internal::StableCdmContext_GetHwConfigData_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::StableCdmContext_GetHwConfigData_Params_Data* data_ = nullptr;
};


class StableCdmContext_GetHwConfigData_ResponseParamsDataView {
 public:
  StableCdmContext_GetHwConfigData_ResponseParamsDataView() = default;

  StableCdmContext_GetHwConfigData_ResponseParamsDataView(
      internal::StableCdmContext_GetHwConfigData_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
  inline void GetConfigDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfigData(UserType* output) {
    
    auto* pointer = data_->config_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::StableCdmContext_GetHwConfigData_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableCdmContext_GetScreenResolutions_ParamsDataView {
 public:
  StableCdmContext_GetScreenResolutions_ParamsDataView() = default;

  StableCdmContext_GetScreenResolutions_ParamsDataView(
      internal::StableCdmContext_GetScreenResolutions_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::StableCdmContext_GetScreenResolutions_Params_Data* data_ = nullptr;
};


class StableCdmContext_GetScreenResolutions_ResponseParamsDataView {
 public:
  StableCdmContext_GetScreenResolutions_ResponseParamsDataView() = default;

  StableCdmContext_GetScreenResolutions_ResponseParamsDataView(
      internal::StableCdmContext_GetScreenResolutions_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResolutionsDataView(
      mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResolutions(UserType* output) {
    
    auto* pointer = data_->resolutions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::StableCdmContext_GetScreenResolutions_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableCdmContext_AllocateSecureBuffer_ParamsDataView {
 public:
  StableCdmContext_AllocateSecureBuffer_ParamsDataView() = default;

  StableCdmContext_AllocateSecureBuffer_ParamsDataView(
      internal::StableCdmContext_AllocateSecureBuffer_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t size() const {
    return data_->size;
  }
 private:
  internal::StableCdmContext_AllocateSecureBuffer_Params_Data* data_ = nullptr;
};


class StableCdmContext_AllocateSecureBuffer_ResponseParamsDataView {
 public:
  StableCdmContext_AllocateSecureBuffer_ResponseParamsDataView() = default;

  StableCdmContext_AllocateSecureBuffer_ResponseParamsDataView(
      internal::StableCdmContext_AllocateSecureBuffer_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::PlatformHandle TakeSecureBuffer() {
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->secure_buffer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::StableCdmContext_AllocateSecureBuffer_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableCdmContext_ParseEncryptedSliceHeader_ParamsDataView {
 public:
  StableCdmContext_ParseEncryptedSliceHeader_ParamsDataView() = default;

  StableCdmContext_ParseEncryptedSliceHeader_ParamsDataView(
      internal::StableCdmContext_ParseEncryptedSliceHeader_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t secure_handle() const {
    return data_->secure_handle;
  }
  uint32_t offset() const {
    return data_->offset;
  }
  inline void GetStreamDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStreamData(UserType* output) {
    
    auto* pointer = data_->stream_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::StableCdmContext_ParseEncryptedSliceHeader_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableCdmContext_ParseEncryptedSliceHeader_ResponseParamsDataView {
 public:
  StableCdmContext_ParseEncryptedSliceHeader_ResponseParamsDataView() = default;

  StableCdmContext_ParseEncryptedSliceHeader_ResponseParamsDataView(
      internal::StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
  inline void GetSliceHeaderDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSliceHeader(UserType* output) {
    
    auto* pointer = data_->slice_header.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableCdmContext_DecryptVideoBuffer_ParamsDataView {
 public:
  StableCdmContext_DecryptVideoBuffer_ParamsDataView() = default;

  StableCdmContext_DecryptVideoBuffer_ParamsDataView(
      internal::StableCdmContext_DecryptVideoBuffer_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBufferDataView(
      ::media::stable::mojom::DecoderBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuffer(UserType* output) {
    
    auto* pointer = data_->buffer.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::DecoderBufferDataView>(
        pointer, output, message_);
  }
  inline void GetBytesDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) {
    
    auto* pointer = data_->bytes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::StableCdmContext_DecryptVideoBuffer_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableCdmContext_DecryptVideoBuffer_ResponseParamsDataView {
 public:
  StableCdmContext_DecryptVideoBuffer_ResponseParamsDataView() = default;

  StableCdmContext_DecryptVideoBuffer_ResponseParamsDataView(
      internal::StableCdmContext_DecryptVideoBuffer_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::media::stable::mojom::DecryptStatus>(
        data_value, output);
  }
  ::media::stable::mojom::DecryptStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::DecryptStatus>(data_->status));
  }
  inline void GetDecoderBufferDataView(
      ::media::stable::mojom::DecoderBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecoderBuffer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::stable::mojom::DecoderBufferDataView, UserType>(),
    "Attempting to read the optional `decoder_buffer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDecoderBuffer` instead "
    "of `ReadDecoderBuffer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->decoder_buffer.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::DecoderBufferDataView>(
        pointer, output, message_);
  }
  inline void GetBytesDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) {
    
    auto* pointer = data_->bytes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::StableCdmContext_DecryptVideoBuffer_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableVideoDecoder_GetSupportedConfigs_ParamsDataView {
 public:
  StableVideoDecoder_GetSupportedConfigs_ParamsDataView() = default;

  StableVideoDecoder_GetSupportedConfigs_ParamsDataView(
      internal::StableVideoDecoder_GetSupportedConfigs_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::StableVideoDecoder_GetSupportedConfigs_Params_Data* data_ = nullptr;
};


class StableVideoDecoder_GetSupportedConfigs_ResponseParamsDataView {
 public:
  StableVideoDecoder_GetSupportedConfigs_ResponseParamsDataView() = default;

  StableVideoDecoder_GetSupportedConfigs_ResponseParamsDataView(
      internal::StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSupportedConfigsDataView(
      mojo::ArrayDataView<::media::stable::mojom::SupportedVideoDecoderConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedConfigs(UserType* output) {
    
    auto* pointer = data_->supported_configs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::stable::mojom::SupportedVideoDecoderConfigDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDecoderType(UserType* output) const {
    auto data_value = data_->decoder_type;
    return mojo::internal::Deserialize<::media::stable::mojom::VideoDecoderType>(
        data_value, output);
  }
  ::media::stable::mojom::VideoDecoderType decoder_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::VideoDecoderType>(data_->decoder_type));
  }
 private:
  internal::StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableVideoDecoder_Construct_ParamsDataView {
 public:
  StableVideoDecoder_Construct_ParamsDataView() = default;

  StableVideoDecoder_Construct_ParamsDataView(
      internal::StableVideoDecoder_Construct_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::media::stable::mojom::VideoDecoderClientAssociatedPtrInfoDataView>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeMediaLog() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::stable::mojom::MediaLogInterfaceBase>>(
            &data_->media_log, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeVideoFrameHandleReleaser() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::stable::mojom::VideoFrameHandleReleaserInterfaceBase>>(
            &data_->video_frame_handle_releaser, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeConsumerHandle TakeDecoderBufferPipe() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->decoder_buffer_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetTargetColorSpaceDataView(
      ::media::stable::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetColorSpace(UserType* output) {
    
    auto* pointer = data_->target_color_space.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
 private:
  internal::StableVideoDecoder_Construct_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableVideoDecoder_Initialize_ParamsDataView {
 public:
  StableVideoDecoder_Initialize_ParamsDataView() = default;

  StableVideoDecoder_Initialize_ParamsDataView(
      internal::StableVideoDecoder_Initialize_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      ::media::stable::mojom::VideoDecoderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::VideoDecoderConfigDataView>(
        pointer, output, message_);
  }
  bool low_delay() const {
    return data_->low_delay;
  }
  template <typename UserType>
  UserType TakeCdmContext() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::stable::mojom::StableCdmContextInterfaceBase>>(
            &data_->cdm_context, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::StableVideoDecoder_Initialize_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableVideoDecoder_Initialize_ResponseParamsDataView {
 public:
  StableVideoDecoder_Initialize_ResponseParamsDataView() = default;

  StableVideoDecoder_Initialize_ResponseParamsDataView(
      internal::StableVideoDecoder_Initialize_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStatusDataView(
      ::media::stable::mojom::StatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::StatusDataView>(
        pointer, output, message_);
  }
  bool needs_bitstream_conversion() const {
    return data_->needs_bitstream_conversion;
  }
  int32_t max_decode_requests() const {
    return data_->max_decode_requests;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDecoderType(UserType* output) const {
    auto data_value = data_->decoder_type;
    return mojo::internal::Deserialize<::media::stable::mojom::VideoDecoderType>(
        data_value, output);
  }
  ::media::stable::mojom::VideoDecoderType decoder_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::stable::mojom::VideoDecoderType>(data_->decoder_type));
  }
  bool needs_transcryption() const {
    if (data_->header_.version < 1)
      return bool{};
    return data_->needs_transcryption;
  }
 private:
  internal::StableVideoDecoder_Initialize_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableVideoDecoder_Decode_ParamsDataView {
 public:
  StableVideoDecoder_Decode_ParamsDataView() = default;

  StableVideoDecoder_Decode_ParamsDataView(
      internal::StableVideoDecoder_Decode_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBufferDataView(
      ::media::stable::mojom::DecoderBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuffer(UserType* output) {
    
    auto* pointer = data_->buffer.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::DecoderBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::StableVideoDecoder_Decode_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableVideoDecoder_Decode_ResponseParamsDataView {
 public:
  StableVideoDecoder_Decode_ResponseParamsDataView() = default;

  StableVideoDecoder_Decode_ResponseParamsDataView(
      internal::StableVideoDecoder_Decode_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStatusDataView(
      ::media::stable::mojom::StatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::media::stable::mojom::StatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::StableVideoDecoder_Decode_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableVideoDecoder_Reset_ParamsDataView {
 public:
  StableVideoDecoder_Reset_ParamsDataView() = default;

  StableVideoDecoder_Reset_ParamsDataView(
      internal::StableVideoDecoder_Reset_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::StableVideoDecoder_Reset_Params_Data* data_ = nullptr;
};


class StableVideoDecoder_Reset_ResponseParamsDataView {
 public:
  StableVideoDecoder_Reset_ResponseParamsDataView() = default;

  StableVideoDecoder_Reset_ResponseParamsDataView(
      internal::StableVideoDecoder_Reset_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::StableVideoDecoder_Reset_ResponseParams_Data* data_ = nullptr;
};


class StableVideoDecoderFactory_CreateStableVideoDecoder_ParamsDataView {
 public:
  StableVideoDecoderFactory_CreateStableVideoDecoder_ParamsDataView() = default;

  StableVideoDecoderFactory_CreateStableVideoDecoder_ParamsDataView(
      internal::StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::stable::mojom::StableVideoDecoderInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeTracker() {
    UserType result;
    if (data_->header_.version < 1)
      return result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::stable::mojom::StableVideoDecoderTrackerInterfaceBase>>(
            &data_->tracker, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_ParamsDataView {
 public:
  StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_ParamsDataView() = default;

  StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_ParamsDataView(
      internal::StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGpuFeatureInfoDataView(
      ::gpu::mojom::GpuFeatureInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGpuFeatureInfo(UserType* output) {
    
    auto* pointer = data_->gpu_feature_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::GpuFeatureInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::stable::mojom::StableVideoDecoderFactoryInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void MediaLog_AddLogRecord_ParamsDataView::GetEventDataView(
    ::media::stable::mojom::MediaLogRecordDataView* output) {
  auto pointer = data_->event.Get();
  *output = ::media::stable::mojom::MediaLogRecordDataView(pointer, message_);
}


inline void VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsDataView::GetReleaseTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->release_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void VideoDecoderClient_OnVideoFrameDecoded_ParamsDataView::GetFrameDataView(
    ::media::stable::mojom::VideoFrameDataView* output) {
  auto pointer = data_->frame.Get();
  *output = ::media::stable::mojom::VideoFrameDataView(pointer, message_);
}
inline void VideoDecoderClient_OnVideoFrameDecoded_ParamsDataView::GetReleaseTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->release_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}






inline void StableCdmContext_GetHwKeyData_ParamsDataView::GetDecryptConfigDataView(
    ::media::stable::mojom::DecryptConfigDataView* output) {
  auto pointer = data_->decrypt_config.Get();
  *output = ::media::stable::mojom::DecryptConfigDataView(pointer, message_);
}
inline void StableCdmContext_GetHwKeyData_ParamsDataView::GetHwIdentifierDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->hw_identifier.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void StableCdmContext_GetHwKeyData_ResponseParamsDataView::GetKeyDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->key_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}






inline void StableCdmContext_GetHwConfigData_ResponseParamsDataView::GetConfigDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->config_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}




inline void StableCdmContext_GetScreenResolutions_ResponseParamsDataView::GetResolutionsDataView(
    mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output) {
  auto pointer = data_->resolutions.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::SizeDataView>(pointer, message_);
}






inline void StableCdmContext_ParseEncryptedSliceHeader_ParamsDataView::GetStreamDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->stream_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void StableCdmContext_ParseEncryptedSliceHeader_ResponseParamsDataView::GetSliceHeaderDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->slice_header.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void StableCdmContext_DecryptVideoBuffer_ParamsDataView::GetBufferDataView(
    ::media::stable::mojom::DecoderBufferDataView* output) {
  auto pointer = data_->buffer.Get();
  *output = ::media::stable::mojom::DecoderBufferDataView(pointer, message_);
}
inline void StableCdmContext_DecryptVideoBuffer_ParamsDataView::GetBytesDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->bytes.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void StableCdmContext_DecryptVideoBuffer_ResponseParamsDataView::GetDecoderBufferDataView(
    ::media::stable::mojom::DecoderBufferDataView* output) {
  auto pointer = data_->decoder_buffer.Get();
  *output = ::media::stable::mojom::DecoderBufferDataView(pointer, message_);
}
inline void StableCdmContext_DecryptVideoBuffer_ResponseParamsDataView::GetBytesDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->bytes.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}




inline void StableVideoDecoder_GetSupportedConfigs_ResponseParamsDataView::GetSupportedConfigsDataView(
    mojo::ArrayDataView<::media::stable::mojom::SupportedVideoDecoderConfigDataView>* output) {
  auto pointer = data_->supported_configs.Get();
  *output = mojo::ArrayDataView<::media::stable::mojom::SupportedVideoDecoderConfigDataView>(pointer, message_);
}


inline void StableVideoDecoder_Construct_ParamsDataView::GetTargetColorSpaceDataView(
    ::media::stable::mojom::ColorSpaceDataView* output) {
  auto pointer = data_->target_color_space.Get();
  *output = ::media::stable::mojom::ColorSpaceDataView(pointer, message_);
}


inline void StableVideoDecoder_Initialize_ParamsDataView::GetConfigDataView(
    ::media::stable::mojom::VideoDecoderConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = ::media::stable::mojom::VideoDecoderConfigDataView(pointer, message_);
}


inline void StableVideoDecoder_Initialize_ResponseParamsDataView::GetStatusDataView(
    ::media::stable::mojom::StatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = ::media::stable::mojom::StatusDataView(pointer, message_);
}


inline void StableVideoDecoder_Decode_ParamsDataView::GetBufferDataView(
    ::media::stable::mojom::DecoderBufferDataView* output) {
  auto pointer = data_->buffer.Get();
  *output = ::media::stable::mojom::DecoderBufferDataView(pointer, message_);
}


inline void StableVideoDecoder_Decode_ResponseParamsDataView::GetStatusDataView(
    ::media::stable::mojom::StatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = ::media::stable::mojom::StatusDataView(pointer, message_);
}








inline void StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_ParamsDataView::GetGpuFeatureInfoDataView(
    ::gpu::mojom::GpuFeatureInfoDataView* output) {
  auto pointer = data_->gpu_feature_info.Get();
  *output = ::gpu::mojom::GpuFeatureInfoDataView(pointer, message_);
}



}  // media::stable::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_STABLE_STABLE_VIDEO_DECODER_MOJOM_PARAMS_DATA_H_