// services/device/public/mojom/pressure_update.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/pressure_update.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/pressure_update.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* PressureSourceToStringHelper(PressureSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PressureSource::kCpu:
      return "kCpu";
    default:
      return nullptr;
  }
}

std::string PressureSourceToString(PressureSource value) {
  const char *str = PressureSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PressureSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PressureSource value) {
  return os << PressureSourceToString(value);
}

NOINLINE static const char* PressureStateToStringHelper(PressureState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PressureState::kNominal:
      return "kNominal";
    case PressureState::kFair:
      return "kFair";
    case PressureState::kSerious:
      return "kSerious";
    case PressureState::kCritical:
      return "kCritical";
    default:
      return nullptr;
  }
}

std::string PressureStateToString(PressureState value) {
  const char *str = PressureStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PressureState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PressureState value) {
  return os << PressureStateToString(value);
}

namespace internal {


// static
bool PressureUpdate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PressureUpdate_Data* object =
      static_cast<const PressureUpdate_Data*>(data);


  if (!::device::mojom::internal::PressureSource_Data
        ::Validate(object->source, validation_context))
    return false;


  if (!::device::mojom::internal::PressureState_Data
        ::Validate(object->state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  return true;
}

PressureUpdate_Data::PressureUpdate_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::PressureSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::PressureSource value) {
  return std::move(context).WriteString(::device::mojom::PressureSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::PressureState>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::PressureState value) {
  return std::move(context).WriteString(::device::mojom::PressureStateToString(value));
}

} // namespace perfetto