// services/network/public/mojom/network_interface.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_interface.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/network_change_manager.mojom-shared.h"







namespace network::mojom {
class NetworkInterfaceDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::NetworkInterfaceDataView> {
  using Data = ::network::mojom::internal::NetworkInterface_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class NetworkInterfaceDataView {
 public:
  NetworkInterfaceDataView() = default;

  NetworkInterfaceDataView(
      internal::NetworkInterface_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFriendlyNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFriendlyName(UserType* output) {
    
    auto* pointer = data_->friendly_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t interface_index() const {
    return data_->interface_index;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::ConnectionType>(
        data_value, output);
  }
  ::network::mojom::ConnectionType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ConnectionType>(data_->type));
  }
  inline void GetAddressDataView(
      ::network::mojom::IPAddressDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddress(UserType* output) {
    
    auto* pointer = data_->address.Get();
    return mojo::internal::Deserialize<::network::mojom::IPAddressDataView>(
        pointer, output, message_);
  }
  uint32_t prefix_length() const {
    return data_->prefix_length;
  }
  int32_t ip_address_attributes() const {
    return data_->ip_address_attributes;
  }
  inline void GetMacAddressDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMacAddress(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `mac_address` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMacAddress` instead "
    "of `ReadMacAddress if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mac_address.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::NetworkInterface_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NetworkInterfaceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetworkInterfaceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NetworkInterface_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in NetworkInterface struct");
    decltype(Traits::friendly_name(input)) in_friendly_name = Traits::friendly_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->friendly_name)::BaseType> friendly_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_friendly_name, friendly_name_fragment);
    fragment->friendly_name.Set(
        friendly_name_fragment.is_null() ? nullptr : friendly_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->friendly_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null friendly_name in NetworkInterface struct");
    fragment->interface_index = Traits::interface_index(input);
    mojo::internal::Serialize<::network::mojom::ConnectionType>(
        Traits::type(input), &fragment->type);
    decltype(Traits::address(input)) in_address = Traits::address(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->address)::BaseType> address_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
        in_address, address_fragment);
    fragment->address.Set(
        address_fragment.is_null() ? nullptr : address_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->address.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null address in NetworkInterface struct");
    fragment->prefix_length = Traits::prefix_length(input);
    fragment->ip_address_attributes = Traits::ip_address_attributes(input);
    decltype(Traits::mac_address(input)) in_mac_address = Traits::mac_address(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mac_address)::BaseType>
        mac_address_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& mac_address_validate_params =
        mojo::internal::GetArrayValidator<6, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_mac_address, mac_address_fragment, &mac_address_validate_params);
    fragment->mac_address.Set(
        mac_address_fragment.is_null() ? nullptr : mac_address_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::NetworkInterface_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NetworkInterfaceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void NetworkInterfaceDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NetworkInterfaceDataView::GetFriendlyNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->friendly_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NetworkInterfaceDataView::GetAddressDataView(
    ::network::mojom::IPAddressDataView* output) {
  auto pointer = data_->address.Get();
  *output = ::network::mojom::IPAddressDataView(pointer, message_);
}
inline void NetworkInterfaceDataView::GetMacAddressDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->mac_address.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_MOJOM_SHARED_H_