// services/network/public/mojom/p2p.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/p2p.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/p2p.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* EcnMarkingToStringHelper(EcnMarking value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EcnMarking::kNotEct:
      return "kNotEct";
    case EcnMarking::kEct1:
      return "kEct1";
    case EcnMarking::kEct0:
      return "kEct0";
    case EcnMarking::kCe:
      return "kCe";
    default:
      return nullptr;
  }
}

std::string EcnMarkingToString(EcnMarking value) {
  const char *str = EcnMarkingToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EcnMarking value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EcnMarking value) {
  return os << EcnMarkingToString(value);
}

namespace internal {


// static
bool P2PReceivedPacket_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PReceivedPacket_Data* object =
      static_cast<const P2PReceivedPacket_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->socket_address, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->socket_address, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;


  if (!::network::mojom::internal::EcnMarking_Data
        ::Validate(object->ecn, validation_context))
    return false;

  return true;
}

P2PReceivedPacket_Data::P2PReceivedPacket_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSendPacket_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSendPacket_Data* object =
      static_cast<const P2PSendPacket_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->packet_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->packet_info, validation_context))
    return false;

  return true;
}

P2PSendPacket_Data::P2PSendPacket_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PNetworkNotificationClient_NetworkListChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PNetworkNotificationClient_NetworkListChanged_Params_Data* object =
      static_cast<const P2PNetworkNotificationClient_NetworkListChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->networks, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& networks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->networks, validation_context,
                                         &networks_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_ipv4_local_address, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_ipv4_local_address, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_ipv6_local_address, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_ipv6_local_address, validation_context))
    return false;

  return true;
}

P2PNetworkNotificationClient_NetworkListChanged_Params_Data::P2PNetworkNotificationClient_NetworkListChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSocketManager_StartNetworkNotifications_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSocketManager_StartNetworkNotifications_Params_Data* object =
      static_cast<const P2PSocketManager_StartNetworkNotifications_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

P2PSocketManager_StartNetworkNotifications_Params_Data::P2PSocketManager_StartNetworkNotifications_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSocketManager_GetHostAddress_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSocketManager_GetHostAddress_Params_Data* object =
      static_cast<const P2PSocketManager_GetHostAddress_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->host_name, validation_context,
                                         &host_name_validate_params)) {
    return false;
  }

  return true;
}

P2PSocketManager_GetHostAddress_Params_Data::P2PSocketManager_GetHostAddress_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSocketManager_GetHostAddress_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSocketManager_GetHostAddress_ResponseParams_Data* object =
      static_cast<const P2PSocketManager_GetHostAddress_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->addresses, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& addresses_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->addresses, validation_context,
                                         &addresses_validate_params)) {
    return false;
  }

  return true;
}

P2PSocketManager_GetHostAddress_ResponseParams_Data::P2PSocketManager_GetHostAddress_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSocketManager_GetHostAddressWithFamily_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSocketManager_GetHostAddressWithFamily_Params_Data* object =
      static_cast<const P2PSocketManager_GetHostAddressWithFamily_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->host_name, validation_context,
                                         &host_name_validate_params)) {
    return false;
  }

  return true;
}

P2PSocketManager_GetHostAddressWithFamily_Params_Data::P2PSocketManager_GetHostAddressWithFamily_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSocketManager_GetHostAddressWithFamily_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSocketManager_GetHostAddressWithFamily_ResponseParams_Data* object =
      static_cast<const P2PSocketManager_GetHostAddressWithFamily_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->addresses, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& addresses_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->addresses, validation_context,
                                         &addresses_validate_params)) {
    return false;
  }

  return true;
}

P2PSocketManager_GetHostAddressWithFamily_ResponseParams_Data::P2PSocketManager_GetHostAddressWithFamily_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSocketManager_CreateSocket_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSocketManager_CreateSocket_Params_Data* object =
      static_cast<const P2PSocketManager_CreateSocket_Params_Data*>(data);


  if (!::network::mojom::internal::P2PSocketType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->local_address, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->local_address, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->port_range, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->port_range, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_address, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_address, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traffic_annotation, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traffic_annotation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->devtools_token, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->socket, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->socket,
                                                 validation_context)) {
    return false;
  }

  return true;
}

P2PSocketManager_CreateSocket_Params_Data::P2PSocketManager_CreateSocket_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSocket_Send_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSocket_Send_Params_Data* object =
      static_cast<const P2PSocket_Send_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->packet_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->packet_info, validation_context))
    return false;

  return true;
}

P2PSocket_Send_Params_Data::P2PSocket_Send_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSocket_SendBatch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSocket_SendBatch_Params_Data* object =
      static_cast<const P2PSocket_SendBatch_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->packet_batch, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& packet_batch_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->packet_batch, validation_context,
                                         &packet_batch_validate_params)) {
    return false;
  }

  return true;
}

P2PSocket_SendBatch_Params_Data::P2PSocket_SendBatch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSocket_SetOption_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSocket_SetOption_Params_Data* object =
      static_cast<const P2PSocket_SetOption_Params_Data*>(data);


  if (!::network::mojom::internal::P2PSocketOption_Data
        ::Validate(object->option, validation_context))
    return false;

  return true;
}

P2PSocket_SetOption_Params_Data::P2PSocket_SetOption_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSocketClient_SocketCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSocketClient_SocketCreated_Params_Data* object =
      static_cast<const P2PSocketClient_SocketCreated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->local_address, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->local_address, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_address, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_address, validation_context))
    return false;

  return true;
}

P2PSocketClient_SocketCreated_Params_Data::P2PSocketClient_SocketCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSocketClient_SendComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSocketClient_SendComplete_Params_Data* object =
      static_cast<const P2PSocketClient_SendComplete_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->send_metrics, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->send_metrics, validation_context))
    return false;

  return true;
}

P2PSocketClient_SendComplete_Params_Data::P2PSocketClient_SendComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSocketClient_SendBatchComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSocketClient_SendBatchComplete_Params_Data* object =
      static_cast<const P2PSocketClient_SendBatchComplete_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->send_metrics_batch, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& send_metrics_batch_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->send_metrics_batch, validation_context,
                                         &send_metrics_batch_validate_params)) {
    return false;
  }

  return true;
}

P2PSocketClient_SendBatchComplete_Params_Data::P2PSocketClient_SendBatchComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool P2PSocketClient_DataReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const P2PSocketClient_DataReceived_Params_Data* object =
      static_cast<const P2PSocketClient_DataReceived_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->packets, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& packets_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->packets, validation_context,
                                         &packets_validate_params)) {
    return false;
  }

  return true;
}

P2PSocketClient_DataReceived_Params_Data::P2PSocketClient_DataReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::EcnMarking>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::EcnMarking value) {
  return std::move(context).WriteString(::network::mojom::EcnMarkingToString(value));
}

} // namespace perfetto