// services/network/public/mojom/proxy_resolving_socket.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/proxy_resolving_socket.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/proxy_resolving_socket.mojom-params-data.h"
#include "services/network/public/mojom/proxy_resolving_socket.mojom-shared-message-ids.h"

#include "services/network/public/mojom/proxy_resolving_socket.mojom-blink-import-headers.h"
#include "services/network/public/mojom/proxy_resolving_socket.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
ProxyResolvingSocketOptions::ProxyResolvingSocketOptions()
    : use_tls(false),
      fake_tls_handshake(false) {}

ProxyResolvingSocketOptions::ProxyResolvingSocketOptions(
    bool use_tls_in,
    bool fake_tls_handshake_in)
    : use_tls(std::move(use_tls_in)),
      fake_tls_handshake(std::move(fake_tls_handshake_in)) {}

ProxyResolvingSocketOptions::~ProxyResolvingSocketOptions() = default;
size_t ProxyResolvingSocketOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->use_tls);
  seed = mojo::internal::WTFHash(seed, this->fake_tls_handshake);
  return seed;
}

void ProxyResolvingSocketOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_tls"), this->use_tls,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fake_tls_handshake"), this->fake_tls_handshake,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyResolvingSocketOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ProxyResolvingSocket::Name_[] = "network.mojom.ProxyResolvingSocket";

ProxyResolvingSocket::IPCStableHashFunction ProxyResolvingSocket::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProxyResolvingSocket>(message.name())) {
    case messages::ProxyResolvingSocket::kUpgradeToTLS: {
      return &ProxyResolvingSocket::UpgradeToTLS_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProxyResolvingSocket::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProxyResolvingSocket>(message.name())) {
      case messages::ProxyResolvingSocket::kUpgradeToTLS:
            return "Receive network::mojom::ProxyResolvingSocket::UpgradeToTLS";
    }
  } else {
    switch (static_cast<messages::ProxyResolvingSocket>(message.name())) {
      case messages::ProxyResolvingSocket::kUpgradeToTLS:
            return "Receive reply network::mojom::ProxyResolvingSocket::UpgradeToTLS";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProxyResolvingSocket::UpgradeToTLS_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::ProxyResolvingSocket::UpgradeToTLS");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ProxyResolvingSocket_UpgradeToTLS_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProxyResolvingSocket_UpgradeToTLS_ForwardToCallback(
      ProxyResolvingSocket::UpgradeToTLSCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProxyResolvingSocket_UpgradeToTLS_ForwardToCallback(const ProxyResolvingSocket_UpgradeToTLS_ForwardToCallback&) = delete;
  ProxyResolvingSocket_UpgradeToTLS_ForwardToCallback& operator=(const ProxyResolvingSocket_UpgradeToTLS_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProxyResolvingSocket::UpgradeToTLSCallback callback_;
};

ProxyResolvingSocketProxy::ProxyResolvingSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyResolvingSocketProxy::UpgradeToTLS(
    const ::net::HostPortPair& in_host_port_pair, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingReceiver<::network::mojom::blink::TLSClientSocket> in_receiver, ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> in_observer, UpgradeToTLSCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ProxyResolvingSocket::UpgradeToTLS", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_port_pair"), in_host_port_pair,
                        "<value of type const ::net::HostPortPair&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::TLSClientSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<::network::mojom::blink::SocketObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolvingSocket::kUpgradeToTLS), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyResolvingSocket_UpgradeToTLS_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host_port_pair)::BaseType> host_port_pair_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
      in_host_port_pair, host_port_pair_fragment);
  params->host_port_pair.Set(
      host_port_pair_fragment.is_null() ? nullptr : host_port_pair_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host_port_pair.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host_port_pair in ProxyResolvingSocket.UpgradeToTLS request");
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, traffic_annotation_fragment);
  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in ProxyResolvingSocket.UpgradeToTLS request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TLSClientSocketInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in ProxyResolvingSocket.UpgradeToTLS request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolvingSocket::Name_);
  message.set_method_name("UpgradeToTLS");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProxyResolvingSocket_UpgradeToTLS_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ProxyResolvingSocket_UpgradeToTLS_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProxyResolvingSocket::UpgradeToTLSCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProxyResolvingSocket_UpgradeToTLS_ProxyToResponder> proxy(
        new ProxyResolvingSocket_UpgradeToTLS_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProxyResolvingSocket_UpgradeToTLS_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProxyResolvingSocket_UpgradeToTLS_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProxyResolvingSocket_UpgradeToTLS_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProxyResolvingSocket::UpgradeToTLSCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream);
};

bool ProxyResolvingSocket_UpgradeToTLS_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProxyResolvingSocket_UpgradeToTLS_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProxyResolvingSocket_UpgradeToTLS_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for ProxyResolvingSocket.0
  bool success = true;
  int32_t p_net_error{};
  ::mojo::ScopedDataPipeConsumerHandle p_receive_stream{};
  ::mojo::ScopedDataPipeProducerHandle p_send_stream{};
  ProxyResolvingSocket_UpgradeToTLS_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (success)
    p_receive_stream = input_data_view.TakeReceiveStream();
  if (success)
    p_send_stream = input_data_view.TakeSendStream();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProxyResolvingSocket::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error), 
std::move(p_receive_stream), 
std::move(p_send_stream));
  return true;
}

void ProxyResolvingSocket_UpgradeToTLS_ProxyToResponder::Run(
    int32_t in_net_error, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::ProxyResolvingSocket::UpgradeToTLS", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_stream"), in_receive_stream,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_stream"), in_send_stream,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolvingSocket::kUpgradeToTLS), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyResolvingSocket_UpgradeToTLS_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_receive_stream, &params->receive_stream, &params.message());
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_send_stream, &params->send_stream, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolvingSocket::Name_);
  message.set_method_name("UpgradeToTLS");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProxyResolvingSocketStubDispatch::Accept(
    ProxyResolvingSocket* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProxyResolvingSocket>(message->header()->name)) {
    case messages::ProxyResolvingSocket::kUpgradeToTLS: {
      break;
    }
  }
  return false;
}

// static
bool ProxyResolvingSocketStubDispatch::AcceptWithResponder(
    ProxyResolvingSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProxyResolvingSocket>(message->header()->name)) {
    case messages::ProxyResolvingSocket::kUpgradeToTLS: {
      internal::ProxyResolvingSocket_UpgradeToTLS_Params_Data* params =
          reinterpret_cast<
              internal::ProxyResolvingSocket_UpgradeToTLS_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for ProxyResolvingSocket.0
      bool success = true;
      ::net::HostPortPair p_host_port_pair{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingReceiver<::network::mojom::blink::TLSClientSocket> p_receiver{};
      ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> p_observer{};
      ProxyResolvingSocket_UpgradeToTLS_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHostPortPair(&p_host_port_pair))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolvingSocket::Name_, 0, false);
        return false;
      }
      ProxyResolvingSocket::UpgradeToTLSCallback callback =
          ProxyResolvingSocket_UpgradeToTLS_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpgradeToTLS(        
        std::move(p_host_port_pair), 
        std::move(p_traffic_annotation), 
        std::move(p_receiver), 
        std::move(p_observer), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProxyResolvingSocketValidationInfo[] = {
    {base::to_underlying(messages::ProxyResolvingSocket::kUpgradeToTLS),
     { &internal::ProxyResolvingSocket_UpgradeToTLS_Params_Data::Validate,
      &internal::ProxyResolvingSocket_UpgradeToTLS_ResponseParams_Data::Validate}},
};

bool ProxyResolvingSocketRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::ProxyResolvingSocket::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProxyResolvingSocketValidationInfo);
}

bool ProxyResolvingSocketResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::ProxyResolvingSocket::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kProxyResolvingSocketValidationInfo);

}
const char ProxyResolvingSocketFactory::Name_[] = "network.mojom.ProxyResolvingSocketFactory";

ProxyResolvingSocketFactory::IPCStableHashFunction ProxyResolvingSocketFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProxyResolvingSocketFactory>(message.name())) {
    case messages::ProxyResolvingSocketFactory::kCreateProxyResolvingSocket: {
      return &ProxyResolvingSocketFactory::CreateProxyResolvingSocket_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProxyResolvingSocketFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProxyResolvingSocketFactory>(message.name())) {
      case messages::ProxyResolvingSocketFactory::kCreateProxyResolvingSocket:
            return "Receive network::mojom::ProxyResolvingSocketFactory::CreateProxyResolvingSocket";
    }
  } else {
    switch (static_cast<messages::ProxyResolvingSocketFactory>(message.name())) {
      case messages::ProxyResolvingSocketFactory::kCreateProxyResolvingSocket:
            return "Receive reply network::mojom::ProxyResolvingSocketFactory::CreateProxyResolvingSocket";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProxyResolvingSocketFactory::CreateProxyResolvingSocket_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::ProxyResolvingSocketFactory::CreateProxyResolvingSocket");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ForwardToCallback(
      ProxyResolvingSocketFactory::CreateProxyResolvingSocketCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ForwardToCallback(const ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ForwardToCallback&) = delete;
  ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ForwardToCallback& operator=(const ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProxyResolvingSocketFactory::CreateProxyResolvingSocketCallback callback_;
};

ProxyResolvingSocketFactoryProxy::ProxyResolvingSocketFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyResolvingSocketFactoryProxy::CreateProxyResolvingSocket(
    const ::blink::KURL& in_url, ::network::mojom::blink::NetworkAnonymizationKeyPtr in_network_anonymization_key, ProxyResolvingSocketOptionsPtr in_options, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingReceiver<ProxyResolvingSocket> in_socket, ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> in_observer, CreateProxyResolvingSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ProxyResolvingSocketFactory::CreateProxyResolvingSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type ::network::mojom::blink::NetworkAnonymizationKeyPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ProxyResolvingSocketOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket"), in_socket,
                        "<value of type ::mojo::PendingReceiver<ProxyResolvingSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<::network::mojom::blink::SocketObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolvingSocketFactory::kCreateProxyResolvingSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ProxyResolvingSocketFactory.CreateProxyResolvingSocket request");
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
      in_network_anonymization_key, network_anonymization_key_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_anonymization_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_anonymization_key in ProxyResolvingSocketFactory.CreateProxyResolvingSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::ProxyResolvingSocketOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, traffic_annotation_fragment);
  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in ProxyResolvingSocketFactory.CreateProxyResolvingSocket request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::ProxyResolvingSocketInterfaceBase>>(
      in_socket, &params->socket, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->socket),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in ProxyResolvingSocketFactory.CreateProxyResolvingSocket request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolvingSocketFactory::Name_);
  message.set_method_name("CreateProxyResolvingSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProxyResolvingSocketFactory::CreateProxyResolvingSocketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ProxyToResponder> proxy(
        new ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProxyResolvingSocketFactory::CreateProxyResolvingSocketCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr, const std::optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream);
};

bool ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for ProxyResolvingSocketFactory.0
  bool success = true;
  int32_t p_result{};
  std::optional<::net::IPEndPoint> p_local_addr{};
  std::optional<::net::IPEndPoint> p_peer_addr{};
  ::mojo::ScopedDataPipeConsumerHandle p_receive_stream{};
  ::mojo::ScopedDataPipeProducerHandle p_send_stream{};
  ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
    success = false;
  if (success && !input_data_view.ReadPeerAddr(&p_peer_addr))
    success = false;
  if (success)
    p_receive_stream = input_data_view.TakeReceiveStream();
  if (success)
    p_send_stream = input_data_view.TakeSendStream();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProxyResolvingSocketFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr), 
std::move(p_peer_addr), 
std::move(p_receive_stream), 
std::move(p_send_stream));
  return true;
}

void ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ProxyToResponder::Run(
    int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr, const std::optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::ProxyResolvingSocketFactory::CreateProxyResolvingSocket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_addr"), in_peer_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_stream"), in_receive_stream,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_stream"), in_send_stream,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyResolvingSocketFactory::kCreateProxyResolvingSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr, local_addr_fragment);
  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->peer_addr)::BaseType> peer_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_peer_addr, peer_addr_fragment);
  params->peer_addr.Set(
      peer_addr_fragment.is_null() ? nullptr : peer_addr_fragment.data());
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_receive_stream, &params->receive_stream, &params.message());
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_send_stream, &params->send_stream, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolvingSocketFactory::Name_);
  message.set_method_name("CreateProxyResolvingSocket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProxyResolvingSocketFactoryStubDispatch::Accept(
    ProxyResolvingSocketFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProxyResolvingSocketFactory>(message->header()->name)) {
    case messages::ProxyResolvingSocketFactory::kCreateProxyResolvingSocket: {
      break;
    }
  }
  return false;
}

// static
bool ProxyResolvingSocketFactoryStubDispatch::AcceptWithResponder(
    ProxyResolvingSocketFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProxyResolvingSocketFactory>(message->header()->name)) {
    case messages::ProxyResolvingSocketFactory::kCreateProxyResolvingSocket: {
      internal::ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params_Data* params =
          reinterpret_cast<
              internal::ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for ProxyResolvingSocketFactory.0
      bool success = true;
      ::blink::KURL p_url{};
      ::network::mojom::blink::NetworkAnonymizationKeyPtr p_network_anonymization_key{};
      ProxyResolvingSocketOptionsPtr p_options{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingReceiver<ProxyResolvingSocket> p_socket{};
      ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> p_observer{};
      ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolvingSocketFactory::Name_, 0, false);
        return false;
      }
      ProxyResolvingSocketFactory::CreateProxyResolvingSocketCallback callback =
          ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateProxyResolvingSocket(        
        std::move(p_url), 
        std::move(p_network_anonymization_key), 
        std::move(p_options), 
        std::move(p_traffic_annotation), 
        std::move(p_socket), 
        std::move(p_observer), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProxyResolvingSocketFactoryValidationInfo[] = {
    {base::to_underlying(messages::ProxyResolvingSocketFactory::kCreateProxyResolvingSocket),
     { &internal::ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params_Data::Validate,
      &internal::ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams_Data::Validate}},
};

bool ProxyResolvingSocketFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::ProxyResolvingSocketFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProxyResolvingSocketFactoryValidationInfo);
}

bool ProxyResolvingSocketFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::ProxyResolvingSocketFactory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kProxyResolvingSocketFactoryValidationInfo);

}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::ProxyResolvingSocketOptions::DataView, ::network::mojom::blink::ProxyResolvingSocketOptionsPtr>::Read(
    ::network::mojom::blink::ProxyResolvingSocketOptions::DataView input,
    ::network::mojom::blink::ProxyResolvingSocketOptionsPtr* output) {
  bool success = true;
  ::network::mojom::blink::ProxyResolvingSocketOptionsPtr result(::network::mojom::blink::ProxyResolvingSocketOptions::New());
  
      if (success)
        result->use_tls = input.use_tls();
      if (success)
        result->fake_tls_handshake = input.fake_tls_handshake();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void ProxyResolvingSocketInterceptorForTesting::UpgradeToTLS(const ::net::HostPortPair& host_port_pair, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::blink::TLSClientSocket> receiver, ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> observer, UpgradeToTLSCallback callback) {
  GetForwardingInterface()->UpgradeToTLS(
    std::move(host_port_pair)
    , 
    std::move(traffic_annotation)
    , 
    std::move(receiver)
    , 
    std::move(observer)
    , std::move(callback));
}
ProxyResolvingSocketAsyncWaiter::ProxyResolvingSocketAsyncWaiter(
    ProxyResolvingSocket* proxy) : proxy_(proxy) {}

ProxyResolvingSocketAsyncWaiter::~ProxyResolvingSocketAsyncWaiter() = default;

void ProxyResolvingSocketAsyncWaiter::UpgradeToTLS(
    const ::net::HostPortPair& host_port_pair, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::blink::TLSClientSocket> receiver, ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> observer, int32_t* out_net_error, ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream, ::mojo::ScopedDataPipeProducerHandle* out_send_stream) {
  base::RunLoop loop;
  proxy_->UpgradeToTLS(
      std::move(host_port_pair),
      std::move(traffic_annotation),
      std::move(receiver),
      std::move(observer),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream
,
             ::mojo::ScopedDataPipeProducerHandle* out_send_stream
,
             int32_t net_error,
             ::mojo::ScopedDataPipeConsumerHandle receive_stream,
             ::mojo::ScopedDataPipeProducerHandle send_stream) {*out_net_error = std::move(net_error);*out_receive_stream = std::move(receive_stream);*out_send_stream = std::move(send_stream);
            loop->Quit();
          },
          &loop,
          out_net_error,
          out_receive_stream,
          out_send_stream));
  loop.Run();
}






void ProxyResolvingSocketFactoryInterceptorForTesting::CreateProxyResolvingSocket(const ::blink::KURL& url, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ProxyResolvingSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<ProxyResolvingSocket> socket, ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> observer, CreateProxyResolvingSocketCallback callback) {
  GetForwardingInterface()->CreateProxyResolvingSocket(
    std::move(url)
    , 
    std::move(network_anonymization_key)
    , 
    std::move(options)
    , 
    std::move(traffic_annotation)
    , 
    std::move(socket)
    , 
    std::move(observer)
    , std::move(callback));
}
ProxyResolvingSocketFactoryAsyncWaiter::ProxyResolvingSocketFactoryAsyncWaiter(
    ProxyResolvingSocketFactory* proxy) : proxy_(proxy) {}

ProxyResolvingSocketFactoryAsyncWaiter::~ProxyResolvingSocketFactoryAsyncWaiter() = default;

void ProxyResolvingSocketFactoryAsyncWaiter::CreateProxyResolvingSocket(
    const ::blink::KURL& url, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ProxyResolvingSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<ProxyResolvingSocket> socket, ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> observer, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr, std::optional<::net::IPEndPoint>* out_peer_addr, ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream, ::mojo::ScopedDataPipeProducerHandle* out_send_stream) {
  base::RunLoop loop;
  proxy_->CreateProxyResolvingSocket(
      std::move(url),
      std::move(network_anonymization_key),
      std::move(options),
      std::move(traffic_annotation),
      std::move(socket),
      std::move(observer),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             std::optional<::net::IPEndPoint>* out_local_addr
,
             std::optional<::net::IPEndPoint>* out_peer_addr
,
             ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream
,
             ::mojo::ScopedDataPipeProducerHandle* out_send_stream
,
             int32_t result,
             const std::optional<::net::IPEndPoint>& local_addr,
             const std::optional<::net::IPEndPoint>& peer_addr,
             ::mojo::ScopedDataPipeConsumerHandle receive_stream,
             ::mojo::ScopedDataPipeProducerHandle send_stream) {*out_result = std::move(result);*out_local_addr = std::move(local_addr);*out_peer_addr = std::move(peer_addr);*out_receive_stream = std::move(receive_stream);*out_send_stream = std::move(send_stream);
            loop->Quit();
          },
          &loop,
          out_result,
          out_local_addr,
          out_peer_addr,
          out_receive_stream,
          out_send_stream));
  loop.Run();
}








}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif