// services/shape_detection/public/mojom/barcodedetection_provider.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_BARCODEDETECTION_PROVIDER_MOJOM_SHARED_H_
#define SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_BARCODEDETECTION_PROVIDER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/shape_detection/public/mojom/barcodedetection_provider.mojom-shared-internal.h"
#include "services/shape_detection/public/mojom/barcodedetection.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace shape_detection::mojom {
class BarcodeDetectorOptionsDataView;



}  // shape_detection::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::shape_detection::mojom::BarcodeDetectorOptionsDataView> {
  using Data = ::shape_detection::mojom::internal::BarcodeDetectorOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace shape_detection::mojom {
// Interface base classes. They are used for type safety check.
class BarcodeDetectionProviderInterfaceBase {};

using BarcodeDetectionProviderPtrDataView =
    mojo::InterfacePtrDataView<BarcodeDetectionProviderInterfaceBase>;
using BarcodeDetectionProviderRequestDataView =
    mojo::InterfaceRequestDataView<BarcodeDetectionProviderInterfaceBase>;
using BarcodeDetectionProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BarcodeDetectionProviderInterfaceBase>;
using BarcodeDetectionProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BarcodeDetectionProviderInterfaceBase>;


class BarcodeDetectorOptionsDataView {
 public:
  BarcodeDetectorOptionsDataView() = default;

  BarcodeDetectorOptionsDataView(
      internal::BarcodeDetectorOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFormatsDataView(
      mojo::ArrayDataView<::shape_detection::mojom::BarcodeFormat>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormats(UserType* output) {
    
    auto* pointer = data_->formats.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::shape_detection::mojom::BarcodeFormat>>(
        pointer, output, message_);
  }
 private:
  internal::BarcodeDetectorOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // shape_detection::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shape_detection::mojom::BarcodeDetectorOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shape_detection::mojom::BarcodeDetectorOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shape_detection::mojom::internal::BarcodeDetectorOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::formats(input)) in_formats = Traits::formats(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->formats)::BaseType>
        formats_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& formats_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::shape_detection::mojom::internal::BarcodeFormat_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::shape_detection::mojom::BarcodeFormat>>(
        in_formats, formats_fragment, &formats_validate_params);
    fragment->formats.Set(
        formats_fragment.is_null() ? nullptr : formats_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->formats.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null formats in BarcodeDetectorOptions struct");
  }

  static bool Deserialize(::shape_detection::mojom::internal::BarcodeDetectorOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shape_detection::mojom::BarcodeDetectorOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace shape_detection::mojom {

inline void BarcodeDetectorOptionsDataView::GetFormatsDataView(
    mojo::ArrayDataView<::shape_detection::mojom::BarcodeFormat>* output) {
  auto pointer = data_->formats.Get();
  *output = mojo::ArrayDataView<::shape_detection::mojom::BarcodeFormat>(pointer, message_);
}



}  // shape_detection::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_BARCODEDETECTION_PROVIDER_MOJOM_SHARED_H_