// services/viz/public/mojom/compositing/surface_id.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_ID_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_ID_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/surface_id.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/surface_id.mojom-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom.h"
#include <string>
#include <vector>




#include "services/viz/public/cpp/compositing/surface_id_mojom_traits.h"




namespace viz::mojom {








class  SurfaceId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SurfaceId, T>::value>;
  using DataView = SurfaceIdDataView;
  using Data_ = internal::SurfaceId_Data;

  template <typename... Args>
  static SurfaceIdPtr New(Args&&... args) {
    return SurfaceIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SurfaceIdPtr From(const U& u) {
    return mojo::TypeConverter<SurfaceIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SurfaceId>::Convert(*this);
  }


  SurfaceId();

  SurfaceId(
      const ::viz::FrameSinkId& frame_sink_id,
      const ::viz::LocalSurfaceId& local_surface_id);


  ~SurfaceId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SurfaceIdPtr>
  SurfaceIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SurfaceId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SurfaceId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SurfaceId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SurfaceId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SurfaceId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SurfaceId_UnserializedMessageContext<
            UserType, SurfaceId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SurfaceId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SurfaceId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SurfaceId_UnserializedMessageContext<
            UserType, SurfaceId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SurfaceId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::FrameSinkId frame_sink_id;
  
  ::viz::LocalSurfaceId local_surface_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SurfaceId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SurfaceId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SurfaceId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SurfaceId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SurfaceIdPtr SurfaceId::Clone() const {
  return New(
      mojo::Clone(frame_sink_id),
      mojo::Clone(local_surface_id)
  );
}

template <typename T, SurfaceId::EnableIfSame<T>*>
bool SurfaceId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_sink_id, other_struct.frame_sink_id))
    return false;
  if (!mojo::Equals(this->local_surface_id, other_struct.local_surface_id))
    return false;
  return true;
}

template <typename T, SurfaceId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_sink_id < rhs.frame_sink_id)
    return true;
  if (rhs.frame_sink_id < lhs.frame_sink_id)
    return false;
  if (lhs.local_surface_id < rhs.local_surface_id)
    return true;
  if (rhs.local_surface_id < lhs.local_surface_id)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::SurfaceId::DataView,
                                         ::viz::mojom::SurfaceIdPtr> {
  static bool IsNull(const ::viz::mojom::SurfaceIdPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::SurfaceIdPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::SurfaceId::frame_sink_id)& frame_sink_id(
      const ::viz::mojom::SurfaceIdPtr& input) {
    return input->frame_sink_id;
  }

  static const decltype(::viz::mojom::SurfaceId::local_surface_id)& local_surface_id(
      const ::viz::mojom::SurfaceIdPtr& input) {
    return input->local_surface_id;
  }

  static bool Read(::viz::mojom::SurfaceId::DataView input, ::viz::mojom::SurfaceIdPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_ID_MOJOM_H_