// third_party/blink/public/mojom/ai/model_streaming_responder.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* ModelStreamingResponseStatusToStringHelper(ModelStreamingResponseStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ModelStreamingResponseStatus::kOngoing:
      return "kOngoing";
    case ModelStreamingResponseStatus::kComplete:
      return "kComplete";
    case ModelStreamingResponseStatus::kErrorUnknown:
      return "kErrorUnknown";
    case ModelStreamingResponseStatus::kErrorInvalidRequest:
      return "kErrorInvalidRequest";
    case ModelStreamingResponseStatus::kErrorRequestThrottled:
      return "kErrorRequestThrottled";
    case ModelStreamingResponseStatus::kErrorPermissionDenied:
      return "kErrorPermissionDenied";
    case ModelStreamingResponseStatus::kErrorGenericFailure:
      return "kErrorGenericFailure";
    case ModelStreamingResponseStatus::kErrorRetryableError:
      return "kErrorRetryableError";
    case ModelStreamingResponseStatus::kErrorNonRetryableError:
      return "kErrorNonRetryableError";
    case ModelStreamingResponseStatus::kErrorUnsupportedLanguage:
      return "kErrorUnsupportedLanguage";
    case ModelStreamingResponseStatus::kErrorFiltered:
      return "kErrorFiltered";
    case ModelStreamingResponseStatus::kErrorDisabled:
      return "kErrorDisabled";
    case ModelStreamingResponseStatus::kErrorCancelled:
      return "kErrorCancelled";
    case ModelStreamingResponseStatus::kErrorSessionDestroyed:
      return "kErrorSessionDestroyed";
    case ModelStreamingResponseStatus::kErrorPromptRequestTooLarge:
      return "kErrorPromptRequestTooLarge";
    case ModelStreamingResponseStatus::kErrorResponseLowQuality:
      return "kErrorResponseLowQuality";
    default:
      return nullptr;
  }
}

std::string ModelStreamingResponseStatusToString(ModelStreamingResponseStatus value) {
  const char *str = ModelStreamingResponseStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ModelStreamingResponseStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ModelStreamingResponseStatus value) {
  return os << ModelStreamingResponseStatusToString(value);
}

NOINLINE static const char* ModelStreamingResponderActionToStringHelper(ModelStreamingResponderAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ModelStreamingResponderAction::kReplace:
      return "kReplace";
    case ModelStreamingResponderAction::kAppend:
      return "kAppend";
    default:
      return nullptr;
  }
}

std::string ModelStreamingResponderActionToString(ModelStreamingResponderAction value) {
  const char *str = ModelStreamingResponderActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ModelStreamingResponderAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ModelStreamingResponderAction value) {
  return os << ModelStreamingResponderActionToString(value);
}

namespace internal {


// static
bool ModelExecutionContextInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelExecutionContextInfo_Data* object =
      static_cast<const ModelExecutionContextInfo_Data*>(data);

  return true;
}

ModelExecutionContextInfo_Data::ModelExecutionContextInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ModelStreamingResponder_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelStreamingResponder_OnError_Params_Data* object =
      static_cast<const ModelStreamingResponder_OnError_Params_Data*>(data);


  if (!::blink::mojom::internal::ModelStreamingResponseStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ModelStreamingResponder_OnError_Params_Data::ModelStreamingResponder_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ModelStreamingResponder_OnStreaming_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelStreamingResponder_OnStreaming_Params_Data* object =
      static_cast<const ModelStreamingResponder_OnStreaming_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::ModelStreamingResponderAction_Data
        ::Validate(object->action, validation_context))
    return false;

  return true;
}

ModelStreamingResponder_OnStreaming_Params_Data::ModelStreamingResponder_OnStreaming_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ModelStreamingResponder_OnCompletion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelStreamingResponder_OnCompletion_Params_Data* object =
      static_cast<const ModelStreamingResponder_OnCompletion_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->context_info, validation_context))
    return false;

  return true;
}

ModelStreamingResponder_OnCompletion_Params_Data::ModelStreamingResponder_OnCompletion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ModelStreamingResponder_OnContextOverflow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelStreamingResponder_OnContextOverflow_Params_Data* object =
      static_cast<const ModelStreamingResponder_OnContextOverflow_Params_Data*>(data);

  return true;
}

ModelStreamingResponder_OnContextOverflow_Params_Data::ModelStreamingResponder_OnContextOverflow_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ModelStreamingResponseStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ModelStreamingResponseStatus value) {
  return std::move(context).WriteString(::blink::mojom::ModelStreamingResponseStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ModelStreamingResponderAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ModelStreamingResponderAction value) {
  return std::move(context).WriteString(::blink::mojom::ModelStreamingResponderActionToString(value));
}

} // namespace perfetto