// third_party/blink/public/mojom/background_fetch/background_fetch.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* BackgroundFetchErrorToStringHelper(BackgroundFetchError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BackgroundFetchError::NONE:
      return "NONE";
    case BackgroundFetchError::DUPLICATED_DEVELOPER_ID:
      return "DUPLICATED_DEVELOPER_ID";
    case BackgroundFetchError::INVALID_ARGUMENT:
      return "INVALID_ARGUMENT";
    case BackgroundFetchError::INVALID_ID:
      return "INVALID_ID";
    case BackgroundFetchError::STORAGE_ERROR:
      return "STORAGE_ERROR";
    case BackgroundFetchError::SERVICE_WORKER_UNAVAILABLE:
      return "SERVICE_WORKER_UNAVAILABLE";
    case BackgroundFetchError::QUOTA_EXCEEDED:
      return "QUOTA_EXCEEDED";
    case BackgroundFetchError::PERMISSION_DENIED:
      return "PERMISSION_DENIED";
    case BackgroundFetchError::REGISTRATION_LIMIT_EXCEEDED:
      return "REGISTRATION_LIMIT_EXCEEDED";
    default:
      return nullptr;
  }
}

std::string BackgroundFetchErrorToString(BackgroundFetchError value) {
  const char *str = BackgroundFetchErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BackgroundFetchError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BackgroundFetchError value) {
  return os << BackgroundFetchErrorToString(value);
}

NOINLINE static const char* BackgroundFetchResultToStringHelper(BackgroundFetchResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BackgroundFetchResult::UNSET:
      return "UNSET";
    case BackgroundFetchResult::FAILURE:
      return "FAILURE";
    case BackgroundFetchResult::SUCCESS:
      return "SUCCESS";
    default:
      return nullptr;
  }
}

std::string BackgroundFetchResultToString(BackgroundFetchResult value) {
  const char *str = BackgroundFetchResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BackgroundFetchResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BackgroundFetchResult value) {
  return os << BackgroundFetchResultToString(value);
}

NOINLINE static const char* BackgroundFetchFailureReasonToStringHelper(BackgroundFetchFailureReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BackgroundFetchFailureReason::NONE:
      return "NONE";
    case BackgroundFetchFailureReason::CANCELLED_FROM_UI:
      return "CANCELLED_FROM_UI";
    case BackgroundFetchFailureReason::CANCELLED_BY_DEVELOPER:
      return "CANCELLED_BY_DEVELOPER";
    case BackgroundFetchFailureReason::BAD_STATUS:
      return "BAD_STATUS";
    case BackgroundFetchFailureReason::FETCH_ERROR:
      return "FETCH_ERROR";
    case BackgroundFetchFailureReason::SERVICE_WORKER_UNAVAILABLE:
      return "SERVICE_WORKER_UNAVAILABLE";
    case BackgroundFetchFailureReason::QUOTA_EXCEEDED:
      return "QUOTA_EXCEEDED";
    case BackgroundFetchFailureReason::DOWNLOAD_TOTAL_EXCEEDED:
      return "DOWNLOAD_TOTAL_EXCEEDED";
    default:
      return nullptr;
  }
}

std::string BackgroundFetchFailureReasonToString(BackgroundFetchFailureReason value) {
  const char *str = BackgroundFetchFailureReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BackgroundFetchFailureReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BackgroundFetchFailureReason value) {
  return os << BackgroundFetchFailureReasonToString(value);
}

namespace internal {


// static
bool BackgroundFetchSettledFetch_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchSettledFetch_Data* object =
      static_cast<const BackgroundFetchSettledFetch_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

BackgroundFetchSettledFetch_Data::BackgroundFetchSettledFetch_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchOptions_Data* object =
      static_cast<const BackgroundFetchOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icons, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->icons, validation_context,
                                         &icons_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  return true;
}

BackgroundFetchOptions_Data::BackgroundFetchOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchRegistrationData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchRegistrationData_Data* object =
      static_cast<const BackgroundFetchRegistrationData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->developer_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& developer_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->developer_id, validation_context,
                                         &developer_id_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::BackgroundFetchResult_Data
        ::Validate(object->result, validation_context))
    return false;


  if (!::blink::mojom::internal::BackgroundFetchFailureReason_Data
        ::Validate(object->failure_reason, validation_context))
    return false;

  return true;
}

BackgroundFetchRegistrationData_Data::BackgroundFetchRegistrationData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchRegistration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchRegistration_Data* object =
      static_cast<const BackgroundFetchRegistration_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registration_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->registration_data, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->registration_interface, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->registration_interface,
                                                 validation_context)) {
    return false;
  }

  return true;
}

BackgroundFetchRegistration_Data::BackgroundFetchRegistration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchUkmData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchUkmData_Data* object =
      static_cast<const BackgroundFetchUkmData_Data*>(data);

  return true;
}

BackgroundFetchUkmData_Data::BackgroundFetchUkmData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchRegistrationObserver_OnProgress_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchRegistrationObserver_OnProgress_Params_Data* object =
      static_cast<const BackgroundFetchRegistrationObserver_OnProgress_Params_Data*>(data);


  if (!::blink::mojom::internal::BackgroundFetchResult_Data
        ::Validate(object->result, validation_context))
    return false;


  if (!::blink::mojom::internal::BackgroundFetchFailureReason_Data
        ::Validate(object->failure_reason, validation_context))
    return false;

  return true;
}

BackgroundFetchRegistrationObserver_OnProgress_Params_Data::BackgroundFetchRegistrationObserver_OnProgress_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchRegistrationObserver_OnRecordsUnavailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchRegistrationObserver_OnRecordsUnavailable_Params_Data* object =
      static_cast<const BackgroundFetchRegistrationObserver_OnRecordsUnavailable_Params_Data*>(data);

  return true;
}

BackgroundFetchRegistrationObserver_OnRecordsUnavailable_Params_Data::BackgroundFetchRegistrationObserver_OnRecordsUnavailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchRegistrationObserver_OnRequestCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchRegistrationObserver_OnRequestCompleted_Params_Data* object =
      static_cast<const BackgroundFetchRegistrationObserver_OnRequestCompleted_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

BackgroundFetchRegistrationObserver_OnRequestCompleted_Params_Data::BackgroundFetchRegistrationObserver_OnRequestCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchService_Fetch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchService_Fetch_Params_Data* object =
      static_cast<const BackgroundFetchService_Fetch_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->developer_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& developer_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->developer_id, validation_context,
                                         &developer_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requests, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->requests, validation_context,
                                         &requests_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ukm_data, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ukm_data, validation_context))
    return false;

  return true;
}

BackgroundFetchService_Fetch_Params_Data::BackgroundFetchService_Fetch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchService_Fetch_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchService_Fetch_ResponseParams_Data* object =
      static_cast<const BackgroundFetchService_Fetch_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::BackgroundFetchError_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->registration, validation_context))
    return false;

  return true;
}

BackgroundFetchService_Fetch_ResponseParams_Data::BackgroundFetchService_Fetch_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchService_GetRegistration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchService_GetRegistration_Params_Data* object =
      static_cast<const BackgroundFetchService_GetRegistration_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->developer_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& developer_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->developer_id, validation_context,
                                         &developer_id_validate_params)) {
    return false;
  }

  return true;
}

BackgroundFetchService_GetRegistration_Params_Data::BackgroundFetchService_GetRegistration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchService_GetRegistration_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchService_GetRegistration_ResponseParams_Data* object =
      static_cast<const BackgroundFetchService_GetRegistration_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::BackgroundFetchError_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->registration, validation_context))
    return false;

  return true;
}

BackgroundFetchService_GetRegistration_ResponseParams_Data::BackgroundFetchService_GetRegistration_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchService_GetDeveloperIds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchService_GetDeveloperIds_Params_Data* object =
      static_cast<const BackgroundFetchService_GetDeveloperIds_Params_Data*>(data);

  return true;
}

BackgroundFetchService_GetDeveloperIds_Params_Data::BackgroundFetchService_GetDeveloperIds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchService_GetDeveloperIds_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchService_GetDeveloperIds_ResponseParams_Data* object =
      static_cast<const BackgroundFetchService_GetDeveloperIds_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::BackgroundFetchError_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->developer_ids, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& developer_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->developer_ids, validation_context,
                                         &developer_ids_validate_params)) {
    return false;
  }

  return true;
}

BackgroundFetchService_GetDeveloperIds_ResponseParams_Data::BackgroundFetchService_GetDeveloperIds_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchService_GetIconDisplaySize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchService_GetIconDisplaySize_Params_Data* object =
      static_cast<const BackgroundFetchService_GetIconDisplaySize_Params_Data*>(data);

  return true;
}

BackgroundFetchService_GetIconDisplaySize_Params_Data::BackgroundFetchService_GetIconDisplaySize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchService_GetIconDisplaySize_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchService_GetIconDisplaySize_ResponseParams_Data* object =
      static_cast<const BackgroundFetchService_GetIconDisplaySize_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_size_pixels, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon_size_pixels, validation_context))
    return false;

  return true;
}

BackgroundFetchService_GetIconDisplaySize_ResponseParams_Data::BackgroundFetchService_GetIconDisplaySize_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchRegistrationService_UpdateUI_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchRegistrationService_UpdateUI_Params_Data* object =
      static_cast<const BackgroundFetchRegistrationService_UpdateUI_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  return true;
}

BackgroundFetchRegistrationService_UpdateUI_Params_Data::BackgroundFetchRegistrationService_UpdateUI_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchRegistrationService_UpdateUI_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchRegistrationService_UpdateUI_ResponseParams_Data* object =
      static_cast<const BackgroundFetchRegistrationService_UpdateUI_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::BackgroundFetchError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

BackgroundFetchRegistrationService_UpdateUI_ResponseParams_Data::BackgroundFetchRegistrationService_UpdateUI_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchRegistrationService_Abort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchRegistrationService_Abort_Params_Data* object =
      static_cast<const BackgroundFetchRegistrationService_Abort_Params_Data*>(data);

  return true;
}

BackgroundFetchRegistrationService_Abort_Params_Data::BackgroundFetchRegistrationService_Abort_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchRegistrationService_Abort_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchRegistrationService_Abort_ResponseParams_Data* object =
      static_cast<const BackgroundFetchRegistrationService_Abort_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::BackgroundFetchError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

BackgroundFetchRegistrationService_Abort_ResponseParams_Data::BackgroundFetchRegistrationService_Abort_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchRegistrationService_MatchRequests_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchRegistrationService_MatchRequests_Params_Data* object =
      static_cast<const BackgroundFetchRegistrationService_MatchRequests_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->request_to_match, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cache_query_options, validation_context))
    return false;

  return true;
}

BackgroundFetchRegistrationService_MatchRequests_Params_Data::BackgroundFetchRegistrationService_MatchRequests_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchRegistrationService_MatchRequests_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchRegistrationService_MatchRequests_ResponseParams_Data* object =
      static_cast<const BackgroundFetchRegistrationService_MatchRequests_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fetches, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& fetches_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->fetches, validation_context,
                                         &fetches_validate_params)) {
    return false;
  }

  return true;
}

BackgroundFetchRegistrationService_MatchRequests_ResponseParams_Data::BackgroundFetchRegistrationService_MatchRequests_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundFetchRegistrationService_AddRegistrationObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundFetchRegistrationService_AddRegistrationObserver_Params_Data* object =
      static_cast<const BackgroundFetchRegistrationService_AddRegistrationObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

BackgroundFetchRegistrationService_AddRegistrationObserver_Params_Data::BackgroundFetchRegistrationService_AddRegistrationObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::BackgroundFetchError>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::BackgroundFetchError value) {
  return std::move(context).WriteString(::blink::mojom::BackgroundFetchErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::BackgroundFetchResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::BackgroundFetchResult value) {
  return std::move(context).WriteString(::blink::mojom::BackgroundFetchResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::BackgroundFetchFailureReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::BackgroundFetchFailureReason value) {
  return std::move(context).WriteString(::blink::mojom::BackgroundFetchFailureReasonToString(value));
}

} // namespace perfetto