// third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BROWSING_TOPICS_BROWSING_TOPICS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BROWSING_TOPICS_BROWSING_TOPICS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class BrowsingTopicsDocumentServiceProxy;

template <typename ImplRefTraits>
class BrowsingTopicsDocumentServiceStub;

class BrowsingTopicsDocumentServiceRequestValidator;
class BrowsingTopicsDocumentServiceResponseValidator;


class BLINK_COMMON_EXPORT BrowsingTopicsDocumentService
    : public BrowsingTopicsDocumentServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BrowsingTopicsDocumentServiceInterfaceBase;
  using Proxy_ = BrowsingTopicsDocumentServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = BrowsingTopicsDocumentServiceStub<ImplRefTraits>;

  using RequestValidator_ = BrowsingTopicsDocumentServiceRequestValidator;
  using ResponseValidator_ = BrowsingTopicsDocumentServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetBrowsingTopicsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetBrowsingTopics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BrowsingTopicsDocumentService() = default;


  using GetBrowsingTopicsCallback = base::OnceCallback<void(GetBrowsingTopicsResultPtr)>;
  
  virtual void GetBrowsingTopics(bool observe, GetBrowsingTopicsCallback callback) = 0;
};



class BLINK_COMMON_EXPORT BrowsingTopicsDocumentServiceProxy
    : public BrowsingTopicsDocumentService {
 public:
  using InterfaceType = BrowsingTopicsDocumentService;

  explicit BrowsingTopicsDocumentServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetBrowsingTopics(bool observe, GetBrowsingTopicsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT BrowsingTopicsDocumentServiceStubDispatch {
 public:
  static bool Accept(BrowsingTopicsDocumentService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BrowsingTopicsDocumentService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BrowsingTopicsDocumentService>>
class BrowsingTopicsDocumentServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BrowsingTopicsDocumentServiceStub() = default;
  ~BrowsingTopicsDocumentServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BrowsingTopicsDocumentServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BrowsingTopicsDocumentServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT BrowsingTopicsDocumentServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT BrowsingTopicsDocumentServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class BLINK_COMMON_EXPORT GetBrowsingTopicsResult {
 public:
  using DataView = GetBrowsingTopicsResultDataView;
  using Data_ = internal::GetBrowsingTopicsResult_Data;
  using Tag = Data_::GetBrowsingTopicsResult_Tag;

  template <typename... Args>
  static GetBrowsingTopicsResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |error_message|.
  static GetBrowsingTopicsResultPtr
  NewErrorMessage(
      const std::string& value) {
    auto result = GetBrowsingTopicsResultPtr(std::in_place);
    result->set_error_message(std::move(value));
    return result;
  }
  // Construct an instance holding |browsing_topics|.
  static GetBrowsingTopicsResultPtr
  NewBrowsingTopics(
      std::vector<EpochTopicPtr> value) {
    auto result = GetBrowsingTopicsResultPtr(std::in_place);
    result->set_browsing_topics(std::move(value));
    return result;
  }

  template <typename U>
  static GetBrowsingTopicsResultPtr From(const U& u) {
    return mojo::TypeConverter<GetBrowsingTopicsResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetBrowsingTopicsResult>::Convert(*this);
  }

  GetBrowsingTopicsResult();
  ~GetBrowsingTopicsResult();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  GetBrowsingTopicsResult(const GetBrowsingTopicsResult& other) = delete;
  GetBrowsingTopicsResult& operator=(const GetBrowsingTopicsResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GetBrowsingTopicsResultPtr>
  GetBrowsingTopicsResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetBrowsingTopicsResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetBrowsingTopicsResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_error_message() const { return tag_ == Tag::kErrorMessage; }

  
  std::string& get_error_message() const {
    CHECK(tag_ == Tag::kErrorMessage);
    return *(data_.error_message);
  }

  
  void set_error_message(
      const std::string& error_message);
  
  bool is_browsing_topics() const { return tag_ == Tag::kBrowsingTopics; }

  
  std::vector<EpochTopicPtr>& get_browsing_topics() const {
    CHECK(tag_ == Tag::kBrowsingTopics);
    return *(data_.browsing_topics);
  }

  
  void set_browsing_topics(
      std::vector<EpochTopicPtr> browsing_topics);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetBrowsingTopicsResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GetBrowsingTopicsResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    std::string* error_message;
    std::vector<EpochTopicPtr>* browsing_topics;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT EpochTopic {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EpochTopic, T>::value>;
  using DataView = EpochTopicDataView;
  using Data_ = internal::EpochTopic_Data;

  template <typename... Args>
  static EpochTopicPtr New(Args&&... args) {
    return EpochTopicPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EpochTopicPtr From(const U& u) {
    return mojo::TypeConverter<EpochTopicPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EpochTopic>::Convert(*this);
  }


  EpochTopic();

  EpochTopic(
      int32_t topic,
      const std::string& version,
      const std::string& config_version,
      const std::string& model_version,
      const std::string& taxonomy_version);


  ~EpochTopic();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EpochTopicPtr>
  EpochTopicPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EpochTopic::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EpochTopic::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EpochTopic_UnserializedMessageContext<
            UserType, EpochTopic::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EpochTopic::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EpochTopic::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EpochTopic_UnserializedMessageContext<
            UserType, EpochTopic::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EpochTopic::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t topic;
  
  std::string version;
  
  std::string config_version;
  
  std::string model_version;
  
  std::string taxonomy_version;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
GetBrowsingTopicsResultPtr GetBrowsingTopicsResult::Clone() const {
  switch (tag_) {
    case Tag::kErrorMessage:
      return NewErrorMessage(
          mojo::Clone(*data_.error_message));
    case Tag::kBrowsingTopics:
      return NewBrowsingTopics(
          mojo::Clone(*data_.browsing_topics));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GetBrowsingTopicsResult>::value>::type*>
bool GetBrowsingTopicsResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kErrorMessage:
      return mojo::Equals(*(data_.error_message), *(other.data_.error_message));
    case Tag::kBrowsingTopics:
      return mojo::Equals(*(data_.browsing_topics), *(other.data_.browsing_topics));
  }

  return false;
}
template <typename StructPtrType>
EpochTopicPtr EpochTopic::Clone() const {
  return New(
      mojo::Clone(topic),
      mojo::Clone(version),
      mojo::Clone(config_version),
      mojo::Clone(model_version),
      mojo::Clone(taxonomy_version)
  );
}

template <typename T, EpochTopic::EnableIfSame<T>*>
bool EpochTopic::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->topic, other_struct.topic))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->config_version, other_struct.config_version))
    return false;
  if (!mojo::Equals(this->model_version, other_struct.model_version))
    return false;
  if (!mojo::Equals(this->taxonomy_version, other_struct.taxonomy_version))
    return false;
  return true;
}

template <typename T, EpochTopic::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.topic < rhs.topic)
    return true;
  if (rhs.topic < lhs.topic)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.config_version < rhs.config_version)
    return true;
  if (rhs.config_version < lhs.config_version)
    return false;
  if (lhs.model_version < rhs.model_version)
    return true;
  if (rhs.model_version < lhs.model_version)
    return false;
  if (lhs.taxonomy_version < rhs.taxonomy_version)
    return true;
  if (rhs.taxonomy_version < lhs.taxonomy_version)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::EpochTopic::DataView,
                                         ::blink::mojom::EpochTopicPtr> {
  static bool IsNull(const ::blink::mojom::EpochTopicPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::EpochTopicPtr* output) { output->reset(); }

  static decltype(::blink::mojom::EpochTopic::topic) topic(
      const ::blink::mojom::EpochTopicPtr& input) {
    return input->topic;
  }

  static const decltype(::blink::mojom::EpochTopic::version)& version(
      const ::blink::mojom::EpochTopicPtr& input) {
    return input->version;
  }

  static const decltype(::blink::mojom::EpochTopic::config_version)& config_version(
      const ::blink::mojom::EpochTopicPtr& input) {
    return input->config_version;
  }

  static const decltype(::blink::mojom::EpochTopic::model_version)& model_version(
      const ::blink::mojom::EpochTopicPtr& input) {
    return input->model_version;
  }

  static const decltype(::blink::mojom::EpochTopic::taxonomy_version)& taxonomy_version(
      const ::blink::mojom::EpochTopicPtr& input) {
    return input->taxonomy_version;
  }

  static bool Read(::blink::mojom::EpochTopic::DataView input, ::blink::mojom::EpochTopicPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::GetBrowsingTopicsResult::DataView,
                                        ::blink::mojom::GetBrowsingTopicsResultPtr> {
  static bool IsNull(const ::blink::mojom::GetBrowsingTopicsResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::GetBrowsingTopicsResultPtr* output) { output->reset(); }

  static ::blink::mojom::GetBrowsingTopicsResult::Tag GetTag(const ::blink::mojom::GetBrowsingTopicsResultPtr& input) {
    return input->which();
  }

  static const std::string& error_message(const ::blink::mojom::GetBrowsingTopicsResultPtr& input) {
    return input->get_error_message();
  }

  static const std::vector<::blink::mojom::EpochTopicPtr>& browsing_topics(const ::blink::mojom::GetBrowsingTopicsResultPtr& input) {
    return input->get_browsing_topics();
  }

  static bool Read(::blink::mojom::GetBrowsingTopicsResult::DataView input, ::blink::mojom::GetBrowsingTopicsResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BROWSING_TOPICS_BROWSING_TOPICS_MOJOM_H_