// third_party/blink/public/mojom/worker/shared_worker_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* SharedWorkerSameSiteCookiesToStringHelper(SharedWorkerSameSiteCookies value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SharedWorkerSameSiteCookies::kAll:
      return "kAll";
    case SharedWorkerSameSiteCookies::kNone:
      return "kNone";
    default:
      return nullptr;
  }
}

std::string SharedWorkerSameSiteCookiesToString(SharedWorkerSameSiteCookies value) {
  const char *str = SharedWorkerSameSiteCookiesToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SharedWorkerSameSiteCookies value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SharedWorkerSameSiteCookies value) {
  return os << SharedWorkerSameSiteCookiesToString(value);
}

namespace internal {


// static
bool SharedWorkerInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedWorkerInfo_Data* object =
      static_cast<const SharedWorkerInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_security_policies, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_security_policies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_security_policies, validation_context,
                                         &content_security_policies_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->outside_fetch_client_settings_object, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->outside_fetch_client_settings_object, validation_context))
    return false;


  if (!::blink::mojom::internal::SharedWorkerSameSiteCookies_Data
        ::Validate(object->same_site_cookies, validation_context))
    return false;

  return true;
}

SharedWorkerInfo_Data::SharedWorkerInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SharedWorkerSameSiteCookies>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::SharedWorkerSameSiteCookies value) {
  return std::move(context).WriteString(::blink::mojom::SharedWorkerSameSiteCookiesToString(value));
}

} // namespace perfetto