#include "device.h"

// The key for the ncclDevFuncNameToId map is a 64-bit unsigned integer.
// Each field (coll, algo, proto, redop, ty, acc, pipeline) is packed into 4 bits,
// This allows up to 16 unique values per field. The layout is:
//   bits  0-3:   coll index
//   bits  4-7:   algo index
//   bits  8-11:  proto index
//   bits 12-15:  redop index
//   bits 16-19:  ty index
//   bits 20-23:  accumulator index
//   bits 24-27:  pipeline index
#include <unordered_map>
std::unordered_map<uint64_t, int> ncclDevFuncNameToId = {
  {0, 0},  // Broadcast RING LL Sum i8 0 0 1
  {256, 1},  // Broadcast RING LL128 Sum i8 0 0 1
  {512, 2},  // Broadcast RING SIMPLE Sum i8 0 0 1
  {17, 3},  // Reduce RING LL Sum i8 0 0 1
  {65553, 3},  // Reduce RING LL Sum u8 0 0 1
  {131089, 4},  // Reduce RING LL Sum i32 0 0 1
  {196625, 4},  // Reduce RING LL Sum u32 0 0 1
  {262161, 5},  // Reduce RING LL Sum i64 0 0 1
  {327697, 5},  // Reduce RING LL Sum u64 0 0 1
  {393233, 6},  // Reduce RING LL Sum f16 0 0 1
  {458769, 7},  // Reduce RING LL Sum f32 0 0 1
  {524305, 8},  // Reduce RING LL Sum f64 0 0 1
  {589841, 9},  // Reduce RING LL Sum bf16 0 0 1
  {17367057, 9},  // Reduce RING LL Sum bf16 0 1 1
  {655377, 10},  // Reduce RING LL Sum f8e4m3 0 0 1
  {720913, 11},  // Reduce RING LL Sum f8e5m2 0 0 1
  {4113, 12},  // Reduce RING LL Prod i8 0 0 1
  {69649, 12},  // Reduce RING LL Prod u8 0 0 1
  {135185, 13},  // Reduce RING LL Prod i32 0 0 1
  {200721, 13},  // Reduce RING LL Prod u32 0 0 1
  {266257, 14},  // Reduce RING LL Prod i64 0 0 1
  {331793, 14},  // Reduce RING LL Prod u64 0 0 1
  {397329, 15},  // Reduce RING LL Prod f16 0 0 1
  {462865, 16},  // Reduce RING LL Prod f32 0 0 1
  {528401, 17},  // Reduce RING LL Prod f64 0 0 1
  {593937, 18},  // Reduce RING LL Prod bf16 0 0 1
  {17371153, 18},  // Reduce RING LL Prod bf16 0 1 1
  {659473, 19},  // Reduce RING LL Prod f8e4m3 0 0 1
  {725009, 20},  // Reduce RING LL Prod f8e5m2 0 0 1
  {8209, 21},  // Reduce RING LL MinMax i8 0 0 1
  {73745, 21},  // Reduce RING LL MinMax u8 0 0 1
  {139281, 22},  // Reduce RING LL MinMax i32 0 0 1
  {204817, 22},  // Reduce RING LL MinMax u32 0 0 1
  {270353, 23},  // Reduce RING LL MinMax i64 0 0 1
  {335889, 23},  // Reduce RING LL MinMax u64 0 0 1
  {401425, 24},  // Reduce RING LL MinMax f16 0 0 1
  {466961, 25},  // Reduce RING LL MinMax f32 0 0 1
  {532497, 26},  // Reduce RING LL MinMax f64 0 0 1
  {598033, 27},  // Reduce RING LL MinMax bf16 0 0 1
  {17375249, 27},  // Reduce RING LL MinMax bf16 0 1 1
  {663569, 28},  // Reduce RING LL MinMax f8e4m3 0 0 1
  {729105, 29},  // Reduce RING LL MinMax f8e5m2 0 0 1
  {12305, 30},  // Reduce RING LL PreMulSum i8 0 0 1
  {77841, 30},  // Reduce RING LL PreMulSum u8 0 0 1
  {143377, 31},  // Reduce RING LL PreMulSum i32 0 0 1
  {208913, 31},  // Reduce RING LL PreMulSum u32 0 0 1
  {274449, 32},  // Reduce RING LL PreMulSum i64 0 0 1
  {339985, 32},  // Reduce RING LL PreMulSum u64 0 0 1
  {405521, 33},  // Reduce RING LL PreMulSum f16 0 0 1
  {471057, 34},  // Reduce RING LL PreMulSum f32 0 0 1
  {536593, 35},  // Reduce RING LL PreMulSum f64 0 0 1
  {602129, 36},  // Reduce RING LL PreMulSum bf16 0 0 1
  {17379345, 36},  // Reduce RING LL PreMulSum bf16 0 1 1
  {667665, 37},  // Reduce RING LL PreMulSum f8e4m3 0 0 1
  {733201, 38},  // Reduce RING LL PreMulSum f8e5m2 0 0 1
  {16401, 39},  // Reduce RING LL SumPostDiv i8 0 0 1
  {81937, 39},  // Reduce RING LL SumPostDiv u8 0 0 1
  {147473, 40},  // Reduce RING LL SumPostDiv i32 0 0 1
  {213009, 40},  // Reduce RING LL SumPostDiv u32 0 0 1
  {278545, 41},  // Reduce RING LL SumPostDiv i64 0 0 1
  {344081, 41},  // Reduce RING LL SumPostDiv u64 0 0 1
  {273, 42},  // Reduce RING LL128 Sum i8 0 0 1
  {65809, 42},  // Reduce RING LL128 Sum u8 0 0 1
  {131345, 43},  // Reduce RING LL128 Sum i32 0 0 1
  {196881, 43},  // Reduce RING LL128 Sum u32 0 0 1
  {262417, 44},  // Reduce RING LL128 Sum i64 0 0 1
  {327953, 44},  // Reduce RING LL128 Sum u64 0 0 1
  {393489, 45},  // Reduce RING LL128 Sum f16 0 0 1
  {459025, 46},  // Reduce RING LL128 Sum f32 0 0 1
  {524561, 47},  // Reduce RING LL128 Sum f64 0 0 1
  {590097, 48},  // Reduce RING LL128 Sum bf16 0 0 1
  {17367313, 48},  // Reduce RING LL128 Sum bf16 0 1 1
  {655633, 49},  // Reduce RING LL128 Sum f8e4m3 0 0 1
  {721169, 50},  // Reduce RING LL128 Sum f8e5m2 0 0 1
  {4369, 51},  // Reduce RING LL128 Prod i8 0 0 1
  {69905, 51},  // Reduce RING LL128 Prod u8 0 0 1
  {135441, 52},  // Reduce RING LL128 Prod i32 0 0 1
  {200977, 52},  // Reduce RING LL128 Prod u32 0 0 1
  {266513, 53},  // Reduce RING LL128 Prod i64 0 0 1
  {332049, 53},  // Reduce RING LL128 Prod u64 0 0 1
  {397585, 54},  // Reduce RING LL128 Prod f16 0 0 1
  {463121, 55},  // Reduce RING LL128 Prod f32 0 0 1
  {528657, 56},  // Reduce RING LL128 Prod f64 0 0 1
  {594193, 57},  // Reduce RING LL128 Prod bf16 0 0 1
  {17371409, 57},  // Reduce RING LL128 Prod bf16 0 1 1
  {659729, 58},  // Reduce RING LL128 Prod f8e4m3 0 0 1
  {725265, 59},  // Reduce RING LL128 Prod f8e5m2 0 0 1
  {8465, 60},  // Reduce RING LL128 MinMax i8 0 0 1
  {74001, 60},  // Reduce RING LL128 MinMax u8 0 0 1
  {139537, 61},  // Reduce RING LL128 MinMax i32 0 0 1
  {205073, 61},  // Reduce RING LL128 MinMax u32 0 0 1
  {270609, 62},  // Reduce RING LL128 MinMax i64 0 0 1
  {336145, 62},  // Reduce RING LL128 MinMax u64 0 0 1
  {401681, 63},  // Reduce RING LL128 MinMax f16 0 0 1
  {467217, 64},  // Reduce RING LL128 MinMax f32 0 0 1
  {532753, 65},  // Reduce RING LL128 MinMax f64 0 0 1
  {598289, 66},  // Reduce RING LL128 MinMax bf16 0 0 1
  {17375505, 66},  // Reduce RING LL128 MinMax bf16 0 1 1
  {663825, 67},  // Reduce RING LL128 MinMax f8e4m3 0 0 1
  {729361, 68},  // Reduce RING LL128 MinMax f8e5m2 0 0 1
  {12561, 69},  // Reduce RING LL128 PreMulSum i8 0 0 1
  {78097, 69},  // Reduce RING LL128 PreMulSum u8 0 0 1
  {143633, 70},  // Reduce RING LL128 PreMulSum i32 0 0 1
  {209169, 70},  // Reduce RING LL128 PreMulSum u32 0 0 1
  {274705, 71},  // Reduce RING LL128 PreMulSum i64 0 0 1
  {340241, 71},  // Reduce RING LL128 PreMulSum u64 0 0 1
  {405777, 72},  // Reduce RING LL128 PreMulSum f16 0 0 1
  {471313, 73},  // Reduce RING LL128 PreMulSum f32 0 0 1
  {536849, 74},  // Reduce RING LL128 PreMulSum f64 0 0 1
  {602385, 75},  // Reduce RING LL128 PreMulSum bf16 0 0 1
  {17379601, 75},  // Reduce RING LL128 PreMulSum bf16 0 1 1
  {667921, 76},  // Reduce RING LL128 PreMulSum f8e4m3 0 0 1
  {733457, 77},  // Reduce RING LL128 PreMulSum f8e5m2 0 0 1
  {16657, 78},  // Reduce RING LL128 SumPostDiv i8 0 0 1
  {82193, 78},  // Reduce RING LL128 SumPostDiv u8 0 0 1
  {147729, 79},  // Reduce RING LL128 SumPostDiv i32 0 0 1
  {213265, 79},  // Reduce RING LL128 SumPostDiv u32 0 0 1
  {278801, 80},  // Reduce RING LL128 SumPostDiv i64 0 0 1
  {344337, 80},  // Reduce RING LL128 SumPostDiv u64 0 0 1
  {529, 81},  // Reduce RING SIMPLE Sum i8 0 0 1
  {66065, 81},  // Reduce RING SIMPLE Sum u8 0 0 1
  {131601, 82},  // Reduce RING SIMPLE Sum i32 0 0 1
  {197137, 82},  // Reduce RING SIMPLE Sum u32 0 0 1
  {262673, 83},  // Reduce RING SIMPLE Sum i64 0 0 1
  {328209, 83},  // Reduce RING SIMPLE Sum u64 0 0 1
  {393745, 84},  // Reduce RING SIMPLE Sum f16 0 0 1
  {459281, 85},  // Reduce RING SIMPLE Sum f32 0 0 1
  {524817, 86},  // Reduce RING SIMPLE Sum f64 0 0 1
  {590353, 87},  // Reduce RING SIMPLE Sum bf16 0 0 1
  {17367569, 88},  // Reduce RING SIMPLE Sum bf16 0 1 1
  {655889, 89},  // Reduce RING SIMPLE Sum f8e4m3 0 0 1
  {721425, 90},  // Reduce RING SIMPLE Sum f8e5m2 0 0 1
  {4625, 91},  // Reduce RING SIMPLE Prod i8 0 0 1
  {70161, 91},  // Reduce RING SIMPLE Prod u8 0 0 1
  {135697, 92},  // Reduce RING SIMPLE Prod i32 0 0 1
  {201233, 92},  // Reduce RING SIMPLE Prod u32 0 0 1
  {266769, 93},  // Reduce RING SIMPLE Prod i64 0 0 1
  {332305, 93},  // Reduce RING SIMPLE Prod u64 0 0 1
  {397841, 94},  // Reduce RING SIMPLE Prod f16 0 0 1
  {463377, 95},  // Reduce RING SIMPLE Prod f32 0 0 1
  {528913, 96},  // Reduce RING SIMPLE Prod f64 0 0 1
  {594449, 97},  // Reduce RING SIMPLE Prod bf16 0 0 1
  {17371665, 98},  // Reduce RING SIMPLE Prod bf16 0 1 1
  {659985, 99},  // Reduce RING SIMPLE Prod f8e4m3 0 0 1
  {725521, 100},  // Reduce RING SIMPLE Prod f8e5m2 0 0 1
  {8721, 101},  // Reduce RING SIMPLE MinMax i8 0 0 1
  {74257, 101},  // Reduce RING SIMPLE MinMax u8 0 0 1
  {139793, 102},  // Reduce RING SIMPLE MinMax i32 0 0 1
  {205329, 102},  // Reduce RING SIMPLE MinMax u32 0 0 1
  {270865, 103},  // Reduce RING SIMPLE MinMax i64 0 0 1
  {336401, 103},  // Reduce RING SIMPLE MinMax u64 0 0 1
  {401937, 104},  // Reduce RING SIMPLE MinMax f16 0 0 1
  {467473, 105},  // Reduce RING SIMPLE MinMax f32 0 0 1
  {533009, 106},  // Reduce RING SIMPLE MinMax f64 0 0 1
  {598545, 107},  // Reduce RING SIMPLE MinMax bf16 0 0 1
  {17375761, 108},  // Reduce RING SIMPLE MinMax bf16 0 1 1
  {664081, 109},  // Reduce RING SIMPLE MinMax f8e4m3 0 0 1
  {729617, 110},  // Reduce RING SIMPLE MinMax f8e5m2 0 0 1
  {12817, 111},  // Reduce RING SIMPLE PreMulSum i8 0 0 1
  {78353, 111},  // Reduce RING SIMPLE PreMulSum u8 0 0 1
  {143889, 112},  // Reduce RING SIMPLE PreMulSum i32 0 0 1
  {209425, 112},  // Reduce RING SIMPLE PreMulSum u32 0 0 1
  {274961, 113},  // Reduce RING SIMPLE PreMulSum i64 0 0 1
  {340497, 113},  // Reduce RING SIMPLE PreMulSum u64 0 0 1
  {406033, 114},  // Reduce RING SIMPLE PreMulSum f16 0 0 1
  {471569, 115},  // Reduce RING SIMPLE PreMulSum f32 0 0 1
  {537105, 116},  // Reduce RING SIMPLE PreMulSum f64 0 0 1
  {602641, 117},  // Reduce RING SIMPLE PreMulSum bf16 0 0 1
  {17379857, 118},  // Reduce RING SIMPLE PreMulSum bf16 0 1 1
  {668177, 119},  // Reduce RING SIMPLE PreMulSum f8e4m3 0 0 1
  {733713, 120},  // Reduce RING SIMPLE PreMulSum f8e5m2 0 0 1
  {16913, 121},  // Reduce RING SIMPLE SumPostDiv i8 0 0 1
  {82449, 121},  // Reduce RING SIMPLE SumPostDiv u8 0 0 1
  {147985, 122},  // Reduce RING SIMPLE SumPostDiv i32 0 0 1
  {213521, 122},  // Reduce RING SIMPLE SumPostDiv u32 0 0 1
  {279057, 123},  // Reduce RING SIMPLE SumPostDiv i64 0 0 1
  {344593, 123},  // Reduce RING SIMPLE SumPostDiv u64 0 0 1
  {18, 124},  // AllGather RING LL Sum i8 0 0 1
  {274, 125},  // AllGather RING LL128 Sum i8 0 0 1
  {530, 126},  // AllGather RING SIMPLE Sum i8 0 0 1
  {98, 127},  // AllGather PAT LL Sum i8 0 0 1
  {354, 128},  // AllGather PAT LL128 Sum i8 0 0 1
  {610, 129},  // AllGather PAT SIMPLE Sum i8 0 0 1
  {19, 130},  // ReduceScatter RING LL Sum i8 0 0 1
  {65555, 130},  // ReduceScatter RING LL Sum u8 0 0 1
  {131091, 131},  // ReduceScatter RING LL Sum i32 0 0 1
  {196627, 131},  // ReduceScatter RING LL Sum u32 0 0 1
  {262163, 132},  // ReduceScatter RING LL Sum i64 0 0 1
  {327699, 132},  // ReduceScatter RING LL Sum u64 0 0 1
  {393235, 133},  // ReduceScatter RING LL Sum f16 0 0 1
  {458771, 134},  // ReduceScatter RING LL Sum f32 0 0 1
  {524307, 135},  // ReduceScatter RING LL Sum f64 0 0 1
  {589843, 136},  // ReduceScatter RING LL Sum bf16 0 0 1
  {17367059, 136},  // ReduceScatter RING LL Sum bf16 0 1 1
  {655379, 137},  // ReduceScatter RING LL Sum f8e4m3 0 0 1
  {720915, 138},  // ReduceScatter RING LL Sum f8e5m2 0 0 1
  {4115, 139},  // ReduceScatter RING LL Prod i8 0 0 1
  {69651, 139},  // ReduceScatter RING LL Prod u8 0 0 1
  {135187, 140},  // ReduceScatter RING LL Prod i32 0 0 1
  {200723, 140},  // ReduceScatter RING LL Prod u32 0 0 1
  {266259, 141},  // ReduceScatter RING LL Prod i64 0 0 1
  {331795, 141},  // ReduceScatter RING LL Prod u64 0 0 1
  {397331, 142},  // ReduceScatter RING LL Prod f16 0 0 1
  {462867, 143},  // ReduceScatter RING LL Prod f32 0 0 1
  {528403, 144},  // ReduceScatter RING LL Prod f64 0 0 1
  {593939, 145},  // ReduceScatter RING LL Prod bf16 0 0 1
  {17371155, 145},  // ReduceScatter RING LL Prod bf16 0 1 1
  {659475, 146},  // ReduceScatter RING LL Prod f8e4m3 0 0 1
  {725011, 147},  // ReduceScatter RING LL Prod f8e5m2 0 0 1
  {8211, 148},  // ReduceScatter RING LL MinMax i8 0 0 1
  {73747, 148},  // ReduceScatter RING LL MinMax u8 0 0 1
  {139283, 149},  // ReduceScatter RING LL MinMax i32 0 0 1
  {204819, 149},  // ReduceScatter RING LL MinMax u32 0 0 1
  {270355, 150},  // ReduceScatter RING LL MinMax i64 0 0 1
  {335891, 150},  // ReduceScatter RING LL MinMax u64 0 0 1
  {401427, 151},  // ReduceScatter RING LL MinMax f16 0 0 1
  {466963, 152},  // ReduceScatter RING LL MinMax f32 0 0 1
  {532499, 153},  // ReduceScatter RING LL MinMax f64 0 0 1
  {598035, 154},  // ReduceScatter RING LL MinMax bf16 0 0 1
  {17375251, 154},  // ReduceScatter RING LL MinMax bf16 0 1 1
  {663571, 155},  // ReduceScatter RING LL MinMax f8e4m3 0 0 1
  {729107, 156},  // ReduceScatter RING LL MinMax f8e5m2 0 0 1
  {12307, 157},  // ReduceScatter RING LL PreMulSum i8 0 0 1
  {77843, 157},  // ReduceScatter RING LL PreMulSum u8 0 0 1
  {143379, 158},  // ReduceScatter RING LL PreMulSum i32 0 0 1
  {208915, 158},  // ReduceScatter RING LL PreMulSum u32 0 0 1
  {274451, 159},  // ReduceScatter RING LL PreMulSum i64 0 0 1
  {339987, 159},  // ReduceScatter RING LL PreMulSum u64 0 0 1
  {405523, 160},  // ReduceScatter RING LL PreMulSum f16 0 0 1
  {471059, 161},  // ReduceScatter RING LL PreMulSum f32 0 0 1
  {536595, 162},  // ReduceScatter RING LL PreMulSum f64 0 0 1
  {602131, 163},  // ReduceScatter RING LL PreMulSum bf16 0 0 1
  {17379347, 163},  // ReduceScatter RING LL PreMulSum bf16 0 1 1
  {667667, 164},  // ReduceScatter RING LL PreMulSum f8e4m3 0 0 1
  {733203, 165},  // ReduceScatter RING LL PreMulSum f8e5m2 0 0 1
  {16403, 166},  // ReduceScatter RING LL SumPostDiv i8 0 0 1
  {81939, 166},  // ReduceScatter RING LL SumPostDiv u8 0 0 1
  {147475, 167},  // ReduceScatter RING LL SumPostDiv i32 0 0 1
  {213011, 167},  // ReduceScatter RING LL SumPostDiv u32 0 0 1
  {278547, 168},  // ReduceScatter RING LL SumPostDiv i64 0 0 1
  {344083, 168},  // ReduceScatter RING LL SumPostDiv u64 0 0 1
  {275, 169},  // ReduceScatter RING LL128 Sum i8 0 0 1
  {65811, 169},  // ReduceScatter RING LL128 Sum u8 0 0 1
  {131347, 170},  // ReduceScatter RING LL128 Sum i32 0 0 1
  {196883, 170},  // ReduceScatter RING LL128 Sum u32 0 0 1
  {262419, 171},  // ReduceScatter RING LL128 Sum i64 0 0 1
  {327955, 171},  // ReduceScatter RING LL128 Sum u64 0 0 1
  {393491, 172},  // ReduceScatter RING LL128 Sum f16 0 0 1
  {459027, 173},  // ReduceScatter RING LL128 Sum f32 0 0 1
  {524563, 174},  // ReduceScatter RING LL128 Sum f64 0 0 1
  {590099, 175},  // ReduceScatter RING LL128 Sum bf16 0 0 1
  {17367315, 175},  // ReduceScatter RING LL128 Sum bf16 0 1 1
  {655635, 176},  // ReduceScatter RING LL128 Sum f8e4m3 0 0 1
  {721171, 177},  // ReduceScatter RING LL128 Sum f8e5m2 0 0 1
  {4371, 178},  // ReduceScatter RING LL128 Prod i8 0 0 1
  {69907, 178},  // ReduceScatter RING LL128 Prod u8 0 0 1
  {135443, 179},  // ReduceScatter RING LL128 Prod i32 0 0 1
  {200979, 179},  // ReduceScatter RING LL128 Prod u32 0 0 1
  {266515, 180},  // ReduceScatter RING LL128 Prod i64 0 0 1
  {332051, 180},  // ReduceScatter RING LL128 Prod u64 0 0 1
  {397587, 181},  // ReduceScatter RING LL128 Prod f16 0 0 1
  {463123, 182},  // ReduceScatter RING LL128 Prod f32 0 0 1
  {528659, 183},  // ReduceScatter RING LL128 Prod f64 0 0 1
  {594195, 184},  // ReduceScatter RING LL128 Prod bf16 0 0 1
  {17371411, 184},  // ReduceScatter RING LL128 Prod bf16 0 1 1
  {659731, 185},  // ReduceScatter RING LL128 Prod f8e4m3 0 0 1
  {725267, 186},  // ReduceScatter RING LL128 Prod f8e5m2 0 0 1
  {8467, 187},  // ReduceScatter RING LL128 MinMax i8 0 0 1
  {74003, 187},  // ReduceScatter RING LL128 MinMax u8 0 0 1
  {139539, 188},  // ReduceScatter RING LL128 MinMax i32 0 0 1
  {205075, 188},  // ReduceScatter RING LL128 MinMax u32 0 0 1
  {270611, 189},  // ReduceScatter RING LL128 MinMax i64 0 0 1
  {336147, 189},  // ReduceScatter RING LL128 MinMax u64 0 0 1
  {401683, 190},  // ReduceScatter RING LL128 MinMax f16 0 0 1
  {467219, 191},  // ReduceScatter RING LL128 MinMax f32 0 0 1
  {532755, 192},  // ReduceScatter RING LL128 MinMax f64 0 0 1
  {598291, 193},  // ReduceScatter RING LL128 MinMax bf16 0 0 1
  {17375507, 193},  // ReduceScatter RING LL128 MinMax bf16 0 1 1
  {663827, 194},  // ReduceScatter RING LL128 MinMax f8e4m3 0 0 1
  {729363, 195},  // ReduceScatter RING LL128 MinMax f8e5m2 0 0 1
  {12563, 196},  // ReduceScatter RING LL128 PreMulSum i8 0 0 1
  {78099, 196},  // ReduceScatter RING LL128 PreMulSum u8 0 0 1
  {143635, 197},  // ReduceScatter RING LL128 PreMulSum i32 0 0 1
  {209171, 197},  // ReduceScatter RING LL128 PreMulSum u32 0 0 1
  {274707, 198},  // ReduceScatter RING LL128 PreMulSum i64 0 0 1
  {340243, 198},  // ReduceScatter RING LL128 PreMulSum u64 0 0 1
  {405779, 199},  // ReduceScatter RING LL128 PreMulSum f16 0 0 1
  {471315, 200},  // ReduceScatter RING LL128 PreMulSum f32 0 0 1
  {536851, 201},  // ReduceScatter RING LL128 PreMulSum f64 0 0 1
  {602387, 202},  // ReduceScatter RING LL128 PreMulSum bf16 0 0 1
  {17379603, 202},  // ReduceScatter RING LL128 PreMulSum bf16 0 1 1
  {667923, 203},  // ReduceScatter RING LL128 PreMulSum f8e4m3 0 0 1
  {733459, 204},  // ReduceScatter RING LL128 PreMulSum f8e5m2 0 0 1
  {16659, 205},  // ReduceScatter RING LL128 SumPostDiv i8 0 0 1
  {82195, 205},  // ReduceScatter RING LL128 SumPostDiv u8 0 0 1
  {147731, 206},  // ReduceScatter RING LL128 SumPostDiv i32 0 0 1
  {213267, 206},  // ReduceScatter RING LL128 SumPostDiv u32 0 0 1
  {278803, 207},  // ReduceScatter RING LL128 SumPostDiv i64 0 0 1
  {344339, 207},  // ReduceScatter RING LL128 SumPostDiv u64 0 0 1
  {531, 208},  // ReduceScatter RING SIMPLE Sum i8 0 0 1
  {66067, 208},  // ReduceScatter RING SIMPLE Sum u8 0 0 1
  {131603, 209},  // ReduceScatter RING SIMPLE Sum i32 0 0 1
  {197139, 209},  // ReduceScatter RING SIMPLE Sum u32 0 0 1
  {262675, 210},  // ReduceScatter RING SIMPLE Sum i64 0 0 1
  {328211, 210},  // ReduceScatter RING SIMPLE Sum u64 0 0 1
  {393747, 211},  // ReduceScatter RING SIMPLE Sum f16 0 0 1
  {459283, 212},  // ReduceScatter RING SIMPLE Sum f32 0 0 1
  {524819, 213},  // ReduceScatter RING SIMPLE Sum f64 0 0 1
  {590355, 214},  // ReduceScatter RING SIMPLE Sum bf16 0 0 1
  {17367571, 215},  // ReduceScatter RING SIMPLE Sum bf16 0 1 1
  {655891, 216},  // ReduceScatter RING SIMPLE Sum f8e4m3 0 0 1
  {721427, 217},  // ReduceScatter RING SIMPLE Sum f8e5m2 0 0 1
  {4627, 218},  // ReduceScatter RING SIMPLE Prod i8 0 0 1
  {70163, 218},  // ReduceScatter RING SIMPLE Prod u8 0 0 1
  {135699, 219},  // ReduceScatter RING SIMPLE Prod i32 0 0 1
  {201235, 219},  // ReduceScatter RING SIMPLE Prod u32 0 0 1
  {266771, 220},  // ReduceScatter RING SIMPLE Prod i64 0 0 1
  {332307, 220},  // ReduceScatter RING SIMPLE Prod u64 0 0 1
  {397843, 221},  // ReduceScatter RING SIMPLE Prod f16 0 0 1
  {463379, 222},  // ReduceScatter RING SIMPLE Prod f32 0 0 1
  {528915, 223},  // ReduceScatter RING SIMPLE Prod f64 0 0 1
  {594451, 224},  // ReduceScatter RING SIMPLE Prod bf16 0 0 1
  {17371667, 225},  // ReduceScatter RING SIMPLE Prod bf16 0 1 1
  {659987, 226},  // ReduceScatter RING SIMPLE Prod f8e4m3 0 0 1
  {725523, 227},  // ReduceScatter RING SIMPLE Prod f8e5m2 0 0 1
  {8723, 228},  // ReduceScatter RING SIMPLE MinMax i8 0 0 1
  {74259, 228},  // ReduceScatter RING SIMPLE MinMax u8 0 0 1
  {139795, 229},  // ReduceScatter RING SIMPLE MinMax i32 0 0 1
  {205331, 229},  // ReduceScatter RING SIMPLE MinMax u32 0 0 1
  {270867, 230},  // ReduceScatter RING SIMPLE MinMax i64 0 0 1
  {336403, 230},  // ReduceScatter RING SIMPLE MinMax u64 0 0 1
  {401939, 231},  // ReduceScatter RING SIMPLE MinMax f16 0 0 1
  {467475, 232},  // ReduceScatter RING SIMPLE MinMax f32 0 0 1
  {533011, 233},  // ReduceScatter RING SIMPLE MinMax f64 0 0 1
  {598547, 234},  // ReduceScatter RING SIMPLE MinMax bf16 0 0 1
  {17375763, 235},  // ReduceScatter RING SIMPLE MinMax bf16 0 1 1
  {664083, 236},  // ReduceScatter RING SIMPLE MinMax f8e4m3 0 0 1
  {729619, 237},  // ReduceScatter RING SIMPLE MinMax f8e5m2 0 0 1
  {12819, 238},  // ReduceScatter RING SIMPLE PreMulSum i8 0 0 1
  {78355, 238},  // ReduceScatter RING SIMPLE PreMulSum u8 0 0 1
  {143891, 239},  // ReduceScatter RING SIMPLE PreMulSum i32 0 0 1
  {209427, 239},  // ReduceScatter RING SIMPLE PreMulSum u32 0 0 1
  {274963, 240},  // ReduceScatter RING SIMPLE PreMulSum i64 0 0 1
  {340499, 240},  // ReduceScatter RING SIMPLE PreMulSum u64 0 0 1
  {406035, 241},  // ReduceScatter RING SIMPLE PreMulSum f16 0 0 1
  {471571, 242},  // ReduceScatter RING SIMPLE PreMulSum f32 0 0 1
  {537107, 243},  // ReduceScatter RING SIMPLE PreMulSum f64 0 0 1
  {602643, 244},  // ReduceScatter RING SIMPLE PreMulSum bf16 0 0 1
  {17379859, 245},  // ReduceScatter RING SIMPLE PreMulSum bf16 0 1 1
  {668179, 246},  // ReduceScatter RING SIMPLE PreMulSum f8e4m3 0 0 1
  {733715, 247},  // ReduceScatter RING SIMPLE PreMulSum f8e5m2 0 0 1
  {16915, 248},  // ReduceScatter RING SIMPLE SumPostDiv i8 0 0 1
  {82451, 248},  // ReduceScatter RING SIMPLE SumPostDiv u8 0 0 1
  {147987, 249},  // ReduceScatter RING SIMPLE SumPostDiv i32 0 0 1
  {213523, 249},  // ReduceScatter RING SIMPLE SumPostDiv u32 0 0 1
  {279059, 250},  // ReduceScatter RING SIMPLE SumPostDiv i64 0 0 1
  {344595, 250},  // ReduceScatter RING SIMPLE SumPostDiv u64 0 0 1
  {99, 251},  // ReduceScatter PAT LL Sum i8 0 0 1
  {65635, 251},  // ReduceScatter PAT LL Sum u8 0 0 1
  {131171, 252},  // ReduceScatter PAT LL Sum i32 0 0 1
  {196707, 252},  // ReduceScatter PAT LL Sum u32 0 0 1
  {262243, 253},  // ReduceScatter PAT LL Sum i64 0 0 1
  {327779, 253},  // ReduceScatter PAT LL Sum u64 0 0 1
  {393315, 254},  // ReduceScatter PAT LL Sum f16 0 0 1
  {458851, 255},  // ReduceScatter PAT LL Sum f32 0 0 1
  {524387, 256},  // ReduceScatter PAT LL Sum f64 0 0 1
  {589923, 257},  // ReduceScatter PAT LL Sum bf16 0 0 1
  {17367139, 257},  // ReduceScatter PAT LL Sum bf16 0 1 1
  {655459, 258},  // ReduceScatter PAT LL Sum f8e4m3 0 0 1
  {720995, 259},  // ReduceScatter PAT LL Sum f8e5m2 0 0 1
  {4195, 260},  // ReduceScatter PAT LL Prod i8 0 0 1
  {69731, 260},  // ReduceScatter PAT LL Prod u8 0 0 1
  {135267, 261},  // ReduceScatter PAT LL Prod i32 0 0 1
  {200803, 261},  // ReduceScatter PAT LL Prod u32 0 0 1
  {266339, 262},  // ReduceScatter PAT LL Prod i64 0 0 1
  {331875, 262},  // ReduceScatter PAT LL Prod u64 0 0 1
  {397411, 263},  // ReduceScatter PAT LL Prod f16 0 0 1
  {462947, 264},  // ReduceScatter PAT LL Prod f32 0 0 1
  {528483, 265},  // ReduceScatter PAT LL Prod f64 0 0 1
  {594019, 266},  // ReduceScatter PAT LL Prod bf16 0 0 1
  {17371235, 266},  // ReduceScatter PAT LL Prod bf16 0 1 1
  {659555, 267},  // ReduceScatter PAT LL Prod f8e4m3 0 0 1
  {725091, 268},  // ReduceScatter PAT LL Prod f8e5m2 0 0 1
  {8291, 269},  // ReduceScatter PAT LL MinMax i8 0 0 1
  {73827, 269},  // ReduceScatter PAT LL MinMax u8 0 0 1
  {139363, 270},  // ReduceScatter PAT LL MinMax i32 0 0 1
  {204899, 270},  // ReduceScatter PAT LL MinMax u32 0 0 1
  {270435, 271},  // ReduceScatter PAT LL MinMax i64 0 0 1
  {335971, 271},  // ReduceScatter PAT LL MinMax u64 0 0 1
  {401507, 272},  // ReduceScatter PAT LL MinMax f16 0 0 1
  {467043, 273},  // ReduceScatter PAT LL MinMax f32 0 0 1
  {532579, 274},  // ReduceScatter PAT LL MinMax f64 0 0 1
  {598115, 275},  // ReduceScatter PAT LL MinMax bf16 0 0 1
  {17375331, 275},  // ReduceScatter PAT LL MinMax bf16 0 1 1
  {663651, 276},  // ReduceScatter PAT LL MinMax f8e4m3 0 0 1
  {729187, 277},  // ReduceScatter PAT LL MinMax f8e5m2 0 0 1
  {12387, 278},  // ReduceScatter PAT LL PreMulSum i8 0 0 1
  {77923, 278},  // ReduceScatter PAT LL PreMulSum u8 0 0 1
  {143459, 279},  // ReduceScatter PAT LL PreMulSum i32 0 0 1
  {208995, 279},  // ReduceScatter PAT LL PreMulSum u32 0 0 1
  {274531, 280},  // ReduceScatter PAT LL PreMulSum i64 0 0 1
  {340067, 280},  // ReduceScatter PAT LL PreMulSum u64 0 0 1
  {405603, 281},  // ReduceScatter PAT LL PreMulSum f16 0 0 1
  {471139, 282},  // ReduceScatter PAT LL PreMulSum f32 0 0 1
  {536675, 283},  // ReduceScatter PAT LL PreMulSum f64 0 0 1
  {602211, 284},  // ReduceScatter PAT LL PreMulSum bf16 0 0 1
  {17379427, 284},  // ReduceScatter PAT LL PreMulSum bf16 0 1 1
  {667747, 285},  // ReduceScatter PAT LL PreMulSum f8e4m3 0 0 1
  {733283, 286},  // ReduceScatter PAT LL PreMulSum f8e5m2 0 0 1
  {16483, 287},  // ReduceScatter PAT LL SumPostDiv i8 0 0 1
  {82019, 287},  // ReduceScatter PAT LL SumPostDiv u8 0 0 1
  {147555, 288},  // ReduceScatter PAT LL SumPostDiv i32 0 0 1
  {213091, 288},  // ReduceScatter PAT LL SumPostDiv u32 0 0 1
  {278627, 289},  // ReduceScatter PAT LL SumPostDiv i64 0 0 1
  {344163, 289},  // ReduceScatter PAT LL SumPostDiv u64 0 0 1
  {355, 290},  // ReduceScatter PAT LL128 Sum i8 0 0 1
  {65891, 290},  // ReduceScatter PAT LL128 Sum u8 0 0 1
  {131427, 291},  // ReduceScatter PAT LL128 Sum i32 0 0 1
  {196963, 291},  // ReduceScatter PAT LL128 Sum u32 0 0 1
  {262499, 292},  // ReduceScatter PAT LL128 Sum i64 0 0 1
  {328035, 292},  // ReduceScatter PAT LL128 Sum u64 0 0 1
  {393571, 293},  // ReduceScatter PAT LL128 Sum f16 0 0 1
  {459107, 294},  // ReduceScatter PAT LL128 Sum f32 0 0 1
  {524643, 295},  // ReduceScatter PAT LL128 Sum f64 0 0 1
  {590179, 296},  // ReduceScatter PAT LL128 Sum bf16 0 0 1
  {17367395, 296},  // ReduceScatter PAT LL128 Sum bf16 0 1 1
  {655715, 297},  // ReduceScatter PAT LL128 Sum f8e4m3 0 0 1
  {721251, 298},  // ReduceScatter PAT LL128 Sum f8e5m2 0 0 1
  {4451, 299},  // ReduceScatter PAT LL128 Prod i8 0 0 1
  {69987, 299},  // ReduceScatter PAT LL128 Prod u8 0 0 1
  {135523, 300},  // ReduceScatter PAT LL128 Prod i32 0 0 1
  {201059, 300},  // ReduceScatter PAT LL128 Prod u32 0 0 1
  {266595, 301},  // ReduceScatter PAT LL128 Prod i64 0 0 1
  {332131, 301},  // ReduceScatter PAT LL128 Prod u64 0 0 1
  {397667, 302},  // ReduceScatter PAT LL128 Prod f16 0 0 1
  {463203, 303},  // ReduceScatter PAT LL128 Prod f32 0 0 1
  {528739, 304},  // ReduceScatter PAT LL128 Prod f64 0 0 1
  {594275, 305},  // ReduceScatter PAT LL128 Prod bf16 0 0 1
  {17371491, 305},  // ReduceScatter PAT LL128 Prod bf16 0 1 1
  {659811, 306},  // ReduceScatter PAT LL128 Prod f8e4m3 0 0 1
  {725347, 307},  // ReduceScatter PAT LL128 Prod f8e5m2 0 0 1
  {8547, 308},  // ReduceScatter PAT LL128 MinMax i8 0 0 1
  {74083, 308},  // ReduceScatter PAT LL128 MinMax u8 0 0 1
  {139619, 309},  // ReduceScatter PAT LL128 MinMax i32 0 0 1
  {205155, 309},  // ReduceScatter PAT LL128 MinMax u32 0 0 1
  {270691, 310},  // ReduceScatter PAT LL128 MinMax i64 0 0 1
  {336227, 310},  // ReduceScatter PAT LL128 MinMax u64 0 0 1
  {401763, 311},  // ReduceScatter PAT LL128 MinMax f16 0 0 1
  {467299, 312},  // ReduceScatter PAT LL128 MinMax f32 0 0 1
  {532835, 313},  // ReduceScatter PAT LL128 MinMax f64 0 0 1
  {598371, 314},  // ReduceScatter PAT LL128 MinMax bf16 0 0 1
  {17375587, 314},  // ReduceScatter PAT LL128 MinMax bf16 0 1 1
  {663907, 315},  // ReduceScatter PAT LL128 MinMax f8e4m3 0 0 1
  {729443, 316},  // ReduceScatter PAT LL128 MinMax f8e5m2 0 0 1
  {12643, 317},  // ReduceScatter PAT LL128 PreMulSum i8 0 0 1
  {78179, 317},  // ReduceScatter PAT LL128 PreMulSum u8 0 0 1
  {143715, 318},  // ReduceScatter PAT LL128 PreMulSum i32 0 0 1
  {209251, 318},  // ReduceScatter PAT LL128 PreMulSum u32 0 0 1
  {274787, 319},  // ReduceScatter PAT LL128 PreMulSum i64 0 0 1
  {340323, 319},  // ReduceScatter PAT LL128 PreMulSum u64 0 0 1
  {405859, 320},  // ReduceScatter PAT LL128 PreMulSum f16 0 0 1
  {471395, 321},  // ReduceScatter PAT LL128 PreMulSum f32 0 0 1
  {536931, 322},  // ReduceScatter PAT LL128 PreMulSum f64 0 0 1
  {602467, 323},  // ReduceScatter PAT LL128 PreMulSum bf16 0 0 1
  {17379683, 323},  // ReduceScatter PAT LL128 PreMulSum bf16 0 1 1
  {668003, 324},  // ReduceScatter PAT LL128 PreMulSum f8e4m3 0 0 1
  {733539, 325},  // ReduceScatter PAT LL128 PreMulSum f8e5m2 0 0 1
  {16739, 326},  // ReduceScatter PAT LL128 SumPostDiv i8 0 0 1
  {82275, 326},  // ReduceScatter PAT LL128 SumPostDiv u8 0 0 1
  {147811, 327},  // ReduceScatter PAT LL128 SumPostDiv i32 0 0 1
  {213347, 327},  // ReduceScatter PAT LL128 SumPostDiv u32 0 0 1
  {278883, 328},  // ReduceScatter PAT LL128 SumPostDiv i64 0 0 1
  {344419, 328},  // ReduceScatter PAT LL128 SumPostDiv u64 0 0 1
  {611, 329},  // ReduceScatter PAT SIMPLE Sum i8 0 0 1
  {66147, 329},  // ReduceScatter PAT SIMPLE Sum u8 0 0 1
  {131683, 330},  // ReduceScatter PAT SIMPLE Sum i32 0 0 1
  {197219, 330},  // ReduceScatter PAT SIMPLE Sum u32 0 0 1
  {262755, 331},  // ReduceScatter PAT SIMPLE Sum i64 0 0 1
  {328291, 331},  // ReduceScatter PAT SIMPLE Sum u64 0 0 1
  {393827, 332},  // ReduceScatter PAT SIMPLE Sum f16 0 0 1
  {459363, 333},  // ReduceScatter PAT SIMPLE Sum f32 0 0 1
  {524899, 334},  // ReduceScatter PAT SIMPLE Sum f64 0 0 1
  {590435, 335},  // ReduceScatter PAT SIMPLE Sum bf16 0 0 1
  {17367651, 336},  // ReduceScatter PAT SIMPLE Sum bf16 0 1 1
  {655971, 337},  // ReduceScatter PAT SIMPLE Sum f8e4m3 0 0 1
  {721507, 338},  // ReduceScatter PAT SIMPLE Sum f8e5m2 0 0 1
  {4707, 339},  // ReduceScatter PAT SIMPLE Prod i8 0 0 1
  {70243, 339},  // ReduceScatter PAT SIMPLE Prod u8 0 0 1
  {135779, 340},  // ReduceScatter PAT SIMPLE Prod i32 0 0 1
  {201315, 340},  // ReduceScatter PAT SIMPLE Prod u32 0 0 1
  {266851, 341},  // ReduceScatter PAT SIMPLE Prod i64 0 0 1
  {332387, 341},  // ReduceScatter PAT SIMPLE Prod u64 0 0 1
  {397923, 342},  // ReduceScatter PAT SIMPLE Prod f16 0 0 1
  {463459, 343},  // ReduceScatter PAT SIMPLE Prod f32 0 0 1
  {528995, 344},  // ReduceScatter PAT SIMPLE Prod f64 0 0 1
  {594531, 345},  // ReduceScatter PAT SIMPLE Prod bf16 0 0 1
  {17371747, 346},  // ReduceScatter PAT SIMPLE Prod bf16 0 1 1
  {660067, 347},  // ReduceScatter PAT SIMPLE Prod f8e4m3 0 0 1
  {725603, 348},  // ReduceScatter PAT SIMPLE Prod f8e5m2 0 0 1
  {8803, 349},  // ReduceScatter PAT SIMPLE MinMax i8 0 0 1
  {74339, 349},  // ReduceScatter PAT SIMPLE MinMax u8 0 0 1
  {139875, 350},  // ReduceScatter PAT SIMPLE MinMax i32 0 0 1
  {205411, 350},  // ReduceScatter PAT SIMPLE MinMax u32 0 0 1
  {270947, 351},  // ReduceScatter PAT SIMPLE MinMax i64 0 0 1
  {336483, 351},  // ReduceScatter PAT SIMPLE MinMax u64 0 0 1
  {402019, 352},  // ReduceScatter PAT SIMPLE MinMax f16 0 0 1
  {467555, 353},  // ReduceScatter PAT SIMPLE MinMax f32 0 0 1
  {533091, 354},  // ReduceScatter PAT SIMPLE MinMax f64 0 0 1
  {598627, 355},  // ReduceScatter PAT SIMPLE MinMax bf16 0 0 1
  {17375843, 356},  // ReduceScatter PAT SIMPLE MinMax bf16 0 1 1
  {664163, 357},  // ReduceScatter PAT SIMPLE MinMax f8e4m3 0 0 1
  {729699, 358},  // ReduceScatter PAT SIMPLE MinMax f8e5m2 0 0 1
  {12899, 359},  // ReduceScatter PAT SIMPLE PreMulSum i8 0 0 1
  {78435, 359},  // ReduceScatter PAT SIMPLE PreMulSum u8 0 0 1
  {143971, 360},  // ReduceScatter PAT SIMPLE PreMulSum i32 0 0 1
  {209507, 360},  // ReduceScatter PAT SIMPLE PreMulSum u32 0 0 1
  {275043, 361},  // ReduceScatter PAT SIMPLE PreMulSum i64 0 0 1
  {340579, 361},  // ReduceScatter PAT SIMPLE PreMulSum u64 0 0 1
  {406115, 362},  // ReduceScatter PAT SIMPLE PreMulSum f16 0 0 1
  {471651, 363},  // ReduceScatter PAT SIMPLE PreMulSum f32 0 0 1
  {537187, 364},  // ReduceScatter PAT SIMPLE PreMulSum f64 0 0 1
  {602723, 365},  // ReduceScatter PAT SIMPLE PreMulSum bf16 0 0 1
  {17379939, 366},  // ReduceScatter PAT SIMPLE PreMulSum bf16 0 1 1
  {668259, 367},  // ReduceScatter PAT SIMPLE PreMulSum f8e4m3 0 0 1
  {733795, 368},  // ReduceScatter PAT SIMPLE PreMulSum f8e5m2 0 0 1
  {16995, 369},  // ReduceScatter PAT SIMPLE SumPostDiv i8 0 0 1
  {82531, 369},  // ReduceScatter PAT SIMPLE SumPostDiv u8 0 0 1
  {148067, 370},  // ReduceScatter PAT SIMPLE SumPostDiv i32 0 0 1
  {213603, 370},  // ReduceScatter PAT SIMPLE SumPostDiv u32 0 0 1
  {279139, 371},  // ReduceScatter PAT SIMPLE SumPostDiv i64 0 0 1
  {344675, 371},  // ReduceScatter PAT SIMPLE SumPostDiv u64 0 0 1
  {4, 372},  // AllReduce TREE LL Sum i8 0 0 1
  {1048580, 373},  // AllReduce TREE LL Sum i8 1 0 1
  {65540, 372},  // AllReduce TREE LL Sum u8 0 0 1
  {1114116, 373},  // AllReduce TREE LL Sum u8 1 0 1
  {131076, 374},  // AllReduce TREE LL Sum i32 0 0 1
  {1179652, 375},  // AllReduce TREE LL Sum i32 1 0 1
  {196612, 374},  // AllReduce TREE LL Sum u32 0 0 1
  {1245188, 375},  // AllReduce TREE LL Sum u32 1 0 1
  {262148, 376},  // AllReduce TREE LL Sum i64 0 0 1
  {1310724, 377},  // AllReduce TREE LL Sum i64 1 0 1
  {327684, 376},  // AllReduce TREE LL Sum u64 0 0 1
  {1376260, 377},  // AllReduce TREE LL Sum u64 1 0 1
  {393220, 378},  // AllReduce TREE LL Sum f16 0 0 1
  {1441796, 379},  // AllReduce TREE LL Sum f16 1 0 1
  {458756, 380},  // AllReduce TREE LL Sum f32 0 0 1
  {1507332, 381},  // AllReduce TREE LL Sum f32 1 0 1
  {524292, 382},  // AllReduce TREE LL Sum f64 0 0 1
  {1572868, 383},  // AllReduce TREE LL Sum f64 1 0 1
  {589828, 384},  // AllReduce TREE LL Sum bf16 0 0 1
  {17367044, 384},  // AllReduce TREE LL Sum bf16 0 1 1
  {1638404, 385},  // AllReduce TREE LL Sum bf16 1 0 1
  {18415620, 385},  // AllReduce TREE LL Sum bf16 1 1 1
  {655364, 386},  // AllReduce TREE LL Sum f8e4m3 0 0 1
  {1703940, 387},  // AllReduce TREE LL Sum f8e4m3 1 0 1
  {720900, 388},  // AllReduce TREE LL Sum f8e5m2 0 0 1
  {1769476, 389},  // AllReduce TREE LL Sum f8e5m2 1 0 1
  {4100, 390},  // AllReduce TREE LL Prod i8 0 0 1
  {1052676, 391},  // AllReduce TREE LL Prod i8 1 0 1
  {69636, 390},  // AllReduce TREE LL Prod u8 0 0 1
  {1118212, 391},  // AllReduce TREE LL Prod u8 1 0 1
  {135172, 392},  // AllReduce TREE LL Prod i32 0 0 1
  {1183748, 393},  // AllReduce TREE LL Prod i32 1 0 1
  {200708, 392},  // AllReduce TREE LL Prod u32 0 0 1
  {1249284, 393},  // AllReduce TREE LL Prod u32 1 0 1
  {266244, 394},  // AllReduce TREE LL Prod i64 0 0 1
  {1314820, 395},  // AllReduce TREE LL Prod i64 1 0 1
  {331780, 394},  // AllReduce TREE LL Prod u64 0 0 1
  {1380356, 395},  // AllReduce TREE LL Prod u64 1 0 1
  {397316, 396},  // AllReduce TREE LL Prod f16 0 0 1
  {1445892, 397},  // AllReduce TREE LL Prod f16 1 0 1
  {462852, 398},  // AllReduce TREE LL Prod f32 0 0 1
  {1511428, 399},  // AllReduce TREE LL Prod f32 1 0 1
  {528388, 400},  // AllReduce TREE LL Prod f64 0 0 1
  {1576964, 401},  // AllReduce TREE LL Prod f64 1 0 1
  {593924, 402},  // AllReduce TREE LL Prod bf16 0 0 1
  {17371140, 402},  // AllReduce TREE LL Prod bf16 0 1 1
  {1642500, 403},  // AllReduce TREE LL Prod bf16 1 0 1
  {18419716, 403},  // AllReduce TREE LL Prod bf16 1 1 1
  {659460, 404},  // AllReduce TREE LL Prod f8e4m3 0 0 1
  {1708036, 405},  // AllReduce TREE LL Prod f8e4m3 1 0 1
  {724996, 406},  // AllReduce TREE LL Prod f8e5m2 0 0 1
  {1773572, 407},  // AllReduce TREE LL Prod f8e5m2 1 0 1
  {8196, 408},  // AllReduce TREE LL MinMax i8 0 0 1
  {1056772, 409},  // AllReduce TREE LL MinMax i8 1 0 1
  {73732, 408},  // AllReduce TREE LL MinMax u8 0 0 1
  {1122308, 409},  // AllReduce TREE LL MinMax u8 1 0 1
  {139268, 410},  // AllReduce TREE LL MinMax i32 0 0 1
  {1187844, 411},  // AllReduce TREE LL MinMax i32 1 0 1
  {204804, 410},  // AllReduce TREE LL MinMax u32 0 0 1
  {1253380, 411},  // AllReduce TREE LL MinMax u32 1 0 1
  {270340, 412},  // AllReduce TREE LL MinMax i64 0 0 1
  {1318916, 413},  // AllReduce TREE LL MinMax i64 1 0 1
  {335876, 412},  // AllReduce TREE LL MinMax u64 0 0 1
  {1384452, 413},  // AllReduce TREE LL MinMax u64 1 0 1
  {401412, 414},  // AllReduce TREE LL MinMax f16 0 0 1
  {1449988, 415},  // AllReduce TREE LL MinMax f16 1 0 1
  {466948, 416},  // AllReduce TREE LL MinMax f32 0 0 1
  {1515524, 417},  // AllReduce TREE LL MinMax f32 1 0 1
  {532484, 418},  // AllReduce TREE LL MinMax f64 0 0 1
  {1581060, 419},  // AllReduce TREE LL MinMax f64 1 0 1
  {598020, 420},  // AllReduce TREE LL MinMax bf16 0 0 1
  {17375236, 420},  // AllReduce TREE LL MinMax bf16 0 1 1
  {1646596, 421},  // AllReduce TREE LL MinMax bf16 1 0 1
  {18423812, 421},  // AllReduce TREE LL MinMax bf16 1 1 1
  {663556, 422},  // AllReduce TREE LL MinMax f8e4m3 0 0 1
  {1712132, 423},  // AllReduce TREE LL MinMax f8e4m3 1 0 1
  {729092, 424},  // AllReduce TREE LL MinMax f8e5m2 0 0 1
  {1777668, 425},  // AllReduce TREE LL MinMax f8e5m2 1 0 1
  {12292, 426},  // AllReduce TREE LL PreMulSum i8 0 0 1
  {1060868, 427},  // AllReduce TREE LL PreMulSum i8 1 0 1
  {77828, 426},  // AllReduce TREE LL PreMulSum u8 0 0 1
  {1126404, 427},  // AllReduce TREE LL PreMulSum u8 1 0 1
  {143364, 428},  // AllReduce TREE LL PreMulSum i32 0 0 1
  {1191940, 429},  // AllReduce TREE LL PreMulSum i32 1 0 1
  {208900, 428},  // AllReduce TREE LL PreMulSum u32 0 0 1
  {1257476, 429},  // AllReduce TREE LL PreMulSum u32 1 0 1
  {274436, 430},  // AllReduce TREE LL PreMulSum i64 0 0 1
  {1323012, 431},  // AllReduce TREE LL PreMulSum i64 1 0 1
  {339972, 430},  // AllReduce TREE LL PreMulSum u64 0 0 1
  {1388548, 431},  // AllReduce TREE LL PreMulSum u64 1 0 1
  {405508, 432},  // AllReduce TREE LL PreMulSum f16 0 0 1
  {1454084, 433},  // AllReduce TREE LL PreMulSum f16 1 0 1
  {471044, 434},  // AllReduce TREE LL PreMulSum f32 0 0 1
  {1519620, 435},  // AllReduce TREE LL PreMulSum f32 1 0 1
  {536580, 436},  // AllReduce TREE LL PreMulSum f64 0 0 1
  {1585156, 437},  // AllReduce TREE LL PreMulSum f64 1 0 1
  {602116, 438},  // AllReduce TREE LL PreMulSum bf16 0 0 1
  {17379332, 438},  // AllReduce TREE LL PreMulSum bf16 0 1 1
  {1650692, 439},  // AllReduce TREE LL PreMulSum bf16 1 0 1
  {18427908, 439},  // AllReduce TREE LL PreMulSum bf16 1 1 1
  {667652, 440},  // AllReduce TREE LL PreMulSum f8e4m3 0 0 1
  {1716228, 441},  // AllReduce TREE LL PreMulSum f8e4m3 1 0 1
  {733188, 442},  // AllReduce TREE LL PreMulSum f8e5m2 0 0 1
  {1781764, 443},  // AllReduce TREE LL PreMulSum f8e5m2 1 0 1
  {16388, 444},  // AllReduce TREE LL SumPostDiv i8 0 0 1
  {1064964, 445},  // AllReduce TREE LL SumPostDiv i8 1 0 1
  {81924, 444},  // AllReduce TREE LL SumPostDiv u8 0 0 1
  {1130500, 445},  // AllReduce TREE LL SumPostDiv u8 1 0 1
  {147460, 446},  // AllReduce TREE LL SumPostDiv i32 0 0 1
  {1196036, 447},  // AllReduce TREE LL SumPostDiv i32 1 0 1
  {212996, 446},  // AllReduce TREE LL SumPostDiv u32 0 0 1
  {1261572, 447},  // AllReduce TREE LL SumPostDiv u32 1 0 1
  {278532, 448},  // AllReduce TREE LL SumPostDiv i64 0 0 1
  {1327108, 449},  // AllReduce TREE LL SumPostDiv i64 1 0 1
  {344068, 448},  // AllReduce TREE LL SumPostDiv u64 0 0 1
  {1392644, 449},  // AllReduce TREE LL SumPostDiv u64 1 0 1
  {260, 450},  // AllReduce TREE LL128 Sum i8 0 0 1
  {1048836, 451},  // AllReduce TREE LL128 Sum i8 1 0 1
  {65796, 450},  // AllReduce TREE LL128 Sum u8 0 0 1
  {1114372, 451},  // AllReduce TREE LL128 Sum u8 1 0 1
  {131332, 452},  // AllReduce TREE LL128 Sum i32 0 0 1
  {1179908, 453},  // AllReduce TREE LL128 Sum i32 1 0 1
  {196868, 452},  // AllReduce TREE LL128 Sum u32 0 0 1
  {1245444, 453},  // AllReduce TREE LL128 Sum u32 1 0 1
  {262404, 454},  // AllReduce TREE LL128 Sum i64 0 0 1
  {1310980, 455},  // AllReduce TREE LL128 Sum i64 1 0 1
  {327940, 454},  // AllReduce TREE LL128 Sum u64 0 0 1
  {1376516, 455},  // AllReduce TREE LL128 Sum u64 1 0 1
  {393476, 456},  // AllReduce TREE LL128 Sum f16 0 0 1
  {1442052, 457},  // AllReduce TREE LL128 Sum f16 1 0 1
  {459012, 458},  // AllReduce TREE LL128 Sum f32 0 0 1
  {1507588, 459},  // AllReduce TREE LL128 Sum f32 1 0 1
  {524548, 460},  // AllReduce TREE LL128 Sum f64 0 0 1
  {1573124, 461},  // AllReduce TREE LL128 Sum f64 1 0 1
  {590084, 462},  // AllReduce TREE LL128 Sum bf16 0 0 1
  {17367300, 462},  // AllReduce TREE LL128 Sum bf16 0 1 1
  {1638660, 463},  // AllReduce TREE LL128 Sum bf16 1 0 1
  {18415876, 463},  // AllReduce TREE LL128 Sum bf16 1 1 1
  {655620, 464},  // AllReduce TREE LL128 Sum f8e4m3 0 0 1
  {1704196, 465},  // AllReduce TREE LL128 Sum f8e4m3 1 0 1
  {721156, 466},  // AllReduce TREE LL128 Sum f8e5m2 0 0 1
  {1769732, 467},  // AllReduce TREE LL128 Sum f8e5m2 1 0 1
  {4356, 468},  // AllReduce TREE LL128 Prod i8 0 0 1
  {1052932, 469},  // AllReduce TREE LL128 Prod i8 1 0 1
  {69892, 468},  // AllReduce TREE LL128 Prod u8 0 0 1
  {1118468, 469},  // AllReduce TREE LL128 Prod u8 1 0 1
  {135428, 470},  // AllReduce TREE LL128 Prod i32 0 0 1
  {1184004, 471},  // AllReduce TREE LL128 Prod i32 1 0 1
  {200964, 470},  // AllReduce TREE LL128 Prod u32 0 0 1
  {1249540, 471},  // AllReduce TREE LL128 Prod u32 1 0 1
  {266500, 472},  // AllReduce TREE LL128 Prod i64 0 0 1
  {1315076, 473},  // AllReduce TREE LL128 Prod i64 1 0 1
  {332036, 472},  // AllReduce TREE LL128 Prod u64 0 0 1
  {1380612, 473},  // AllReduce TREE LL128 Prod u64 1 0 1
  {397572, 474},  // AllReduce TREE LL128 Prod f16 0 0 1
  {1446148, 475},  // AllReduce TREE LL128 Prod f16 1 0 1
  {463108, 476},  // AllReduce TREE LL128 Prod f32 0 0 1
  {1511684, 477},  // AllReduce TREE LL128 Prod f32 1 0 1
  {528644, 478},  // AllReduce TREE LL128 Prod f64 0 0 1
  {1577220, 479},  // AllReduce TREE LL128 Prod f64 1 0 1
  {594180, 480},  // AllReduce TREE LL128 Prod bf16 0 0 1
  {17371396, 480},  // AllReduce TREE LL128 Prod bf16 0 1 1
  {1642756, 481},  // AllReduce TREE LL128 Prod bf16 1 0 1
  {18419972, 481},  // AllReduce TREE LL128 Prod bf16 1 1 1
  {659716, 482},  // AllReduce TREE LL128 Prod f8e4m3 0 0 1
  {1708292, 483},  // AllReduce TREE LL128 Prod f8e4m3 1 0 1
  {725252, 484},  // AllReduce TREE LL128 Prod f8e5m2 0 0 1
  {1773828, 485},  // AllReduce TREE LL128 Prod f8e5m2 1 0 1
  {8452, 486},  // AllReduce TREE LL128 MinMax i8 0 0 1
  {1057028, 487},  // AllReduce TREE LL128 MinMax i8 1 0 1
  {73988, 486},  // AllReduce TREE LL128 MinMax u8 0 0 1
  {1122564, 487},  // AllReduce TREE LL128 MinMax u8 1 0 1
  {139524, 488},  // AllReduce TREE LL128 MinMax i32 0 0 1
  {1188100, 489},  // AllReduce TREE LL128 MinMax i32 1 0 1
  {205060, 488},  // AllReduce TREE LL128 MinMax u32 0 0 1
  {1253636, 489},  // AllReduce TREE LL128 MinMax u32 1 0 1
  {270596, 490},  // AllReduce TREE LL128 MinMax i64 0 0 1
  {1319172, 491},  // AllReduce TREE LL128 MinMax i64 1 0 1
  {336132, 490},  // AllReduce TREE LL128 MinMax u64 0 0 1
  {1384708, 491},  // AllReduce TREE LL128 MinMax u64 1 0 1
  {401668, 492},  // AllReduce TREE LL128 MinMax f16 0 0 1
  {1450244, 493},  // AllReduce TREE LL128 MinMax f16 1 0 1
  {467204, 494},  // AllReduce TREE LL128 MinMax f32 0 0 1
  {1515780, 495},  // AllReduce TREE LL128 MinMax f32 1 0 1
  {532740, 496},  // AllReduce TREE LL128 MinMax f64 0 0 1
  {1581316, 497},  // AllReduce TREE LL128 MinMax f64 1 0 1
  {598276, 498},  // AllReduce TREE LL128 MinMax bf16 0 0 1
  {17375492, 498},  // AllReduce TREE LL128 MinMax bf16 0 1 1
  {1646852, 499},  // AllReduce TREE LL128 MinMax bf16 1 0 1
  {18424068, 499},  // AllReduce TREE LL128 MinMax bf16 1 1 1
  {663812, 500},  // AllReduce TREE LL128 MinMax f8e4m3 0 0 1
  {1712388, 501},  // AllReduce TREE LL128 MinMax f8e4m3 1 0 1
  {729348, 502},  // AllReduce TREE LL128 MinMax f8e5m2 0 0 1
  {1777924, 503},  // AllReduce TREE LL128 MinMax f8e5m2 1 0 1
  {12548, 504},  // AllReduce TREE LL128 PreMulSum i8 0 0 1
  {1061124, 505},  // AllReduce TREE LL128 PreMulSum i8 1 0 1
  {78084, 504},  // AllReduce TREE LL128 PreMulSum u8 0 0 1
  {1126660, 505},  // AllReduce TREE LL128 PreMulSum u8 1 0 1
  {143620, 506},  // AllReduce TREE LL128 PreMulSum i32 0 0 1
  {1192196, 507},  // AllReduce TREE LL128 PreMulSum i32 1 0 1
  {209156, 506},  // AllReduce TREE LL128 PreMulSum u32 0 0 1
  {1257732, 507},  // AllReduce TREE LL128 PreMulSum u32 1 0 1
  {274692, 508},  // AllReduce TREE LL128 PreMulSum i64 0 0 1
  {1323268, 509},  // AllReduce TREE LL128 PreMulSum i64 1 0 1
  {340228, 508},  // AllReduce TREE LL128 PreMulSum u64 0 0 1
  {1388804, 509},  // AllReduce TREE LL128 PreMulSum u64 1 0 1
  {405764, 510},  // AllReduce TREE LL128 PreMulSum f16 0 0 1
  {1454340, 511},  // AllReduce TREE LL128 PreMulSum f16 1 0 1
  {471300, 512},  // AllReduce TREE LL128 PreMulSum f32 0 0 1
  {1519876, 513},  // AllReduce TREE LL128 PreMulSum f32 1 0 1
  {536836, 514},  // AllReduce TREE LL128 PreMulSum f64 0 0 1
  {1585412, 515},  // AllReduce TREE LL128 PreMulSum f64 1 0 1
  {602372, 516},  // AllReduce TREE LL128 PreMulSum bf16 0 0 1
  {17379588, 516},  // AllReduce TREE LL128 PreMulSum bf16 0 1 1
  {1650948, 517},  // AllReduce TREE LL128 PreMulSum bf16 1 0 1
  {18428164, 517},  // AllReduce TREE LL128 PreMulSum bf16 1 1 1
  {667908, 518},  // AllReduce TREE LL128 PreMulSum f8e4m3 0 0 1
  {1716484, 519},  // AllReduce TREE LL128 PreMulSum f8e4m3 1 0 1
  {733444, 520},  // AllReduce TREE LL128 PreMulSum f8e5m2 0 0 1
  {1782020, 521},  // AllReduce TREE LL128 PreMulSum f8e5m2 1 0 1
  {16644, 522},  // AllReduce TREE LL128 SumPostDiv i8 0 0 1
  {1065220, 523},  // AllReduce TREE LL128 SumPostDiv i8 1 0 1
  {82180, 522},  // AllReduce TREE LL128 SumPostDiv u8 0 0 1
  {1130756, 523},  // AllReduce TREE LL128 SumPostDiv u8 1 0 1
  {147716, 524},  // AllReduce TREE LL128 SumPostDiv i32 0 0 1
  {1196292, 525},  // AllReduce TREE LL128 SumPostDiv i32 1 0 1
  {213252, 524},  // AllReduce TREE LL128 SumPostDiv u32 0 0 1
  {1261828, 525},  // AllReduce TREE LL128 SumPostDiv u32 1 0 1
  {278788, 526},  // AllReduce TREE LL128 SumPostDiv i64 0 0 1
  {1327364, 527},  // AllReduce TREE LL128 SumPostDiv i64 1 0 1
  {344324, 526},  // AllReduce TREE LL128 SumPostDiv u64 0 0 1
  {1392900, 527},  // AllReduce TREE LL128 SumPostDiv u64 1 0 1
  {516, 528},  // AllReduce TREE SIMPLE Sum i8 0 0 1
  {1049092, 529},  // AllReduce TREE SIMPLE Sum i8 1 0 1
  {66052, 528},  // AllReduce TREE SIMPLE Sum u8 0 0 1
  {1114628, 529},  // AllReduce TREE SIMPLE Sum u8 1 0 1
  {131588, 530},  // AllReduce TREE SIMPLE Sum i32 0 0 1
  {1180164, 531},  // AllReduce TREE SIMPLE Sum i32 1 0 1
  {197124, 530},  // AllReduce TREE SIMPLE Sum u32 0 0 1
  {1245700, 531},  // AllReduce TREE SIMPLE Sum u32 1 0 1
  {262660, 532},  // AllReduce TREE SIMPLE Sum i64 0 0 1
  {1311236, 533},  // AllReduce TREE SIMPLE Sum i64 1 0 1
  {328196, 532},  // AllReduce TREE SIMPLE Sum u64 0 0 1
  {1376772, 533},  // AllReduce TREE SIMPLE Sum u64 1 0 1
  {393732, 534},  // AllReduce TREE SIMPLE Sum f16 0 0 1
  {1442308, 535},  // AllReduce TREE SIMPLE Sum f16 1 0 1
  {459268, 536},  // AllReduce TREE SIMPLE Sum f32 0 0 1
  {1507844, 537},  // AllReduce TREE SIMPLE Sum f32 1 0 1
  {524804, 538},  // AllReduce TREE SIMPLE Sum f64 0 0 1
  {1573380, 539},  // AllReduce TREE SIMPLE Sum f64 1 0 1
  {590340, 540},  // AllReduce TREE SIMPLE Sum bf16 0 0 1
  {17367556, 541},  // AllReduce TREE SIMPLE Sum bf16 0 1 1
  {1638916, 542},  // AllReduce TREE SIMPLE Sum bf16 1 0 1
  {18416132, 543},  // AllReduce TREE SIMPLE Sum bf16 1 1 1
  {655876, 544},  // AllReduce TREE SIMPLE Sum f8e4m3 0 0 1
  {1704452, 545},  // AllReduce TREE SIMPLE Sum f8e4m3 1 0 1
  {721412, 546},  // AllReduce TREE SIMPLE Sum f8e5m2 0 0 1
  {1769988, 547},  // AllReduce TREE SIMPLE Sum f8e5m2 1 0 1
  {4612, 548},  // AllReduce TREE SIMPLE Prod i8 0 0 1
  {1053188, 549},  // AllReduce TREE SIMPLE Prod i8 1 0 1
  {70148, 548},  // AllReduce TREE SIMPLE Prod u8 0 0 1
  {1118724, 549},  // AllReduce TREE SIMPLE Prod u8 1 0 1
  {135684, 550},  // AllReduce TREE SIMPLE Prod i32 0 0 1
  {1184260, 551},  // AllReduce TREE SIMPLE Prod i32 1 0 1
  {201220, 550},  // AllReduce TREE SIMPLE Prod u32 0 0 1
  {1249796, 551},  // AllReduce TREE SIMPLE Prod u32 1 0 1
  {266756, 552},  // AllReduce TREE SIMPLE Prod i64 0 0 1
  {1315332, 553},  // AllReduce TREE SIMPLE Prod i64 1 0 1
  {332292, 552},  // AllReduce TREE SIMPLE Prod u64 0 0 1
  {1380868, 553},  // AllReduce TREE SIMPLE Prod u64 1 0 1
  {397828, 554},  // AllReduce TREE SIMPLE Prod f16 0 0 1
  {1446404, 555},  // AllReduce TREE SIMPLE Prod f16 1 0 1
  {463364, 556},  // AllReduce TREE SIMPLE Prod f32 0 0 1
  {1511940, 557},  // AllReduce TREE SIMPLE Prod f32 1 0 1
  {528900, 558},  // AllReduce TREE SIMPLE Prod f64 0 0 1
  {1577476, 559},  // AllReduce TREE SIMPLE Prod f64 1 0 1
  {594436, 560},  // AllReduce TREE SIMPLE Prod bf16 0 0 1
  {17371652, 561},  // AllReduce TREE SIMPLE Prod bf16 0 1 1
  {1643012, 562},  // AllReduce TREE SIMPLE Prod bf16 1 0 1
  {18420228, 563},  // AllReduce TREE SIMPLE Prod bf16 1 1 1
  {659972, 564},  // AllReduce TREE SIMPLE Prod f8e4m3 0 0 1
  {1708548, 565},  // AllReduce TREE SIMPLE Prod f8e4m3 1 0 1
  {725508, 566},  // AllReduce TREE SIMPLE Prod f8e5m2 0 0 1
  {1774084, 567},  // AllReduce TREE SIMPLE Prod f8e5m2 1 0 1
  {8708, 568},  // AllReduce TREE SIMPLE MinMax i8 0 0 1
  {1057284, 569},  // AllReduce TREE SIMPLE MinMax i8 1 0 1
  {74244, 568},  // AllReduce TREE SIMPLE MinMax u8 0 0 1
  {1122820, 569},  // AllReduce TREE SIMPLE MinMax u8 1 0 1
  {139780, 570},  // AllReduce TREE SIMPLE MinMax i32 0 0 1
  {1188356, 571},  // AllReduce TREE SIMPLE MinMax i32 1 0 1
  {205316, 570},  // AllReduce TREE SIMPLE MinMax u32 0 0 1
  {1253892, 571},  // AllReduce TREE SIMPLE MinMax u32 1 0 1
  {270852, 572},  // AllReduce TREE SIMPLE MinMax i64 0 0 1
  {1319428, 573},  // AllReduce TREE SIMPLE MinMax i64 1 0 1
  {336388, 572},  // AllReduce TREE SIMPLE MinMax u64 0 0 1
  {1384964, 573},  // AllReduce TREE SIMPLE MinMax u64 1 0 1
  {401924, 574},  // AllReduce TREE SIMPLE MinMax f16 0 0 1
  {1450500, 575},  // AllReduce TREE SIMPLE MinMax f16 1 0 1
  {467460, 576},  // AllReduce TREE SIMPLE MinMax f32 0 0 1
  {1516036, 577},  // AllReduce TREE SIMPLE MinMax f32 1 0 1
  {532996, 578},  // AllReduce TREE SIMPLE MinMax f64 0 0 1
  {1581572, 579},  // AllReduce TREE SIMPLE MinMax f64 1 0 1
  {598532, 580},  // AllReduce TREE SIMPLE MinMax bf16 0 0 1
  {17375748, 581},  // AllReduce TREE SIMPLE MinMax bf16 0 1 1
  {1647108, 582},  // AllReduce TREE SIMPLE MinMax bf16 1 0 1
  {18424324, 583},  // AllReduce TREE SIMPLE MinMax bf16 1 1 1
  {664068, 584},  // AllReduce TREE SIMPLE MinMax f8e4m3 0 0 1
  {1712644, 585},  // AllReduce TREE SIMPLE MinMax f8e4m3 1 0 1
  {729604, 586},  // AllReduce TREE SIMPLE MinMax f8e5m2 0 0 1
  {1778180, 587},  // AllReduce TREE SIMPLE MinMax f8e5m2 1 0 1
  {12804, 588},  // AllReduce TREE SIMPLE PreMulSum i8 0 0 1
  {1061380, 589},  // AllReduce TREE SIMPLE PreMulSum i8 1 0 1
  {78340, 588},  // AllReduce TREE SIMPLE PreMulSum u8 0 0 1
  {1126916, 589},  // AllReduce TREE SIMPLE PreMulSum u8 1 0 1
  {143876, 590},  // AllReduce TREE SIMPLE PreMulSum i32 0 0 1
  {1192452, 591},  // AllReduce TREE SIMPLE PreMulSum i32 1 0 1
  {209412, 590},  // AllReduce TREE SIMPLE PreMulSum u32 0 0 1
  {1257988, 591},  // AllReduce TREE SIMPLE PreMulSum u32 1 0 1
  {274948, 592},  // AllReduce TREE SIMPLE PreMulSum i64 0 0 1
  {1323524, 593},  // AllReduce TREE SIMPLE PreMulSum i64 1 0 1
  {340484, 592},  // AllReduce TREE SIMPLE PreMulSum u64 0 0 1
  {1389060, 593},  // AllReduce TREE SIMPLE PreMulSum u64 1 0 1
  {406020, 594},  // AllReduce TREE SIMPLE PreMulSum f16 0 0 1
  {1454596, 595},  // AllReduce TREE SIMPLE PreMulSum f16 1 0 1
  {471556, 596},  // AllReduce TREE SIMPLE PreMulSum f32 0 0 1
  {1520132, 597},  // AllReduce TREE SIMPLE PreMulSum f32 1 0 1
  {537092, 598},  // AllReduce TREE SIMPLE PreMulSum f64 0 0 1
  {1585668, 599},  // AllReduce TREE SIMPLE PreMulSum f64 1 0 1
  {602628, 600},  // AllReduce TREE SIMPLE PreMulSum bf16 0 0 1
  {17379844, 601},  // AllReduce TREE SIMPLE PreMulSum bf16 0 1 1
  {1651204, 602},  // AllReduce TREE SIMPLE PreMulSum bf16 1 0 1
  {18428420, 603},  // AllReduce TREE SIMPLE PreMulSum bf16 1 1 1
  {668164, 604},  // AllReduce TREE SIMPLE PreMulSum f8e4m3 0 0 1
  {1716740, 605},  // AllReduce TREE SIMPLE PreMulSum f8e4m3 1 0 1
  {733700, 606},  // AllReduce TREE SIMPLE PreMulSum f8e5m2 0 0 1
  {1782276, 607},  // AllReduce TREE SIMPLE PreMulSum f8e5m2 1 0 1
  {16900, 608},  // AllReduce TREE SIMPLE SumPostDiv i8 0 0 1
  {1065476, 609},  // AllReduce TREE SIMPLE SumPostDiv i8 1 0 1
  {82436, 608},  // AllReduce TREE SIMPLE SumPostDiv u8 0 0 1
  {1131012, 609},  // AllReduce TREE SIMPLE SumPostDiv u8 1 0 1
  {147972, 610},  // AllReduce TREE SIMPLE SumPostDiv i32 0 0 1
  {1196548, 611},  // AllReduce TREE SIMPLE SumPostDiv i32 1 0 1
  {213508, 610},  // AllReduce TREE SIMPLE SumPostDiv u32 0 0 1
  {1262084, 611},  // AllReduce TREE SIMPLE SumPostDiv u32 1 0 1
  {279044, 612},  // AllReduce TREE SIMPLE SumPostDiv i64 0 0 1
  {1327620, 613},  // AllReduce TREE SIMPLE SumPostDiv i64 1 0 1
  {344580, 612},  // AllReduce TREE SIMPLE SumPostDiv u64 0 0 1
  {1393156, 613},  // AllReduce TREE SIMPLE SumPostDiv u64 1 0 1
  {20, 614},  // AllReduce RING LL Sum i8 0 0 1
  {1048596, 615},  // AllReduce RING LL Sum i8 1 0 1
  {65556, 614},  // AllReduce RING LL Sum u8 0 0 1
  {1114132, 615},  // AllReduce RING LL Sum u8 1 0 1
  {131092, 616},  // AllReduce RING LL Sum i32 0 0 1
  {1179668, 617},  // AllReduce RING LL Sum i32 1 0 1
  {196628, 616},  // AllReduce RING LL Sum u32 0 0 1
  {1245204, 617},  // AllReduce RING LL Sum u32 1 0 1
  {262164, 618},  // AllReduce RING LL Sum i64 0 0 1
  {1310740, 619},  // AllReduce RING LL Sum i64 1 0 1
  {327700, 618},  // AllReduce RING LL Sum u64 0 0 1
  {1376276, 619},  // AllReduce RING LL Sum u64 1 0 1
  {393236, 620},  // AllReduce RING LL Sum f16 0 0 1
  {1441812, 621},  // AllReduce RING LL Sum f16 1 0 1
  {458772, 622},  // AllReduce RING LL Sum f32 0 0 1
  {1507348, 623},  // AllReduce RING LL Sum f32 1 0 1
  {524308, 624},  // AllReduce RING LL Sum f64 0 0 1
  {1572884, 625},  // AllReduce RING LL Sum f64 1 0 1
  {589844, 626},  // AllReduce RING LL Sum bf16 0 0 1
  {17367060, 626},  // AllReduce RING LL Sum bf16 0 1 1
  {1638420, 627},  // AllReduce RING LL Sum bf16 1 0 1
  {18415636, 627},  // AllReduce RING LL Sum bf16 1 1 1
  {655380, 628},  // AllReduce RING LL Sum f8e4m3 0 0 1
  {1703956, 629},  // AllReduce RING LL Sum f8e4m3 1 0 1
  {720916, 630},  // AllReduce RING LL Sum f8e5m2 0 0 1
  {1769492, 631},  // AllReduce RING LL Sum f8e5m2 1 0 1
  {4116, 632},  // AllReduce RING LL Prod i8 0 0 1
  {1052692, 633},  // AllReduce RING LL Prod i8 1 0 1
  {69652, 632},  // AllReduce RING LL Prod u8 0 0 1
  {1118228, 633},  // AllReduce RING LL Prod u8 1 0 1
  {135188, 634},  // AllReduce RING LL Prod i32 0 0 1
  {1183764, 635},  // AllReduce RING LL Prod i32 1 0 1
  {200724, 634},  // AllReduce RING LL Prod u32 0 0 1
  {1249300, 635},  // AllReduce RING LL Prod u32 1 0 1
  {266260, 636},  // AllReduce RING LL Prod i64 0 0 1
  {1314836, 637},  // AllReduce RING LL Prod i64 1 0 1
  {331796, 636},  // AllReduce RING LL Prod u64 0 0 1
  {1380372, 637},  // AllReduce RING LL Prod u64 1 0 1
  {397332, 638},  // AllReduce RING LL Prod f16 0 0 1
  {1445908, 639},  // AllReduce RING LL Prod f16 1 0 1
  {462868, 640},  // AllReduce RING LL Prod f32 0 0 1
  {1511444, 641},  // AllReduce RING LL Prod f32 1 0 1
  {528404, 642},  // AllReduce RING LL Prod f64 0 0 1
  {1576980, 643},  // AllReduce RING LL Prod f64 1 0 1
  {593940, 644},  // AllReduce RING LL Prod bf16 0 0 1
  {17371156, 644},  // AllReduce RING LL Prod bf16 0 1 1
  {1642516, 645},  // AllReduce RING LL Prod bf16 1 0 1
  {18419732, 645},  // AllReduce RING LL Prod bf16 1 1 1
  {659476, 646},  // AllReduce RING LL Prod f8e4m3 0 0 1
  {1708052, 647},  // AllReduce RING LL Prod f8e4m3 1 0 1
  {725012, 648},  // AllReduce RING LL Prod f8e5m2 0 0 1
  {1773588, 649},  // AllReduce RING LL Prod f8e5m2 1 0 1
  {8212, 650},  // AllReduce RING LL MinMax i8 0 0 1
  {1056788, 651},  // AllReduce RING LL MinMax i8 1 0 1
  {73748, 650},  // AllReduce RING LL MinMax u8 0 0 1
  {1122324, 651},  // AllReduce RING LL MinMax u8 1 0 1
  {139284, 652},  // AllReduce RING LL MinMax i32 0 0 1
  {1187860, 653},  // AllReduce RING LL MinMax i32 1 0 1
  {204820, 652},  // AllReduce RING LL MinMax u32 0 0 1
  {1253396, 653},  // AllReduce RING LL MinMax u32 1 0 1
  {270356, 654},  // AllReduce RING LL MinMax i64 0 0 1
  {1318932, 655},  // AllReduce RING LL MinMax i64 1 0 1
  {335892, 654},  // AllReduce RING LL MinMax u64 0 0 1
  {1384468, 655},  // AllReduce RING LL MinMax u64 1 0 1
  {401428, 656},  // AllReduce RING LL MinMax f16 0 0 1
  {1450004, 657},  // AllReduce RING LL MinMax f16 1 0 1
  {466964, 658},  // AllReduce RING LL MinMax f32 0 0 1
  {1515540, 659},  // AllReduce RING LL MinMax f32 1 0 1
  {532500, 660},  // AllReduce RING LL MinMax f64 0 0 1
  {1581076, 661},  // AllReduce RING LL MinMax f64 1 0 1
  {598036, 662},  // AllReduce RING LL MinMax bf16 0 0 1
  {17375252, 662},  // AllReduce RING LL MinMax bf16 0 1 1
  {1646612, 663},  // AllReduce RING LL MinMax bf16 1 0 1
  {18423828, 663},  // AllReduce RING LL MinMax bf16 1 1 1
  {663572, 664},  // AllReduce RING LL MinMax f8e4m3 0 0 1
  {1712148, 665},  // AllReduce RING LL MinMax f8e4m3 1 0 1
  {729108, 666},  // AllReduce RING LL MinMax f8e5m2 0 0 1
  {1777684, 667},  // AllReduce RING LL MinMax f8e5m2 1 0 1
  {12308, 668},  // AllReduce RING LL PreMulSum i8 0 0 1
  {1060884, 669},  // AllReduce RING LL PreMulSum i8 1 0 1
  {77844, 668},  // AllReduce RING LL PreMulSum u8 0 0 1
  {1126420, 669},  // AllReduce RING LL PreMulSum u8 1 0 1
  {143380, 670},  // AllReduce RING LL PreMulSum i32 0 0 1
  {1191956, 671},  // AllReduce RING LL PreMulSum i32 1 0 1
  {208916, 670},  // AllReduce RING LL PreMulSum u32 0 0 1
  {1257492, 671},  // AllReduce RING LL PreMulSum u32 1 0 1
  {274452, 672},  // AllReduce RING LL PreMulSum i64 0 0 1
  {1323028, 673},  // AllReduce RING LL PreMulSum i64 1 0 1
  {339988, 672},  // AllReduce RING LL PreMulSum u64 0 0 1
  {1388564, 673},  // AllReduce RING LL PreMulSum u64 1 0 1
  {405524, 674},  // AllReduce RING LL PreMulSum f16 0 0 1
  {1454100, 675},  // AllReduce RING LL PreMulSum f16 1 0 1
  {471060, 676},  // AllReduce RING LL PreMulSum f32 0 0 1
  {1519636, 677},  // AllReduce RING LL PreMulSum f32 1 0 1
  {536596, 678},  // AllReduce RING LL PreMulSum f64 0 0 1
  {1585172, 679},  // AllReduce RING LL PreMulSum f64 1 0 1
  {602132, 680},  // AllReduce RING LL PreMulSum bf16 0 0 1
  {17379348, 680},  // AllReduce RING LL PreMulSum bf16 0 1 1
  {1650708, 681},  // AllReduce RING LL PreMulSum bf16 1 0 1
  {18427924, 681},  // AllReduce RING LL PreMulSum bf16 1 1 1
  {667668, 682},  // AllReduce RING LL PreMulSum f8e4m3 0 0 1
  {1716244, 683},  // AllReduce RING LL PreMulSum f8e4m3 1 0 1
  {733204, 684},  // AllReduce RING LL PreMulSum f8e5m2 0 0 1
  {1781780, 685},  // AllReduce RING LL PreMulSum f8e5m2 1 0 1
  {16404, 686},  // AllReduce RING LL SumPostDiv i8 0 0 1
  {1064980, 687},  // AllReduce RING LL SumPostDiv i8 1 0 1
  {81940, 686},  // AllReduce RING LL SumPostDiv u8 0 0 1
  {1130516, 687},  // AllReduce RING LL SumPostDiv u8 1 0 1
  {147476, 688},  // AllReduce RING LL SumPostDiv i32 0 0 1
  {1196052, 689},  // AllReduce RING LL SumPostDiv i32 1 0 1
  {213012, 688},  // AllReduce RING LL SumPostDiv u32 0 0 1
  {1261588, 689},  // AllReduce RING LL SumPostDiv u32 1 0 1
  {278548, 690},  // AllReduce RING LL SumPostDiv i64 0 0 1
  {1327124, 691},  // AllReduce RING LL SumPostDiv i64 1 0 1
  {344084, 690},  // AllReduce RING LL SumPostDiv u64 0 0 1
  {1392660, 691},  // AllReduce RING LL SumPostDiv u64 1 0 1
  {276, 692},  // AllReduce RING LL128 Sum i8 0 0 1
  {1048852, 693},  // AllReduce RING LL128 Sum i8 1 0 1
  {65812, 692},  // AllReduce RING LL128 Sum u8 0 0 1
  {1114388, 693},  // AllReduce RING LL128 Sum u8 1 0 1
  {131348, 694},  // AllReduce RING LL128 Sum i32 0 0 1
  {1179924, 695},  // AllReduce RING LL128 Sum i32 1 0 1
  {196884, 694},  // AllReduce RING LL128 Sum u32 0 0 1
  {1245460, 695},  // AllReduce RING LL128 Sum u32 1 0 1
  {262420, 696},  // AllReduce RING LL128 Sum i64 0 0 1
  {1310996, 697},  // AllReduce RING LL128 Sum i64 1 0 1
  {327956, 696},  // AllReduce RING LL128 Sum u64 0 0 1
  {1376532, 697},  // AllReduce RING LL128 Sum u64 1 0 1
  {393492, 698},  // AllReduce RING LL128 Sum f16 0 0 1
  {1442068, 699},  // AllReduce RING LL128 Sum f16 1 0 1
  {459028, 700},  // AllReduce RING LL128 Sum f32 0 0 1
  {1507604, 701},  // AllReduce RING LL128 Sum f32 1 0 1
  {524564, 702},  // AllReduce RING LL128 Sum f64 0 0 1
  {1573140, 703},  // AllReduce RING LL128 Sum f64 1 0 1
  {590100, 704},  // AllReduce RING LL128 Sum bf16 0 0 1
  {17367316, 704},  // AllReduce RING LL128 Sum bf16 0 1 1
  {1638676, 705},  // AllReduce RING LL128 Sum bf16 1 0 1
  {18415892, 705},  // AllReduce RING LL128 Sum bf16 1 1 1
  {655636, 706},  // AllReduce RING LL128 Sum f8e4m3 0 0 1
  {1704212, 707},  // AllReduce RING LL128 Sum f8e4m3 1 0 1
  {721172, 708},  // AllReduce RING LL128 Sum f8e5m2 0 0 1
  {1769748, 709},  // AllReduce RING LL128 Sum f8e5m2 1 0 1
  {4372, 710},  // AllReduce RING LL128 Prod i8 0 0 1
  {1052948, 711},  // AllReduce RING LL128 Prod i8 1 0 1
  {69908, 710},  // AllReduce RING LL128 Prod u8 0 0 1
  {1118484, 711},  // AllReduce RING LL128 Prod u8 1 0 1
  {135444, 712},  // AllReduce RING LL128 Prod i32 0 0 1
  {1184020, 713},  // AllReduce RING LL128 Prod i32 1 0 1
  {200980, 712},  // AllReduce RING LL128 Prod u32 0 0 1
  {1249556, 713},  // AllReduce RING LL128 Prod u32 1 0 1
  {266516, 714},  // AllReduce RING LL128 Prod i64 0 0 1
  {1315092, 715},  // AllReduce RING LL128 Prod i64 1 0 1
  {332052, 714},  // AllReduce RING LL128 Prod u64 0 0 1
  {1380628, 715},  // AllReduce RING LL128 Prod u64 1 0 1
  {397588, 716},  // AllReduce RING LL128 Prod f16 0 0 1
  {1446164, 717},  // AllReduce RING LL128 Prod f16 1 0 1
  {463124, 718},  // AllReduce RING LL128 Prod f32 0 0 1
  {1511700, 719},  // AllReduce RING LL128 Prod f32 1 0 1
  {528660, 720},  // AllReduce RING LL128 Prod f64 0 0 1
  {1577236, 721},  // AllReduce RING LL128 Prod f64 1 0 1
  {594196, 722},  // AllReduce RING LL128 Prod bf16 0 0 1
  {17371412, 722},  // AllReduce RING LL128 Prod bf16 0 1 1
  {1642772, 723},  // AllReduce RING LL128 Prod bf16 1 0 1
  {18419988, 723},  // AllReduce RING LL128 Prod bf16 1 1 1
  {659732, 724},  // AllReduce RING LL128 Prod f8e4m3 0 0 1
  {1708308, 725},  // AllReduce RING LL128 Prod f8e4m3 1 0 1
  {725268, 726},  // AllReduce RING LL128 Prod f8e5m2 0 0 1
  {1773844, 727},  // AllReduce RING LL128 Prod f8e5m2 1 0 1
  {8468, 728},  // AllReduce RING LL128 MinMax i8 0 0 1
  {1057044, 729},  // AllReduce RING LL128 MinMax i8 1 0 1
  {74004, 728},  // AllReduce RING LL128 MinMax u8 0 0 1
  {1122580, 729},  // AllReduce RING LL128 MinMax u8 1 0 1
  {139540, 730},  // AllReduce RING LL128 MinMax i32 0 0 1
  {1188116, 731},  // AllReduce RING LL128 MinMax i32 1 0 1
  {205076, 730},  // AllReduce RING LL128 MinMax u32 0 0 1
  {1253652, 731},  // AllReduce RING LL128 MinMax u32 1 0 1
  {270612, 732},  // AllReduce RING LL128 MinMax i64 0 0 1
  {1319188, 733},  // AllReduce RING LL128 MinMax i64 1 0 1
  {336148, 732},  // AllReduce RING LL128 MinMax u64 0 0 1
  {1384724, 733},  // AllReduce RING LL128 MinMax u64 1 0 1
  {401684, 734},  // AllReduce RING LL128 MinMax f16 0 0 1
  {1450260, 735},  // AllReduce RING LL128 MinMax f16 1 0 1
  {467220, 736},  // AllReduce RING LL128 MinMax f32 0 0 1
  {1515796, 737},  // AllReduce RING LL128 MinMax f32 1 0 1
  {532756, 738},  // AllReduce RING LL128 MinMax f64 0 0 1
  {1581332, 739},  // AllReduce RING LL128 MinMax f64 1 0 1
  {598292, 740},  // AllReduce RING LL128 MinMax bf16 0 0 1
  {17375508, 740},  // AllReduce RING LL128 MinMax bf16 0 1 1
  {1646868, 741},  // AllReduce RING LL128 MinMax bf16 1 0 1
  {18424084, 741},  // AllReduce RING LL128 MinMax bf16 1 1 1
  {663828, 742},  // AllReduce RING LL128 MinMax f8e4m3 0 0 1
  {1712404, 743},  // AllReduce RING LL128 MinMax f8e4m3 1 0 1
  {729364, 744},  // AllReduce RING LL128 MinMax f8e5m2 0 0 1
  {1777940, 745},  // AllReduce RING LL128 MinMax f8e5m2 1 0 1
  {12564, 746},  // AllReduce RING LL128 PreMulSum i8 0 0 1
  {1061140, 747},  // AllReduce RING LL128 PreMulSum i8 1 0 1
  {78100, 746},  // AllReduce RING LL128 PreMulSum u8 0 0 1
  {1126676, 747},  // AllReduce RING LL128 PreMulSum u8 1 0 1
  {143636, 748},  // AllReduce RING LL128 PreMulSum i32 0 0 1
  {1192212, 749},  // AllReduce RING LL128 PreMulSum i32 1 0 1
  {209172, 748},  // AllReduce RING LL128 PreMulSum u32 0 0 1
  {1257748, 749},  // AllReduce RING LL128 PreMulSum u32 1 0 1
  {274708, 750},  // AllReduce RING LL128 PreMulSum i64 0 0 1
  {1323284, 751},  // AllReduce RING LL128 PreMulSum i64 1 0 1
  {340244, 750},  // AllReduce RING LL128 PreMulSum u64 0 0 1
  {1388820, 751},  // AllReduce RING LL128 PreMulSum u64 1 0 1
  {405780, 752},  // AllReduce RING LL128 PreMulSum f16 0 0 1
  {1454356, 753},  // AllReduce RING LL128 PreMulSum f16 1 0 1
  {471316, 754},  // AllReduce RING LL128 PreMulSum f32 0 0 1
  {1519892, 755},  // AllReduce RING LL128 PreMulSum f32 1 0 1
  {536852, 756},  // AllReduce RING LL128 PreMulSum f64 0 0 1
  {1585428, 757},  // AllReduce RING LL128 PreMulSum f64 1 0 1
  {602388, 758},  // AllReduce RING LL128 PreMulSum bf16 0 0 1
  {17379604, 758},  // AllReduce RING LL128 PreMulSum bf16 0 1 1
  {1650964, 759},  // AllReduce RING LL128 PreMulSum bf16 1 0 1
  {18428180, 759},  // AllReduce RING LL128 PreMulSum bf16 1 1 1
  {667924, 760},  // AllReduce RING LL128 PreMulSum f8e4m3 0 0 1
  {1716500, 761},  // AllReduce RING LL128 PreMulSum f8e4m3 1 0 1
  {733460, 762},  // AllReduce RING LL128 PreMulSum f8e5m2 0 0 1
  {1782036, 763},  // AllReduce RING LL128 PreMulSum f8e5m2 1 0 1
  {16660, 764},  // AllReduce RING LL128 SumPostDiv i8 0 0 1
  {1065236, 765},  // AllReduce RING LL128 SumPostDiv i8 1 0 1
  {82196, 764},  // AllReduce RING LL128 SumPostDiv u8 0 0 1
  {1130772, 765},  // AllReduce RING LL128 SumPostDiv u8 1 0 1
  {147732, 766},  // AllReduce RING LL128 SumPostDiv i32 0 0 1
  {1196308, 767},  // AllReduce RING LL128 SumPostDiv i32 1 0 1
  {213268, 766},  // AllReduce RING LL128 SumPostDiv u32 0 0 1
  {1261844, 767},  // AllReduce RING LL128 SumPostDiv u32 1 0 1
  {278804, 768},  // AllReduce RING LL128 SumPostDiv i64 0 0 1
  {1327380, 769},  // AllReduce RING LL128 SumPostDiv i64 1 0 1
  {344340, 768},  // AllReduce RING LL128 SumPostDiv u64 0 0 1
  {1392916, 769},  // AllReduce RING LL128 SumPostDiv u64 1 0 1
  {532, 770},  // AllReduce RING SIMPLE Sum i8 0 0 1
  {1049108, 771},  // AllReduce RING SIMPLE Sum i8 1 0 1
  {66068, 770},  // AllReduce RING SIMPLE Sum u8 0 0 1
  {1114644, 771},  // AllReduce RING SIMPLE Sum u8 1 0 1
  {131604, 772},  // AllReduce RING SIMPLE Sum i32 0 0 1
  {1180180, 773},  // AllReduce RING SIMPLE Sum i32 1 0 1
  {197140, 772},  // AllReduce RING SIMPLE Sum u32 0 0 1
  {1245716, 773},  // AllReduce RING SIMPLE Sum u32 1 0 1
  {262676, 774},  // AllReduce RING SIMPLE Sum i64 0 0 1
  {1311252, 775},  // AllReduce RING SIMPLE Sum i64 1 0 1
  {328212, 774},  // AllReduce RING SIMPLE Sum u64 0 0 1
  {1376788, 775},  // AllReduce RING SIMPLE Sum u64 1 0 1
  {393748, 776},  // AllReduce RING SIMPLE Sum f16 0 0 1
  {1442324, 777},  // AllReduce RING SIMPLE Sum f16 1 0 1
  {459284, 778},  // AllReduce RING SIMPLE Sum f32 0 0 1
  {1507860, 779},  // AllReduce RING SIMPLE Sum f32 1 0 1
  {524820, 780},  // AllReduce RING SIMPLE Sum f64 0 0 1
  {1573396, 781},  // AllReduce RING SIMPLE Sum f64 1 0 1
  {590356, 782},  // AllReduce RING SIMPLE Sum bf16 0 0 1
  {17367572, 783},  // AllReduce RING SIMPLE Sum bf16 0 1 1
  {1638932, 784},  // AllReduce RING SIMPLE Sum bf16 1 0 1
  {18416148, 785},  // AllReduce RING SIMPLE Sum bf16 1 1 1
  {655892, 786},  // AllReduce RING SIMPLE Sum f8e4m3 0 0 1
  {1704468, 787},  // AllReduce RING SIMPLE Sum f8e4m3 1 0 1
  {721428, 788},  // AllReduce RING SIMPLE Sum f8e5m2 0 0 1
  {1770004, 789},  // AllReduce RING SIMPLE Sum f8e5m2 1 0 1
  {4628, 790},  // AllReduce RING SIMPLE Prod i8 0 0 1
  {1053204, 791},  // AllReduce RING SIMPLE Prod i8 1 0 1
  {70164, 790},  // AllReduce RING SIMPLE Prod u8 0 0 1
  {1118740, 791},  // AllReduce RING SIMPLE Prod u8 1 0 1
  {135700, 792},  // AllReduce RING SIMPLE Prod i32 0 0 1
  {1184276, 793},  // AllReduce RING SIMPLE Prod i32 1 0 1
  {201236, 792},  // AllReduce RING SIMPLE Prod u32 0 0 1
  {1249812, 793},  // AllReduce RING SIMPLE Prod u32 1 0 1
  {266772, 794},  // AllReduce RING SIMPLE Prod i64 0 0 1
  {1315348, 795},  // AllReduce RING SIMPLE Prod i64 1 0 1
  {332308, 794},  // AllReduce RING SIMPLE Prod u64 0 0 1
  {1380884, 795},  // AllReduce RING SIMPLE Prod u64 1 0 1
  {397844, 796},  // AllReduce RING SIMPLE Prod f16 0 0 1
  {1446420, 797},  // AllReduce RING SIMPLE Prod f16 1 0 1
  {463380, 798},  // AllReduce RING SIMPLE Prod f32 0 0 1
  {1511956, 799},  // AllReduce RING SIMPLE Prod f32 1 0 1
  {528916, 800},  // AllReduce RING SIMPLE Prod f64 0 0 1
  {1577492, 801},  // AllReduce RING SIMPLE Prod f64 1 0 1
  {594452, 802},  // AllReduce RING SIMPLE Prod bf16 0 0 1
  {17371668, 803},  // AllReduce RING SIMPLE Prod bf16 0 1 1
  {1643028, 804},  // AllReduce RING SIMPLE Prod bf16 1 0 1
  {18420244, 805},  // AllReduce RING SIMPLE Prod bf16 1 1 1
  {659988, 806},  // AllReduce RING SIMPLE Prod f8e4m3 0 0 1
  {1708564, 807},  // AllReduce RING SIMPLE Prod f8e4m3 1 0 1
  {725524, 808},  // AllReduce RING SIMPLE Prod f8e5m2 0 0 1
  {1774100, 809},  // AllReduce RING SIMPLE Prod f8e5m2 1 0 1
  {8724, 810},  // AllReduce RING SIMPLE MinMax i8 0 0 1
  {1057300, 811},  // AllReduce RING SIMPLE MinMax i8 1 0 1
  {74260, 810},  // AllReduce RING SIMPLE MinMax u8 0 0 1
  {1122836, 811},  // AllReduce RING SIMPLE MinMax u8 1 0 1
  {139796, 812},  // AllReduce RING SIMPLE MinMax i32 0 0 1
  {1188372, 813},  // AllReduce RING SIMPLE MinMax i32 1 0 1
  {205332, 812},  // AllReduce RING SIMPLE MinMax u32 0 0 1
  {1253908, 813},  // AllReduce RING SIMPLE MinMax u32 1 0 1
  {270868, 814},  // AllReduce RING SIMPLE MinMax i64 0 0 1
  {1319444, 815},  // AllReduce RING SIMPLE MinMax i64 1 0 1
  {336404, 814},  // AllReduce RING SIMPLE MinMax u64 0 0 1
  {1384980, 815},  // AllReduce RING SIMPLE MinMax u64 1 0 1
  {401940, 816},  // AllReduce RING SIMPLE MinMax f16 0 0 1
  {1450516, 817},  // AllReduce RING SIMPLE MinMax f16 1 0 1
  {467476, 818},  // AllReduce RING SIMPLE MinMax f32 0 0 1
  {1516052, 819},  // AllReduce RING SIMPLE MinMax f32 1 0 1
  {533012, 820},  // AllReduce RING SIMPLE MinMax f64 0 0 1
  {1581588, 821},  // AllReduce RING SIMPLE MinMax f64 1 0 1
  {598548, 822},  // AllReduce RING SIMPLE MinMax bf16 0 0 1
  {17375764, 823},  // AllReduce RING SIMPLE MinMax bf16 0 1 1
  {1647124, 824},  // AllReduce RING SIMPLE MinMax bf16 1 0 1
  {18424340, 825},  // AllReduce RING SIMPLE MinMax bf16 1 1 1
  {664084, 826},  // AllReduce RING SIMPLE MinMax f8e4m3 0 0 1
  {1712660, 827},  // AllReduce RING SIMPLE MinMax f8e4m3 1 0 1
  {729620, 828},  // AllReduce RING SIMPLE MinMax f8e5m2 0 0 1
  {1778196, 829},  // AllReduce RING SIMPLE MinMax f8e5m2 1 0 1
  {12820, 830},  // AllReduce RING SIMPLE PreMulSum i8 0 0 1
  {1061396, 831},  // AllReduce RING SIMPLE PreMulSum i8 1 0 1
  {78356, 830},  // AllReduce RING SIMPLE PreMulSum u8 0 0 1
  {1126932, 831},  // AllReduce RING SIMPLE PreMulSum u8 1 0 1
  {143892, 832},  // AllReduce RING SIMPLE PreMulSum i32 0 0 1
  {1192468, 833},  // AllReduce RING SIMPLE PreMulSum i32 1 0 1
  {209428, 832},  // AllReduce RING SIMPLE PreMulSum u32 0 0 1
  {1258004, 833},  // AllReduce RING SIMPLE PreMulSum u32 1 0 1
  {274964, 834},  // AllReduce RING SIMPLE PreMulSum i64 0 0 1
  {1323540, 835},  // AllReduce RING SIMPLE PreMulSum i64 1 0 1
  {340500, 834},  // AllReduce RING SIMPLE PreMulSum u64 0 0 1
  {1389076, 835},  // AllReduce RING SIMPLE PreMulSum u64 1 0 1
  {406036, 836},  // AllReduce RING SIMPLE PreMulSum f16 0 0 1
  {1454612, 837},  // AllReduce RING SIMPLE PreMulSum f16 1 0 1
  {471572, 838},  // AllReduce RING SIMPLE PreMulSum f32 0 0 1
  {1520148, 839},  // AllReduce RING SIMPLE PreMulSum f32 1 0 1
  {537108, 840},  // AllReduce RING SIMPLE PreMulSum f64 0 0 1
  {1585684, 841},  // AllReduce RING SIMPLE PreMulSum f64 1 0 1
  {602644, 842},  // AllReduce RING SIMPLE PreMulSum bf16 0 0 1
  {17379860, 843},  // AllReduce RING SIMPLE PreMulSum bf16 0 1 1
  {1651220, 844},  // AllReduce RING SIMPLE PreMulSum bf16 1 0 1
  {18428436, 845},  // AllReduce RING SIMPLE PreMulSum bf16 1 1 1
  {668180, 846},  // AllReduce RING SIMPLE PreMulSum f8e4m3 0 0 1
  {1716756, 847},  // AllReduce RING SIMPLE PreMulSum f8e4m3 1 0 1
  {733716, 848},  // AllReduce RING SIMPLE PreMulSum f8e5m2 0 0 1
  {1782292, 849},  // AllReduce RING SIMPLE PreMulSum f8e5m2 1 0 1
  {16916, 850},  // AllReduce RING SIMPLE SumPostDiv i8 0 0 1
  {1065492, 851},  // AllReduce RING SIMPLE SumPostDiv i8 1 0 1
  {82452, 850},  // AllReduce RING SIMPLE SumPostDiv u8 0 0 1
  {1131028, 851},  // AllReduce RING SIMPLE SumPostDiv u8 1 0 1
  {147988, 852},  // AllReduce RING SIMPLE SumPostDiv i32 0 0 1
  {1196564, 853},  // AllReduce RING SIMPLE SumPostDiv i32 1 0 1
  {213524, 852},  // AllReduce RING SIMPLE SumPostDiv u32 0 0 1
  {1262100, 853},  // AllReduce RING SIMPLE SumPostDiv u32 1 0 1
  {279060, 854},  // AllReduce RING SIMPLE SumPostDiv i64 0 0 1
  {1327636, 855},  // AllReduce RING SIMPLE SumPostDiv i64 1 0 1
  {344596, 854},  // AllReduce RING SIMPLE SumPostDiv u64 0 0 1
  {1393172, 855},  // AllReduce RING SIMPLE SumPostDiv u64 1 0 1
  {5, 856},  // SendRecv RING SIMPLE Sum i8 0 0 1
  {8, 857},  // AllToAllPivot RING SIMPLE Sum i8 0 0 1
};
