/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_svcctl.h"
#include "bin/default/librpc/gen_ndr/ndr_svcctl_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* svcctl - dcerpc server boilerplate generated by pidl */
static NTSTATUS svcctl__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_SVCCTL_BIND
	return DCESRV_INTERFACE_SVCCTL_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void svcctl__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_SVCCTL_UNBIND
	DCESRV_INTERFACE_SVCCTL_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS svcctl__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_svcctl.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_svcctl.calls[opnum].struct_size, "struct %s", ndr_table_svcctl.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_svcctl.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS svcctl__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* svcctl_CloseServiceHandle */
		struct svcctl_CloseServiceHandle *r2 = (struct svcctl_CloseServiceHandle *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CloseServiceHandle, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = r2->in.handle;
		r2->out.result = _svcctl_CloseServiceHandle(p, r2);
		break;
	}
	case 1: { /* svcctl_ControlService */
		struct svcctl_ControlService *r2 = (struct svcctl_ControlService *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ControlService, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.service_status = talloc_zero(r2, struct SERVICE_STATUS);
		if (r2->out.service_status == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_ControlService(p, r2);
		break;
	}
	case 2: { /* svcctl_DeleteService */
		struct svcctl_DeleteService *r2 = (struct svcctl_DeleteService *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_DeleteService, NDR_IN, r2);
		}
		r2->out.result = _svcctl_DeleteService(p, r2);
		break;
	}
	case 3: { /* svcctl_LockServiceDatabase */
		struct svcctl_LockServiceDatabase *r2 = (struct svcctl_LockServiceDatabase *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_LockServiceDatabase, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.lock = talloc_zero(r2, struct policy_handle);
		if (r2->out.lock == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_LockServiceDatabase(p, r2);
		break;
	}
	case 4: { /* svcctl_QueryServiceObjectSecurity */
		struct svcctl_QueryServiceObjectSecurity *r2 = (struct svcctl_QueryServiceObjectSecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceObjectSecurity, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.buffer = talloc_zero_array(r2, uint8_t, r2->in.offered);
		if (r2->out.buffer == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_QueryServiceObjectSecurity(p, r2);
		break;
	}
	case 5: { /* svcctl_SetServiceObjectSecurity */
		struct svcctl_SetServiceObjectSecurity *r2 = (struct svcctl_SetServiceObjectSecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SetServiceObjectSecurity, NDR_IN, r2);
		}
		r2->out.result = _svcctl_SetServiceObjectSecurity(p, r2);
		break;
	}
	case 6: { /* svcctl_QueryServiceStatus */
		struct svcctl_QueryServiceStatus *r2 = (struct svcctl_QueryServiceStatus *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceStatus, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.service_status = talloc_zero(r2, struct SERVICE_STATUS);
		if (r2->out.service_status == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_QueryServiceStatus(p, r2);
		break;
	}
	case 7: { /* svcctl_SetServiceStatus */
		struct svcctl_SetServiceStatus *r2 = (struct svcctl_SetServiceStatus *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SetServiceStatus, NDR_IN, r2);
		}
		r2->out.result = _svcctl_SetServiceStatus(p, r2);
		break;
	}
	case 8: { /* svcctl_UnlockServiceDatabase */
		struct svcctl_UnlockServiceDatabase *r2 = (struct svcctl_UnlockServiceDatabase *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_UnlockServiceDatabase, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.lock = r2->in.lock;
		r2->out.result = _svcctl_UnlockServiceDatabase(p, r2);
		break;
	}
	case 9: { /* svcctl_NotifyBootConfigStatus */
		struct svcctl_NotifyBootConfigStatus *r2 = (struct svcctl_NotifyBootConfigStatus *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_NotifyBootConfigStatus, NDR_IN, r2);
		}
		r2->out.result = _svcctl_NotifyBootConfigStatus(p, r2);
		break;
	}
	case 10: { /* svcctl_SCSetServiceBitsW */
		struct svcctl_SCSetServiceBitsW *r2 = (struct svcctl_SCSetServiceBitsW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SCSetServiceBitsW, NDR_IN, r2);
		}
		r2->out.result = _svcctl_SCSetServiceBitsW(p, r2);
		break;
	}
	case 11: { /* svcctl_ChangeServiceConfigW */
		struct svcctl_ChangeServiceConfigW *r2 = (struct svcctl_ChangeServiceConfigW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfigW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.tag_id = r2->in.tag_id;
		r2->out.result = _svcctl_ChangeServiceConfigW(p, r2);
		break;
	}
	case 12: { /* svcctl_CreateServiceW */
		struct svcctl_CreateServiceW *r2 = (struct svcctl_CreateServiceW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateServiceW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.TagId = r2->in.TagId;
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_CreateServiceW(p, r2);
		break;
	}
	case 13: { /* svcctl_EnumDependentServicesW */
		struct svcctl_EnumDependentServicesW *r2 = (struct svcctl_EnumDependentServicesW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumDependentServicesW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.service_status = talloc_zero_array(r2, uint8_t, r2->in.offered);
		if (r2->out.service_status == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.services_returned = talloc_zero(r2, uint32_t);
		if (r2->out.services_returned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_EnumDependentServicesW(p, r2);
		break;
	}
	case 14: { /* svcctl_EnumServicesStatusW */
		struct svcctl_EnumServicesStatusW *r2 = (struct svcctl_EnumServicesStatusW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServicesStatusW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.service = talloc_zero_array(r2, uint8_t, r2->in.offered);
		if (r2->out.service == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.services_returned = talloc_zero(r2, uint32_t);
		if (r2->out.services_returned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_EnumServicesStatusW(p, r2);
		break;
	}
	case 15: { /* svcctl_OpenSCManagerW */
		struct svcctl_OpenSCManagerW *r2 = (struct svcctl_OpenSCManagerW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenSCManagerW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_OpenSCManagerW(p, r2);
		break;
	}
	case 16: { /* svcctl_OpenServiceW */
		struct svcctl_OpenServiceW *r2 = (struct svcctl_OpenServiceW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenServiceW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_OpenServiceW(p, r2);
		break;
	}
	case 17: { /* svcctl_QueryServiceConfigW */
		struct svcctl_QueryServiceConfigW *r2 = (struct svcctl_QueryServiceConfigW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfigW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.query = talloc_zero(r2, struct QUERY_SERVICE_CONFIG);
		if (r2->out.query == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_QueryServiceConfigW(p, r2);
		break;
	}
	case 18: { /* svcctl_QueryServiceLockStatusW */
		struct svcctl_QueryServiceLockStatusW *r2 = (struct svcctl_QueryServiceLockStatusW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceLockStatusW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.lock_status = talloc_zero(r2, struct SERVICE_LOCK_STATUS);
		if (r2->out.lock_status == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_QueryServiceLockStatusW(p, r2);
		break;
	}
	case 19: { /* svcctl_StartServiceW */
		struct svcctl_StartServiceW *r2 = (struct svcctl_StartServiceW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_StartServiceW, NDR_IN, r2);
		}
		r2->out.result = _svcctl_StartServiceW(p, r2);
		break;
	}
	case 20: { /* svcctl_GetServiceDisplayNameW */
		struct svcctl_GetServiceDisplayNameW *r2 = (struct svcctl_GetServiceDisplayNameW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceDisplayNameW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.display_name_length = r2->in.display_name_length;
		r2->out.display_name = talloc_zero(r2, const char *);
		if (r2->out.display_name == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_GetServiceDisplayNameW(p, r2);
		break;
	}
	case 21: { /* svcctl_GetServiceKeyNameW */
		struct svcctl_GetServiceKeyNameW *r2 = (struct svcctl_GetServiceKeyNameW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceKeyNameW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.display_name_length = r2->in.display_name_length;
		r2->out.key_name = talloc_zero(r2, const char *);
		if (r2->out.key_name == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_GetServiceKeyNameW(p, r2);
		break;
	}
	case 22: { /* svcctl_SCSetServiceBitsA */
		struct svcctl_SCSetServiceBitsA *r2 = (struct svcctl_SCSetServiceBitsA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SCSetServiceBitsA, NDR_IN, r2);
		}
		r2->out.result = _svcctl_SCSetServiceBitsA(p, r2);
		break;
	}
	case 23: { /* svcctl_ChangeServiceConfigA */
		struct svcctl_ChangeServiceConfigA *r2 = (struct svcctl_ChangeServiceConfigA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfigA, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.tag_id = talloc_zero(r2, uint32_t);
		if (r2->out.tag_id == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_ChangeServiceConfigA(p, r2);
		break;
	}
	case 24: { /* svcctl_CreateServiceA */
		struct svcctl_CreateServiceA *r2 = (struct svcctl_CreateServiceA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateServiceA, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.TagId = talloc_zero(r2, uint32_t);
		if (r2->out.TagId == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_CreateServiceA(p, r2);
		break;
	}
	case 25: { /* svcctl_EnumDependentServicesA */
		struct svcctl_EnumDependentServicesA *r2 = (struct svcctl_EnumDependentServicesA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumDependentServicesA, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.service_status = talloc_zero(r2, struct ENUM_SERVICE_STATUSA);
		if (r2->out.service_status == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.services_returned = talloc_zero(r2, uint32_t);
		if (r2->out.services_returned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_EnumDependentServicesA(p, r2);
		break;
	}
	case 26: { /* svcctl_EnumServicesStatusA */
		struct svcctl_EnumServicesStatusA *r2 = (struct svcctl_EnumServicesStatusA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServicesStatusA, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.service = talloc_zero_array(r2, uint8_t, r2->in.offered);
		if (r2->out.service == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.services_returned = talloc_zero(r2, uint32_t);
		if (r2->out.services_returned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_EnumServicesStatusA(p, r2);
		break;
	}
	case 27: { /* svcctl_OpenSCManagerA */
		struct svcctl_OpenSCManagerA *r2 = (struct svcctl_OpenSCManagerA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenSCManagerA, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_OpenSCManagerA(p, r2);
		break;
	}
	case 28: { /* svcctl_OpenServiceA */
		struct svcctl_OpenServiceA *r2 = (struct svcctl_OpenServiceA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenServiceA, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_OpenServiceA(p, r2);
		break;
	}
	case 29: { /* svcctl_QueryServiceConfigA */
		struct svcctl_QueryServiceConfigA *r2 = (struct svcctl_QueryServiceConfigA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfigA, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.query = talloc_zero_array(r2, uint8_t, r2->in.offered);
		if (r2->out.query == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_QueryServiceConfigA(p, r2);
		break;
	}
	case 30: { /* svcctl_QueryServiceLockStatusA */
		struct svcctl_QueryServiceLockStatusA *r2 = (struct svcctl_QueryServiceLockStatusA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceLockStatusA, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.lock_status = talloc_zero(r2, struct SERVICE_LOCK_STATUS);
		if (r2->out.lock_status == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_QueryServiceLockStatusA(p, r2);
		break;
	}
	case 31: { /* svcctl_StartServiceA */
		struct svcctl_StartServiceA *r2 = (struct svcctl_StartServiceA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_StartServiceA, NDR_IN, r2);
		}
		r2->out.result = _svcctl_StartServiceA(p, r2);
		break;
	}
	case 32: { /* svcctl_GetServiceDisplayNameA */
		struct svcctl_GetServiceDisplayNameA *r2 = (struct svcctl_GetServiceDisplayNameA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceDisplayNameA, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.display_name_length = r2->in.display_name_length;
		r2->out.display_name = talloc_zero(r2, const char *);
		if (r2->out.display_name == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_GetServiceDisplayNameA(p, r2);
		break;
	}
	case 33: { /* svcctl_GetServiceKeyNameA */
		struct svcctl_GetServiceKeyNameA *r2 = (struct svcctl_GetServiceKeyNameA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceKeyNameA, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.display_name_length = r2->in.display_name_length;
		r2->out.key_name = talloc_zero(r2, const char *);
		if (r2->out.key_name == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_GetServiceKeyNameA(p, r2);
		break;
	}
	case 34: { /* svcctl_GetCurrentGroupeStateW */
		struct svcctl_GetCurrentGroupeStateW *r2 = (struct svcctl_GetCurrentGroupeStateW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetCurrentGroupeStateW, NDR_IN, r2);
		}
		r2->out.result = _svcctl_GetCurrentGroupeStateW(p, r2);
		break;
	}
	case 35: { /* svcctl_EnumServiceGroupW */
		struct svcctl_EnumServiceGroupW *r2 = (struct svcctl_EnumServiceGroupW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServiceGroupW, NDR_IN, r2);
		}
		r2->out.result = _svcctl_EnumServiceGroupW(p, r2);
		break;
	}
	case 36: { /* svcctl_ChangeServiceConfig2A */
		struct svcctl_ChangeServiceConfig2A *r2 = (struct svcctl_ChangeServiceConfig2A *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfig2A, NDR_IN, r2);
		}
		r2->out.result = _svcctl_ChangeServiceConfig2A(p, r2);
		break;
	}
	case 37: { /* svcctl_ChangeServiceConfig2W */
		struct svcctl_ChangeServiceConfig2W *r2 = (struct svcctl_ChangeServiceConfig2W *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfig2W, NDR_IN, r2);
		}
		r2->out.result = _svcctl_ChangeServiceConfig2W(p, r2);
		break;
	}
	case 38: { /* svcctl_QueryServiceConfig2A */
		struct svcctl_QueryServiceConfig2A *r2 = (struct svcctl_QueryServiceConfig2A *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfig2A, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.buffer = talloc_zero_array(r2, uint8_t, r2->in.offered);
		if (r2->out.buffer == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_QueryServiceConfig2A(p, r2);
		break;
	}
	case 39: { /* svcctl_QueryServiceConfig2W */
		struct svcctl_QueryServiceConfig2W *r2 = (struct svcctl_QueryServiceConfig2W *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfig2W, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.buffer = talloc_zero_array(r2, uint8_t, r2->in.offered);
		if (r2->out.buffer == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_QueryServiceConfig2W(p, r2);
		break;
	}
	case 40: { /* svcctl_QueryServiceStatusEx */
		struct svcctl_QueryServiceStatusEx *r2 = (struct svcctl_QueryServiceStatusEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceStatusEx, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.buffer = talloc_zero_array(r2, uint8_t, r2->in.offered);
		if (r2->out.buffer == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_QueryServiceStatusEx(p, r2);
		break;
	}
	case 41: { /* svcctl_EnumServicesStatusExA */
		struct svcctl_EnumServicesStatusExA *r2 = (struct svcctl_EnumServicesStatusExA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServicesStatusExA, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.services = talloc_zero_array(r2, uint8_t, r2->in.offered);
		if (r2->out.services == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.service_returned = talloc_zero(r2, uint32_t);
		if (r2->out.service_returned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.group_name = talloc_zero(r2, const char *);
		if (r2->out.group_name == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_EnumServicesStatusExA(p, r2);
		break;
	}
	case 42: { /* svcctl_EnumServicesStatusExW */
		struct svcctl_EnumServicesStatusExW *r2 = (struct svcctl_EnumServicesStatusExW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServicesStatusExW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.services = talloc_zero_array(r2, uint8_t, r2->in.offered);
		if (r2->out.services == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.service_returned = talloc_zero(r2, uint32_t);
		if (r2->out.service_returned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_EnumServicesStatusExW(p, r2);
		break;
	}
	case 43: { /* svcctl_SCSendTSMessage */
		struct svcctl_SCSendTSMessage *r2 = (struct svcctl_SCSendTSMessage *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SCSendTSMessage, NDR_IN, r2);
		}
		r2->out.result = _svcctl_SCSendTSMessage(p, r2);
		break;
	}
	case 44: { /* svcctl_CreateServiceWOW64A */
		struct svcctl_CreateServiceWOW64A *r2 = (struct svcctl_CreateServiceWOW64A *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateServiceWOW64A, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.lpdwTagId = r2->in.lpdwTagId;
		r2->out.lpServiceHandle = talloc_zero(r2, struct policy_handle);
		if (r2->out.lpServiceHandle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_CreateServiceWOW64A(p, r2);
		break;
	}
	case 45: { /* svcctl_CreateServiceWOW64W */
		struct svcctl_CreateServiceWOW64W *r2 = (struct svcctl_CreateServiceWOW64W *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateServiceWOW64W, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.lpdwTagId = r2->in.lpdwTagId;
		r2->out.lpServiceHandle = talloc_zero(r2, struct policy_handle);
		if (r2->out.lpServiceHandle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_CreateServiceWOW64W(p, r2);
		break;
	}
	case 46: { /* Opnum46NotUsedOnWire */
		struct Opnum46NotUsedOnWire *r2 = (struct Opnum46NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum46NotUsedOnWire, NDR_IN, r2);
		}
		_Opnum46NotUsedOnWire(p, r2);
		break;
	}
	case 47: { /* svcctl_NotifyServiceStatusChange */
		struct svcctl_NotifyServiceStatusChange *r2 = (struct svcctl_NotifyServiceStatusChange *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_NotifyServiceStatusChange, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pSCMProcessGuid = talloc_zero(r2, struct GUID);
		if (r2->out.pSCMProcessGuid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.pfCreateRemoteQueue = talloc_zero(r2, uint32_t);
		if (r2->out.pfCreateRemoteQueue == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.phNotify = talloc_zero(r2, struct policy_handle);
		if (r2->out.phNotify == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_NotifyServiceStatusChange(p, r2);
		break;
	}
	case 48: { /* svcctl_GetNotifyResults */
		struct svcctl_GetNotifyResults *r2 = (struct svcctl_GetNotifyResults *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetNotifyResults, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ppNotifyParams = talloc_zero(r2, struct SC_RPC_NOTIFY_PARAMS_LIST);
		if (r2->out.ppNotifyParams == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_GetNotifyResults(p, r2);
		break;
	}
	case 49: { /* svcctl_CloseNotifyHandle */
		struct svcctl_CloseNotifyHandle *r2 = (struct svcctl_CloseNotifyHandle *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CloseNotifyHandle, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.phNotify = r2->in.phNotify;
		r2->out.pfApcFired = talloc_zero(r2, uint32_t);
		if (r2->out.pfApcFired == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_CloseNotifyHandle(p, r2);
		break;
	}
	case 50: { /* svcctl_ControlServiceExA */
		struct svcctl_ControlServiceExA *r2 = (struct svcctl_ControlServiceExA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ControlServiceExA, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pControlOutParams = talloc_zero(r2, union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA);
		if (r2->out.pControlOutParams == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_ControlServiceExA(p, r2);
		break;
	}
	case 51: { /* svcctl_ControlServiceExW */
		struct svcctl_ControlServiceExW *r2 = (struct svcctl_ControlServiceExW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ControlServiceExW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pControlOutParams = talloc_zero(r2, union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW);
		if (r2->out.pControlOutParams == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_ControlServiceExW(p, r2);
		break;
	}
	case 52: { /* Opnum52NotUsedOnWire */
		struct Opnum52NotUsedOnWire *r2 = (struct Opnum52NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum52NotUsedOnWire, NDR_IN, r2);
		}
		_Opnum52NotUsedOnWire(p, r2);
		break;
	}
	case 53: { /* Opnum53NotUsedOnWire */
		struct Opnum53NotUsedOnWire *r2 = (struct Opnum53NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum53NotUsedOnWire, NDR_IN, r2);
		}
		_Opnum53NotUsedOnWire(p, r2);
		break;
	}
	case 54: { /* Opnum54NotUsedOnWire */
		struct Opnum54NotUsedOnWire *r2 = (struct Opnum54NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum54NotUsedOnWire, NDR_IN, r2);
		}
		_Opnum54NotUsedOnWire(p, r2);
		break;
	}
	case 55: { /* Opnum55NotUsedOnWire */
		struct Opnum55NotUsedOnWire *r2 = (struct Opnum55NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum55NotUsedOnWire, NDR_IN, r2);
		}
		_Opnum55NotUsedOnWire(p, r2);
		break;
	}
	case 56: { /* svcctl_QueryServiceConfigEx */
		struct svcctl_QueryServiceConfigEx *r2 = (struct svcctl_QueryServiceConfigEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfigEx, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pInfo = talloc_zero(r2, struct SC_RPC_CONFIG_INFOW);
		if (r2->out.pInfo == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_QueryServiceConfigEx(p, r2);
		break;
	}
	case 57: { /* Opnum57NotUsedOnWire */
		struct Opnum57NotUsedOnWire *r2 = (struct Opnum57NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum57NotUsedOnWire, NDR_IN, r2);
		}
		_Opnum57NotUsedOnWire(p, r2);
		break;
	}
	case 58: { /* Opnum58NotUsedOnWire */
		struct Opnum58NotUsedOnWire *r2 = (struct Opnum58NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum58NotUsedOnWire, NDR_IN, r2);
		}
		_Opnum58NotUsedOnWire(p, r2);
		break;
	}
	case 59: { /* Opnum59NotUsedOnWire */
		struct Opnum59NotUsedOnWire *r2 = (struct Opnum59NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum59NotUsedOnWire, NDR_IN, r2);
		}
		_Opnum59NotUsedOnWire(p, r2);
		break;
	}
	case 60: { /* svcctl_CreateWowService */
		struct svcctl_CreateWowService *r2 = (struct svcctl_CreateWowService *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateWowService, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.lpdwTagId = r2->in.lpdwTagId;
		r2->out.lpServiceHandle = talloc_zero(r2, struct policy_handle);
		if (r2->out.lpServiceHandle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_CreateWowService(p, r2);
		break;
	}
	case 61: { /* svcctl_OpenSCManager2 */
		struct svcctl_OpenSCManager2 *r2 = (struct svcctl_OpenSCManager2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenSCManager2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ScmHandle = talloc_zero(r2, struct policy_handle);
		if (r2->out.ScmHandle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _svcctl_OpenSCManager2(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS svcctl__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return svcctl__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS svcctl__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* svcctl_CloseServiceHandle */
		struct svcctl_CloseServiceHandle *r2 = (struct svcctl_CloseServiceHandle *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_CloseServiceHandle replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CloseServiceHandle, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_CloseServiceHandle\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* svcctl_ControlService */
		struct svcctl_ControlService *r2 = (struct svcctl_ControlService *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ControlService replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ControlService, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_ControlService\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* svcctl_DeleteService */
		struct svcctl_DeleteService *r2 = (struct svcctl_DeleteService *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_DeleteService replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_DeleteService, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_DeleteService\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* svcctl_LockServiceDatabase */
		struct svcctl_LockServiceDatabase *r2 = (struct svcctl_LockServiceDatabase *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_LockServiceDatabase replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_LockServiceDatabase, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_LockServiceDatabase\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* svcctl_QueryServiceObjectSecurity */
		struct svcctl_QueryServiceObjectSecurity *r2 = (struct svcctl_QueryServiceObjectSecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceObjectSecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceObjectSecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_QueryServiceObjectSecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* svcctl_SetServiceObjectSecurity */
		struct svcctl_SetServiceObjectSecurity *r2 = (struct svcctl_SetServiceObjectSecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SetServiceObjectSecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SetServiceObjectSecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_SetServiceObjectSecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* svcctl_QueryServiceStatus */
		struct svcctl_QueryServiceStatus *r2 = (struct svcctl_QueryServiceStatus *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceStatus replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceStatus, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_QueryServiceStatus\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* svcctl_SetServiceStatus */
		struct svcctl_SetServiceStatus *r2 = (struct svcctl_SetServiceStatus *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SetServiceStatus replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SetServiceStatus, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_SetServiceStatus\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* svcctl_UnlockServiceDatabase */
		struct svcctl_UnlockServiceDatabase *r2 = (struct svcctl_UnlockServiceDatabase *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_UnlockServiceDatabase replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_UnlockServiceDatabase, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_UnlockServiceDatabase\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* svcctl_NotifyBootConfigStatus */
		struct svcctl_NotifyBootConfigStatus *r2 = (struct svcctl_NotifyBootConfigStatus *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_NotifyBootConfigStatus replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_NotifyBootConfigStatus, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_NotifyBootConfigStatus\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* svcctl_SCSetServiceBitsW */
		struct svcctl_SCSetServiceBitsW *r2 = (struct svcctl_SCSetServiceBitsW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SCSetServiceBitsW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SCSetServiceBitsW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_SCSetServiceBitsW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 11: { /* svcctl_ChangeServiceConfigW */
		struct svcctl_ChangeServiceConfigW *r2 = (struct svcctl_ChangeServiceConfigW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ChangeServiceConfigW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfigW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_ChangeServiceConfigW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 12: { /* svcctl_CreateServiceW */
		struct svcctl_CreateServiceW *r2 = (struct svcctl_CreateServiceW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_CreateServiceW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateServiceW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_CreateServiceW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 13: { /* svcctl_EnumDependentServicesW */
		struct svcctl_EnumDependentServicesW *r2 = (struct svcctl_EnumDependentServicesW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumDependentServicesW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumDependentServicesW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_EnumDependentServicesW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 14: { /* svcctl_EnumServicesStatusW */
		struct svcctl_EnumServicesStatusW *r2 = (struct svcctl_EnumServicesStatusW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumServicesStatusW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServicesStatusW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_EnumServicesStatusW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 15: { /* svcctl_OpenSCManagerW */
		struct svcctl_OpenSCManagerW *r2 = (struct svcctl_OpenSCManagerW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_OpenSCManagerW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenSCManagerW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_OpenSCManagerW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 16: { /* svcctl_OpenServiceW */
		struct svcctl_OpenServiceW *r2 = (struct svcctl_OpenServiceW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_OpenServiceW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenServiceW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_OpenServiceW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 17: { /* svcctl_QueryServiceConfigW */
		struct svcctl_QueryServiceConfigW *r2 = (struct svcctl_QueryServiceConfigW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceConfigW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfigW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_QueryServiceConfigW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 18: { /* svcctl_QueryServiceLockStatusW */
		struct svcctl_QueryServiceLockStatusW *r2 = (struct svcctl_QueryServiceLockStatusW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceLockStatusW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceLockStatusW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_QueryServiceLockStatusW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 19: { /* svcctl_StartServiceW */
		struct svcctl_StartServiceW *r2 = (struct svcctl_StartServiceW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_StartServiceW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_StartServiceW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_StartServiceW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 20: { /* svcctl_GetServiceDisplayNameW */
		struct svcctl_GetServiceDisplayNameW *r2 = (struct svcctl_GetServiceDisplayNameW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetServiceDisplayNameW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceDisplayNameW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_GetServiceDisplayNameW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 21: { /* svcctl_GetServiceKeyNameW */
		struct svcctl_GetServiceKeyNameW *r2 = (struct svcctl_GetServiceKeyNameW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetServiceKeyNameW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceKeyNameW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_GetServiceKeyNameW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 22: { /* svcctl_SCSetServiceBitsA */
		struct svcctl_SCSetServiceBitsA *r2 = (struct svcctl_SCSetServiceBitsA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SCSetServiceBitsA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SCSetServiceBitsA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_SCSetServiceBitsA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 23: { /* svcctl_ChangeServiceConfigA */
		struct svcctl_ChangeServiceConfigA *r2 = (struct svcctl_ChangeServiceConfigA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ChangeServiceConfigA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfigA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_ChangeServiceConfigA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 24: { /* svcctl_CreateServiceA */
		struct svcctl_CreateServiceA *r2 = (struct svcctl_CreateServiceA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_CreateServiceA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateServiceA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_CreateServiceA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 25: { /* svcctl_EnumDependentServicesA */
		struct svcctl_EnumDependentServicesA *r2 = (struct svcctl_EnumDependentServicesA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumDependentServicesA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumDependentServicesA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_EnumDependentServicesA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 26: { /* svcctl_EnumServicesStatusA */
		struct svcctl_EnumServicesStatusA *r2 = (struct svcctl_EnumServicesStatusA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumServicesStatusA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServicesStatusA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_EnumServicesStatusA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 27: { /* svcctl_OpenSCManagerA */
		struct svcctl_OpenSCManagerA *r2 = (struct svcctl_OpenSCManagerA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_OpenSCManagerA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenSCManagerA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_OpenSCManagerA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 28: { /* svcctl_OpenServiceA */
		struct svcctl_OpenServiceA *r2 = (struct svcctl_OpenServiceA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_OpenServiceA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenServiceA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_OpenServiceA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 29: { /* svcctl_QueryServiceConfigA */
		struct svcctl_QueryServiceConfigA *r2 = (struct svcctl_QueryServiceConfigA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceConfigA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfigA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_QueryServiceConfigA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 30: { /* svcctl_QueryServiceLockStatusA */
		struct svcctl_QueryServiceLockStatusA *r2 = (struct svcctl_QueryServiceLockStatusA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceLockStatusA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceLockStatusA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_QueryServiceLockStatusA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 31: { /* svcctl_StartServiceA */
		struct svcctl_StartServiceA *r2 = (struct svcctl_StartServiceA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_StartServiceA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_StartServiceA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_StartServiceA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 32: { /* svcctl_GetServiceDisplayNameA */
		struct svcctl_GetServiceDisplayNameA *r2 = (struct svcctl_GetServiceDisplayNameA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetServiceDisplayNameA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceDisplayNameA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_GetServiceDisplayNameA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 33: { /* svcctl_GetServiceKeyNameA */
		struct svcctl_GetServiceKeyNameA *r2 = (struct svcctl_GetServiceKeyNameA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetServiceKeyNameA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceKeyNameA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_GetServiceKeyNameA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 34: { /* svcctl_GetCurrentGroupeStateW */
		struct svcctl_GetCurrentGroupeStateW *r2 = (struct svcctl_GetCurrentGroupeStateW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetCurrentGroupeStateW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetCurrentGroupeStateW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_GetCurrentGroupeStateW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 35: { /* svcctl_EnumServiceGroupW */
		struct svcctl_EnumServiceGroupW *r2 = (struct svcctl_EnumServiceGroupW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumServiceGroupW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServiceGroupW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_EnumServiceGroupW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 36: { /* svcctl_ChangeServiceConfig2A */
		struct svcctl_ChangeServiceConfig2A *r2 = (struct svcctl_ChangeServiceConfig2A *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ChangeServiceConfig2A replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfig2A, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_ChangeServiceConfig2A\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 37: { /* svcctl_ChangeServiceConfig2W */
		struct svcctl_ChangeServiceConfig2W *r2 = (struct svcctl_ChangeServiceConfig2W *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ChangeServiceConfig2W replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfig2W, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_ChangeServiceConfig2W\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 38: { /* svcctl_QueryServiceConfig2A */
		struct svcctl_QueryServiceConfig2A *r2 = (struct svcctl_QueryServiceConfig2A *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceConfig2A replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfig2A, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_QueryServiceConfig2A\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 39: { /* svcctl_QueryServiceConfig2W */
		struct svcctl_QueryServiceConfig2W *r2 = (struct svcctl_QueryServiceConfig2W *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceConfig2W replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfig2W, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_QueryServiceConfig2W\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 40: { /* svcctl_QueryServiceStatusEx */
		struct svcctl_QueryServiceStatusEx *r2 = (struct svcctl_QueryServiceStatusEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceStatusEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceStatusEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_QueryServiceStatusEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 41: { /* svcctl_EnumServicesStatusExA */
		struct svcctl_EnumServicesStatusExA *r2 = (struct svcctl_EnumServicesStatusExA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumServicesStatusExA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServicesStatusExA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_EnumServicesStatusExA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 42: { /* svcctl_EnumServicesStatusExW */
		struct svcctl_EnumServicesStatusExW *r2 = (struct svcctl_EnumServicesStatusExW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumServicesStatusExW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServicesStatusExW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_EnumServicesStatusExW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 43: { /* svcctl_SCSendTSMessage */
		struct svcctl_SCSendTSMessage *r2 = (struct svcctl_SCSendTSMessage *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SCSendTSMessage replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SCSendTSMessage, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_SCSendTSMessage\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 44: { /* svcctl_CreateServiceWOW64A */
		struct svcctl_CreateServiceWOW64A *r2 = (struct svcctl_CreateServiceWOW64A *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_CreateServiceWOW64A replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateServiceWOW64A, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_CreateServiceWOW64A\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 45: { /* svcctl_CreateServiceWOW64W */
		struct svcctl_CreateServiceWOW64W *r2 = (struct svcctl_CreateServiceWOW64W *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_CreateServiceWOW64W replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateServiceWOW64W, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_CreateServiceWOW64W\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 46: { /* Opnum46NotUsedOnWire */
		struct Opnum46NotUsedOnWire *r2 = (struct Opnum46NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Opnum46NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum46NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in Opnum46NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 47: { /* svcctl_NotifyServiceStatusChange */
		struct svcctl_NotifyServiceStatusChange *r2 = (struct svcctl_NotifyServiceStatusChange *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_NotifyServiceStatusChange replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_NotifyServiceStatusChange, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_NotifyServiceStatusChange\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 48: { /* svcctl_GetNotifyResults */
		struct svcctl_GetNotifyResults *r2 = (struct svcctl_GetNotifyResults *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetNotifyResults replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetNotifyResults, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_GetNotifyResults\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 49: { /* svcctl_CloseNotifyHandle */
		struct svcctl_CloseNotifyHandle *r2 = (struct svcctl_CloseNotifyHandle *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_CloseNotifyHandle replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CloseNotifyHandle, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_CloseNotifyHandle\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 50: { /* svcctl_ControlServiceExA */
		struct svcctl_ControlServiceExA *r2 = (struct svcctl_ControlServiceExA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ControlServiceExA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ControlServiceExA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_ControlServiceExA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 51: { /* svcctl_ControlServiceExW */
		struct svcctl_ControlServiceExW *r2 = (struct svcctl_ControlServiceExW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ControlServiceExW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ControlServiceExW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_ControlServiceExW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 52: { /* Opnum52NotUsedOnWire */
		struct Opnum52NotUsedOnWire *r2 = (struct Opnum52NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Opnum52NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum52NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in Opnum52NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 53: { /* Opnum53NotUsedOnWire */
		struct Opnum53NotUsedOnWire *r2 = (struct Opnum53NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Opnum53NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum53NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in Opnum53NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 54: { /* Opnum54NotUsedOnWire */
		struct Opnum54NotUsedOnWire *r2 = (struct Opnum54NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Opnum54NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum54NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in Opnum54NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 55: { /* Opnum55NotUsedOnWire */
		struct Opnum55NotUsedOnWire *r2 = (struct Opnum55NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Opnum55NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum55NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in Opnum55NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 56: { /* svcctl_QueryServiceConfigEx */
		struct svcctl_QueryServiceConfigEx *r2 = (struct svcctl_QueryServiceConfigEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceConfigEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfigEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_QueryServiceConfigEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 57: { /* Opnum57NotUsedOnWire */
		struct Opnum57NotUsedOnWire *r2 = (struct Opnum57NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Opnum57NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum57NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in Opnum57NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 58: { /* Opnum58NotUsedOnWire */
		struct Opnum58NotUsedOnWire *r2 = (struct Opnum58NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Opnum58NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum58NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in Opnum58NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 59: { /* Opnum59NotUsedOnWire */
		struct Opnum59NotUsedOnWire *r2 = (struct Opnum59NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Opnum59NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Opnum59NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in Opnum59NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 60: { /* svcctl_CreateWowService */
		struct svcctl_CreateWowService *r2 = (struct svcctl_CreateWowService *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_CreateWowService replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateWowService, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_CreateWowService\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 61: { /* svcctl_OpenSCManager2 */
		struct svcctl_OpenSCManager2 *r2 = (struct svcctl_OpenSCManager2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_OpenSCManager2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenSCManager2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in svcctl_OpenSCManager2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS svcctl__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_svcctl.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS svcctl__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return svcctl__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_svcctl_interface = {
	.name      = "svcctl",
	.syntax_id = {{0x367abb81,0x9844,0x35f1,{0xad,0x32},{0x98,0xf0,0x38,0x00,0x10,0x03}},2.0},
	.bind      = svcctl__op_bind,
	.unbind    = svcctl__op_unbind,
	.ndr_pull  = svcctl__op_ndr_pull,
	.dispatch  = svcctl__op_dispatch,
	.reply     = svcctl__op_reply,
	.ndr_push  = svcctl__op_ndr_push,
	.local     = svcctl__op_local,
#ifdef DCESRV_INTERFACE_SVCCTL_FLAGS
	.flags     = DCESRV_INTERFACE_SVCCTL_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS svcctl__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_SVCCTL_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_SVCCTL_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_svcctl.endpoints->count;i++) {
		const char *name = ndr_table_svcctl.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_svcctl_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS svcctl__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool svcctl__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_svcctl_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_svcctl_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_svcctl_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool svcctl__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_svcctl_interface.name, name)==0) {
		memcpy(iface, &dcesrv_svcctl_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server svcctl_ep_server = {
	/* fill in our name */
	.name = "svcctl",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_SVCCTL_INIT_SERVER
	.init_server = DCESRV_INTERFACE_SVCCTL_INIT_SERVER,
#else
	.init_server = svcctl__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_SVCCTL_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_SVCCTL_SHUTDOWN_SERVER,
#else
	.shutdown_server = svcctl__op_shutdown_server,
#endif
	.interface_by_uuid = svcctl__op_interface_by_uuid,
	.interface_by_name = svcctl__op_interface_by_name
};

const struct dcesrv_endpoint_server *svcctl_get_ep_server(void)
{
	return &svcctl_ep_server;
}
