/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_krb5pac.h"

#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_lsa.h"
#include "librpc/gen_ndr/ndr_netlogon.h"
#include "librpc/gen_ndr/ndr_samr.h"
static enum ndr_err_code ndr_push_PAC_LOGON_NAME(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_LOGON_NAME *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->logon_time));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * strlen_m(r->account_name)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->account_name, 2 * strlen_m(r->account_name), sizeof(uint8_t), CH_UTF16));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_LOGON_NAME(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_LOGON_NAME *r)
{
	uint32_t size_account_name_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->logon_time));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		size_account_name_0 = r->size;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->account_name, size_account_name_0, sizeof(uint8_t), CH_UTF16));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_LOGON_NAME(struct ndr_print *ndr, const char *name, const struct PAC_LOGON_NAME *r)
{
	ndr_print_struct(ndr, name, "PAC_LOGON_NAME");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_NTTIME(ndr, "logon_time", r->logon_time);
	ndr_print_uint16(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m(r->account_name):r->size);
	ndr_print_string(ndr, "account_name", r->account_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_SIGNATURE_DATA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_SIGNATURE_DATA *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->type));
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->signature));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_SIGNATURE_DATA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_SIGNATURE_DATA *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->type));
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->signature));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_PAC_SIGNATURE_DATA(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_SIGNATURE_DATA *r)
{
	ndr_print_PAC_SIGNATURE_DATA(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_SIGNATURE_DATA(struct ndr_print *ndr, const char *name, const struct PAC_SIGNATURE_DATA *r)
{
	ndr_print_struct(ndr, name, "PAC_SIGNATURE_DATA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint32(ndr, "type", r->type);
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			ndr_print_DATA_BLOB(ndr, "signature", r->signature);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_PAC_DOMAIN_GROUP_MEMBERSHIP(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_DOMAIN_GROUP_MEMBERSHIP *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_sid));
		NDR_CHECK(ndr_push_samr_RidWithAttributeArray(ndr, NDR_SCALARS, &r->groups));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain_sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain_sid));
		}
		NDR_CHECK(ndr_push_samr_RidWithAttributeArray(ndr, NDR_BUFFERS, &r->groups));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_DOMAIN_GROUP_MEMBERSHIP(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_DOMAIN_GROUP_MEMBERSHIP *r)
{
	uint32_t _ptr_domain_sid;
	TALLOC_CTX *_mem_save_domain_sid_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_sid));
		if (_ptr_domain_sid) {
			NDR_PULL_ALLOC(ndr, r->domain_sid);
		} else {
			r->domain_sid = NULL;
		}
		NDR_CHECK(ndr_pull_samr_RidWithAttributeArray(ndr, NDR_SCALARS, &r->groups));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain_sid) {
			_mem_save_domain_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain_sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_sid_0, 0);
		}
		NDR_CHECK(ndr_pull_samr_RidWithAttributeArray(ndr, NDR_BUFFERS, &r->groups));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_DOMAIN_GROUP_MEMBERSHIP(struct ndr_print *ndr, const char *name, const struct PAC_DOMAIN_GROUP_MEMBERSHIP *r)
{
	ndr_print_struct(ndr, name, "PAC_DOMAIN_GROUP_MEMBERSHIP");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "domain_sid", r->domain_sid);
	ndr->depth++;
	if (r->domain_sid) {
		ndr_print_dom_sid2(ndr, "domain_sid", r->domain_sid);
	}
	ndr->depth--;
	ndr_print_samr_RidWithAttributeArray(ndr, "groups", &r->groups);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PAC_LOGON_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_LOGON_INFO *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_SamInfo3(ndr, NDR_SCALARS, &r->info3));
		NDR_CHECK(ndr_push_PAC_DOMAIN_GROUP_MEMBERSHIP(ndr, NDR_SCALARS, &r->resource_groups));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_netr_SamInfo3(ndr, NDR_BUFFERS, &r->info3));
		NDR_CHECK(ndr_push_PAC_DOMAIN_GROUP_MEMBERSHIP(ndr, NDR_BUFFERS, &r->resource_groups));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_LOGON_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_LOGON_INFO *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_netr_SamInfo3(ndr, NDR_SCALARS, &r->info3));
		NDR_CHECK(ndr_pull_PAC_DOMAIN_GROUP_MEMBERSHIP(ndr, NDR_SCALARS, &r->resource_groups));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_netr_SamInfo3(ndr, NDR_BUFFERS, &r->info3));
		NDR_CHECK(ndr_pull_PAC_DOMAIN_GROUP_MEMBERSHIP(ndr, NDR_BUFFERS, &r->resource_groups));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_LOGON_INFO(struct ndr_print *ndr, const char *name, const struct PAC_LOGON_INFO *r)
{
	ndr_print_struct(ndr, name, "PAC_LOGON_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_SamInfo3(ndr, "info3", &r->info3);
	ndr_print_PAC_DOMAIN_GROUP_MEMBERSHIP(ndr, "resource_groups", &r->resource_groups);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PAC_CREDENTIAL_NTLM_FLAGS(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_CREDENTIAL_NTLM_FLAGS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_CREDENTIAL_NTLM_FLAGS(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PAC_CREDENTIAL_NTLM_HAS_LM_HASH", PAC_CREDENTIAL_NTLM_HAS_LM_HASH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PAC_CREDENTIAL_NTLM_HAS_NT_HASH", PAC_CREDENTIAL_NTLM_HAS_NT_HASH, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_CREDENTIAL_NTLM_SECPKG(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_CREDENTIAL_NTLM_SECPKG *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_PAC_CREDENTIAL_NTLM_FLAGS(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, &r->lm_password));
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, &r->nt_password));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_CREDENTIAL_NTLM_SECPKG(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_CREDENTIAL_NTLM_SECPKG *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_PAC_CREDENTIAL_NTLM_FLAGS(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, &r->lm_password));
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, &r->nt_password));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_PAC_CREDENTIAL_NTLM_SECPKG(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_CREDENTIAL_NTLM_SECPKG *r)
{
	ndr_print_PAC_CREDENTIAL_NTLM_SECPKG(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_CREDENTIAL_NTLM_SECPKG(struct ndr_print *ndr, const char *name, const struct PAC_CREDENTIAL_NTLM_SECPKG *r)
{
	ndr_print_struct(ndr, name, "PAC_CREDENTIAL_NTLM_SECPKG");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->version);
	ndr_print_PAC_CREDENTIAL_NTLM_FLAGS(ndr, "flags", r->flags);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->package_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->credential_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->credential));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->package_name));
		if (r->credential) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->credential_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->credential, r->credential_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *r)
{
	uint32_t _ptr_credential;
	uint32_t size_credential_1 = 0;
	TALLOC_CTX *_mem_save_credential_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->package_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->credential_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_credential));
		if (_ptr_credential) {
			NDR_PULL_ALLOC(ndr, r->credential);
		} else {
			r->credential = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->package_name));
		if (r->credential) {
			_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->credential, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->credential));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->credential, &size_credential_1));
			NDR_PULL_ALLOC_N(ndr, r->credential, size_credential_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->credential, size_credential_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, 0);
		}
		if (r->credential) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->credential, r->credential_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *r)
{
	ndr_print_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG(struct ndr_print *ndr, const char *name, const struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *r)
{
	ndr_print_struct(ndr, name, "PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "package_name", &r->package_name);
	ndr_print_uint32(ndr, "credential_size", r->credential_size);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_CREDENTIAL_DATA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_CREDENTIAL_DATA *r)
{
	uint32_t cntr_credentials_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->credential_count));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->credential_count));
		for (cntr_credentials_0 = 0; cntr_credentials_0 < (r->credential_count); cntr_credentials_0++) {
			NDR_CHECK(ndr_push_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG(ndr, NDR_SCALARS, &r->credentials[cntr_credentials_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_credentials_0 = 0; cntr_credentials_0 < (r->credential_count); cntr_credentials_0++) {
			NDR_CHECK(ndr_push_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG(ndr, NDR_BUFFERS, &r->credentials[cntr_credentials_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_CREDENTIAL_DATA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_CREDENTIAL_DATA *r)
{
	uint32_t size_credentials_0 = 0;
	uint32_t cntr_credentials_0;
	TALLOC_CTX *_mem_save_credentials_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->credentials));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->credential_count));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->credentials, &size_credentials_0));
		NDR_PULL_ALLOC_N(ndr, r->credentials, size_credentials_0);
		_mem_save_credentials_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->credentials, 0);
		for (cntr_credentials_0 = 0; cntr_credentials_0 < (size_credentials_0); cntr_credentials_0++) {
			NDR_CHECK(ndr_pull_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG(ndr, NDR_SCALARS, &r->credentials[cntr_credentials_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credentials_0, 0);
		if (r->credentials) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->credentials, r->credential_count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->credentials, &size_credentials_0));
		_mem_save_credentials_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->credentials, 0);
		for (cntr_credentials_0 = 0; cntr_credentials_0 < (size_credentials_0); cntr_credentials_0++) {
			NDR_CHECK(ndr_pull_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG(ndr, NDR_BUFFERS, &r->credentials[cntr_credentials_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credentials_0, 0);
		for (cntr_credentials_0 = 0; cntr_credentials_0 < (size_credentials_0); cntr_credentials_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_PAC_CREDENTIAL_DATA(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_CREDENTIAL_DATA *r)
{
	ndr_print_PAC_CREDENTIAL_DATA(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_CREDENTIAL_DATA(struct ndr_print *ndr, const char *name, const struct PAC_CREDENTIAL_DATA *r)
{
	uint32_t cntr_credentials_0;
	ndr_print_struct(ndr, name, "PAC_CREDENTIAL_DATA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "credential_count", r->credential_count);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "credentials", (uint32_t)(r->credential_count));
	ndr->depth++;
	for (cntr_credentials_0 = 0; cntr_credentials_0 < (r->credential_count); cntr_credentials_0++) {
		ndr_print_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG(ndr, "credentials", &r->credentials[cntr_credentials_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_CREDENTIAL_DATA_CTR(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_CREDENTIAL_DATA_CTR *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			NDR_CHECK(ndr_push_PAC_CREDENTIAL_DATA(ndr, NDR_SCALARS|NDR_BUFFERS, r->data));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_CREDENTIAL_DATA_CTR(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_CREDENTIAL_DATA_CTR *r)
{
	uint32_t _ptr_data;
	TALLOC_CTX *_mem_save_data_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->data);
		} else {
			r->data = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
			NDR_CHECK(ndr_pull_PAC_CREDENTIAL_DATA(ndr, NDR_SCALARS|NDR_BUFFERS, r->data));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_PAC_CREDENTIAL_DATA_CTR(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_CREDENTIAL_DATA_CTR *r)
{
	ndr_print_PAC_CREDENTIAL_DATA_CTR(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_CREDENTIAL_DATA_CTR(struct ndr_print *ndr, const char *name, const struct PAC_CREDENTIAL_DATA_CTR *r)
{
	ndr_print_struct(ndr, name, "PAC_CREDENTIAL_DATA_CTR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "data", r->data);
	ndr->depth++;
	if (r->data) {
		ndr_print_PAC_CREDENTIAL_DATA(ndr, "data", r->data);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_CREDENTIAL_DATA_NDR(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_CREDENTIAL_DATA_NDR *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_ctr;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_ctr, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_PAC_CREDENTIAL_DATA_CTR(_ndr_ctr, NDR_SCALARS|NDR_BUFFERS, &r->ctr));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_ctr, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_CREDENTIAL_DATA_NDR(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_CREDENTIAL_DATA_NDR *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_ctr;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_ctr, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_PAC_CREDENTIAL_DATA_CTR(_ndr_ctr, NDR_SCALARS|NDR_BUFFERS, &r->ctr));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_ctr, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_PAC_CREDENTIAL_DATA_NDR(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_CREDENTIAL_DATA_NDR *r)
{
	ndr_print_PAC_CREDENTIAL_DATA_NDR(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_CREDENTIAL_DATA_NDR(struct ndr_print *ndr, const char *name, const struct PAC_CREDENTIAL_DATA_NDR *r)
{
	ndr_print_struct(ndr, name, "PAC_CREDENTIAL_DATA_NDR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_PAC_CREDENTIAL_DATA_CTR(ndr, "ctr", &r->ctr);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_CREDENTIAL_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_CREDENTIAL_INFO *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->encryption_type));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->encrypted_data));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_CREDENTIAL_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_CREDENTIAL_INFO *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->encryption_type));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->encrypted_data));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_PAC_CREDENTIAL_INFO(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_CREDENTIAL_INFO *r)
{
	ndr_print_PAC_CREDENTIAL_INFO(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_CREDENTIAL_INFO(struct ndr_print *ndr, const char *name, const struct PAC_CREDENTIAL_INFO *r)
{
	ndr_print_struct(ndr, name, "PAC_CREDENTIAL_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->version);
	ndr_print_uint32(ndr, "encryption_type", r->encryption_type);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "encrypted_data", r->encrypted_data);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PAC_CONSTRAINED_DELEGATION(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_CONSTRAINED_DELEGATION *r)
{
	uint32_t cntr_transited_services_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->proxy_target));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_transited_services));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->transited_services));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->proxy_target));
		if (r->transited_services) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_transited_services));
			for (cntr_transited_services_1 = 0; cntr_transited_services_1 < (r->num_transited_services); cntr_transited_services_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->transited_services[cntr_transited_services_1]));
			}
			for (cntr_transited_services_1 = 0; cntr_transited_services_1 < (r->num_transited_services); cntr_transited_services_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->transited_services[cntr_transited_services_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_CONSTRAINED_DELEGATION(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_CONSTRAINED_DELEGATION *r)
{
	uint32_t _ptr_transited_services;
	uint32_t size_transited_services_1 = 0;
	uint32_t cntr_transited_services_1;
	TALLOC_CTX *_mem_save_transited_services_0 = NULL;
	TALLOC_CTX *_mem_save_transited_services_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->proxy_target));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_transited_services));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_transited_services));
		if (_ptr_transited_services) {
			NDR_PULL_ALLOC(ndr, r->transited_services);
		} else {
			r->transited_services = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->proxy_target));
		if (r->transited_services) {
			_mem_save_transited_services_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->transited_services, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->transited_services));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->transited_services, &size_transited_services_1));
			NDR_PULL_ALLOC_N(ndr, r->transited_services, size_transited_services_1);
			_mem_save_transited_services_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->transited_services, 0);
			for (cntr_transited_services_1 = 0; cntr_transited_services_1 < (size_transited_services_1); cntr_transited_services_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->transited_services[cntr_transited_services_1]));
			}
			for (cntr_transited_services_1 = 0; cntr_transited_services_1 < (size_transited_services_1); cntr_transited_services_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->transited_services[cntr_transited_services_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_transited_services_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_transited_services_0, 0);
		}
		if (r->transited_services) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->transited_services, r->num_transited_services));
		}
		for (cntr_transited_services_1 = 0; cntr_transited_services_1 < (size_transited_services_1); cntr_transited_services_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_CONSTRAINED_DELEGATION(struct ndr_print *ndr, const char *name, const struct PAC_CONSTRAINED_DELEGATION *r)
{
	uint32_t cntr_transited_services_1;
	ndr_print_struct(ndr, name, "PAC_CONSTRAINED_DELEGATION");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "proxy_target", &r->proxy_target);
	ndr_print_uint32(ndr, "num_transited_services", r->num_transited_services);
	ndr_print_ptr(ndr, "transited_services", r->transited_services);
	ndr->depth++;
	if (r->transited_services) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "transited_services", (uint32_t)(r->num_transited_services));
		ndr->depth++;
		for (cntr_transited_services_1 = 0; cntr_transited_services_1 < (r->num_transited_services); cntr_transited_services_1++) {
			ndr_print_lsa_String(ndr, "transited_services", &r->transited_services[cntr_transited_services_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PAC_UPN_DNS_FLAGS(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_UPN_DNS_FLAGS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_UPN_DNS_FLAGS(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PAC_UPN_DNS_FLAG_CONSTRUCTED", PAC_UPN_DNS_FLAG_CONSTRUCTED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID", PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_UPN_DNS_INFO_SAM_NAME_AND_SID *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * strlen_m(r->samaccountname)));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->samaccountname));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_size_dom_sid(r->objectsid, ndr->flags)));
		NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->objectsid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
			if (r->samaccountname) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->samaccountname));
				{
					struct ndr_push *_ndr_samaccountname;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_samaccountname, 0, 2 * strlen_m(r->samaccountname)));
					NDR_CHECK(ndr_push_string(_ndr_samaccountname, NDR_SCALARS, r->samaccountname));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_samaccountname, 0, 2 * strlen_m(r->samaccountname)));
				}
			}
			ndr->flags = _flags_save_string;
		}
		if (r->objectsid) {
			NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->objectsid));
			{
				struct ndr_push *_ndr_objectsid;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_objectsid, 0, ndr_size_dom_sid(r->objectsid, ndr->flags)));
				NDR_CHECK(ndr_push_dom_sid(_ndr_objectsid, NDR_SCALARS, r->objectsid));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_objectsid, 0, ndr_size_dom_sid(r->objectsid, ndr->flags)));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_UPN_DNS_INFO_SAM_NAME_AND_SID *r)
{
	uint16_t _ptr_samaccountname;
	TALLOC_CTX *_mem_save_samaccountname_0 = NULL;
	uint16_t _ptr_objectsid;
	TALLOC_CTX *_mem_save_objectsid_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->samaccountname_size));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_samaccountname));
			if (_ptr_samaccountname) {
				NDR_PULL_ALLOC(ndr, r->samaccountname);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->samaccountname, _ptr_samaccountname));
			} else {
				r->samaccountname = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->objectsid_size));
		NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_objectsid));
		if (_ptr_objectsid) {
			NDR_PULL_ALLOC(ndr, r->objectsid);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->objectsid, _ptr_objectsid));
		} else {
			r->objectsid = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
			if (r->samaccountname) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->samaccountname));
				_mem_save_samaccountname_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->samaccountname, 0);
				{
					struct ndr_pull *_ndr_samaccountname;
					ssize_t sub_size = r->samaccountname_size;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_samaccountname, 0, sub_size));
					NDR_CHECK(ndr_pull_string(_ndr_samaccountname, NDR_SCALARS, &r->samaccountname));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_samaccountname, 0, sub_size));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_samaccountname_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		if (r->objectsid) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->objectsid));
			_mem_save_objectsid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->objectsid, 0);
			{
				struct ndr_pull *_ndr_objectsid;
				ssize_t sub_size = r->objectsid_size;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_objectsid, 0, sub_size));
				NDR_CHECK(ndr_pull_dom_sid(_ndr_objectsid, NDR_SCALARS, r->objectsid));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_objectsid, 0, sub_size));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_objectsid_0, 0);
			if (ndr->offset > ndr->relative_highest_offset) {
				ndr->relative_highest_offset = ndr->offset;
			}
			ndr->offset = _relative_save_offset;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID(struct ndr_print *ndr, const char *name, const struct PAC_UPN_DNS_INFO_SAM_NAME_AND_SID *r)
{
	ndr_print_struct(ndr, name, "PAC_UPN_DNS_INFO_SAM_NAME_AND_SID");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "samaccountname_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m(r->samaccountname):r->samaccountname_size);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
		ndr_print_ptr(ndr, "samaccountname", r->samaccountname);
		ndr->depth++;
		if (r->samaccountname) {
			ndr_print_string(ndr, "samaccountname", r->samaccountname);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr_print_uint16(ndr, "objectsid_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_dom_sid(r->objectsid, ndr->flags):r->objectsid_size);
	ndr_print_ptr(ndr, "objectsid", r->objectsid);
	ndr->depth++;
	if (r->objectsid) {
		ndr_print_dom_sid(ndr, "objectsid", r->objectsid);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PAC_UPN_DNS_INFO_EX(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union PAC_UPN_DNS_INFO_EX *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID: {
				NDR_CHECK(ndr_push_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID(ndr, NDR_SCALARS, &r->sam_name_and_sid));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID:
				NDR_CHECK(ndr_push_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID(ndr, NDR_BUFFERS, &r->sam_name_and_sid));
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_UPN_DNS_INFO_EX(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union PAC_UPN_DNS_INFO_EX *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID: {
				NDR_CHECK(ndr_pull_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID(ndr, NDR_SCALARS, &r->sam_name_and_sid));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID:
				NDR_CHECK(ndr_pull_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID(ndr, NDR_BUFFERS, &r->sam_name_and_sid));
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_UPN_DNS_INFO_EX(struct ndr_print *ndr, const char *name, const union PAC_UPN_DNS_INFO_EX *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "PAC_UPN_DNS_INFO_EX");
	switch (level) {
		case PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID:
			ndr_print_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID(ndr, "sam_name_and_sid", &r->sam_name_and_sid);
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_PAC_UPN_DNS_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_UPN_DNS_INFO *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * strlen_m(r->upn_name)));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->upn_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * strlen_m(r->dns_domain_name)));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->dns_domain_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_PAC_UPN_DNS_FLAGS(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ex, r->flags & PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID));
		NDR_CHECK(ndr_push_PAC_UPN_DNS_INFO_EX(ndr, NDR_SCALARS, &r->ex));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
			if (r->upn_name) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->upn_name));
				{
					struct ndr_push *_ndr_upn_name;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_upn_name, 0, 2 * strlen_m(r->upn_name)));
					NDR_CHECK(ndr_push_string(_ndr_upn_name, NDR_SCALARS, r->upn_name));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_upn_name, 0, 2 * strlen_m(r->upn_name)));
				}
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
			if (r->dns_domain_name) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->dns_domain_name));
				{
					struct ndr_push *_ndr_dns_domain_name;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_dns_domain_name, 0, 2 * strlen_m(r->dns_domain_name)));
					NDR_CHECK(ndr_push_string(_ndr_dns_domain_name, NDR_SCALARS, r->dns_domain_name));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_dns_domain_name, 0, 2 * strlen_m(r->dns_domain_name)));
				}
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ex, r->flags & PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID));
		NDR_CHECK(ndr_push_PAC_UPN_DNS_INFO_EX(ndr, NDR_BUFFERS, &r->ex));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_UPN_DNS_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_UPN_DNS_INFO *r)
{
	uint16_t _ptr_upn_name;
	TALLOC_CTX *_mem_save_upn_name_0 = NULL;
	uint16_t _ptr_dns_domain_name;
	TALLOC_CTX *_mem_save_dns_domain_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->upn_name_size));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_upn_name));
			if (_ptr_upn_name) {
				NDR_PULL_ALLOC(ndr, r->upn_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->upn_name, _ptr_upn_name));
			} else {
				r->upn_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->dns_domain_name_size));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_dns_domain_name));
			if (_ptr_dns_domain_name) {
				NDR_PULL_ALLOC(ndr, r->dns_domain_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->dns_domain_name, _ptr_dns_domain_name));
			} else {
				r->dns_domain_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_PAC_UPN_DNS_FLAGS(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ex, r->flags & PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID));
		NDR_CHECK(ndr_pull_PAC_UPN_DNS_INFO_EX(ndr, NDR_SCALARS, &r->ex));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
			if (r->upn_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->upn_name));
				_mem_save_upn_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->upn_name, 0);
				{
					struct ndr_pull *_ndr_upn_name;
					ssize_t sub_size = r->upn_name_size;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_upn_name, 0, sub_size));
					NDR_CHECK(ndr_pull_string(_ndr_upn_name, NDR_SCALARS, &r->upn_name));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_upn_name, 0, sub_size));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_upn_name_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
			if (r->dns_domain_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->dns_domain_name));
				_mem_save_dns_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->dns_domain_name, 0);
				{
					struct ndr_pull *_ndr_dns_domain_name;
					ssize_t sub_size = r->dns_domain_name_size;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_dns_domain_name, 0, sub_size));
					NDR_CHECK(ndr_pull_string(_ndr_dns_domain_name, NDR_SCALARS, &r->dns_domain_name));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_dns_domain_name, 0, sub_size));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_domain_name_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ex, r->flags & PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID));
		NDR_CHECK(ndr_pull_PAC_UPN_DNS_INFO_EX(ndr, NDR_BUFFERS, &r->ex));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_UPN_DNS_INFO(struct ndr_print *ndr, const char *name, const struct PAC_UPN_DNS_INFO *r)
{
	ndr_print_struct(ndr, name, "PAC_UPN_DNS_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "upn_name_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m(r->upn_name):r->upn_name_size);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
		ndr_print_ptr(ndr, "upn_name", r->upn_name);
		ndr->depth++;
		if (r->upn_name) {
			ndr_print_string(ndr, "upn_name", r->upn_name);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr_print_uint16(ndr, "dns_domain_name_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m(r->dns_domain_name):r->dns_domain_name_size);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_REMAINING);
		ndr_print_ptr(ndr, "dns_domain_name", r->dns_domain_name);
		ndr->depth++;
		if (r->dns_domain_name) {
			ndr_print_string(ndr, "dns_domain_name", r->dns_domain_name);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr_print_PAC_UPN_DNS_FLAGS(ndr, "flags", r->flags);
	ndr_print_set_switch_value(ndr, &r->ex, r->flags & PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID);
	ndr_print_PAC_UPN_DNS_INFO_EX(ndr, "ex", &r->ex);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PAC_ATTRIBUTE_INFO_FLAGS(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_ATTRIBUTE_INFO_FLAGS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_ATTRIBUTE_INFO_FLAGS(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PAC_ATTRIBUTE_FLAG_PAC_WAS_REQUESTED", PAC_ATTRIBUTE_FLAG_PAC_WAS_REQUESTED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PAC_ATTRIBUTE_FLAG_PAC_WAS_GIVEN_IMPLICITLY", PAC_ATTRIBUTE_FLAG_PAC_WAS_GIVEN_IMPLICITLY, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PAC_ATTRIBUTES_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_ATTRIBUTES_INFO *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags_length));
		NDR_CHECK(ndr_push_PAC_ATTRIBUTE_INFO_FLAGS(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_ATTRIBUTES_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_ATTRIBUTES_INFO *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags_length));
		NDR_CHECK(ndr_pull_PAC_ATTRIBUTE_INFO_FLAGS(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_ATTRIBUTES_INFO(struct ndr_print *ndr, const char *name, const struct PAC_ATTRIBUTES_INFO *r)
{
	ndr_print_struct(ndr, name, "PAC_ATTRIBUTES_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "flags_length", r->flags_length);
	ndr_print_PAC_ATTRIBUTE_INFO_FLAGS(ndr, "flags", r->flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PAC_REQUESTER_SID(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_REQUESTER_SID *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_REQUESTER_SID(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_REQUESTER_SID *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_REQUESTER_SID(struct ndr_print *ndr, const char *name, const struct PAC_REQUESTER_SID *r)
{
	ndr_print_struct(ndr, name, "PAC_REQUESTER_SID");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dom_sid(ndr, "sid", &r->sid);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_LOGON_INFO_CTR(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_LOGON_INFO_CTR *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			NDR_CHECK(ndr_push_PAC_LOGON_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_LOGON_INFO_CTR(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_LOGON_INFO_CTR *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->info);
		} else {
			r->info = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
			NDR_CHECK(ndr_pull_PAC_LOGON_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_PAC_LOGON_INFO_CTR(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_LOGON_INFO_CTR *r)
{
	ndr_print_PAC_LOGON_INFO_CTR(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_LOGON_INFO_CTR(struct ndr_print *ndr, const char *name, const struct PAC_LOGON_INFO_CTR *r)
{
	ndr_print_struct(ndr, name, "PAC_LOGON_INFO_CTR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "info", r->info);
	ndr->depth++;
	if (r->info) {
		ndr_print_PAC_LOGON_INFO(ndr, "info", r->info);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_CONSTRAINED_DELEGATION_CTR(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_CONSTRAINED_DELEGATION_CTR *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			NDR_CHECK(ndr_push_PAC_CONSTRAINED_DELEGATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_CONSTRAINED_DELEGATION_CTR(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_CONSTRAINED_DELEGATION_CTR *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->info);
		} else {
			r->info = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
			NDR_CHECK(ndr_pull_PAC_CONSTRAINED_DELEGATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_PAC_CONSTRAINED_DELEGATION_CTR(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_CONSTRAINED_DELEGATION_CTR *r)
{
	ndr_print_PAC_CONSTRAINED_DELEGATION_CTR(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_CONSTRAINED_DELEGATION_CTR(struct ndr_print *ndr, const char *name, const struct PAC_CONSTRAINED_DELEGATION_CTR *r)
{
	ndr_print_struct(ndr, name, "PAC_CONSTRAINED_DELEGATION_CTR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "info", r->info);
	ndr->depth++;
	if (r->info) {
		ndr_print_PAC_CONSTRAINED_DELEGATION(ndr, "info", r->info);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PAC_DEVICE_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_DEVICE_INFO *r)
{
	uint32_t cntr_sids_1;
	uint32_t cntr_domain_groups_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->primary_gid));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_sid));
		NDR_CHECK(ndr_push_samr_RidWithAttributeArray(ndr, NDR_SCALARS, &r->groups));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->domain_group_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_groups));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain_sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain_sid));
		}
		NDR_CHECK(ndr_push_samr_RidWithAttributeArray(ndr, NDR_BUFFERS, &r->groups));
		if (r->sids) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->sid_count));
			for (cntr_sids_1 = 0; cntr_sids_1 < (r->sid_count); cntr_sids_1++) {
				NDR_CHECK(ndr_push_netr_SidAttr(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < (r->sid_count); cntr_sids_1++) {
				NDR_CHECK(ndr_push_netr_SidAttr(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
		}
		if (r->domain_groups) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->domain_group_count));
			for (cntr_domain_groups_1 = 0; cntr_domain_groups_1 < (r->domain_group_count); cntr_domain_groups_1++) {
				NDR_CHECK(ndr_push_PAC_DOMAIN_GROUP_MEMBERSHIP(ndr, NDR_SCALARS, &r->domain_groups[cntr_domain_groups_1]));
			}
			for (cntr_domain_groups_1 = 0; cntr_domain_groups_1 < (r->domain_group_count); cntr_domain_groups_1++) {
				NDR_CHECK(ndr_push_PAC_DOMAIN_GROUP_MEMBERSHIP(ndr, NDR_BUFFERS, &r->domain_groups[cntr_domain_groups_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_DEVICE_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_DEVICE_INFO *r)
{
	uint32_t _ptr_domain_sid;
	TALLOC_CTX *_mem_save_domain_sid_0 = NULL;
	uint32_t _ptr_sids;
	uint32_t size_sids_1 = 0;
	uint32_t cntr_sids_1;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_sids_1 = NULL;
	uint32_t _ptr_domain_groups;
	uint32_t size_domain_groups_1 = 0;
	uint32_t cntr_domain_groups_1;
	TALLOC_CTX *_mem_save_domain_groups_0 = NULL;
	TALLOC_CTX *_mem_save_domain_groups_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->primary_gid));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_sid));
		if (_ptr_domain_sid) {
			NDR_PULL_ALLOC(ndr, r->domain_sid);
		} else {
			r->domain_sid = NULL;
		}
		NDR_CHECK(ndr_pull_samr_RidWithAttributeArray(ndr, NDR_SCALARS, &r->groups));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
		if (_ptr_sids) {
			NDR_PULL_ALLOC(ndr, r->sids);
		} else {
			r->sids = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->domain_group_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_groups));
		if (_ptr_domain_groups) {
			NDR_PULL_ALLOC(ndr, r->domain_groups);
		} else {
			r->domain_groups = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain_sid) {
			_mem_save_domain_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain_sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_sid_0, 0);
		}
		NDR_CHECK(ndr_pull_samr_RidWithAttributeArray(ndr, NDR_BUFFERS, &r->groups));
		if (r->sids) {
			_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->sids, &size_sids_1));
			NDR_PULL_ALLOC_N(ndr, r->sids, size_sids_1);
			_mem_save_sids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
				NDR_CHECK(ndr_pull_netr_SidAttr(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
				NDR_CHECK(ndr_pull_netr_SidAttr(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		}
		if (r->domain_groups) {
			_mem_save_domain_groups_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_groups, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain_groups));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->domain_groups, &size_domain_groups_1));
			NDR_PULL_ALLOC_N(ndr, r->domain_groups, size_domain_groups_1);
			_mem_save_domain_groups_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_groups, 0);
			for (cntr_domain_groups_1 = 0; cntr_domain_groups_1 < (size_domain_groups_1); cntr_domain_groups_1++) {
				NDR_CHECK(ndr_pull_PAC_DOMAIN_GROUP_MEMBERSHIP(ndr, NDR_SCALARS, &r->domain_groups[cntr_domain_groups_1]));
			}
			for (cntr_domain_groups_1 = 0; cntr_domain_groups_1 < (size_domain_groups_1); cntr_domain_groups_1++) {
				NDR_CHECK(ndr_pull_PAC_DOMAIN_GROUP_MEMBERSHIP(ndr, NDR_BUFFERS, &r->domain_groups[cntr_domain_groups_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_groups_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_groups_0, 0);
		}
		if (r->sids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sids, r->sid_count));
		}
		for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
		}
		if (r->domain_groups) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->domain_groups, r->domain_group_count));
		}
		for (cntr_domain_groups_1 = 0; cntr_domain_groups_1 < (size_domain_groups_1); cntr_domain_groups_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_DEVICE_INFO(struct ndr_print *ndr, const char *name, const struct PAC_DEVICE_INFO *r)
{
	uint32_t cntr_sids_1;
	uint32_t cntr_domain_groups_1;
	ndr_print_struct(ndr, name, "PAC_DEVICE_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_uint32(ndr, "primary_gid", r->primary_gid);
	ndr_print_ptr(ndr, "domain_sid", r->domain_sid);
	ndr->depth++;
	if (r->domain_sid) {
		ndr_print_dom_sid2(ndr, "domain_sid", r->domain_sid);
	}
	ndr->depth--;
	ndr_print_samr_RidWithAttributeArray(ndr, "groups", &r->groups);
	ndr_print_uint32(ndr, "sid_count", r->sid_count);
	ndr_print_ptr(ndr, "sids", r->sids);
	ndr->depth++;
	if (r->sids) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "sids", (uint32_t)(r->sid_count));
		ndr->depth++;
		for (cntr_sids_1 = 0; cntr_sids_1 < (r->sid_count); cntr_sids_1++) {
			ndr_print_netr_SidAttr(ndr, "sids", &r->sids[cntr_sids_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "domain_group_count", r->domain_group_count);
	ndr_print_ptr(ndr, "domain_groups", r->domain_groups);
	ndr->depth++;
	if (r->domain_groups) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "domain_groups", (uint32_t)(r->domain_group_count));
		ndr->depth++;
		for (cntr_domain_groups_1 = 0; cntr_domain_groups_1 < (r->domain_group_count); cntr_domain_groups_1++) {
			ndr_print_PAC_DOMAIN_GROUP_MEMBERSHIP(ndr, "domain_groups", &r->domain_groups[cntr_domain_groups_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PAC_DEVICE_INFO_CTR(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_DEVICE_INFO_CTR *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			NDR_CHECK(ndr_push_PAC_DEVICE_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_DEVICE_INFO_CTR(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_DEVICE_INFO_CTR *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->info);
		} else {
			r->info = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
			NDR_CHECK(ndr_pull_PAC_DEVICE_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_DEVICE_INFO_CTR(struct ndr_print *ndr, const char *name, const struct PAC_DEVICE_INFO_CTR *r)
{
	ndr_print_struct(ndr, name, "PAC_DEVICE_INFO_CTR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "info", r->info);
	ndr->depth++;
	if (r->info) {
		ndr_print_PAC_DEVICE_INFO(ndr, "info", r->info);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_TYPE(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum PAC_TYPE r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_TYPE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum PAC_TYPE *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_TYPE(struct ndr_print *ndr, const char *name, enum PAC_TYPE r)
{
	const char *val = NULL;

	switch (r) {
		case PAC_TYPE_LOGON_INFO: val = "PAC_TYPE_LOGON_INFO"; break;
		case PAC_TYPE_CREDENTIAL_INFO: val = "PAC_TYPE_CREDENTIAL_INFO"; break;
		case PAC_TYPE_SRV_CHECKSUM: val = "PAC_TYPE_SRV_CHECKSUM"; break;
		case PAC_TYPE_KDC_CHECKSUM: val = "PAC_TYPE_KDC_CHECKSUM"; break;
		case PAC_TYPE_LOGON_NAME: val = "PAC_TYPE_LOGON_NAME"; break;
		case PAC_TYPE_CONSTRAINED_DELEGATION: val = "PAC_TYPE_CONSTRAINED_DELEGATION"; break;
		case PAC_TYPE_UPN_DNS_INFO: val = "PAC_TYPE_UPN_DNS_INFO"; break;
		case PAC_TYPE_CLIENT_CLAIMS_INFO: val = "PAC_TYPE_CLIENT_CLAIMS_INFO"; break;
		case PAC_TYPE_DEVICE_INFO: val = "PAC_TYPE_DEVICE_INFO"; break;
		case PAC_TYPE_DEVICE_CLAIMS_INFO: val = "PAC_TYPE_DEVICE_CLAIMS_INFO"; break;
		case PAC_TYPE_TICKET_CHECKSUM: val = "PAC_TYPE_TICKET_CHECKSUM"; break;
		case PAC_TYPE_ATTRIBUTES_INFO: val = "PAC_TYPE_ATTRIBUTES_INFO"; break;
		case PAC_TYPE_REQUESTER_SID: val = "PAC_TYPE_REQUESTER_SID"; break;
		case PAC_TYPE_FULL_CHECKSUM: val = "PAC_TYPE_FULL_CHECKSUM"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_DATA_BLOB_REM(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DATA_BLOB_REM *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->remaining));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DATA_BLOB_REM(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DATA_BLOB_REM *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->remaining));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DATA_BLOB_REM(struct ndr_print *ndr, const char *name, const struct DATA_BLOB_REM *r)
{
	ndr_print_struct(ndr, name, "DATA_BLOB_REM");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "remaining", r->remaining);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union PAC_INFO *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case PAC_TYPE_LOGON_INFO: {
				{
					struct ndr_push *_ndr_logon_info;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_logon_info, 0xFFFFFC01, -1));
					NDR_CHECK(ndr_push_PAC_LOGON_INFO_CTR(_ndr_logon_info, NDR_SCALARS|NDR_BUFFERS, &r->logon_info));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_logon_info, 0xFFFFFC01, -1));
				}
			break; }

			case PAC_TYPE_CREDENTIAL_INFO: {
				NDR_CHECK(ndr_push_PAC_CREDENTIAL_INFO(ndr, NDR_SCALARS, &r->credential_info));
			break; }

			case PAC_TYPE_SRV_CHECKSUM: {
				NDR_CHECK(ndr_push_PAC_SIGNATURE_DATA(ndr, NDR_SCALARS, &r->srv_cksum));
			break; }

			case PAC_TYPE_KDC_CHECKSUM: {
				NDR_CHECK(ndr_push_PAC_SIGNATURE_DATA(ndr, NDR_SCALARS, &r->kdc_cksum));
			break; }

			case PAC_TYPE_LOGON_NAME: {
				NDR_CHECK(ndr_push_PAC_LOGON_NAME(ndr, NDR_SCALARS, &r->logon_name));
			break; }

			case PAC_TYPE_CONSTRAINED_DELEGATION: {
				{
					struct ndr_push *_ndr_constrained_delegation;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_constrained_delegation, 0xFFFFFC01, -1));
					NDR_CHECK(ndr_push_PAC_CONSTRAINED_DELEGATION_CTR(_ndr_constrained_delegation, NDR_SCALARS|NDR_BUFFERS, &r->constrained_delegation));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_constrained_delegation, 0xFFFFFC01, -1));
				}
			break; }

			case PAC_TYPE_UPN_DNS_INFO: {
				NDR_CHECK(ndr_push_PAC_UPN_DNS_INFO(ndr, NDR_SCALARS, &r->upn_dns_info));
			break; }

			case PAC_TYPE_TICKET_CHECKSUM: {
				NDR_CHECK(ndr_push_PAC_SIGNATURE_DATA(ndr, NDR_SCALARS, &r->ticket_checksum));
			break; }

			case PAC_TYPE_ATTRIBUTES_INFO: {
				NDR_CHECK(ndr_push_PAC_ATTRIBUTES_INFO(ndr, NDR_SCALARS, &r->attributes_info));
			break; }

			case PAC_TYPE_REQUESTER_SID: {
				NDR_CHECK(ndr_push_PAC_REQUESTER_SID(ndr, NDR_SCALARS, &r->requester_sid));
			break; }

			case PAC_TYPE_CLIENT_CLAIMS_INFO: {
				{
					struct ndr_push *_ndr_client_claims_info;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_client_claims_info, 0, -1));
					NDR_CHECK(ndr_push_DATA_BLOB_REM(_ndr_client_claims_info, NDR_SCALARS, &r->client_claims_info));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_client_claims_info, 0, -1));
				}
			break; }

			case PAC_TYPE_DEVICE_INFO: {
				{
					struct ndr_push *_ndr_device_info;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_device_info, 0xFFFFFC01, -1));
					NDR_CHECK(ndr_push_PAC_DEVICE_INFO_CTR(_ndr_device_info, NDR_SCALARS|NDR_BUFFERS, &r->device_info));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_device_info, 0xFFFFFC01, -1));
				}
			break; }

			case PAC_TYPE_DEVICE_CLAIMS_INFO: {
				{
					struct ndr_push *_ndr_device_claims_info;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_device_claims_info, 0, -1));
					NDR_CHECK(ndr_push_DATA_BLOB_REM(_ndr_device_claims_info, NDR_SCALARS, &r->device_claims_info));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_device_claims_info, 0, -1));
				}
			break; }

			case PAC_TYPE_FULL_CHECKSUM: {
				NDR_CHECK(ndr_push_PAC_SIGNATURE_DATA(ndr, NDR_SCALARS, &r->full_checksum));
			break; }

			default: {
				{
					struct ndr_push *_ndr_unknown;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_unknown, 0, -1));
					NDR_CHECK(ndr_push_DATA_BLOB_REM(_ndr_unknown, NDR_SCALARS, &r->unknown));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_unknown, 0, -1));
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case PAC_TYPE_LOGON_INFO:
			break;

			case PAC_TYPE_CREDENTIAL_INFO:
			break;

			case PAC_TYPE_SRV_CHECKSUM:
			break;

			case PAC_TYPE_KDC_CHECKSUM:
			break;

			case PAC_TYPE_LOGON_NAME:
			break;

			case PAC_TYPE_CONSTRAINED_DELEGATION:
			break;

			case PAC_TYPE_UPN_DNS_INFO:
				NDR_CHECK(ndr_push_PAC_UPN_DNS_INFO(ndr, NDR_BUFFERS, &r->upn_dns_info));
			break;

			case PAC_TYPE_TICKET_CHECKSUM:
			break;

			case PAC_TYPE_ATTRIBUTES_INFO:
			break;

			case PAC_TYPE_REQUESTER_SID:
			break;

			case PAC_TYPE_CLIENT_CLAIMS_INFO:
			break;

			case PAC_TYPE_DEVICE_INFO:
			break;

			case PAC_TYPE_DEVICE_CLAIMS_INFO:
			break;

			case PAC_TYPE_FULL_CHECKSUM:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union PAC_INFO *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case PAC_TYPE_LOGON_INFO: {
				{
					struct ndr_pull *_ndr_logon_info;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_logon_info, 0xFFFFFC01, sub_size));
					NDR_CHECK(ndr_pull_PAC_LOGON_INFO_CTR(_ndr_logon_info, NDR_SCALARS|NDR_BUFFERS, &r->logon_info));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_logon_info, 0xFFFFFC01, sub_size));
				}
			break; }

			case PAC_TYPE_CREDENTIAL_INFO: {
				NDR_CHECK(ndr_pull_PAC_CREDENTIAL_INFO(ndr, NDR_SCALARS, &r->credential_info));
			break; }

			case PAC_TYPE_SRV_CHECKSUM: {
				NDR_CHECK(ndr_pull_PAC_SIGNATURE_DATA(ndr, NDR_SCALARS, &r->srv_cksum));
			break; }

			case PAC_TYPE_KDC_CHECKSUM: {
				NDR_CHECK(ndr_pull_PAC_SIGNATURE_DATA(ndr, NDR_SCALARS, &r->kdc_cksum));
			break; }

			case PAC_TYPE_LOGON_NAME: {
				NDR_CHECK(ndr_pull_PAC_LOGON_NAME(ndr, NDR_SCALARS, &r->logon_name));
			break; }

			case PAC_TYPE_CONSTRAINED_DELEGATION: {
				{
					struct ndr_pull *_ndr_constrained_delegation;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_constrained_delegation, 0xFFFFFC01, sub_size));
					NDR_CHECK(ndr_pull_PAC_CONSTRAINED_DELEGATION_CTR(_ndr_constrained_delegation, NDR_SCALARS|NDR_BUFFERS, &r->constrained_delegation));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_constrained_delegation, 0xFFFFFC01, sub_size));
				}
			break; }

			case PAC_TYPE_UPN_DNS_INFO: {
				NDR_CHECK(ndr_pull_PAC_UPN_DNS_INFO(ndr, NDR_SCALARS, &r->upn_dns_info));
			break; }

			case PAC_TYPE_TICKET_CHECKSUM: {
				NDR_CHECK(ndr_pull_PAC_SIGNATURE_DATA(ndr, NDR_SCALARS, &r->ticket_checksum));
			break; }

			case PAC_TYPE_ATTRIBUTES_INFO: {
				NDR_CHECK(ndr_pull_PAC_ATTRIBUTES_INFO(ndr, NDR_SCALARS, &r->attributes_info));
			break; }

			case PAC_TYPE_REQUESTER_SID: {
				NDR_CHECK(ndr_pull_PAC_REQUESTER_SID(ndr, NDR_SCALARS, &r->requester_sid));
			break; }

			case PAC_TYPE_CLIENT_CLAIMS_INFO: {
				{
					struct ndr_pull *_ndr_client_claims_info;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_client_claims_info, 0, sub_size));
					NDR_CHECK(ndr_pull_DATA_BLOB_REM(_ndr_client_claims_info, NDR_SCALARS, &r->client_claims_info));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_client_claims_info, 0, sub_size));
				}
			break; }

			case PAC_TYPE_DEVICE_INFO: {
				{
					struct ndr_pull *_ndr_device_info;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_device_info, 0xFFFFFC01, sub_size));
					NDR_CHECK(ndr_pull_PAC_DEVICE_INFO_CTR(_ndr_device_info, NDR_SCALARS|NDR_BUFFERS, &r->device_info));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_device_info, 0xFFFFFC01, sub_size));
				}
			break; }

			case PAC_TYPE_DEVICE_CLAIMS_INFO: {
				{
					struct ndr_pull *_ndr_device_claims_info;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_device_claims_info, 0, sub_size));
					NDR_CHECK(ndr_pull_DATA_BLOB_REM(_ndr_device_claims_info, NDR_SCALARS, &r->device_claims_info));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_device_claims_info, 0, sub_size));
				}
			break; }

			case PAC_TYPE_FULL_CHECKSUM: {
				NDR_CHECK(ndr_pull_PAC_SIGNATURE_DATA(ndr, NDR_SCALARS, &r->full_checksum));
			break; }

			default: {
				{
					struct ndr_pull *_ndr_unknown;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_unknown, 0, sub_size));
					NDR_CHECK(ndr_pull_DATA_BLOB_REM(_ndr_unknown, NDR_SCALARS, &r->unknown));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_unknown, 0, sub_size));
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case PAC_TYPE_LOGON_INFO:
			break;

			case PAC_TYPE_CREDENTIAL_INFO:
			break;

			case PAC_TYPE_SRV_CHECKSUM:
			break;

			case PAC_TYPE_KDC_CHECKSUM:
			break;

			case PAC_TYPE_LOGON_NAME:
			break;

			case PAC_TYPE_CONSTRAINED_DELEGATION:
			break;

			case PAC_TYPE_UPN_DNS_INFO:
				NDR_CHECK(ndr_pull_PAC_UPN_DNS_INFO(ndr, NDR_BUFFERS, &r->upn_dns_info));
			break;

			case PAC_TYPE_TICKET_CHECKSUM:
			break;

			case PAC_TYPE_ATTRIBUTES_INFO:
			break;

			case PAC_TYPE_REQUESTER_SID:
			break;

			case PAC_TYPE_CLIENT_CLAIMS_INFO:
			break;

			case PAC_TYPE_DEVICE_INFO:
			break;

			case PAC_TYPE_DEVICE_CLAIMS_INFO:
			break;

			case PAC_TYPE_FULL_CHECKSUM:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_INFO(struct ndr_print *ndr, const char *name, const union PAC_INFO *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "PAC_INFO");
	switch (level) {
		case PAC_TYPE_LOGON_INFO:
			ndr_print_PAC_LOGON_INFO_CTR(ndr, "logon_info", &r->logon_info);
		break;

		case PAC_TYPE_CREDENTIAL_INFO:
			ndr_print_PAC_CREDENTIAL_INFO(ndr, "credential_info", &r->credential_info);
		break;

		case PAC_TYPE_SRV_CHECKSUM:
			ndr_print_PAC_SIGNATURE_DATA(ndr, "srv_cksum", &r->srv_cksum);
		break;

		case PAC_TYPE_KDC_CHECKSUM:
			ndr_print_PAC_SIGNATURE_DATA(ndr, "kdc_cksum", &r->kdc_cksum);
		break;

		case PAC_TYPE_LOGON_NAME:
			ndr_print_PAC_LOGON_NAME(ndr, "logon_name", &r->logon_name);
		break;

		case PAC_TYPE_CONSTRAINED_DELEGATION:
			ndr_print_PAC_CONSTRAINED_DELEGATION_CTR(ndr, "constrained_delegation", &r->constrained_delegation);
		break;

		case PAC_TYPE_UPN_DNS_INFO:
			ndr_print_PAC_UPN_DNS_INFO(ndr, "upn_dns_info", &r->upn_dns_info);
		break;

		case PAC_TYPE_TICKET_CHECKSUM:
			ndr_print_PAC_SIGNATURE_DATA(ndr, "ticket_checksum", &r->ticket_checksum);
		break;

		case PAC_TYPE_ATTRIBUTES_INFO:
			ndr_print_PAC_ATTRIBUTES_INFO(ndr, "attributes_info", &r->attributes_info);
		break;

		case PAC_TYPE_REQUESTER_SID:
			ndr_print_PAC_REQUESTER_SID(ndr, "requester_sid", &r->requester_sid);
		break;

		case PAC_TYPE_CLIENT_CLAIMS_INFO:
			ndr_print_DATA_BLOB_REM(ndr, "client_claims_info", &r->client_claims_info);
		break;

		case PAC_TYPE_DEVICE_INFO:
			ndr_print_PAC_DEVICE_INFO_CTR(ndr, "device_info", &r->device_info);
		break;

		case PAC_TYPE_DEVICE_CLAIMS_INFO:
			ndr_print_DATA_BLOB_REM(ndr, "device_claims_info", &r->device_claims_info);
		break;

		case PAC_TYPE_FULL_CHECKSUM:
			ndr_print_PAC_SIGNATURE_DATA(ndr, "full_checksum", &r->full_checksum);
		break;

		default:
			ndr_print_DATA_BLOB_REM(ndr, "unknown", &r->unknown);
		break;

	}
}

_PUBLIC_ size_t ndr_size_PAC_INFO(const union PAC_INFO *r, uint32_t level, libndr_flags flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_PAC_INFO);
}

static void ndr_print_flags_PAC_BUFFER(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_BUFFER *r)
{
	ndr_print_PAC_BUFFER(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_BUFFER(struct ndr_print *ndr, const char *name, const struct PAC_BUFFER *r)
{
	ndr_print_struct(ndr, name, "PAC_BUFFER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_PAC_TYPE(ndr, "type", r->type);
	ndr_print_uint32(ndr, "_ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?_ndr_size_PAC_INFO(r->info, r->type, LIBNDR_FLAG_ALIGN8):r->_ndr_size);
	{
		libndr_flags _flags_save_PAC_INFO = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
		ndr_print_ptr(ndr, "info", r->info);
		ndr->depth++;
		if (r->info) {
			ndr_print_set_switch_value(ndr, r->info, r->type);
			ndr_print_PAC_INFO(ndr, "info", r->info);
		}
		ndr->depth--;
		ndr->flags = _flags_save_PAC_INFO;
	}
	ndr_print_uint32(ndr, "_pad", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->_pad);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_DATA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_DATA *r)
{
	uint32_t cntr_buffers_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_buffers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		for (cntr_buffers_0 = 0; cntr_buffers_0 < (r->num_buffers); cntr_buffers_0++) {
			NDR_CHECK(ndr_push_PAC_BUFFER(ndr, NDR_SCALARS, &r->buffers[cntr_buffers_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_buffers_0 = 0; cntr_buffers_0 < (r->num_buffers); cntr_buffers_0++) {
			NDR_CHECK(ndr_push_PAC_BUFFER(ndr, NDR_BUFFERS, &r->buffers[cntr_buffers_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_DATA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_DATA *r)
{
	uint32_t size_buffers_0 = 0;
	uint32_t cntr_buffers_0;
	TALLOC_CTX *_mem_save_buffers_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_buffers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		size_buffers_0 = r->num_buffers;
		NDR_PULL_ALLOC_N(ndr, r->buffers, size_buffers_0);
		_mem_save_buffers_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->buffers, 0);
		for (cntr_buffers_0 = 0; cntr_buffers_0 < (size_buffers_0); cntr_buffers_0++) {
			NDR_CHECK(ndr_pull_PAC_BUFFER(ndr, NDR_SCALARS, &r->buffers[cntr_buffers_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffers_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		size_buffers_0 = r->num_buffers;
		_mem_save_buffers_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->buffers, 0);
		for (cntr_buffers_0 = 0; cntr_buffers_0 < (size_buffers_0); cntr_buffers_0++) {
			NDR_CHECK(ndr_pull_PAC_BUFFER(ndr, NDR_BUFFERS, &r->buffers[cntr_buffers_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffers_0, 0);
		for (cntr_buffers_0 = 0; cntr_buffers_0 < (size_buffers_0); cntr_buffers_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_PAC_DATA(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_DATA *r)
{
	ndr_print_PAC_DATA(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_DATA(struct ndr_print *ndr, const char *name, const struct PAC_DATA *r)
{
	uint32_t cntr_buffers_0;
	ndr_print_struct(ndr, name, "PAC_DATA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_buffers", r->num_buffers);
	ndr_print_uint32(ndr, "version", r->version);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "buffers", (uint32_t)(r->num_buffers));
	ndr->depth++;
	for (cntr_buffers_0 = 0; cntr_buffers_0 < (r->num_buffers); cntr_buffers_0++) {
		ndr_print_PAC_BUFFER(ndr, "buffers", &r->buffers[cntr_buffers_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_BUFFER_RAW(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_BUFFER_RAW *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_PAC_TYPE(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ndr_size));
		{
			libndr_flags _flags_save_DATA_BLOB_REM = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->info));
			ndr->flags = _flags_save_DATA_BLOB_REM;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_DATA_BLOB_REM = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			if (r->info) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->info));
				{
					struct ndr_push *_ndr_info;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_info, 0, NDR_ROUND(r->ndr_size, 8)));
					NDR_CHECK(ndr_push_DATA_BLOB_REM(_ndr_info, NDR_SCALARS, r->info));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_info, 0, NDR_ROUND(r->ndr_size, 8)));
				}
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->info));
			}
			ndr->flags = _flags_save_DATA_BLOB_REM;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_BUFFER_RAW(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_BUFFER_RAW *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_PAC_TYPE(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ndr_size));
		{
			libndr_flags _flags_save_DATA_BLOB_REM = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
			if (_ptr_info) {
				NDR_PULL_ALLOC(ndr, r->info);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->info, _ptr_info));
			} else {
				r->info = NULL;
			}
			ndr->flags = _flags_save_DATA_BLOB_REM;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_pad));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_DATA_BLOB_REM = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			if (r->info) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->info));
				_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
				{
					struct ndr_pull *_ndr_info;
					ssize_t sub_size = NDR_ROUND(r->ndr_size, 8);
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_info, 0, sub_size));
					NDR_CHECK(ndr_pull_DATA_BLOB_REM(_ndr_info, NDR_SCALARS, r->info));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_info, 0, sub_size));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_DATA_BLOB_REM;
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_PAC_BUFFER_RAW(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_BUFFER_RAW *r)
{
	ndr_print_PAC_BUFFER_RAW(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_BUFFER_RAW(struct ndr_print *ndr, const char *name, const struct PAC_BUFFER_RAW *r)
{
	ndr_print_struct(ndr, name, "PAC_BUFFER_RAW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_PAC_TYPE(ndr, "type", r->type);
	ndr_print_uint32(ndr, "ndr_size", r->ndr_size);
	{
		libndr_flags _flags_save_DATA_BLOB_REM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
		ndr_print_ptr(ndr, "info", r->info);
		ndr->depth++;
		if (r->info) {
			ndr_print_DATA_BLOB_REM(ndr, "info", r->info);
		}
		ndr->depth--;
		ndr->flags = _flags_save_DATA_BLOB_REM;
	}
	ndr_print_uint32(ndr, "_pad", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->_pad);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_DATA_RAW(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_DATA_RAW *r)
{
	uint32_t cntr_buffers_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_buffers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		for (cntr_buffers_0 = 0; cntr_buffers_0 < (r->num_buffers); cntr_buffers_0++) {
			NDR_CHECK(ndr_push_PAC_BUFFER_RAW(ndr, NDR_SCALARS, &r->buffers[cntr_buffers_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_buffers_0 = 0; cntr_buffers_0 < (r->num_buffers); cntr_buffers_0++) {
			NDR_CHECK(ndr_push_PAC_BUFFER_RAW(ndr, NDR_BUFFERS, &r->buffers[cntr_buffers_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_DATA_RAW(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_DATA_RAW *r)
{
	uint32_t size_buffers_0 = 0;
	uint32_t cntr_buffers_0;
	TALLOC_CTX *_mem_save_buffers_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_buffers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		size_buffers_0 = r->num_buffers;
		NDR_PULL_ALLOC_N(ndr, r->buffers, size_buffers_0);
		_mem_save_buffers_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->buffers, 0);
		for (cntr_buffers_0 = 0; cntr_buffers_0 < (size_buffers_0); cntr_buffers_0++) {
			NDR_CHECK(ndr_pull_PAC_BUFFER_RAW(ndr, NDR_SCALARS, &r->buffers[cntr_buffers_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffers_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		size_buffers_0 = r->num_buffers;
		_mem_save_buffers_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->buffers, 0);
		for (cntr_buffers_0 = 0; cntr_buffers_0 < (size_buffers_0); cntr_buffers_0++) {
			NDR_CHECK(ndr_pull_PAC_BUFFER_RAW(ndr, NDR_BUFFERS, &r->buffers[cntr_buffers_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffers_0, 0);
		for (cntr_buffers_0 = 0; cntr_buffers_0 < (size_buffers_0); cntr_buffers_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_PAC_DATA_RAW(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_DATA_RAW *r)
{
	ndr_print_PAC_DATA_RAW(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_DATA_RAW(struct ndr_print *ndr, const char *name, const struct PAC_DATA_RAW *r)
{
	uint32_t cntr_buffers_0;
	ndr_print_struct(ndr, name, "PAC_DATA_RAW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_buffers", r->num_buffers);
	ndr_print_uint32(ndr, "version", r->version);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "buffers", (uint32_t)(r->num_buffers));
	ndr->depth++;
	for (cntr_buffers_0 = 0; cntr_buffers_0 < (r->num_buffers); cntr_buffers_0++) {
		ndr_print_PAC_BUFFER_RAW(ndr, "buffers", &r->buffers[cntr_buffers_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_Validate(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PAC_Validate *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, NETLOGON_GENERIC_KRB5_PAC_VALIDATE));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ChecksumLength));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->SignatureType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->SignatureLength));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->ChecksumAndSignature));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_Validate(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PAC_Validate *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->MessageType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ChecksumLength));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->SignatureType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->SignatureLength));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->ChecksumAndSignature));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_PAC_Validate(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct PAC_Validate *r)
{
	ndr_print_PAC_Validate(ndr, name, r);
}

_PUBLIC_ void ndr_print_PAC_Validate(struct ndr_print *ndr, const char *name, const struct PAC_Validate *r)
{
	ndr_print_struct(ndr, name, "PAC_Validate");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "MessageType", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NETLOGON_GENERIC_KRB5_PAC_VALIDATE:r->MessageType);
	ndr_print_uint32(ndr, "ChecksumLength", r->ChecksumLength);
	ndr_print_int32(ndr, "SignatureType", r->SignatureType);
	ndr_print_uint32(ndr, "SignatureLength", r->SignatureLength);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "ChecksumAndSignature", r->ChecksumAndSignature);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_netsamlogoncache_entry(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct netsamlogoncache_entry *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->timestamp));
		NDR_CHECK(ndr_push_netr_SamInfo3(ndr, NDR_SCALARS, &r->info3));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_netr_SamInfo3(ndr, NDR_BUFFERS, &r->info3));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netsamlogoncache_entry(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct netsamlogoncache_entry *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->timestamp));
		NDR_CHECK(ndr_pull_netr_SamInfo3(ndr, NDR_SCALARS, &r->info3));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_netr_SamInfo3(ndr, NDR_BUFFERS, &r->info3));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_netsamlogoncache_entry(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct netsamlogoncache_entry *r)
{
	ndr_print_netsamlogoncache_entry(ndr, name, r);
}

_PUBLIC_ void ndr_print_netsamlogoncache_entry(struct ndr_print *ndr, const char *name, const struct netsamlogoncache_entry *r)
{
	ndr_print_struct(ndr, name, "netsamlogoncache_entry");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_time_t(ndr, "timestamp", r->timestamp);
	ndr_print_netr_SamInfo3(ndr, "info3", &r->info3);
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_krb5pac
static const struct ndr_interface_public_struct krb5pac_public_structs[] = {
	{
		.name = "PAC_SIGNATURE_DATA",
		.struct_size = sizeof(struct PAC_SIGNATURE_DATA ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_SIGNATURE_DATA,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_SIGNATURE_DATA,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_SIGNATURE_DATA,
	},
	{
		.name = "PAC_CREDENTIAL_NTLM_SECPKG",
		.struct_size = sizeof(struct PAC_CREDENTIAL_NTLM_SECPKG ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_CREDENTIAL_NTLM_SECPKG,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_CREDENTIAL_NTLM_SECPKG,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_CREDENTIAL_NTLM_SECPKG,
	},
	{
		.name = "PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG",
		.struct_size = sizeof(struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG,
	},
	{
		.name = "PAC_CREDENTIAL_DATA",
		.struct_size = sizeof(struct PAC_CREDENTIAL_DATA ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_CREDENTIAL_DATA,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_CREDENTIAL_DATA,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_CREDENTIAL_DATA,
	},
	{
		.name = "PAC_CREDENTIAL_DATA_CTR",
		.struct_size = sizeof(struct PAC_CREDENTIAL_DATA_CTR ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_CREDENTIAL_DATA_CTR,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_CREDENTIAL_DATA_CTR,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_CREDENTIAL_DATA_CTR,
	},
	{
		.name = "PAC_CREDENTIAL_DATA_NDR",
		.struct_size = sizeof(struct PAC_CREDENTIAL_DATA_NDR ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_CREDENTIAL_DATA_NDR,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_CREDENTIAL_DATA_NDR,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_CREDENTIAL_DATA_NDR,
	},
	{
		.name = "PAC_CREDENTIAL_INFO",
		.struct_size = sizeof(struct PAC_CREDENTIAL_INFO ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_CREDENTIAL_INFO,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_CREDENTIAL_INFO,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_CREDENTIAL_INFO,
	},
	{
		.name = "PAC_LOGON_INFO_CTR",
		.struct_size = sizeof(struct PAC_LOGON_INFO_CTR ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_LOGON_INFO_CTR,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_LOGON_INFO_CTR,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_LOGON_INFO_CTR,
	},
	{
		.name = "PAC_CONSTRAINED_DELEGATION_CTR",
		.struct_size = sizeof(struct PAC_CONSTRAINED_DELEGATION_CTR ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_CONSTRAINED_DELEGATION_CTR,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_CONSTRAINED_DELEGATION_CTR,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_CONSTRAINED_DELEGATION_CTR,
	},
	{
		.name = "PAC_BUFFER",
		.struct_size = sizeof(struct PAC_BUFFER ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_BUFFER,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_BUFFER,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_BUFFER,
	},
	{
		.name = "PAC_DATA",
		.struct_size = sizeof(struct PAC_DATA ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_DATA,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_DATA,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_DATA,
	},
	{
		.name = "PAC_BUFFER_RAW",
		.struct_size = sizeof(struct PAC_BUFFER_RAW ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_BUFFER_RAW,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_BUFFER_RAW,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_BUFFER_RAW,
	},
	{
		.name = "PAC_DATA_RAW",
		.struct_size = sizeof(struct PAC_DATA_RAW ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_DATA_RAW,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_DATA_RAW,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_DATA_RAW,
	},
	{
		.name = "PAC_Validate",
		.struct_size = sizeof(struct PAC_Validate ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_PAC_Validate,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_PAC_Validate,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_PAC_Validate,
	},
	{
		.name = "netsamlogoncache_entry",
		.struct_size = sizeof(struct netsamlogoncache_entry ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_netsamlogoncache_entry,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_netsamlogoncache_entry,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_netsamlogoncache_entry,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call krb5pac_calls[] = {
	{ .name = NULL }
};

static const char * const krb5pac_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\krb5pac]", 
};

static const struct ndr_interface_string_array krb5pac_endpoints = {
	.count	= 1,
	.names	= krb5pac_endpoint_strings
};

static const char * const krb5pac_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array krb5pac_authservices = {
	.count	= 1,
	.names	= krb5pac_authservice_strings
};


const struct ndr_interface_table ndr_table_krb5pac = {
	.name		= "krb5pac",
	.syntax_id	= {
		{0x12345778,0x1234,0xabcd,{0x00,0x00},{0x00,0x00,0x00,0x00}},
		NDR_KRB5PAC_VERSION
	},
	.helpstring	= NDR_KRB5PAC_HELPSTRING,
	.num_calls	= 0,
	.calls		= krb5pac_calls,
	.num_public_structs	= 15,
	.public_structs		= krb5pac_public_structs,
	.endpoints	= &krb5pac_endpoints,
	.authservices	= &krb5pac_authservices
};

#endif /* SKIP_NDR_TABLE_krb5pac */
