/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkMaskedFFTNormalizedCorrelationImageFilter.h"
#include "itkMaskedFFTNormalizedCorrelationImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
MaskedFFTNormalizedCorrelationImageFilter::MaskedFFTNormalizedCorrelationImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
MaskedFFTNormalizedCorrelationImageFilter::~MaskedFFTNormalizedCorrelationImageFilter() = default;



//
// ToString
//
std::string MaskedFFTNormalizedCorrelationImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::MaskedFFTNormalizedCorrelationImageFilter\n";
  out << "  RequiredNumberOfOverlappingPixels: ";
  this->ToStringHelper(out, this->m_RequiredNumberOfOverlappingPixels);
  out << std::endl;
  out << "  RequiredFractionOfOverlappingPixels: ";
  this->ToStringHelper(out, this->m_RequiredFractionOfOverlappingPixels);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image MaskedFFTNormalizedCorrelationImageFilter::Execute ( const Image & fixedImage, const Image & movingImage, const Image & fixedImageMask, const Image & movingImageMask )
{
  const PixelIDValueEnum type = fixedImage.GetPixelID();
  const unsigned int dimension = fixedImage.GetDimension();
  CheckImageMatchingDimension(  fixedImage, movingImage, "movingImage" );
  CheckImageMatchingDimension(  fixedImage, fixedImageMask, "fixedImageMask" );
  CheckImageMatchingSize(  fixedImage, fixedImageMask, "fixedImageMask" );
  CheckImageMatchingDimension(  fixedImage, movingImageMask, "movingImageMask" );

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &fixedImage, &movingImage, &fixedImageMask, &movingImageMask );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image MaskedFFTNormalizedCorrelationImageFilter::ExecuteInternal ( const Image * inFixedImage, const Image * inMovingImage, const Image * inFixedImageMask, const Image * inMovingImageMask )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  // Define output image type
  using OutputImageType = itk::Image< typename itk::NumericTraits<typename InputImageType::PixelType>::RealType, InputImageType::ImageDimension >;



  using FilterType = itk::MaskedFFTNormalizedCorrelationImageFilter<InputImageType, OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inFixedImage != nullptr );
  filter->SetFixedImage( this->CastImageToITK<typename FilterType::InputImageType>(*inFixedImage) );
  assert( inMovingImage != nullptr );
  filter->SetMovingImage( this->CastImageToITK<typename FilterType::InputImageType>(*inMovingImage) );
  assert( inFixedImageMask != nullptr );
  filter->SetFixedImageMask( this->CastImageToITK<typename FilterType::MaskImageType>(*inFixedImageMask) );
  assert( inMovingImageMask != nullptr );
  filter->SetMovingImageMask( this->CastImageToITK<typename FilterType::MaskImageType>(*inMovingImageMask) );


  filter->SetRequiredNumberOfOverlappingPixels ( this->m_RequiredNumberOfOverlappingPixels );
  filter->SetRequiredFractionOfOverlappingPixels ( this->m_RequiredFractionOfOverlappingPixels );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image MaskedFFTNormalizedCorrelation ( const Image & fixedImage, const Image & movingImage, const Image & fixedImageMask, const Image & movingImageMask, uint64_t requiredNumberOfOverlappingPixels, float requiredFractionOfOverlappingPixels )
{
  MaskedFFTNormalizedCorrelationImageFilter filter;
  filter.SetRequiredNumberOfOverlappingPixels( requiredNumberOfOverlappingPixels );  filter.SetRequiredFractionOfOverlappingPixels( requiredFractionOfOverlappingPixels );
  return filter.Execute ( fixedImage, movingImage, fixedImageMask, movingImageMask );
}


}
