/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkDoubleThresholdImageFilter.h"
#include "itkDoubleThresholdImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
DoubleThresholdImageFilter::DoubleThresholdImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
DoubleThresholdImageFilter::~DoubleThresholdImageFilter() = default;



//
// ToString
//
std::string DoubleThresholdImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::DoubleThresholdImageFilter\n";
  out << "  Threshold1: ";
  this->ToStringHelper(out, this->m_Threshold1);
  out << std::endl;
  out << "  Threshold2: ";
  this->ToStringHelper(out, this->m_Threshold2);
  out << std::endl;
  out << "  Threshold3: ";
  this->ToStringHelper(out, this->m_Threshold3);
  out << std::endl;
  out << "  Threshold4: ";
  this->ToStringHelper(out, this->m_Threshold4);
  out << std::endl;
  out << "  InsideValue: ";
  this->ToStringHelper(out, this->m_InsideValue);
  out << std::endl;
  out << "  OutsideValue: ";
  this->ToStringHelper(out, this->m_OutsideValue);
  out << std::endl;
  out << "  FullyConnected: ";
  this->ToStringHelper(out, this->m_FullyConnected);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image DoubleThresholdImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image DoubleThresholdImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  // Define output image type
  using OutputImageType = itk::Image< uint8_t, InputImageType::ImageDimension >;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType =  itk::DoubleThresholdImageFilter<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  filter->SetThreshold1 ( static_cast< typename InputImageType::PixelType> ( this->m_Threshold1 ) );
  filter->SetThreshold2 ( static_cast< typename InputImageType::PixelType> ( this->m_Threshold2 ) );
  filter->SetThreshold3 ( static_cast< typename InputImageType::PixelType> ( this->m_Threshold3 ) );
  filter->SetThreshold4 ( static_cast< typename InputImageType::PixelType> ( this->m_Threshold4 ) );
  filter->SetInsideValue ( static_cast< typename OutputImageType::PixelType> ( this->m_InsideValue ) );
  filter->SetOutsideValue ( static_cast< typename OutputImageType::PixelType> ( this->m_OutsideValue ) );
  filter->SetFullyConnected ( this->m_FullyConnected );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image DoubleThreshold ( const Image& image1, double threshold1, double threshold2, double threshold3, double threshold4, uint8_t insideValue, uint8_t outsideValue, bool fullyConnected )
{
  DoubleThresholdImageFilter filter;
  filter.SetThreshold1( threshold1 );  filter.SetThreshold2( threshold2 );  filter.SetThreshold3( threshold3 );  filter.SetThreshold4( threshold4 );  filter.SetInsideValue( insideValue );  filter.SetOutsideValue( outsideValue );  filter.SetFullyConnected( fullyConnected );
  return filter.Execute ( image1 );
}


}
