/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkTernaryAddImageFilter.h"
#include "itkTernaryAddImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
TernaryAddImageFilter::TernaryAddImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
TernaryAddImageFilter::~TernaryAddImageFilter() = default;



//
// ToString
//
std::string TernaryAddImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::TernaryAddImageFilter\n";

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image TernaryAddImageFilter::Execute ( const Image& image1, const Image& image2, const Image& image3 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();
  CheckImageMatchingDimension( image1, image2, "image2" );
  CheckImageMatchingPixelType( image1, image2, "image2" );
  CheckImageMatchingDimension( image1, image3, "image3" );
  CheckImageMatchingPixelType( image1, image3, "image3" );

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1, image2, image3 );
}
Image TernaryAddImageFilter::Execute ( Image&& image1, const Image& image2, const Image& image3 )
{
  Image &temp = image1;
  auto autoResetInPlace = make_scope_exit([this, &temp]{this->m_InPlace=false; Image moved(std::move(temp));});
  if (temp.IsUnique())
    {
    m_InPlace = true;
    }
  return this->Execute( image1, image2, image3 );
}


//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image TernaryAddImageFilter::ExecuteInternal ( const Image& inImage1, const Image& inImage2, const Image& inImage3 )
{
  // Define the input and output image types
  using InputImageType = TImageType;

  using InputImageType2 = TImageType;
  using InputImageType3 = TImageType;

  using OutputImageType = InputImageType;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );
  // Get the a pointer to the ITK image contained in image2
  typename InputImageType2::ConstPointer image2 = this->CastImageToITK<InputImageType2>( inImage2 );
  // Get the a pointer to the ITK image contained in image3
  typename InputImageType3::ConstPointer image3 = this->CastImageToITK<InputImageType3>( inImage3 );


  using FilterType = itk::TernaryAddImageFilter<InputImageType, InputImageType2, InputImageType3, OutputImageType >;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );
  filter->SetInput( 1, image2 );
  filter->SetInput( 2, image3 );



  filter->SetInPlace( m_InPlace );
         



  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image TernaryAdd ( const Image& image1, const Image& image2, const Image& image3 )
{
  TernaryAddImageFilter filter;

  return filter.Execute ( image1, image2, image3 );
}
//
// Function to run the Execute method of this filter
//
Image TernaryAdd ( Image&& image1, const Image& image2, const Image& image3 )
{
  TernaryAddImageFilter filter;

  return filter.Execute ( std::move(image1), image2, image3 );
}

}
