/* This is a generated file! */
/* Generated by `utils/build_lexers.py` via `utils/rustify.py` */
/* This process can be run via tox: `tox -e generate-rs` */
#![cfg_attr(rustfmt, rustfmt_skip)]
use once_cell::sync::Lazy;
use sqlfluffrs_types::LexMatcher;
use sqlfluffrs_types::{Token, RegexModeGroup};
use sqlfluffrs_types::token::CaseFold;

pub static DORIS_KEYWORDS: Lazy<Vec<String>> = Lazy::new(|| { vec![
    "ACCOUNT_LOCK".to_string(),
    "ACCOUNT_UNLOCK".to_string(),
    "ADD".to_string(),
    "ADMIN".to_string(),
    "ALL".to_string(),
    "ALTER".to_string(),
    "ANALYZE".to_string(),
    "ANALYZER".to_string(),
    "AND".to_string(),
    "ANTI".to_string(),
    "APPEND".to_string(),
    "AS".to_string(),
    "ASC".to_string(),
    "AUTO".to_string(),
    "BACKEND".to_string(),
    "BETWEEN".to_string(),
    "BIGINT".to_string(),
    "BINARY".to_string(),
    "BINLOG".to_string(),
    "BY".to_string(),
    "CANCEL".to_string(),
    "CASE".to_string(),
    "CAST".to_string(),
    "CLEAN".to_string(),
    "COLLATE".to_string(),
    "COLUMN".to_string(),
    "CONSTRAINT".to_string(),
    "CREATE".to_string(),
    "CROSS".to_string(),
    "CUBE".to_string(),
    "CURRENT".to_string(),
    "DATABASE".to_string(),
    "DATABASES".to_string(),
    "DECOMMISSION".to_string(),
    "DEFAULT".to_string(),
    "DELETE".to_string(),
    "DESC".to_string(),
    "DESCRIBE".to_string(),
    "DISK".to_string(),
    "DISTINCT".to_string(),
    "DISTRIBUTED".to_string(),
    "DISTRIBUTION".to_string(),
    "DIV".to_string(),
    "DOUBLE".to_string(),
    "DROP".to_string(),
    "DROPP".to_string(),
    "DUMP".to_string(),
    "DUPLICATE".to_string(),
    "ELSE".to_string(),
    "ENTER".to_string(),
    "EXCEPT".to_string(),
    "EXECUTE".to_string(),
    "EXISTS".to_string(),
    "EXPLAIN".to_string(),
    "EXPORT".to_string(),
    "EXTENDED".to_string(),
    "EXTRACT".to_string(),
    "FALSE".to_string(),
    "FLOAT".to_string(),
    "FOLLOWER".to_string(),
    "FOLLOWING".to_string(),
    "FOR".to_string(),
    "FORCE".to_string(),
    "FOREIGN".to_string(),
    "FROM".to_string(),
    "FRONTEND".to_string(),
    "FULL".to_string(),
    "FUNCTIONS".to_string(),
    "GRANT".to_string(),
    "GRANTS".to_string(),
    "GROUP".to_string(),
    "HAVING".to_string(),
    "HLL".to_string(),
    "IF".to_string(),
    "IN".to_string(),
    "INDEX".to_string(),
    "INFILE".to_string(),
    "INNER".to_string(),
    "INSERT".to_string(),
    "INSTALL".to_string(),
    "INT".to_string(),
    "INTEGER".to_string(),
    "INTERMEDIATE".to_string(),
    "INTERSECT".to_string(),
    "INTERVAL".to_string(),
    "INTO".to_string(),
    "IS".to_string(),
    "JOIN".to_string(),
    "KEY".to_string(),
    "KEYS".to_string(),
    "KILL".to_string(),
    "LARGEINT".to_string(),
    "LATERAL".to_string(),
    "LAYOUT".to_string(),
    "LEFT".to_string(),
    "LIKE".to_string(),
    "LIMIT".to_string(),
    "LIST".to_string(),
    "LOAD".to_string(),
    "LOW_PRIORITY".to_string(),
    "MATCH".to_string(),
    "MAXVALUE".to_string(),
    "MINUS".to_string(),
    "NATURAL".to_string(),
    "NOT".to_string(),
    "NO_USE_MV".to_string(),
    "NULL".to_string(),
    "OBSERVER".to_string(),
    "ON".to_string(),
    "OR".to_string(),
    "ORDER".to_string(),
    "OUTER".to_string(),
    "OUTFILE".to_string(),
    "OVER".to_string(),
    "OVERWRITE".to_string(),
    "PARTITION".to_string(),
    "PLACEHOLDER".to_string(),
    "PLAY".to_string(),
    "PRECEDING".to_string(),
    "PREPARE".to_string(),
    "PRIMARY".to_string(),
    "PROCEDURE".to_string(),
    "RANGE".to_string(),
    "READ".to_string(),
    "REAL".to_string(),
    "REBALANCE".to_string(),
    "REFERENCES".to_string(),
    "REGEXP".to_string(),
    "RELEASE".to_string(),
    "RENAME".to_string(),
    "REPAIR".to_string(),
    "REPLICA".to_string(),
    "REVOKE".to_string(),
    "RIGHT".to_string(),
    "ROLE".to_string(),
    "ROLES".to_string(),
    "ROW".to_string(),
    "ROWS".to_string(),
    "SCHEMAS".to_string(),
    "SELECT".to_string(),
    "SEMI".to_string(),
    "SET".to_string(),
    "SETS".to_string(),
    "SHOW".to_string(),
    "SIGNED".to_string(),
    "SMALLINT".to_string(),
    "SQL_BLOCK_RULE".to_string(),
    "SUPERUSER".to_string(),
    "SWITCH".to_string(),
    "SYNC".to_string(),
    "SYSTEM".to_string(),
    "TABLE".to_string(),
    "TABLESAMPLE".to_string(),
    "TABLET".to_string(),
    "TABLETS".to_string(),
    "TERMINATED".to_string(),
    "THEN".to_string(),
    "TINYINT".to_string(),
    "TO".to_string(),
    "TOKENIZER".to_string(),
    "TOKEN_FILTER".to_string(),
    "TRASH".to_string(),
    "TRIM".to_string(),
    "TRUE".to_string(),
    "TYPECAST".to_string(),
    "UNBOUNDED".to_string(),
    "UNINSTALL".to_string(),
    "UNION".to_string(),
    "UNIQUE".to_string(),
    "UNSIGNED".to_string(),
    "UPDATE".to_string(),
    "USE".to_string(),
    "USE_MV".to_string(),
    "USING".to_string(),
    "VALUES".to_string(),
    "WHEN".to_string(),
    "WHERE".to_string(),
    "WHITELIST".to_string(),
    "WITH".to_string(),
    "WORKLOAD".to_string(),
    "WRITE".to_string(),
    "XOR".to_string(),
]});

pub static DORIS_LEXERS: Lazy<Vec<LexMatcher>> = Lazy::new(|| { vec![

    LexMatcher::regex_lexer(
        "whitespace",
        r#"[^\S\r\n]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::whitespace_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "inline_comment",
        r#"(^--|-- |#)[^\n]*"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comment_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        Some(vec![String::from("--"), String::from("#")]),
        None,
        None,
        None,
        CaseFold::None,
        None,
        |input| input.starts_with(['#','-','/']),
        None,
    ),

    LexMatcher::regex_lexer(
        "block_comment",
        r#"\/\*([^\*]|\*(?!\/))*\*\/"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comment_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        Some(Box::new(
    LexMatcher::regex_subdivider(
        "newline",
        r#"\r\n|\n"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::newline_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ))),
        Some(Box::new(
    LexMatcher::regex_subdivider(
        "whitespace",
        r#"[^\S\r\n]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::whitespace_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ))),
        None,
        None,
        None,
        None,
        CaseFold::None,
        Some(extract_nested_block_comment),
        |input| input.starts_with("/"),
        None,
    ),

    LexMatcher::regex_lexer(
        "single_quote",
        r#"(?s)('(?:\\'|''|\\\\|[^'])*'(?!'))"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"(?s)('((?:\\'|''|\\\\|[^'])*)'(?!'))"#.to_string(), RegexModeGroup::Index(2))),
        Some((r#"\\'|''"#.to_string(), r#"'"#.to_string())),
        CaseFold::None,
        None,
        |input| match input.as_bytes() {
        [b'\'', ..] => true,                     // Single quote case
        [b'R' | b'r', b'\'', ..] => true,        // r' or R'
        [b'B' | b'b', b'\'', ..] => true,        // b' or B'
        [b'R' | b'r', b'B' | b'b', b'\'', ..] => true, // rb', RB', etc.
        [b'B' | b'b', b'R' | b'r', b'\'', ..] => true, // br', Br', etc.
        _ => false,
    },
        None,
    ),

    LexMatcher::regex_lexer(
        "double_quote",
        r#"(?s)("(?:\\"|""|\\\\|[^"])*"(?!"))"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"(?s)("((?:\\"|""|\\\\|[^"])*)"(?!"))"#.to_string(), RegexModeGroup::Index(2))),
        Some((r#"\\"|"""#.to_string(), r#"""#.to_string())),
        CaseFold::None,
        None,
        |input| match input.as_bytes() {
        [b'"', ..] => true,                     // Just a double quote
        [b'R' | b'r', b'"', ..] => true,        // r" or R"
        [b'B' | b'b', b'"', ..] => true,        // b" or B"
        [b'R' | b'r', b'B' | b'b', b'"', ..] => true, // rb", RB", etc.
        [b'B' | b'b', b'R' | b'r', b'"', ..] => true, // br", Br", etc.
        _ => false,
    },
        None,
    ),

    LexMatcher::regex_lexer(
        "back_quote",
        r#"`(?:[^`\\]|\\.)*`"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"`((?:[^`\\]|\\.)*)`"#.to_string(), RegexModeGroup::Index(1))),
        Some((r#"\\`"#.to_string(), r#"`"#.to_string())),
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "dollar_quote",
        r#"\$(\w*)\$(.*?)\$\1\$"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"\$(\w*)\$(.*?)\$\1\$"#.to_string(), RegexModeGroup::Index(2))),
        None,
        CaseFold::None,
        None,
        |input| input.starts_with("$"),
        None,
    ),

    LexMatcher::regex_lexer(
        "hexadecimal_literal",
        r#"([xX]'([\da-fA-F][\da-fA-F])+'|0x[\da-fA-F]+)"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::literal_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        Some(String::from("numeric_literal")),
    ),

    LexMatcher::regex_lexer(
        "bit_value_literal",
        r#"([bB]'[01]+'|0b[01]+)"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::literal_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        Some(String::from("numeric_literal")),
    ),

    LexMatcher::regex_lexer(
        "numeric_literal",
        r#"(?>\d+\.\d+|\d+\.(?![\.\w])|\.\d+|\d+)(\.?[eE][+-]?\d+)?((?<=\.)|(?=\b))"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::literal_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |input| input.starts_with(['x','X','.','0','1','2','3','4','5','6','7','8','9']),
        None,
    ),

    LexMatcher::regex_lexer(
        "obevo_annotation",
        r#"////\s*(CHANGE|BODY|METADATA)[^\n]*"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comment_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::string_lexer(
        "glob_operator",
        "~~~",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comparison_operator_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::regex_lexer(
        "like_operator",
        r#"!?~~?\*?"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comparison_operator_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "newline",
        r#"\r\n|\n"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::newline_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::string_lexer(
        "casting_operator",
        "::",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "walrus_operator",
        ":=",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "equals",
        "=",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "inline_path_operator",
        "->>",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::symbol_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "column_path_operator",
        "->",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::symbol_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "greater_than",
        ">",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "less_than",
        "<",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "not",
        "!",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "dot",
        ".",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "comma",
        ",",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "plus",
        "+",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "minus",
        "-",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "divide",
        "/",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "percent",
        "%",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "question",
        "?",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "double_ampersand",
        "&&",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "ampersand",
        "&",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "double_vertical_bar",
        "||",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "vertical_bar",
        "|",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "caret",
        "^",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "star",
        "*",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "start_bracket",
        "(",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "end_bracket",
        ")",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "start_square_bracket",
        "[",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "end_square_bracket",
        "]",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "start_curly_bracket",
        "{",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "end_curly_bracket",
        "}",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "colon",
        ":",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "semicolon",
        ";",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::regex_lexer(
        "at_sign",
        r#"@@?[a-zA-Z0-9_$]*(\.[a-zA-Z0-9_$]+)?"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        Some(vec![String::from("@")]),
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        Some(String::from("at_sign_literal")),
    ),

    LexMatcher::regex_lexer(
        "word",
        r#"[0-9a-zA-Z_]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::word_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),
]});


// Wrapper function that passes the dialect name to the shared implementation
fn extract_nested_block_comment(input: &str) -> Option<&str> {
    crate::extract_nested_block_comment(input, "doris")
}
