// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by hack/docgen tool. DO NOT EDIT.

package security

import (
	"github.com/siderolabs/talos/pkg/machinery/config/encoder"
)

func (TrustedRootsConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "TrustedRootsConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "TrustedRootsConfig allows to configure additional trusted CA roots." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "TrustedRootsConfig allows to configure additional trusted CA roots.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the config document.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "certificates",
				Type:        "string",
				Note:        "",
				Description: "List of additional trusted certificate authorities (as PEM-encoded certificates).\n\nMultiple certificates can be provided in a single config document, separated by newline characters.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "List of additional trusted certificate authorities (as PEM-encoded certificates)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleTrustedRootsConfigV1Alpha1())

	return doc
}

// GetFileDoc returns documentation for the file security_doc.go.
func GetFileDoc() *encoder.FileDoc {
	return &encoder.FileDoc{
		Name:        "security",
		Description: "Package security provides security-related machine configuration documents.\n",
		Structs: []*encoder.Doc{
			TrustedRootsConfigV1Alpha1{}.Doc(),
		},
	}
}
