// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanGeckoviewMetrics_h
#define mozilla_GleanGeckoviewMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace geckoview {
  /**
   * generated from geckoview.document_site_origins
   * When a document is loaded, report the number of [site origins](https://searchfox.org/ mozilla-central/rev/ 3300072e993ae05d50d5c63d815260367eaf9179/ caps/nsIPrincipal.idl#264) of the entire browser if it has been at least 5 minutes since last time we collect this data. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric document_site_origins(4163);

  /**
   * generated from geckoview.page_load_progress_time
   * Time between page load progress starts (0) and completion (100). (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric page_load_progress_time(4164);

  /**
   * generated from geckoview.page_load_time
   * The time taken to load a page. This includes all static contents, no dynamic content. Loading of about: pages is not counted. Back back navigation (sometimes via BFCache) is included which is a source of bimodality due to the <50ms load times. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric page_load_time(4165);

  /**
   * generated from geckoview.page_reload_time
   * Time taken to reload a page. This includes all static contents, no dynamic content. Loading of about: pages is not counted. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric page_reload_time(4166);

  /**
   * generated from geckoview.per_document_site_origins
   * When a document is unloaded, report the highest number of [site origins](https://searchfox.org/ mozilla-central/rev/ 3300072e993ae05d50d5c63d815260367eaf9179/ caps/nsIPrincipal.idl#264) loaded simultaneously in that document. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric per_document_site_origins(4167);
}

} // namespace mozilla::glean

#endif // mozilla_GleanGeckoviewMetrics_h
