/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* Generated with cbindgen:0.29.0 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */
#ifndef mozilla_intl_l10n_RegistryBindings_h
#error "Don't include this file directly, instead include RegistryBindings.h"
#endif


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>
#include "nsIStreamLoader.h"

namespace mozilla {
namespace intl {
namespace ffi {

enum class GeckoResourceType {
  Optional,
  Required,
};

enum class L10nFileSourceStatus {
  None,
  EmptyName,
  EmptyPrePath,
  EmptyResId,
  InvalidLocaleCode,
};

enum class L10nRegistryStatus {
  None,
  EmptyName,
  InvalidLocaleCode,
};

/// `FileSource` provides a generic fetching and caching of fluent resources.
/// The user of `FileSource` provides a [`FileFetcher`](trait.FileFetcher.html)
/// implementation and `FileSource` takes care of the rest.
struct FileSource;

/// A resource containing a list of localization messages.
///
/// [`FluentResource`] wraps an [`Abstract Syntax Tree`](../fluent_syntax/ast/index.html) produced by the
/// [`parser`](../fluent_syntax/parser/index.html) and provides an access to a list
/// of its entries.
///
/// A good mental model for a resource is a single FTL file, but in the future
/// there's nothing preventing a resource from being stored in a data base,
/// pre-parsed format or in some other structured form.
///
/// # Example
///
/// ```
/// use fluent_bundle::FluentResource;
///
/// let source = r#"
///
/// hello-world = Hello World!
///
/// "#;
///
/// let resource = FluentResource::try_new(source.to_string())
///     .expect("Errors encountered while parsing a resource.");
///
/// assert_eq!(resource.entries().count(), 1);
/// ```
///
/// # Ownership
///
/// A resource owns the source string and the AST contains references
/// to the slices of the source.
struct FluentResource;

struct GeckoBundleAdapter;

struct GeckoEnvironment;

struct GeckoFluentBundleAsyncIteratorWrapper;

template<typename P = void, typename B = void>
struct GenerateBundlesSync;

/// The L10nRegistry is the main struct for owning the registry information.
///
/// `P` - A provider
/// `B` - A bundle adapter
template<typename P = void, typename B = void>
struct L10nRegistry;

using GeckoL10nRegistry = L10nRegistry<GeckoEnvironment, GeckoBundleAdapter>;

struct L10nFileSourceDescriptor {
  nsCString name;
  nsCString metasource;
  nsTArray<nsCString> locales;
  nsCString pre_path;
  nsTArray<nsCString> index;
};

using GeckoFluentBundleIterator = GenerateBundlesSync<GeckoEnvironment, GeckoBundleAdapter>;

struct GeckoResourceId {
  nsCString value;
  GeckoResourceType resource_type;
};

struct L10nFileSourceMockFile {
  nsCString path;
  nsCString source;
};

extern "C" {

extern nsresult L10nRegistryLoad(const nsACString *path, const nsIStreamLoaderObserver *observer);

extern nsresult L10nRegistryLoadSync(const nsACString *aPath, void **aData, uint64_t *aSize);

const GeckoL10nRegistry *l10nregistry_new(bool use_isolating);

const GeckoL10nRegistry *l10nregistry_instance_get();

void l10nregistry_get_parent_process_sources(nsTArray<L10nFileSourceDescriptor> *sources);

void l10nregistry_register_parent_process_sources(const nsTArray<L10nFileSourceDescriptor> *sources);

void l10nregistry_addref(const GeckoL10nRegistry *reg);

void l10nregistry_release(const GeckoL10nRegistry *reg);

void l10nregistry_get_available_locales(const GeckoL10nRegistry *reg, nsTArray<nsCString> *result);

void l10nregistry_register_sources(const GeckoL10nRegistry *reg,
                                   const nsTArray<const FileSource*> *sources);

void l10nregistry_update_sources(const GeckoL10nRegistry *reg,
                                 nsTArray<const FileSource*> *sources);

void l10nregistry_remove_sources(const GeckoL10nRegistry *reg,
                                 const nsCString *sources_elements,
                                 uintptr_t sources_length);

bool l10nregistry_has_source(const GeckoL10nRegistry *reg,
                             const nsACString *name,
                             L10nRegistryStatus *status);

FileSource *l10nregistry_get_source(const GeckoL10nRegistry *reg,
                                    const nsACString *name,
                                    L10nRegistryStatus *status);

void l10nregistry_clear_sources(const GeckoL10nRegistry *reg);

void l10nregistry_get_source_names(const GeckoL10nRegistry *reg, nsTArray<nsCString> *result);

GeckoFluentBundleIterator *l10nregistry_generate_bundles_sync(const GeckoL10nRegistry *reg,
                                                              const nsCString *locales_elements,
                                                              uintptr_t locales_length,
                                                              const GeckoResourceId *res_ids_elements,
                                                              uintptr_t res_ids_length,
                                                              L10nRegistryStatus *status);

void fluent_bundle_iterator_destroy(GeckoFluentBundleIterator *iter);

FluentBundleRc *fluent_bundle_iterator_next(GeckoFluentBundleIterator *iter);

GeckoFluentBundleAsyncIteratorWrapper *l10nregistry_generate_bundles(const GeckoL10nRegistry *reg,
                                                                     const nsCString *locales_elements,
                                                                     uintptr_t locales_length,
                                                                     const GeckoResourceId *res_ids_elements,
                                                                     uintptr_t res_ids_length,
                                                                     L10nRegistryStatus *status);

void fluent_bundle_async_iterator_destroy(GeckoFluentBundleAsyncIteratorWrapper *iter);

void fluent_bundle_async_iterator_next(const GeckoFluentBundleAsyncIteratorWrapper *iter,
                                       const dom::Promise *promise,
                                       void (*callback)(const dom::Promise*, FluentBundleRc*));

extern void L10nRegistrySendUpdateL10nFileSources();

const FileSource *l10nfilesource_new(const nsACString *name,
                                     const nsACString *metasource,
                                     const nsTArray<nsCString> *locales,
                                     const nsACString *pre_path,
                                     bool allow_override,
                                     L10nFileSourceStatus *status);

const FileSource *l10nfilesource_new_with_index(const nsACString *name,
                                                const nsACString *metasource,
                                                const nsTArray<nsCString> *locales,
                                                const nsACString *pre_path,
                                                const nsCString *index_elements,
                                                uintptr_t index_length,
                                                bool allow_override,
                                                L10nFileSourceStatus *status);

const FileSource *l10nfilesource_new_mock(const nsACString *name,
                                          const nsACString *metasource,
                                          const nsTArray<nsCString> *locales,
                                          const nsACString *pre_path,
                                          const nsTArray<L10nFileSourceMockFile> *fs,
                                          L10nFileSourceStatus *status);

void l10nfilesource_addref(const FileSource *source);

void l10nfilesource_release(const FileSource *source);

void l10nfilesource_get_name(const FileSource *source, nsACString *ret_val);

void l10nfilesource_get_metasource(const FileSource *source, nsACString *ret_val);

void l10nfilesource_get_locales(const FileSource *source, nsTArray<nsCString> *ret_val);

void l10nfilesource_get_prepath(const FileSource *source, nsACString *ret_val);

bool l10nfilesource_get_index(const FileSource *source, nsTArray<nsCString> *ret_val);

bool l10nfilesource_has_file(const FileSource *source,
                             const nsACString *locale,
                             const nsACString *path,
                             L10nFileSourceStatus *status,
                             bool *present);

const FluentResource *l10nfilesource_fetch_file_sync(const FileSource *source,
                                                     const nsACString *locale,
                                                     const nsACString *path,
                                                     L10nFileSourceStatus *status);

void l10nfilesource_fetch_file(const FileSource *source,
                               const nsACString *locale,
                               const nsACString *path,
                               const dom::Promise *promise,
                               void (*callback)(const dom::Promise*, const FluentResource*),
                               L10nFileSourceStatus *status);

}  // extern "C"

}  // namespace ffi
}  // namespace intl
}  // namespace mozilla
