// python wrapper for ttkCinemaImaging
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkCinemaImaging.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkCinemaImaging(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkCinemaImaging_ClassNew(); }


static PyObject *
PyttkCinemaImaging_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkCinemaImaging::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkCinemaImaging::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkCinemaImaging *tempr = ttkCinemaImaging::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkCinemaImaging *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkCinemaImaging::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkCinemaImaging::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkCinemaImaging::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_SetBackend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackend");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackend(temp0);
    }
    else
    {
      op->ttkCinemaImaging::SetBackend(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_GetBackend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackend");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBackend() :
      op->ttkCinemaImaging::GetBackend());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_SetResolution_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetResolution(temp0, temp1);
    }
    else
    {
      op->ttkCinemaImaging::SetResolution(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkCinemaImaging_SetResolution_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetResolution(temp0);
    }
    else
    {
      op->ttkCinemaImaging::SetResolution(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkCinemaImaging_SetResolution(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyttkCinemaImaging_SetResolution_s1(self, args);
    case 1:
      return PyttkCinemaImaging_SetResolution_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetResolution");
  return nullptr;
}


static PyObject *
PyttkCinemaImaging_GetResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetResolution() :
      op->ttkCinemaImaging::GetResolution());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_SetProjectionMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProjectionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetProjectionMode(temp0);
    }
    else
    {
      op->ttkCinemaImaging::SetProjectionMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_GetProjectionMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProjectionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetProjectionMode() :
      op->ttkCinemaImaging::GetProjectionMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_SetAutoFocalPoint(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAutoFocalPoint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAutoFocalPoint(temp0);
    }
    else
    {
      op->ttkCinemaImaging::SetAutoFocalPoint(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_GetAutoFocalPoint(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutoFocalPoint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAutoFocalPoint() :
      op->ttkCinemaImaging::GetAutoFocalPoint());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_SetFocalPoint_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFocalPoint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetFocalPoint(temp0, temp1, temp2);
    }
    else
    {
      op->ttkCinemaImaging::SetFocalPoint(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkCinemaImaging_SetFocalPoint_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFocalPoint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetFocalPoint(temp0);
    }
    else
    {
      op->ttkCinemaImaging::SetFocalPoint(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkCinemaImaging_SetFocalPoint(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyttkCinemaImaging_SetFocalPoint_s1(self, args);
    case 1:
      return PyttkCinemaImaging_SetFocalPoint_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetFocalPoint");
  return nullptr;
}


static PyObject *
PyttkCinemaImaging_GetFocalPoint(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFocalPoint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetFocalPoint() :
      op->ttkCinemaImaging::GetFocalPoint());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_SetAutoNearFar(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAutoNearFar");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAutoNearFar(temp0);
    }
    else
    {
      op->ttkCinemaImaging::SetAutoNearFar(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_GetAutoNearFar(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutoNearFar");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAutoNearFar() :
      op->ttkCinemaImaging::GetAutoNearFar());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_SetNearFar_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNearFar");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetNearFar(temp0, temp1);
    }
    else
    {
      op->ttkCinemaImaging::SetNearFar(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkCinemaImaging_SetNearFar_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNearFar");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  const size_t size0 = 2;
  double temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetNearFar(temp0);
    }
    else
    {
      op->ttkCinemaImaging::SetNearFar(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkCinemaImaging_SetNearFar(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyttkCinemaImaging_SetNearFar_s1(self, args);
    case 1:
      return PyttkCinemaImaging_SetNearFar_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetNearFar");
  return nullptr;
}


static PyObject *
PyttkCinemaImaging_GetNearFar(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNearFar");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetNearFar() :
      op->ttkCinemaImaging::GetNearFar());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_SetAutoHeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAutoHeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAutoHeight(temp0);
    }
    else
    {
      op->ttkCinemaImaging::SetAutoHeight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_GetAutoHeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutoHeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAutoHeight() :
      op->ttkCinemaImaging::GetAutoHeight());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_SetHeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHeight(temp0);
    }
    else
    {
      op->ttkCinemaImaging::SetHeight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_GetHeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetHeight() :
      op->ttkCinemaImaging::GetHeight());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_SetAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAngle(temp0);
    }
    else
    {
      op->ttkCinemaImaging::SetAngle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_GetAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkCinemaImaging *op = static_cast<ttkCinemaImaging *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetAngle() :
      op->ttkCinemaImaging::GetAngle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_GetCells(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetCells");

  vtkPointSet *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPointSet"))
  {
    vtkCellArray *tempr = ttkCinemaImaging::GetCells(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_Normalize(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "Normalize");

  vtkDataArray *temp0 = nullptr;
  const size_t size1 = 2;
  double temp1[2];
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkDataArray") &&
      ap.GetArray(temp1, size1))
  {
    int tempr = ttkCinemaImaging::Normalize(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_AddFieldDataArray(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "AddFieldDataArray");

  vtkFieldData *temp0 = nullptr;
  vtkDataArray *temp1 = nullptr;
  int temp2;
  std::string temp3 = "";
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3, 4) &&
      ap.GetVTKObject(temp0, "vtkFieldData") &&
      ap.GetVTKObject(temp1, "vtkDataArray") &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    int tempr = ttkCinemaImaging::AddFieldDataArray(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_AddAllFieldDataArrays(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "AddAllFieldDataArrays");

  vtkPointSet *temp0 = nullptr;
  vtkImageData *temp1 = nullptr;
  int temp2;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkPointSet") &&
      ap.GetVTKObject(temp1, "vtkImageData") &&
      ap.GetValue(temp2))
  {
    int tempr = ttkCinemaImaging::AddAllFieldDataArrays(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_ComputeDirFromFocalPoint(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ComputeDirFromFocalPoint");

  vtkPointSet *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPointSet"))
  {
    int tempr = ttkCinemaImaging::ComputeDirFromFocalPoint(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkCinemaImaging_EnsureGridData(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "EnsureGridData");

  vtkPointData *temp0 = nullptr;
  std::string temp1;
  int temp2;
  std::vector<double> temp3(ap.GetArgSize(3));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkPointData") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetArray(temp3.data(), temp3.size()))
  {
    int tempr = ttkCinemaImaging::EnsureGridData(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkCinemaImaging_Methods[] = {
  {"IsTypeOf", PyttkCinemaImaging_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkCinemaImaging_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkCinemaImaging_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkCinemaImaging\nC++: static ttkCinemaImaging *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkCinemaImaging_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkCinemaImaging\nC++: ttkCinemaImaging *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkCinemaImaging_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkCinemaImaging_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetBackend", PyttkCinemaImaging_SetBackend, METH_VARARGS,
   "SetBackend(self, _arg:int) -> None\nC++: virtual void SetBackend(int _arg)\n\n"},
  {"GetBackend", PyttkCinemaImaging_GetBackend, METH_VARARGS,
   "GetBackend(self) -> int\nC++: virtual int GetBackend()\n\n"},
  {"SetResolution", PyttkCinemaImaging_SetResolution, METH_VARARGS,
   "SetResolution(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetResolution(int _arg1, int _arg2)\nSetResolution(self, _arg:(int, int)) -> None\nC++: void SetResolution(const int _arg[2])\n\n"},
  {"GetResolution", PyttkCinemaImaging_GetResolution, METH_VARARGS,
   "GetResolution(self) -> (int, int)\nC++: virtual int *GetResolution()\n\n"},
  {"SetProjectionMode", PyttkCinemaImaging_SetProjectionMode, METH_VARARGS,
   "SetProjectionMode(self, _arg:int) -> None\nC++: virtual void SetProjectionMode(int _arg)\n\n"},
  {"GetProjectionMode", PyttkCinemaImaging_GetProjectionMode, METH_VARARGS,
   "GetProjectionMode(self) -> int\nC++: virtual int GetProjectionMode()\n\n"},
  {"SetAutoFocalPoint", PyttkCinemaImaging_SetAutoFocalPoint, METH_VARARGS,
   "SetAutoFocalPoint(self, _arg:bool) -> None\nC++: virtual void SetAutoFocalPoint(bool _arg)\n\n"},
  {"GetAutoFocalPoint", PyttkCinemaImaging_GetAutoFocalPoint, METH_VARARGS,
   "GetAutoFocalPoint(self) -> bool\nC++: virtual bool GetAutoFocalPoint()\n\n"},
  {"SetFocalPoint", PyttkCinemaImaging_SetFocalPoint, METH_VARARGS,
   "SetFocalPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None\nC++: virtual void SetFocalPoint(double _arg1, double _arg2,\n    double _arg3)\nSetFocalPoint(self, _arg:(float, float, float)) -> None\nC++: virtual void SetFocalPoint(const double _arg[3])\n\n"},
  {"GetFocalPoint", PyttkCinemaImaging_GetFocalPoint, METH_VARARGS,
   "GetFocalPoint(self) -> (float, float, float)\nC++: virtual double *GetFocalPoint()\n\n"},
  {"SetAutoNearFar", PyttkCinemaImaging_SetAutoNearFar, METH_VARARGS,
   "SetAutoNearFar(self, _arg:bool) -> None\nC++: virtual void SetAutoNearFar(bool _arg)\n\n"},
  {"GetAutoNearFar", PyttkCinemaImaging_GetAutoNearFar, METH_VARARGS,
   "GetAutoNearFar(self) -> bool\nC++: virtual bool GetAutoNearFar()\n\n"},
  {"SetNearFar", PyttkCinemaImaging_SetNearFar, METH_VARARGS,
   "SetNearFar(self, _arg1:float, _arg2:float) -> None\nC++: virtual void SetNearFar(double _arg1, double _arg2)\nSetNearFar(self, _arg:(float, float)) -> None\nC++: void SetNearFar(const double _arg[2])\n\n"},
  {"GetNearFar", PyttkCinemaImaging_GetNearFar, METH_VARARGS,
   "GetNearFar(self) -> (float, float)\nC++: virtual double *GetNearFar()\n\n"},
  {"SetAutoHeight", PyttkCinemaImaging_SetAutoHeight, METH_VARARGS,
   "SetAutoHeight(self, _arg:bool) -> None\nC++: virtual void SetAutoHeight(bool _arg)\n\n"},
  {"GetAutoHeight", PyttkCinemaImaging_GetAutoHeight, METH_VARARGS,
   "GetAutoHeight(self) -> bool\nC++: virtual bool GetAutoHeight()\n\n"},
  {"SetHeight", PyttkCinemaImaging_SetHeight, METH_VARARGS,
   "SetHeight(self, _arg:float) -> None\nC++: virtual void SetHeight(double _arg)\n\n"},
  {"GetHeight", PyttkCinemaImaging_GetHeight, METH_VARARGS,
   "GetHeight(self) -> float\nC++: virtual double GetHeight()\n\n"},
  {"SetAngle", PyttkCinemaImaging_SetAngle, METH_VARARGS,
   "SetAngle(self, _arg:float) -> None\nC++: virtual void SetAngle(double _arg)\n\n"},
  {"GetAngle", PyttkCinemaImaging_GetAngle, METH_VARARGS,
   "GetAngle(self) -> float\nC++: virtual double GetAngle()\n\n"},
  {"GetCells", PyttkCinemaImaging_GetCells, METH_VARARGS,
   "GetCells(pointSet:vtkPointSet) -> vtkCellArray\nC++: static vtkCellArray *GetCells(vtkPointSet *pointSet)\n\n"},
  {"Normalize", PyttkCinemaImaging_Normalize, METH_VARARGS,
   "Normalize(depthArray:vtkDataArray, nearFar:(float, float)) -> int\nC++: static int Normalize(vtkDataArray *depthArray,\n    const double nearFar[2])\n\n"},
  {"AddFieldDataArray", PyttkCinemaImaging_AddFieldDataArray, METH_VARARGS,
   "AddFieldDataArray(fd:vtkFieldData, array:vtkDataArray,\n    tupleIdx:int, name:str=...) -> int\nC++: static int AddFieldDataArray(vtkFieldData *fd,\n    vtkDataArray *array, int tupleIdx,\n    const std::string &name=\"\")\n\n"},
  {"AddAllFieldDataArrays", PyttkCinemaImaging_AddAllFieldDataArrays, METH_VARARGS,
   "AddAllFieldDataArrays(inputGrid:vtkPointSet, image:vtkImageData,\n    tupleIdx:int) -> int\nC++: static int AddAllFieldDataArrays(vtkPointSet *inputGrid,\n    vtkImageData *image, int tupleIdx)\n\n"},
  {"ComputeDirFromFocalPoint", PyttkCinemaImaging_ComputeDirFromFocalPoint, METH_VARARGS,
   "ComputeDirFromFocalPoint(inputGrid:vtkPointSet) -> int\nC++: static int ComputeDirFromFocalPoint(vtkPointSet *inputGrid)\n\n"},
  {"EnsureGridData", PyttkCinemaImaging_EnsureGridData, METH_VARARGS,
   "EnsureGridData(fd:vtkPointData, name:str, nTuples:int, Values:(\n    float, ...)) -> int\nC++: static int EnsureGridData(vtkPointData *fd,\n    const std::string &name, int nTuples,\n    const std::vector<double> &Values)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkCinemaImaging_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("backend"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaImaging_GetBackend(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaImaging_SetBackend(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaImaging_SetBackend(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBackend/SetBackend\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("resolution"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaImaging_GetResolution(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaImaging_SetResolution(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaImaging_SetResolution(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetResolution/SetResolution\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("projection_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaImaging_GetProjectionMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaImaging_SetProjectionMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaImaging_SetProjectionMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetProjectionMode/SetProjectionMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("auto_focal_point"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaImaging_GetAutoFocalPoint(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaImaging_SetAutoFocalPoint(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaImaging_SetAutoFocalPoint(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutoFocalPoint/SetAutoFocalPoint\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("focal_point"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaImaging_GetFocalPoint(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaImaging_SetFocalPoint(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaImaging_SetFocalPoint(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFocalPoint/SetFocalPoint\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("auto_near_far"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaImaging_GetAutoNearFar(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaImaging_SetAutoNearFar(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaImaging_SetAutoNearFar(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutoNearFar/SetAutoNearFar\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("near_far"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaImaging_GetNearFar(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaImaging_SetNearFar(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaImaging_SetNearFar(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNearFar/SetNearFar\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("auto_height"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaImaging_GetAutoHeight(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaImaging_SetAutoHeight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaImaging_SetAutoHeight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutoHeight/SetAutoHeight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("height"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaImaging_GetHeight(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaImaging_SetHeight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaImaging_SetHeight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHeight/SetHeight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("angle"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkCinemaImaging_GetAngle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkCinemaImaging_SetAngle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkCinemaImaging_SetAngle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAngle/SetAngle\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkCinemaImaging_Doc =
  "ttkCinemaImaging - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Jonas Lukasczyk <jl@jluk.de>\\date 1.9.2018\n\n"
  "TTK VTK-filter that generates images of a vtkDataSet.\n\n"
  "This filter takes images of a vtkDataObject from positions specified\n"
  "on a vtkPointSet. Each image will be a block of a\n"
  "vtkMultiBlockDataSet where block order corresponds to point order.\n"
  "Each sample point can optionally have vtkDoubleArrays to override the\n"
  " rendering parameters, i.e, the resolution, focus, clipping planes,\n"
  "and viewport height.\n\n"
  "VTK wrapping code for the ttk::CinemaImaging package.\n\n"
  "\\param Input vtkDataObject that will be depicted (vtkDataObject)\n"
  "\\param Input vtkPointSet that records the camera sampling locations\n"
  "(vtkPointSet) \\param Output vtkMultiBlockDataSet that represents a\n"
  "list of images (vtkMultiBlockDataSet)\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/geometryApproximation/\"\n"
  "  >Geometry Approximation example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkCinemaImaging_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkCinemaImaging.ttkCinemaImaging", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkCinemaImaging_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkCinemaImaging_StaticNew()
{
  return ttkCinemaImaging::New();
}

PyObject *PyttkCinemaImaging_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkCinemaImaging_Type, PyttkCinemaImaging_Methods,
    "ttkCinemaImaging",
 &PyttkCinemaImaging_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkCinemaImaging_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkCinemaImaging(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkCinemaImaging_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkCinemaImaging", o) != 0)
  {
    Py_DECREF(o);
  }

}

